// 
// 
//   Header file for COBOL Compiler Run Time Library
// 
// 
 
#include <sys/param.h>
#include <sys/stat.h>
#include <ctype.h>
#include <stdio.h> 
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <sys/types.h>
#include <fcntl.h>

#include "htconfig.h"

#define min(x,y) ((x)<(y) ? (x) : (y))

/* Set library db version 1.85 compatibility feature on for versions >= 2.xx */
#ifdef USE_DB_185_COMPATIBILITY
#define DB_LIBRARY_COMPATIBILITY_API
#include <db_185.h>
#else
#include <db.h>
#endif

#include <curses.h>

#ifdef WANT_READLINE
#include <readline/readline.h>
#endif

#ifdef WANT_DYNAMIC_LIBS
#include <dlfcn.h>
#endif


#define KEY_RETURN		10
#define CHR_POSITIVE		'+'
#define CHR_NEGATIVE		'-'
// #define CHR_DECIMAL		'.'
// #define CHR_DEC_GROUP_DEL	','
#define CHR_DECIMAL		','
#define CHR_DEC_GROUP_DEL	'.'
#define CHR_BLANK		' '
#define CHR_ZERO		'0'

#define DTYPE_DISPLAY           '9'
#define DTYPE_ALPHA             'A'
#define DTYPE_BININT            'B'
#define DTYPE_PACKED            'C'
#define DTYPE_EDITED            'E'
#define DTYPE_FLOAT             'F'
#define DTYPE_GROUP		'G'
#define DTYPE_ALPHANUMERIC      'X'

#define DTYPE_COUNT             7
#define MAX_DIGITS              18                          

#define move_bytes 		memmove

#define ORG_INDEXED		1
#define ORG_SEQUENTIAL 		2
#define ORG_RELATIVE 		3
#define ORG_LINESEQUENTIAL 	4

#define ACC_SEQUENTIAL 		1
#define ACC_DYNAMIC 		2
#define ACC_RANDOM 		3

#define FMOD_INPUT 		1
#define FMOD_IO 		2
#define FMOD_OUTPUT 		3
#define FMOD_EXTEND 		4

/* inspect options */
#define INSPECT_CHARACTERS 1
#define INSPECT_ALL        2
#define INSPECT_LEADING    3
#define INSPECT_FIRST      4

/* screen attributes */
#define SCR_BLANK_WHEN_ZERO  0x00000001
#define SCR_HIGHLIGHT        0x00000002
#define SCR_LOWLIGHT         0x00000004
#define SCR_UNDERLINE        0x00000008
#define SCR_REVERSE_VIDEO    0x00000010
#define SCR_BLINK            0x00000020
#define SCR_JUST_LEFT        0x00000040
#define SCR_JUST_RIGHT       0x00000080
#define SCR_AUTO             0x00000100
#define SCR_SECURE           0x00000200
#define SCR_REQUIRED         0x00000400
#define SCR_FULL             0x00000800
#define SCR_SIGN_LEADING     0x00001000                   
#define SCR_SIGN_SEPARATE    0x00002000
#define SCR_SIGN_PRESENT     0x00004000
#define SCR_BELL             0x00008000
#define SCR_BLANK_SCREEN     0x00010000
#define SCR_BLANK_LINE       0x00020000
#define SCR_DISPLAY          0x00040000  /* if set display, else accept */                                                                   
#define RTERR_INVALID_DATA      1
#define RTERR_INVALID_PIC       2       

/* CONDITIONAL */

#define EQUAL   1
#define LESS    2
#define GREATER 4
#define GEQ     5
#define LEQ     3
#define NEQ     6

#pragma pack(1)
struct fld_desc {
	unsigned long int len;
	char type;
	unsigned char decimals;
	unsigned char all;
	char *pic;
};

struct file_desc {
	struct fld_desc *fname_desc;
	short unsigned reclen;	/* length of record */

	/* 1=INDEXED,2=SEQUENTIAL,3=RELATIVE 4=LINESEQUENTIAL */
	unsigned char organization; 

	/* 1=SEQUENTIAL,2=DYNAMIC,3=RANDOM */
	unsigned char access_mode;

	int open_mode;
	DB *dbp;         /* pointer for libdb operations */
	short unsigned rec_index; 	/* offset of index field in record */
	struct fld_desc
		*ixd_desc;	/* offset (DGROUP) index field descriptor */
	struct altkey_desc *key_in_use; 
};

struct altkey_desc {
	short int offset;  /* offset of alternate key field in record */
	struct fld_desc 
		*descriptor;   /* descriptor for this field */
	short int
		duplicates;    /* = 1 if duplicates allowed */
    DB *alt_dbp;    /* handle for the alternate key file */   
};

struct scr_desc {
	int attr;
	int line;
	int column;
	short int foreground;
	short int background;
	void (*process_scr)();
};
#pragma pack()


/* mccntrl.s */
void  exit_paragraph(unsigned, unsigned, unsigned);

/* cobmove.c */
void  cob_move(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2);
void  move_edited(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2);
void  _DUMP_(unsigned char *caData, char *szCount, char *caOut);
char* mc_picexpand(struct fld_desc *f); 

/* mcmath.c */
char  sign_to_char(int  digit );
int   char_to_sign(char  ch );
char  extract_sign(struct fld_desc *f, char *s);
void  put_sign(struct fld_desc *f, char *s, char sign);
int   get_index(struct fld_desc *f, char *s);
void  fldtod(struct fld_desc *f, unsigned char *s, double *fp);
void  push_double(struct fld_desc *f, char *s, double d);
void  assign_double(struct fld_desc *f, char *s1, double d1);
void  add_double(double d1, double d2);
void  subtract_double(double d1, double d2); 
void  multiply_double(double d1, double d2); 
void  divide_double(double d1, double d2); 
void  add(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2);
void  subtract(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2);
void  multiply(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2, struct fld_desc *f3, char *s3);
void  divide(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2, struct fld_desc *f3, char *s3);
int   check_condition(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2, struct fld_desc *f3, char *s3);
int   compare(struct fld_desc *f1, char *s1, struct fld_desc *f2, char *s2);

/* general.c */
void stop_run(void); 

/* basicio.c */
void  newline(int dupon); 
void  display(char *buffer, int len, int dupon);
void  display_erase(int dupon); 
int   accept_time(char *buffer);
int   accept_date(char *buffer);
int   accept_std(char *buffer, struct fld_desc *f, int echo);
int   accept_cmd_line(int ac, char **av, struct fld_desc *f, char *buffer);
int   accept_env_var(struct fld_desc *f, char *buffer);

/* fileio.c */
int   cob_open(struct file_desc *f, char *record, char *fname, int mode);
int   cob_close(struct file_desc *f, char *record);
int   cob_read(struct file_desc *f, char *record, ...);
int   cob_read_into(struct file_desc *f, char *record, char *buf, ...);
int   cob_read_next(struct file_desc *f, char *record);
int   cob_read_prev(struct file_desc *f, char *record);
int   cob_read_next_into(struct file_desc *f, char *record, char *buf);
int   cob_read_prev_into(struct file_desc *f, char *record, char *buf);
int   cob_write(struct file_desc *f, char *record, ...);
int   cob_save_status(char *status, int rt);

/* Run Time Error Routines */
void runtime_error(int iErrorNbr, struct fld_desc *pFld, void *pData);    

/* EOF htcoblib.h */

