// 
// 
//   COBOL Compiler Run Time Library -- Math Module
// 
// 


#include "htcoblib.h"

/*#define min(x,y) ((x)<(y) ? (x) : (y))*/

void
fp_runtime_error( struct fld_desc *f )
{
	char *pic;
	fprintf(stderr,"\n*** invalid content of numeric:\n"); 
	pic = mc_picexpand(f);
	fprintf(stderr,"field len: %ld, type: %c, decimals: %d, pic: %s\n",
		f->len,f->type,f->decimals,pic);
	free(pic);
/*	getchar();*/
}

/*void dump_double( msg,ptr )
char *msg;
unsigned char *ptr;
{
	int i;
	printf(msg);
	ptr+=7;
	for (i=0;i<8;i++)
		printf("%02.2x",*ptr--);
	getchar();
}*/

char sign_to_char( digit )
int digit;
{
	if (!digit) return '{';
	if (digit==0x80) return '}';
	if (digit>0) return 'A'+(char)(digit-1);
	digit= -digit;
	return 'J'+(char)(digit-1);
}

int char_to_sign( ch )
char ch;
{
	if (ch=='{') return 0;
	if (ch=='}') return 0x80;
	if (ch<'J') return (int)(ch-'A'+1);
	return (-(int)(ch-'J'+1));
}

char extract_sign( f,s )
struct fld_desc *f;
char *s;
{
	char *tmp;
	int digit;
	if (f->type=='C') {
		digit = (f->len/2);
		if(f->len & 1) {			/* length is odd number of digits */
			if((*(s+digit) & 0xf) == 0x0d)
				return 1;
			else
				return 0;
		}
		if ((*(s+digit) & 0xf0)==0xd0)
			return 1;
		else
			return 0;
	}
	if (*f->pic != 'S') return 0;
	tmp = s+f->len-1;
	digit = char_to_sign(*tmp);
	if (digit==0x80)
		*tmp='0';
	else if (digit<0)
		*tmp='0'-digit;
	else
		*tmp='0'+digit;
	if (digit==0x80) return 1;
	if (digit>=0) return 0;
	else return 1;
}

void put_sign( f,s,sign )
struct fld_desc *f;
char *s;
char sign;
{
	char *tmp;
	int digit;
	if (f->type=='C') {
		digit = f->len/2;
		if(f->len & 1) {		/* length is odd number of digits */
			if (sign)
				*(s+digit) = (*(s+digit) & 0xf0) | 0x0d;
			else
				*(s+digit) = (*(s+digit) & 0xf0) | 0x0c;
			return;
		}
		if (sign)
			*(s+digit) = 0xd0;
		else
			*(s+digit) = 0xc0;
		return;
	}
	if (*f->pic != 'S') return;
	tmp = s+f->len-1;
	digit = *tmp - '0';
	if (sign) digit = -digit;
	if (sign && digit==0)
		*tmp = sign_to_char(0x80);
	else
		*tmp = sign_to_char( digit );
}

int get_index( f,s )
struct fld_desc *f;
char *s;
{
	int index,i;
	index=0;
	for (i=0;i<f->len;i++)
		index = index * 10 + *(s+i) - '0';
    if (index>30000) {
        printf("\fWARN: index=%d.",index); getchar();
    }
    return index;
}

double exp10[]={1e0,1e1,1e2,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,
		1e13,1e14,1e15,1e16,1e17,1e18};

double fp1=0.;
double fp2=0.;
double fp3=0.;
double fpaux=0.;
double fpp=0.;
int fpdig=0;
unsigned long fint;

void fldtod( f,s,fp )
struct fld_desc *f;
unsigned char *s;
double *fp;
{
	int i,sign=0;
	fpp=0.;
	if (f->type=='B') {
		fpp = (double) *((int *)s);
	}
	else if (f->type=='C') {
/*dump_double("\fEntr: ",s);*/
		while ((fpdig=(*s&0x0f))<0x0a) {
			fpdig = *s >> 4;
/*printf("\ndigito: %c ",fpdig+'0'); getchar();*/
			fpaux = (double)fpdig;
			fpp = fpp * 10.;
			fpp = fpp + fpaux;
			fpdig = *s++ & 0x0f;
/*printf("\ndigito: %c ",fpdig+'0'); getchar();*/
			fpaux=(double)fpdig;
			fpp = fpp * 10.;
			fpp = fpp + fpaux;
		}
		fpdig = *s >> 4;
		fpaux = (double)fpdig;
		fpp = fpp * 10.;
		fpp = fpp + fpaux;
		sign = ((*s & 0x0f) == 0x0d) ? 1 : 0;
	}
	else {
		sign=extract_sign(f,s);
		for (i=0;i<f->len;i++) {
            if (*(s+i)==' ')
                fpdig=0;
            else
                fpdig = *(s+i)-'0';
			fpaux = (double)fpdig;
			fpp = fpp * 10.;
			fpp = fpp + fpaux;
		}
		put_sign(f,s,sign);
	}
	/* scale the number with it's (fld_desc *)->decimals */
	if (f->decimals >0 && f->decimals <= 18)
		fpp = fpp/exp10[f->decimals];
	else if (f->decimals>18) /* because our table don't have everything */
		fpp = fpp/pow(10,f->decimals);
	if (sign) 
		fpp = -fpp;
/*dump_double( "\fRes:",&fpp );*/
	move_bytes(fp,&fpp,8);
}

void push_double( f,s,d )
struct fld_desc *f;
char *s;
double d;
{
	fldtod( f,s,&d );
}

#define dtofld( f,s,d ) assign_double( f,s,d )

double fpa=0.;
static char buf[20]="";

void assign_double( f,s1,d1 )
struct fld_desc *f;
char *s1;
double d1;
{
	int i,len,ndec,sign;
	char *his;
	int hilen;
	char *s;
	if (f->type=='B') {
		d1 *= exp10[f->decimals];
		d1 += .5;
		*((int *)s1) = (int) d1;
		return;
	}
	else if (f->type=='C') {
		s=buf;
		len = f->len * 2 - 1;
	}
	else {
		s=s1;
		len = f->len;
	}
/*dump_double("\fAssign: ",&d1);*/
	move_bytes(&fpa,&d1,8);
	ndec = f->decimals;
	if (fpa<0.) {
		sign=1;
		fpa = -fpa;
	}
	else
		sign=0;
	if (fpa>exp10[len-ndec]) {
		fp_runtime_error(f);
		return;
	}
	fpa *= exp10[ndec];
	fpa += .5;
/*	if (fpa>pow(2.,32.)) {
		printf("\fFP overflow!"); getchar();
		return;
	}
*/
if (fpa>exp10[9]) {
	fint = (unsigned long) ( fpa/exp10[9] );
/*	fint *= exp10[9]; */
/******* subtrai parte alta do numero *******/
	fpa -= fint * exp10[9];
/********* converte parte alta para string ********/
	hilen = len-9;
	his = s + hilen-1;
	for (i=0;i<hilen;i++) {
		*his-- = (char)(fint % 10) + '0';
		fint /= 10;
	}
	len -= hilen;
	s += hilen;
}
	fint = (unsigned long) fpa;
	s += (len-1);
	for (i=0;i<len;i++) {
		*s-- = (char)(fint % 10) + '0';
		fint /= 10;
	}
/*printf("\nString: %20.20s",buf); getchar();*/
	if (f->type=='C') {
		unsigned char *stmp;
		stmp = s1;
		s = buf;
		stmp += f->len - 1;
		s += len - 1;
		if (sign) *stmp = 0x0d;
		else *stmp = 0x0c;
		while (s >= buf) {
			*stmp-- |= (*s-- << 4);
			if (s >= buf)
				*stmp = (*s-- & 0x0f);
		}
	}
	else
		put_sign( f,s1,sign );
}

void add_double( d1,d2 ) double d1,d2; {
	move_bytes(&fp1,&d1,8);
	move_bytes(&fp2,&d2,8);
	fp2 += fp1;
	move_bytes(&d2,&fp2,8);
}
void subtract_double( d1,d2 ) double d1,d2; {
	move_bytes(&fp1,&d1,8);
	move_bytes(&fp2,&d2,8);
	fp2 -= fp1;
	move_bytes(&d2,&fp2,8);
}
void multiply_double( d1,d2 ) double d1,d2; {
	move_bytes(&fp1,&d1,8);
	move_bytes(&fp2,&d2,8);
	fp2 *= fp1;
	move_bytes(&d2,&fp2,8);
}
void divide_double( d1,d2 ) double d1,d2; {
	move_bytes(&fp1,&d1,8);
	move_bytes(&fp2,&d2,8);
	fp2 /= fp1;
	move_bytes(&d2,&fp2,8);
}

void add( f1,s1,f2,s2 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
{
	fldtod(f1,s1,&fp1);
	fldtod(f2,s2,&fp2);
	fp1+=fp2;
	dtofld(f2,s2,fp1);
}

void subtract( f1,s1,f2,s2 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
{
	fldtod(f1,s1,&fp1);
	fldtod(f2,s2,&fp2);
	fp2 -= fp1;
	dtofld(f2,s2,fp2);
}

void multiply( f1,s1,f2,s2,f3,s3 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
struct fld_desc *f3;
char *s3;
{
	fldtod(f1,s1,&fp1);
	fldtod(f2,s2,&fp2);
	fp3 = fp1*fp2;
	dtofld(f3,s3,fp3);
}

void divide( f1,s1,f2,s2,f3,s3 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
struct fld_desc *f3;
char *s3;
{
	fldtod(f1,s1,&fp1);
	fldtod(f2,s2,&fp2);
	fp3=fp1/fp2;
	dtofld(f3,s3,fp3);
}

int check_condition( f1,s1,f2,s2,f3,s3 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
struct fld_desc *f3;
char *s3;
{
	int i,len2,len3;
	if (f1->type == '9') {
		fldtod(f1,s1,&fp1);
		fldtod(f2,s2,&fp2);
		fldtod(f3,s3,&fp3);
		if (fp1>=fp2 && fp1<=fp3)
			return 0;
		return 1;
	}
	else {
		len2=f2->len;
		len3=f3->len;
		for (i=0;i<f1->len;i++) {
			if (i<len2)
				if (*(s1+i) < *(s2+i)) return 1;
			if (i<len3)
				if (*(s1+i) > *(s3+i)) return 1;
		}
		return 0;
	}
}

int compare( f1,s1,f2,s2 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
{
/*********** retorna 1 se s1>s2; 0 se s1==s2; -1 se s1<s2 **********/
	int i,maxi;
   if ((f1->type!='9' && f1->type!='C' && f1->type!='B') ||
        (f2->type!='9' && f2->type!='C' && f2->type!='B')) {  /* compare strings */
	maxi=(f1->len<f2->len)?f1->len:f2->len;
	for (i=0;;i++) {
		if (i>=maxi) break;
		if (*(s1+i) == *(s2+i)) continue;
		if (*(s1+i) >  *(s2+i)) return 1;
		if (*(s1+i) <  *(s2+i)) return -1;
	}
	if (f1->len>f2->len) {
		while (i<f1->len)
			if (*(s1+i++)!=' ') return 1;
		return 0;
	}
	else {
		while (i<f2->len)
			if (*(s2+i++)!=' ') return -1;
		return 0;
	}
    }
    else {
	fldtod(f1,s1,&fp1);
	fldtod(f2,s2,&fp2);
	if (fp1>fp2) return 1;
	if (fp2>fp1) return -1;
	return 0;
    }
}

/* end of MCMATH.C */

