/*
**  Cobol Compiler Library -- Move Module
**
**  by Rildo Pragana -- 1991
**  P.O. Box 7440 - Recife PE Brazil 50000
**
**  Revision history:
**	29-oct-91 Code implementation
**	24-dec-91 Separate library for files
**
*/

#include "mcoblib.h"
#include <math.h>

#define min(x,y) ((x)<(y) ? (x) : (y))

static char *s2tmp=NULL;
static char buf2[20]="";
static char buf1[20]="";
static char *stmp=NULL;
static struct fld_desc *f2tmp=NULL;
static struct fld_desc f2t={0};
static struct fld_desc f1t={0};

/*void move_to_edited( );*/

void move( f1,s1,f2,s2 )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
{
	char *p2,*s;
	int picn;
	char picc,compact;
	int pi1,pi2;
	int i,j,k;
	int first;
	unsigned char sign;
	compact=picn=0;
	p2=f2->pic;
	if (f1->type=='9' || f1->type=='C')
		sign=extract_sign(f1,s1);
	if (f1->type=='C') { /* converte para DISPLAY */
		unsigned char digito;
		stmp=s1;
		s1=buf1;
		f1t.len=f1->len*2-1;
		f1t.type='9';
		f1t.decimals=f1->decimals;
		f1t.pic = f1->pic;
		while ((digito=(*stmp & 0x0f)) < 0x0a) {
			*s1++ = (((unsigned char)*stmp >> 4)+'0');
			*s1++ = ((*stmp & 0x0f)+'0');
			stmp++;
		}
		*s1++ = (((unsigned char) *stmp >> 4)+'0');
		s1=buf1;
		f1=&f1t;
	}
	if (f2->type=='C') { /* converte temporariamente p/campo DISPLAY */
		s2tmp=s2;
		s2=buf2;
		f2tmp=f2;
		f2t.len=f2->len*2-1;
		f2t.type='9';
		f2t.decimals=f2->decimals;
		f2t.pic=f2->pic;
		f2=&f2t;
		compact++;
	}
	if (f1->type=='9' && f2->type=='9') { /* numeric -> numeric */
		i=(f1->len)-1;
		j=(f2->len)-1;
		for (first=0;first<f1->len;first++)
			if (isdigit(*(s1+first)) && *(s1+first)!=0) break;
		if ( (f1->decimals) > (f2->decimals) )
			i -= ((f1->decimals)-(f2->decimals));
		else {
			k=j;
			j -= ((f2->decimals)-(f1->decimals));
			for (;k>j;k--)
					*(s2+k)='0';
		}
		for (;j>=0;j--,i--) {
			if (i>=0)
				*(s2+j) = *(s1+i);
			else
				*(s2+j) = '0';
		}
		put_sign(f1,s1,sign);
		put_sign(f2,s2,sign);
	}
	else if (f1->type=='9' && f2->type=='E') { /* numeric -> edited */
char *ss1;
ss1=s1;
first=pi2=0;
for (s=p2;*(s+1) && *s;s+=2)
	if (*s=='Z' || *s=='9'|| *s=='X' || *s=='A' )
		pi2+=*(s+1);
pi2-=f2->decimals;
pi1=f1->len-f1->decimals;
if (pi2 > pi1) {
	for (i=0;i<(pi2-pi1);i++) {
		if (picn==0) { picc=*p2++; picn=*p2++; }
		picn--;
		switch (picc) {
		case 'X':
		case '9': *s2++ = '0'; break;
		case '.':
		case 'B':
		case 'Z': *s2++ = ' '; break;
		case '/': *s2++ = '/'; break;
		case ',': *s2++ = ','; break;
		case '+': if (sign) *s2++ = '-';
			  else *s2++ = '+'; break;
		case '-': if (sign) *s2++ = '-';
			  else *s2++ = ' '; break;
		default:  *s2++ = picc; break;
		}
	}
}
else if (pi1>pi2) {
	for (;pi1>pi2;pi1--,s1++)
		if (*s1>'0') first=1;
}
j=pi1+min(f1->decimals,f2->decimals);
for (i=0;i<j;) {
	if (picn==0) { picc=*p2++; picn=*p2++; }
	picn--;
	if (picc==0) break; /* final da picture, aborte */
	switch (picc) {
		case 'X':
		case '9': *s2++ = *s1++; i++; break;
		case '.': if (first)
				*s2++ = '.';
			  else
				*s2++ = ' ';
			  break;
		case 'Z': if (first)
				*s2++ = *s1++;
			  else if (*s1 > '0' &&
					isdigit(*s1)) {
				first++;
				*s2++ = *s1++;
			  }
			  else { *s2++ = ' '; s1++; }
			  i++; break;
		case '0': *s2++='0'; break;
		case 'B': *s2++=' '; break;
		case '/': *s2++='/'; break;
		case ',': *s2++ = ','; first++; break;
		case '+': if (sign) *s2++ = '-';
			  else *s2++ = '+'; break;
		case '-': if (sign) *s2++ = '-';
			  else *s2++ = ' '; break;
		default:  *s2++ = picc; break;
	}
}
for (i=0;picc /*i<(f2->decimals-f1->decimals)*/;i++) {
	if (picn==0) { picc=*p2++; picn=*p2++; }
	picn--;
	if (picc==0) break;
	switch (picc) {
		case 'X':
		case '9': *s2++ = '0'; break;
		case '.': if (first)
				*s2++ = '.';
			  else
				*s2++ = ' ';
			  break;
		case 'Z': if (first) {
				*s2++ = '0';
			  }
			  else *s2++ = ' ';
			  break;
		case '0': *s2++='0'; break;
		case 'B': *s2++=' '; break;
		case '/': *s2++='/'; break;
		case ',': *s2++ = ','; first++; break;
		case '+': if (sign) *s2++ = '-';
			  else *s2++ = '+'; break;
		case '-': if (sign) *s2++ = '-';
			  else *s2++ = ' '; break;
		default:  *s2++ = picc; break;
	}
}
	put_sign(f1,ss1,sign);
}
	else if ((f1->type=='X' || f1->type=='G') && f2->type=='E') {
			/* alpha/edited -> edited */
		pi2=0;
		for (s=p2;*(s+1);s+=2)
			if (*s=='Z' || *s=='9'|| *s=='X' || *s=='A')
				pi2+=*(s+1);
		pi1=f1->len;
		if (pi2 > pi1) {
			for (i=0;i<(pi2-pi1);i++) {
				if (picn==0) { picc=*p2++; picn=*p2++; }
				picn--;
				switch (picc) {
				case 'X':
				case '9': *s2++ = ' '; break;
				case '.':
				case 'B':
				case 'Z': *s2++ = ' '; break;
				case ',': *s2++ = ','; break;
				case '/': *s2++ = '/'; break;
				default:  *s2++ = picc; break;
				}
			}
		}
		j=min(pi1,pi2);
		for (i=0;i<j;) {
			if (picn==0) { picc=*p2++; picn=*p2++; }
			picn--;
			if (picc==0) return; /* final da picture, aborte */
			switch (picc) {
				case 'X':
				case '9': *s2++ = *s1++; i++; break;
				case 'Z': *s2++ = *s1++;
					  i++; break;
				case 'B': *s2++ = ' '; break;
				case '/': *s2++ = '/'; break;
				default:  *s2++ = picc; break;
			}
		}
	}
	else { /* alpha/numeric/edited -> alpha/edited */
		for (j=0;j<f1->len && j<f2->len;j++)
			*(s2+j) = *(s1+j);
		if (j<f2->len)
			for (;j<f2->len;j++)
				*(s2+j) = ' ';
	}
	if (compact) {
		s2 = buf2;
		stmp = s2tmp;
		s2 += f2->len - 1;
		stmp += f2tmp->len - 1;
		if (sign) *stmp = 0x0d;
		else *stmp = 0x0c;
		while (s2 >= buf2) {
			*stmp-- |= (*s2-- << 4);
			if (s2 >= buf2)
				*stmp = (*s2-- & 0x0f);
		}
	}
}

/*void move_to_edited( f1,s1,f2,s2,p2,sign )
struct fld_desc *f1;
char *s1;
struct fld_desc *f2;
char *s2;
char *p2;
int sign;
{
	char *s;
	char picc;
	int picn;
	int pi1,pi2,first;
	int i,j;
}*/

/* end of MCMOVE.C */
