//
//  Cobol Compiler Run Time Library -- Screen I/O functions
//
//
// Do not use, not finished

#if defined(SunOS)
#include <curses.h>
#else
#include <ncurses.h>
#endif

#include "htcoblib.h"

extern int decimal_comma;
int scrio_init=0;
int decimal_char = '.';

void
cob_accept_screen() {
}

void
cob_display_screen() {
}

void
cob_scr_process() {
}

void do_putch_terminal(char c)
{
	int x,y;
	int mx, my;

	getyx(stdscr, y, x);
	getmaxyx(stdscr, my, mx);

	if(c>31)
		addch(c);
	else if(c=='\t')
	{
		do
		{
			addch(' ');
			x++;
			if(x==mx)
			{
				x=0;
				if(y<my)
					y++;
				move(y,x);
				return;
			}
		}
		while(x%8);		
	}
	else if(c=='\n')
	{
		if(y<my)
			move(y+1,  x);
	}
	else if(c=='\r')
	{
		move(y,0);
	}
}

void cob_init_screen(void)
{
	if (!scrio_init) {
		if (decimal_comma)
			decimal_char = ',';
		initscr();
		noecho();
		cbreak();
		//keypad(stdscr,TRUE);
		scrollok(stdscr,TRUE);
		scrio_init++;
	}
}

void display_terminal(char *buf, int len)
{
	int i;
//	char *tbuf=buf;
	
//	while(*buf)
	for(i=0; i<len; i++, buf++)
		do_putch_terminal(*buf);
	refresh();
}

void newline_terminal(void)
{
	do_putch_terminal('\n');
}

void display_erase_terminal(void)
{
	clear();
	refresh();
}

// void stop_run(void)
void do_scrio_finish(void)
{
	if (scrio_init) {
		printw("\n***END***\n");
		getch();
		endwin();
		scrio_init=0;
	}
}

void outit_terminal(void)
{	
	write(2, "BRK",3);
}

void outeek_terminal(void)
{	
	write(2, "CNT",3);
}

void ep_debug_terminal(void *addr, void *low, void *high, void *ret)
{
	printf("ADDR=%p LOW=%p HIGH=%p RET=%p\n", addr, low, high, ret);
	fflush(stdout);
}

static void backspace(void)
{
	int y,x;
	getyx(stdscr, y,x);
	if(x) x--;
	move(y,x);
}

int cob_accept(char *buffer, struct fld_desc *f, int echo )
{
	char *buf,*tmp;
	int y,x;
	int cnt,digcnt,i;
	/* cnt 		= how many chars need be entered
	** digcnt 	= how many already entered 
	*/
	int c,sign=0;
	int decimal_flg=0;
	buf=buffer;

	getyx(stdscr, y,x);
	digcnt=0;
	cnt=f->len;
	/*
	** echo & 4 --> DARK,
	** echo == 0 --> NO ECHO
	*/
	if (echo & 2) {		/* WITH FILLER (this isn't standard, 
							I've invented it, but...) */
		for (i=0;i<cnt;i++) addch('_');
		if (f->decimals) addch(decimal_char);
		refresh();
	}
	if (echo & 8) {		/* WITH UPDATE */
		for (i=0;i<cnt;i++)
			addch(*(buffer+i));
		move(y,x);
		refresh();
	}
	while (1) {
		c=getch();
		if (c=='-' && buf==buffer) {
			sign=1;
			if (echo & 3) addch('-');
			else if (echo & 4) addch('*');
			continue;
		}
		if (c==KEY_BACKSPACE) {
			tmp=buffer;
			while (tmp!=buf) {
				backspace();
				if (echo & 2) addch('_');
				else if (echo & 8) addch(*tmp);
				else if (echo) addch(' ');
				tmp++;
			}
			if (decimal_flg)
				if (echo & 2) addch(decimal_char);
				else if (echo & 8) { } /* nothing to be done */
				else if (echo) addch(' ');
			refresh();
			decimal_flg=0;
			cnt=f->len;
			digcnt=0;
			buf=buffer;
			continue;
		}
		if (c==8) {
			if (buf>buffer) {
				buf--;
				if (echo) backspace();
				if (cnt==f->decimals) {
					decimal_flg=0;
					if (echo) backspace();
				}
				else if (digcnt==1 && sign) {
					sign=0;
					if (echo) backspace();
				}
				cnt++;
				digcnt--;
			}
			continue;
		}
		if (c=='\n') /* curses return '\n' as the return key */ 
			goto final;
		if ( ((f->type=='A') && (isalpha(c) || c==' ')) ||
		     ((f->type=='X' || f->type=='G')
					&& (isprint(c) || c==' ')) ||
		     ((f->type=='9') && isdigit(c) )) {
				*(buf++) = c;
			if (echo & 4) addch('*');
			else if (echo) addch(c);
			if (cnt) { 
				cnt--;
				digcnt++;
			}
			if (cnt==f->decimals && cnt) {
				if (echo & 4) addch('*');
				else if (echo) addch(decimal_char);
				decimal_flg++;
			}
			continue;
		}
		if (c==decimal_char && f->type=='9' && !decimal_flg) {
			decimal_flg++;
			cnt=f->decimals;
			if (echo & 4) addch('*');
			else if (echo) addch(decimal_char);
			continue;
		}
	}
final:  if (f->type=='9') {
		if (!decimal_flg) {
			/* align field (integer part) at the right */
			if (f->len-cnt)
				memmove(buffer+cnt-f->decimals,
					buffer,digcnt);
			/* fill rest of field at the left with zeros */
				if (cnt>f->decimals)
					memset(buffer,'0',cnt-f->decimals);
			/* fill decimal digits with zeros at the right */
			memset(buffer+f->len-f->decimals,
				'0',f->decimals);
		}
		else {
			while (cnt) {
				*buf++ = '0';
				cnt--;
				digcnt++;
			}
			memmove(buffer+f->len-digcnt,buffer,digcnt);
			memset(buffer,'0',f->len-digcnt);
		}
	}
	else 
		memset(buf,' ',cnt);
	if (f->type=='9')
		put_sign(f,buffer,sign);
	printw("\n");
	return (int)(buf-buffer);
}

/* screenio.c */
