// 
// 
//   COBOL Compiler Run Time Library -- Strings Module
// 

#include "htcoblib.h"
/*
#define min(a,b) (((a) < (b)) ? (a) : (b))
*/
#if defined(SunOS)
va_list __builtin_va_alist;
#endif

int offset_substr( char *s1, char *s2, int n1, int n2 );
void cob_put_integer( struct fld_desc *fdesc, char *sbuf, int value);
struct comparand *
alloc_comparand( int opt, struct comparand **list );
void free_comparands( struct comparand *cmps );

/*
 * auxiliary comparands list to walk several times through comparands
 * in cob_inspect_replacing function.
 */
struct comparand {
	struct comparand *next;
	int opt;
	struct fld_desc *ffor,*fby,*fbefore,*fafter;
	char *sfor,*sby,*sbefore,*safter;
	int stop; /* -1 -> not yet (only if "after" found), 
                  0 -> go, 1 -> stop */
};

struct comparand *
alloc_comparand( int opt, struct comparand **list ) {
	struct comparand *new,*tmp;
	new = malloc(sizeof(struct comparand));
	if ((tmp=*list)) {
		while (tmp->next)
			tmp = tmp->next;
		tmp->next = new;
	}
	else 
		*list = new;
	new->next = NULL; 
	new->opt = opt;
	new->ffor = new->fby = new->fbefore = new->fafter = NULL;
	new->sfor = new->sby = new->sbefore = new->safter = NULL;
	new->stop = -1;
	return new;
};

void
free_comparands( struct comparand *cmps ) {
	struct comparand *tmp;
	while (cmps) {
		tmp = cmps;
		cmps = cmps->next;
		free(tmp);
	}
}

int
cob_inspect_tallying( struct fld_desc *fvar, char *svar, ... )
{
	struct fld_desc *fcnt,*ffor,*fbefore,*fafter;
	char *scnt,*sfor,*sbefore,*safter;
	int opt;
	va_list args;
	va_start(args,svar);
	while ((fcnt = va_arg(args,struct fld_desc *))) {
		scnt = va_arg(args,char *);
		while ((opt = va_arg(args,int))) {
			if ((ffor = va_arg(args,struct fld_desc *))) {
				sfor = va_arg(args,char *);
			}
			if ((fbefore = va_arg(args,struct fld_desc *))) {
				sbefore = va_arg(args,char *);
			}
			if ((fafter = va_arg(args,struct fld_desc *))) {
				safter = va_arg(args,char *);
			}
		/* now we do the actual processing */
			
		}
	}
	va_end(args);
	return 0;
}

int
cob_inspect_replacing( struct fld_desc *fvar, char *svar, ... )
{
	struct comparand *cmp,*comparands;
	int opt,len,rsize;
	va_list args;

	va_start(args,svar);
	comparands = NULL;
	while ((opt = va_arg(args,int))) {
		cmp = alloc_comparand( opt,&comparands );
		if (opt != INSPECT_CHARACTERS) {
			if ((cmp->ffor = va_arg(args,struct fld_desc *))) {
				cmp->sfor = va_arg(args,char *);
			}
		}
		if ((cmp->fby = va_arg(args,struct fld_desc *))) {
			cmp->sby = va_arg(args,char *);
		}
		if ((cmp->fbefore = va_arg(args,struct fld_desc *))) {
			cmp->sbefore = va_arg(args,char *);
		}
		if ((cmp->fafter = va_arg(args,struct fld_desc *))) {
			cmp->safter = va_arg(args,char *);
		}
		else
			cmp->stop = 0;
	}
	va_end(args);
	len = fvar->len;
	/* do the actual processing */
	while (len) {
		cmp = comparands; /* reposition comparand list */
		rsize = 1;
		while (cmp) {
			if (cmp->stop < 0) {
				if (!offset_substr(svar,cmp->safter,len,cmp->fafter->len))
					cmp->stop = 0;
			}
			if (cmp->fbefore) {
				if (!offset_substr(svar,cmp->sbefore,len,cmp->fbefore->len))
					cmp->stop = 1;
			}
			if (!cmp->stop) {
				if (cmp->opt == INSPECT_CHARACTERS) {
					memmove(svar,cmp->sby,1);
					break;
				}
				if	(!offset_substr(svar,cmp->sfor,len,cmp->ffor->len)) {
						rsize = cmp->ffor->len;
						memmove(svar,cmp->sby,rsize);
						if (cmp->opt == INSPECT_FIRST)
							cmp->stop=1;
						break;
				}
				else if (cmp->opt == INSPECT_LEADING) {
					cmp->stop=1;
				}
			}
			cmp = cmp->next;
		}
		svar+=rsize;
		len-=rsize;
	}
	free(comparands);
	return 0;
}

int
cob_unstring( struct fld_desc *fvar, char *svar, ... )
{
	struct fld_desc *fptr;
	char *sptr;
	struct fld_desc *ftally;
	char *stally;
	struct fld_desc **delim_arr, **dest_arr, **p;
	struct fld_desc *fdelim,*fdest,*fdltr,*fcnt;
	char *sdelim,*sdest,*sdltr,*scnt, *delimbuf, *s1;
	void *tmp;
	int all,n,n1,len,partlen,delimlen,delimall,nfields;
	va_list args;

	/* first receive all arguments */
	va_start(args,svar);
	if ((fptr = va_arg(args,struct fld_desc *))) {
		sptr = va_arg(args,char *);
	}
	if ((ftally = va_arg(args,struct fld_desc *))) {
		stally = va_arg(args,char *);
	}
	p = &va_arg(args,struct fld_desc *);
	delim_arr = p;
	tmp = *p;
	while (tmp) {
		tmp = va_arg(args,void *);
		tmp = va_arg(args,void *);
		tmp = va_arg(args,void *);
	}
	dest_arr = &va_arg(args,struct fld_desc*);
	va_end(args);

#if 0 
/********** testing *************/
	p=delim_arr;
	fdelim = *p++;
	printf("\nDelimited by:\n");
	printf("-------------\n");
	while (fdelim) {
		sdelim = (char *)*p++;
		all = (int)*p++;
		printf("field descriptor: len % 3d, type %c, decimals % 2d, ",
			fdelim->len,fdelim->type,fdelim->decimals);
		printf("value: \"");
		display( sdelim,fdelim->len );
		printf("\", all %1d\n",all);
		fdelim = *p++;
	}
	fdest = *dest_arr++;
	printf("\nDestination vars:\n");
	printf("-----------------\n");
	while (fdest) {
		sdest = (char *)*dest_arr++;
		printf("dest descriptor: len % 3d, type %c, decimals % 2d\n",
			fdest->len,fdest->type,fdest->decimals);
		if ((fdltr = *dest_arr++)) {
			sdltr = (char *)*dest_arr++;
			printf("delimiter descriptor: len % 3d, type %c, decimals % 2d\n",
				fdltr->len,fdltr->type,fdltr->decimals);
		}
		if ((fcnt = *dest_arr++)) {
			scnt = (char *)*dest_arr++;
			printf("count descriptor: len % 3d, type %c, decimals % 2d\n",
				fcnt->len,fcnt->type,fcnt->decimals);
		}
		printf("---------------------------------------------------\n");
		fdest = *dest_arr++;
	}
	printf("\nOther vars:\n");
	printf("-------------\n");
	if (fptr) {
		printf("pointer descriptor: len % 3d, type %c, decimals % 2d\n",
			fptr->len,fptr->type,fptr->decimals);
	}
	if (ftally) {
		printf("tally descriptor: len % 3d, type %c, decimals % 2d\n",
			ftally->len,ftally->type,ftally->decimals);
	}
	printf("\n");
	return 0;
#endif
	/* now execute the actual unstring command */
	len = fvar->len;
	if (fptr) { /* if there is a pointer, skip some length at svar */
		n = get_index(fptr,sptr); /* get the integer value of this */
		if (n >= len)
			return -1; /* overflow at the pointer */
		len -= n;
		svar += n;
	}
	nfields = 0;
	fdest = *dest_arr++;
	while (fdest) {
		sdest = (char *)*dest_arr++;
		if ((fdltr = *dest_arr++)) {
			sdltr = (char *)*dest_arr++;
		}
		if ((fcnt = *dest_arr++)) {
			scnt = (char *)*dest_arr++;
		}
		if (len<=0) /* check if overflow found */
			return -1;
		p=delim_arr;
		fdelim = *p++;
		/* find the nearest delimiter */
		delimall = 0;
		delimlen = len;
		delimbuf = NULL;
		if (!fdelim)
			partlen = fdest->len;
		else
			partlen = len;
		while (fdelim) {
			sdelim = (char *)*p++;
			all = (int)*p++;
			n1 = offset_substr(svar,sdelim,partlen,fdelim->len);
			if (n1 < partlen) { 
				partlen	= n1;
				delimlen = fdelim->len;
				delimbuf = sdelim;
				delimall = all;
			}
			fdelim = *p++;
		}
		/* this should be a call to our cob_move function, 
		but it's unfinished yet */
		memmove(sdest,svar,min(fdest->len,partlen));
		if (fdest->len > partlen)
			memset(sdest+partlen,' ',fdest->len-partlen);
		/* adjust for the partial string processed */
		len -= partlen;
		svar += partlen;
		if (delimbuf) { /* adjust for delimiter too */
			len -= delimlen;
			svar += delimlen;
			if (fdltr) { /* if delimiter storage requested */
				memset(sdltr,' ',fdltr->len);
				memmove(sdltr,delimbuf,min(fdltr->len,delimlen));
				n1 = fdltr->len-delimlen;
				s1 = sdltr+delimlen;
			}
		}
		if (fcnt) {
			cob_put_integer(fcnt,scnt,partlen);
		}
		if (delimall) { /* remove all copies of delimiter */
			while (len && !offset_substr(svar,delimbuf,len,delimlen)) {
				len -= delimlen;
				svar += delimlen;
				if (n1 && fdltr) {
					memmove(s1,delimbuf,min(n1,delimlen));
					n1 -= delimlen;
					s1 += delimlen;
				}
			}
			if (fdltr)
				memset(s1,' ',n1);
		}
		if (fcnt) { /* if count requested */
			cob_put_integer(fcnt,scnt,partlen);
		}
		fdest = *dest_arr++;
		nfields++;
	}
	if (ftally) {
		cob_put_integer( ftally, stally, nfields + 
			get_index( ftally, stally ) );
	}
	if (len) /* another way to overflow */
		return -1;
	return 0;
}

/*
 * Cobol string statement.
 * The variables are (in that order):
 *    receiving var, pointer (with pointer clause),
 *    1st. sending var, 2nd sending var,...
 * Each variable have it's field descriptor (struct fld_desc) and
 * it's buffer, except if it's non-existent. In such case, only a NULL
 * is passed as argument and must be skipped. (not 2 stack positions ever)
 * The last sending variable is a NULL.
 *
 * This function returns -1 in case of overflow found, or 0 if ok.
 */
int
cob_stringcmd( struct fld_desc *fdst, char *sdst,... )
{
	struct fld_desc *fptr;
	char *sptr;
	struct fld_desc *fsrc;
	char *ssrc;
	struct fld_desc *fdelim;
	char *sdelim;
	int n,len;
	va_list args;

	len = fdst->len;
	va_start(args,sdst);
	fptr = va_arg(args,struct fld_desc *);
	if (fptr) {
		sptr = va_arg(args,char *);
		n = get_index(fptr,sptr); /* get the integer value of this */
	 	len -= n;
		sdst += n;
	}
	fsrc = va_arg(args,struct fld_desc *);
	while (fsrc) { /* while there are variables to move */
		ssrc = va_arg(args,char *);
		fdelim = va_arg(args,struct fld_desc *);
		if (fdelim) { /* if there is a delimiter, get it's buffer */
			sdelim = va_arg(args,char *);
		}
		n = fsrc->len;
		if (fdelim) {
			n = offset_substr(ssrc,sdelim,n,fdelim->len);
		}
		if (len >= n) {
			memmove(sdst,ssrc,n);
			sdst += n;
			len -= n;
		}
		else {
			return -1;
		}
		fsrc = va_arg(args,struct fld_desc *);
	}
	va_end(args);
	while (len--) {
		*sdst++ = ' ';
	}
	return 0;
}

/* 
 * return number of characters before found s2 in s1
 * (C string functions are not useful here, because
 * the strings are _not_ NULL-terminated)
 * I would like to see here a better algorithm, but this
 * "brute-force" method is easier to code now.
 */
int 
offset_substr( char *s1, char *s2, int n1, int n2 ) {
	int i,j;
	for (i=0;i<n1;i++) {
		for (j=0;j<n2;j++) {
			if (i+j > n1) break; /* past the first string, ignore */
			if (s1[i+j]!=s2[j]) break; 	
		}
		if (j==n2) break; /* found! */
	}
	return i;
}

/* this is not the most generic implementation, as we should use
   a call to cob_move in the future, but it's better than none */
void
cob_put_integer( struct fld_desc *fdesc, char *sbuf, int value) {
	char *s;
	s = malloc(fdesc->len+1);
	sprintf(s,"%0*d",(int)fdesc->len,value);
	memmove(sbuf,s,fdesc->len);
	free(s);
}

/* end of strings.c */

