 IDENTIFICATION DIVISION.
 PROGRAM-ID.    TestVariable. 
 AUTHOR.         
    Rildo Pragana.
 DATE-WRITTEN.   
    November 13, 1999.
 REMARKS.
    This is to exercise variables, specially
    qualifying as in: var of parentvar of grandparentvar ...
*
 ENVIRONMENT DIVISION.
 DATA DIVISION.
*
 WORKING-STORAGE SECTION.

 01     ARRAY-1.
  05    ARRAY-2 OCCURS 15.
   10   ARRAY-3 OCCURS 7.
    15  ITEM PIC  X.
    15  ITEM1 PIC XXX.
 01     PARENT1.
  05    LEVEL05.
   10   LEVEL10.
    15  LEVEL15.
     20 LEVEL20     PIC X(30) VALUE "Child of parent 1".
  05    CHILD           PIC X VALUE "A".
  05    OTHER-CHILD     PIC X value "B".
  05    PARENT3.
   10   CHILD           PIC X(10) VALUE "internal".
   10   INNER-PARENT.
    15  FILLER          PIC X(22) VALUE "...and this other...".
    15  CHILD           PIC X(5)  VALUE "inner".
  05    CNT             PIC 99 VALUE 2.
 01     PARENT2.
  05    LEVEL05.
   10   LEVEL10.
    15  LEVEL15.
     20 LEVEL20     PIC X(30) VALUE "Child of parent 2".
     20 SMALL-ARRAY OCCURS 2.
      25 ITEM  PIC X(10).
  05    CHILD           PIC X value "C".
  05    OTHER-CHILD     PIC X value "D".
  05    UNIQUE-CHILD    PIC X value "E".
  05    INNER-PARENT    PIC X value "F".
  05    CNT             PIC 99 value 1.
 01     N           pic 9(03).
 01     N-BEG       pic 9(03) value 23.
 01     N-END       pic 9(03) value 32.       
 01     N-INC       pic 9 value 3.

 PROCEDURE DIVISION.
 
    Perform TEST-VARYING VARYING N from N-BEG by N-INC 
        until N > N-END
    Display "** 2 distinct childs **"
    Display "First:" LEVEL20 OF LEVEL15 OF LEVEL10 OF LEVEL05 OF PARENT1.
    Display "Second:" LEVEL20 OF LEVEL15 OF LEVEL10 OF LEVEL05 OF PARENT2.
    DISPLAY "** PERFORMING CNT OF PARENT1 TIMES **"
    PERFORM PAR1 OF SEC2 CNT OF PARENT1 TIMES 
    DISPLAY "** PERFORMING CNT OF PARENT2 TIMES **"
    PERFORM PAR1 OF SEC1 CNT OF PARENT2 TIMES 
    DISPLAY "** PERFORMING 3 TIMES **"
    PERFORM UNIQUE-PAR 3 times
    PERFORM OTHER-SIMPLE-PAR.
    perform OTHER-PAR THROUGH PAR1 of SEC1.
    stop run.

 UNIQUE-PAR.
    DISPLAY "CHILD OF PARENT3 OF PARENT1 = " CHILD OF PARENT3 OF PARENT1.
    DISPLAY "CHILD OF INNER-PARENT OF PARENT3 OF PARENT1 = " 
        CHILD OF INNER-PARENT OF PARENT3 OF PARENT1.
 OTHER-SIMPLE-PAR.
    MOVE "Item 1" TO ITEM (1)
    MOVE "Item 2" to ITEM (2)
    DISPLAY "Table values"
    Display "First: " ITEM (1)
    Display "Second: " ITEM (2)

 SEC1 SECTION.
 OTHER-PAR.
 *   INSPECT CHILD TALLYING CNT for CHARACTERS 
 *   TALLYING CNT for CHARACTERS
    DISPLAY "THIS IS AN OTHER PARAGRAPH".
 PAR1.
    DISPLAY "CHILD OF PARENT2:" CHILD OF PARENT2
    Display "OTHER-CHILD OF PARENT1:" OTHER-CHILD OF PARENT1
    Display "OTHER-CHILD OF PARENT2:" OTHER-CHILD OF PARENT2
*    DISPLAY PARENT3  of PARENT2
    
 SEC2 SECTION.   
 PAR1.
    DISPLAY "CHILD OF PARENT1:" CHILD OF PARENT1
    DISPLAY "UNIQUE-CHILD:" UNIQUE-CHILD.
 PAR2.
    DISPLAY "This should not be seen."
 TEST-VARYING.
    Display "Test varying N = " N.


