 IDENTIFICATION DIVISION.
 PROGRAM-ID. TEST19.
 ENVIRONMENT DIVISION.
 CONFIGURATION SECTION.

 INPUT-OUTPUT SECTION.
 FILE-CONTROL.

 SELECT TEST-FILE-OUT ASSIGN TO WS-FILENAME-OUT
    ORGANIZATION IS SEQUENTIAL
    ACCESS MODE  IS SEQUENTIAL.

 SELECT TEST-FILE-IN  ASSIGN TO WS-FILENAME-IN
    ORGANIZATION IS LINE SEQUENTIAL
    ACCESS MODE  IS SEQUENTIAL.


 DATA DIVISION.
 FILE SECTION.

 FD TEST-FILE-OUT
    LABEL RECORDS ARE STANDARD.
    01 TEST-RECORD-OUT.
       05   FILLER 	           PIC X(48).

 FD TEST-FILE-IN
    LABEL RECORDS ARE STANDARD.
    01 TEST-RECORD-IN.
       05   FILLER 	           PIC X(31).

 WORKING-STORAGE SECTION.

 01 WS-FILENAME-OUT PIC X(35) VALUE "test.out.txt".
 01 WS-FILENAME-IN  PIC X(35) VALUE "test.in.txt".

 01 TEST-RECORD-OUT-WS.
    05  WS-NUMBER-OUT	PIC 9(5)  VALUE 1.
    05  WS-DATA-OUT	PIC X(43) VALUE SPACES.

 01 TEST-RECORD-IN-WS.
    05  WS-DATA-IN	PIC X(31).

 01 WS-RCODE	        PIC Z(4)9 VALUE ZERO.
 01 EOF-SW		PIC X(1)  VALUE 'N'.
 01 WS-REC-COUNTER-IN	PIC 9(5)  VALUE 0.


 
copy CMDLine1.cpy. 


PROCEDURE DIVISION.

A-000.

 ACCEPT CMDLINE-PARM FROM COMMAND-LINE.

 DISPLAY "CMDLINE-ERROR           = " CMDLINE-ERROR
 DISPLAY "CMDLINE-ARGC-NUMBER     = " CMDLINE-ARGC-NUMBER
 DISPLAY "CMDLINE-ARGC-MAX-NUMBER = " CMDLINE-ARGC-MAX-NUMBER
 DISPLAY "CMDLINE-ARGV-MAX-LENGTH = " CMDLINE-ARGV-MAX-LENGTH

 IF CMDLINE-ERROR NOT EQUAL 0
    MOVE 11 TO RETURN-CODE
    MOVE RETURN-CODE TO WS-RCODE
    DISPLAY "WS-RCODE=" WS-RCODE
    STOP RUN.
    

 IF CMDLINE-ARGC-NUMBER EQUAL 2
    MOVE CMDLINE-ARGV (2) TO WS-FILENAME-OUT.

 OPEN OUTPUT TEST-FILE-OUT.
 OPEN INPUT  TEST-FILE-IN.

* READ TEST-FILE-IN INTO WS-DATA-IN
*    AT END MOVE  'Y' TO EOF-SW.
 PERFORM A-200.
 PERFORM A-100 UNTIL EOF-SW = 'Y'.

 CLOSE TEST-FILE-OUT.
 CLOSE TEST-FILE-IN.

 MOVE WS-REC-COUNTER-IN TO WS-RCODE.
 DISPLAY "WS-REC-COUNTER-IN=" WS-RCODE.

 MOVE RETURN-CODE TO WS-RCODE.
 DISPLAY "WS-RCODE=" WS-RCODE.

 STOP RUN.

A-100.

 DISPLAY "ENTER A-100".
    
 MOVE WS-DATA-IN TO WS-DATA-OUT.
 WRITE TEST-RECORD-OUT FROM TEST-RECORD-OUT-WS.

 ADD 1 TO WS-NUMBER-OUT.
 
* READ TEST-FILE-IN INTO WS-DATA-IN
*    AT END MOVE  'Y' TO EOF-SW.
 PERFORM A-200.

 DISPLAY "EXIT  A-100".

A-200.

 DISPLAY "ENTER A-200".
 
 READ TEST-FILE-IN INTO WS-DATA-IN
    AT END MOVE  'Y' TO EOF-SW.

 IF EOF-SW = 'N' 
    ADD 1 TO WS-REC-COUNTER-IN.

 DISPLAY "EXIT  A-200".
