 IDENTIFICATION DIVISION.
 PROGRAM-ID. TEST1-FORMATS.
 AUTHOR.  JIM NOETH.
 INSTALLATION. Tiny Cobol Project
 DATE-WRITTEN. 03 January, 2000.

 ENVIRONMENT DIVISION.
 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
 DATA DIVISION.
 FILE SECTION.

 WORKING-STORAGE SECTION.
 01  WS-COMP-VALUE           PIC 9(02) COMP.
 01  WS-DISPLAY-5            PIC 9(05).
 01  WS-DISPLAY-WITH-FRAC    PIC 9(05)V9999.
 01  WS-DISPLAY-WITH-SIGN    PIC S9(07).
 01  WS-ANOTHER-COMP         PIC 9(04) COMP.
 01  WS-PACKED               PIC 9(07)V99 COMP-3.
 01  WS-EDITED-1             PIC $$$$,$$9-.
 01  WS-CHARACTER-SHORT      PIC X(08).
 01  WS-CHARACTER-LONG       PIC X(15).
*
*
 01  WS-DUMP-COUNT           PIC 9(04).
 01  WS-DUMP-OUT-8           PIC X(08).
 01  WS-DUMP-OUT-10          PIC X(10).

 PROCEDURE DIVISION.
 0000-PROGRAM-ENTRY-POINT.
     DISPLAY "TEST1-FORMATS program entry."

     PERFORM A000-COMPUTATIONAL-TESTS THRU A000-EXIT.

     STOP RUN.

 A000-COMPUTATIONAL-TESTS.
 A001-TEST.
     MOVE "-5432" TO WS-COMP-VALUE.
     MOVE WS-COMP-VALUE TO WS-DISPLAY-5.
     DISPLAY "A301:(" WS-DISPLAY-5 "):(05432):"
             "COMP MOVE 5432 TO 9(05)".

     MOVE WS-COMP-VALUE TO WS-DISPLAY-WITH-FRAC.
     DISPLAY "A302:(" WS-DISPLAY-WITH-FRAC "):(054320000):"
             "COMP MOVE 5432 TO 9(05)V9(04)".

     MOVE WS-COMP-VALUE TO WS-DISPLAY-WITH-SIGN.
     DISPLAY "A303:(" WS-DISPLAY-WITH-SIGN "):(000543K):"
             "COMP MOVE 5432 TO S9(07)".

     MOVE WS-COMP-VALUE TO WS-ANOTHER-COMP.
     MOVE 4 TO WS-DUMP-COUNT.
     CALL "_DUMP_" USING
         WS-ANOTHER-COMP
         WS-DUMP-COUNT
         WS-DUMP-OUT-8.  
     DISPLAY "A304:(" WS-DUMP-OUT-8 "):(C8EAFFFF):"
             "COMP MOVE 5432 TO 9(04) COMP".

     MOVE WS-COMP-VALUE TO WS-PACKED.
     MOVE 5 TO WS-DUMP-COUNT.
     CALL "_DUMP_" USING
         WS-PACKED
         WS-DUMP-COUNT
         WS-DUMP-OUT-10.
     DISPLAY "A305:(" WS-DUMP-OUT-10 "):(000543200D):"
             "COMP MOVE 5432 TO 9(06)V9(02) COMP-3".

     MOVE WS-COMP-VALUE TO WS-EDITED-1.
     DISPLAY "A306:(" WS-EDITED-1 "):(  $5,432-):"
             "COMP MOVE 5432 TO $$$$,$$9-".

     MOVE 97531 TO WS-COMP-VALUE.
     MOVE WS-COMP-VALUE TO WS-DISPLAY-WITH-SIGN.
     MOVE WS-DISPLAY-WITH-SIGN TO WS-ANOTHER-COMP.
     MOVE 4 TO WS-DUMP-COUNT.
     CALL "_DUMP_" USING
         WS-ANOTHER-COMP
         WS-DUMP-COUNT
         WS-DUMP-OUT-8.
     DISPLAY "A307:(" WS-DUMP-OUT-8 "):(FB7C0100):"
         "MOVE 97531 AS S9(07) TO 9(04) COMP".


     MOVE "-8642975" TO WS-COMP-VALUE.
     MOVE WS-COMP-VALUE TO WS-PACKED.
     MOVE WS-PACKED TO WS-ANOTHER-COMP.
     MOVE 4 TO WS-DUMP-COUNT.
     CALL "_DUMP_" USING
         WS-ANOTHER-COMP
         WS-DUMP-COUNT
         WS-DUMP-OUT-8.
     DISPLAY "A308:(" WS-DUMP-OUT-8 "):(611E7CFF):"
         "MOVE -8642975 AS 9(07)V9(04) COMP-3 TO 9(04) COMP".

     MOVE WS-COMP-VALUE TO WS-CHARACTER-SHORT.
     DISPLAY "A309:(" WS-CHARACTER-SHORT "):(00086429):"
         "MOVE -8642975 AS COMP TO PIC X(08)".

     MOVE WS-COMP-VALUE TO WS-CHARACTER-LONG.
     DISPLAY "A310:(" WS-CHARACTER-LONG "):(0008642975-    ):"
         "MOVE -8642975 AS COMP TO PIC X(15)". 

 A000-EXIT.
     EXIT.
