       IDENTIFICATION DIVISION.
       PROGRAM-ID.    IDXIO01.
       ENVIRONMENT DIVISION.
*      This program creates the random access file used in
*      subsequent tests in this directory.

       CONFIGURATION SECTION. 
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        SELECT TEST-FILE 
            ASSIGN TO "./idx_test.dat" 
            ORGANIZATION IS INDEXED
            ACCESS MODE  IS DYNAMIC
	    RECORD KEY IS TR-KEY
            FILE STATUS  IS TR-FS.

       DATA DIVISION.
       FILE SECTION.
       FD  TEST-FILE
           LABEL RECORDS ARE STANDARD.
       01  TEST-REC.
           05  TR-KEY                 PIC  9(03).
           05  TR-REC-TYPE            PIC  X(02).
           05  TR-DESCRIPTION         PIC  X(60).
       
       
       WORKING-STORAGE SECTION.
        01  TR-FS                      PIC 9(02).
	01  W-COUNTER	               PIC 9(15).
	01  REM		               PIC 9(5).
 
       PROCEDURE DIVISION.
       0000-PROGRAM-ENTRY.
            PERFORM A000-INITIALIZE.

            PERFORM 9000-WRITE-IT 998 TIMES.
            PERFORM B000-HOUSEKEEPING.

            STOP RUN.

       A000-INITIALIZE.
	   MOVE ZERO             TO W-COUNTER.
	   OPEN OUTPUT TEST-FILE.
           DISPLAY "IXO1:(" TR-FS "):(00):INDEX WRITE OPEN".

       B000-HOUSEKEEPING.
	   CLOSE TEST-FILE.
           DISPLAY "IXC1:(" TR-FS "):(00):INDEX WRITE CLOSE".

      9000-WRITE-IT.
           ADD 1 TO W-COUNTER.
           MOVE W-COUNTER TO TR-KEY.
           MOVE "UR"             TO TR-REC-TYPE.
           MOVE "Undefined Record Type" TO TR-DESCRIPTION.

           IF W-COUNTER = 50
              MOVE "S1"          TO TR-REC-TYPE
              MOVE "FIFTY"       TO TR-DESCRIPTION.

           IF W-COUNTER = 100
              MOVE "S2"          TO TR-REC-TYPE
              MOVE "HUNDRED"     TO TR-DESCRIPTION.

           IF W-COUNTER = 200
              MOVE "S3"          TO TR-REC-TYPE
              MOVE "TWO HUNDRED" TO TR-DESCRIPTION.

           IF W-COUNTER = 998
              MOVE "S4"          TO TR-REC-TYPE
              MOVE "LAST"        TO TR-DESCRIPTION.

           WRITE TEST-REC.
           IF TR-REC-TYPE <> "UR"
              DISPLAY "IX01:(" TR-FS "):(00):INDEX FILE WRITE".

