       IDENTIFICATION DIVISION.
       PROGRAM-ID.    IDXIO02.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION. 
       SPECIAL-NAMES.
           DECIMAL-POINT IS COMMA.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        SELECT TEST-FILE 
            ASSIGN TO "./idx_test.dat" 
            ORGANIZATION IS INDEXED
            ACCESS MODE  IS DYNAMIC
	    RECORD KEY IS TR-KEY
            FILE STATUS  IS TR-FS.

       DATA DIVISION.
       FILE SECTION.
       FD  TEST-FILE
           LABEL RECORDS ARE STANDARD.
       01  TEST-REC.
           05  TR-KEY                 PIC  9(03).
           05  TR-REC-TYPE            PIC  X(02).
           05  TR-DESCRIPTION         PIC  X(60).
       
       WORKING-STORAGE SECTION.
        01 TR-FS                      PIC 9(02).
	01 W-COUNTER                  PIC 9(15).
	01 REM		PIC 9(5).
        01 W01-SWITCHES	PIC X(03).
        88	W01-END	VALUE "YES".
        88	W01-MORE VALUE "NO".
 
      PROCEDURE DIVISION.
      0000-PROGRAM-ENTRY.
          PERFORM A000-INITIALIZE.

          MOVE 1                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX21:(" TR-FS "):(00):INDEX FILE READ".
          DISPLAY "IX22:(" TR-REC-TYPE "):(UR):INDEX FILE READ".

          MOVE 50                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX23:(" TR-FS "):(00):INDEX FILE READ".
          DISPLAY "IX24:(" TR-REC-TYPE "):(S1):INDEX FILE READ".

          MOVE 100                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX23:(" TR-FS "):(00):INDEX FILE READ".
          DISPLAY "IX24:(" TR-REC-TYPE "):(S2):INDEX FILE READ".

          MOVE 200                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX23:(" TR-FS "):(00):INDEX FILE READ".
          DISPLAY "IX24:(" TR-REC-TYPE "):(S3):INDEX FILE READ".

          MOVE 998                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX23:(" TR-FS "):(00):INDEX FILE READ".
          DISPLAY "IX24:(" TR-REC-TYPE "):(S4):INDEX FILE READ".

          MOVE 999                TO W-COUNTER.
          PERFORM C000-PROCESS.
          DISPLAY "IX23:(" TR-FS "):(23):INDEX FILE READ PAST EOF".

          PERFORM B000-HOUSEKEEPING.

          STOP RUN.


      A000-INITIALIZE.
          OPEN I-O TEST-FILE.
          DISPLAY "IXO2:(" TR-FS "):(00):INDEX READ OPEN".
          MOVE "NO" TO W01-SWITCHES.
          MOVE 1                TO W-COUNTER.

      B000-HOUSEKEEPING.
	  CLOSE TEST-FILE.
          DISPLAY "IXC2:(" TR-FS "):(00):INDEX READ CLOSE".

      C000-PROCESS.
          MOVE W-COUNTER TO TR-KEY.

          READ TEST-FILE 
             AT END 
             MOVE "YES" TO W01-SWITCHES.
