       IDENTIFICATION DIVISION.
       PROGRAM-ID.    IDXIO03.
       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION. 
       SPECIAL-NAMES.
           DECIMAL-POINT IS COMMA.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        SELECT TEST-FILE 
            ASSIGN TO "./idx_test.dat" 
            ORGANIZATION IS INDEXED
            ACCESS MODE  IS SEQUENTIAL
            RECORD KEY   IS TR-KEY
            FILE STATUS  IS TR-FS.

       DATA DIVISION.
       FILE SECTION.
       FD  TEST-FILE
           LABEL RECORDS ARE STANDARD.
       01  TEST-REC.
           05  TR-KEY                 PIC  9(03).
           05  TR-REC-TYPE            PIC  X(02).
           05  TR-DESCRIPTION         PIC  X(60).
       
       WORKING-STORAGE SECTION.
        01 TR-FS                      PIC 9(02).
	01 W-COUNTER                  PIC 9(15).
	01 REM		PIC 9(5).
        01 W01-SWITCHES	PIC X(03).
        88	W01-END	VALUE "YES".
        88	W01-MORE VALUE "NO".
 
      PROCEDURE DIVISION.
      0000-PROGRAM-ENTRY.
          PERFORM A000-INITIALIZE.

      0000-LOOP.
          PERFORM C000-PROCESS THRU C000-EXIT .
          IF W01-SWITCHES = "NO"
             GO TO 0000-LOOP.

          PERFORM B000-HOUSEKEEPING.

          STOP RUN.


      A000-INITIALIZE.
          OPEN INPUT TEST-FILE.
          MOVE LOW-VALUES TO TR-KEY.
          DISPLAY "ISO2:(" TR-FS "):(00):S/INDEX READ OPEN".
          MOVE "NO" TO W01-SWITCHES.
          MOVE 0                TO W-COUNTER.

      B000-HOUSEKEEPING.
	  CLOSE TEST-FILE.
          DISPLAY "ISC2:(" TR-FS "):(00):S/INDEX READ CLOSE".

      C000-PROCESS.
*          ADD 1 TO W-COUNTER.
*          MOVE W-COUNTER TO TR-KEY.

          READ TEST-FILE NEXT.

          IF TR-FS NOT = 0
             MOVE "YES" TO W01-SWITCHES
             GO TO C000-EXIT.

          IF TR-KEY = 1
          DISPLAY "IS21:(" TR-FS "):(00):S/INDEX FILE READ"
          DISPLAY "IS22:(" TR-REC-TYPE "):(UR):S/INDEX FILE READ".

          IF TR-KEY = 50
          DISPLAY "IS23:(" TR-FS "):(00):S/INDEX FILE READ" 
          DISPLAY "IS24:(" TR-REC-TYPE "):(S1):S/INDEX FILE READ".

          IF TR-KEY = 75
          DISPLAY "IS21:(" TR-FS "):(00):S/INDEX FILE READ"
          DISPLAY "IS22:(" TR-REC-TYPE "):(UR):S/INDEX FILE READ".

          IF TR-KEY = 100
          DISPLAY "IS23:(" TR-FS "):(00):S/INDEX FILE READ" 
          DISPLAY "IS24:(" TR-REC-TYPE "):(S2):S/INDEX FILE READ".

          IF TR-KEY = 200
          DISPLAY "IS23:(" TR-FS "):(00):S/INDEX FILE READ" 
          DISPLAY "IS24:(" TR-REC-TYPE "):(S3):S/INDEX FILE READ".

          IF TR-KEY = 998
          DISPLAY "IS23:(" TR-FS "):(00):S/INDEX FILE READ" 
          DISPLAY "IS24:(" TR-REC-TYPE "):(S4):S/INDEX FILE READ".

      C000-EXIT.
          EXIT.
