 IDENTIFICATION DIVISION.
 PROGRAM-ID.    SEQIO06.
 ENVIRONMENT DIVISION.

 CONFIGURATION SECTION. 
 SPECIAL-NAMES.
     DECIMAL-POINT IS COMMA.
 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
     SELECT GOZOUT ASSIGN TO "./test06.dat" 
            ORGANIZATION IS SEQUENTIAL 
            ACCESS MODE  IS SEQUENTIAL
            FILE STATUS  IS FS.

 DATA DIVISION.
 FILE SECTION.

 FD  GOZOUT
     LABEL RECORDS ARE OMITTED.
 01  GOZOUT-REC.
     03 X-IND                         PIC  9(03).
     03 DESCRIPTION                   PIC  X(20).
     03 FILLER                        PIC  X(57).
      
 WORKING-STORAGE SECTION.
 01  FS                              PIC  9(02).
 01  WS-COUNTERS.
     05 WS-TEST-COUNTER              PIC  9(4).

 PROCEDURE DIVISION.
 0000-PROGRAM-ENTRY.
      MOVE 0              TO WS-TEST-COUNTER.
      PERFORM B000-INITIALIZE THRU B000-EXIT.
      PERFORM C000-MAIN-LOGIC THRU C000-EXIT.
      PERFORM D000-CLEANUP THRU D000-EXIT.
      PERFORM E000-SUMMARY THRU E000-EXIT.
      STOP RUN.
      
      DISPLAY "SQ06:(IL):(FA):PROGRAM RAN PAST STOP RUN".

 0000-EXIT.
      EXIT.
 
 B000-INITIALIZE.
      OPEN OUTPUT GOZOUT.
      ADD 1             TO WS-TEST-COUNTER.
      DISPLAY "SO01:(" FS "):(00):"
          "SEQUENTIAL I/O OPEN STATUS".
 B000-EXIT.
      EXIT.

 C000-MAIN-LOGIC.
      MOVE SPACES TO GOZOUT-REC.
      MOVE 001 TO X-IND.
      MOVE "FIRST RECORD" TO DESCRIPTION.
      WRITE GOZOUT-REC.
      DISPLAY "SO02:(" FS "):(00):"
          "SEQUENTIAL I/O WRITE STATUS".
      ADD 1             TO WS-TEST-COUNTER.

      MOVE 002 TO X-IND.
      MOVE "SECOND RECORD" TO DESCRIPTION.
      WRITE GOZOUT-REC.
      DISPLAY "SO02:(" FS "):(00):"
          "SEQUENTIAL I/O WRITE STATUS".
      ADD 1             TO WS-TEST-COUNTER.

      MOVE 003 TO X-IND.
      MOVE "THIRD RECORD" TO DESCRIPTION.
      WRITE GOZOUT-REC.

      DISPLAY "SO02:(" FS "):(00):"
          "SEQUENTIAL I/O WRITE STATUS".
      ADD 1             TO WS-TEST-COUNTER.
 C000-EXIT.
      EXIT.

 D000-CLEANUP.
      CLOSE GOZOUT.
      DISPLAY "SO03:(" FS "):(00):"
          "SEQUENTIAL I/O CLOSE STATUS".
      ADD 1             TO WS-TEST-COUNTER.
 D000-EXIT.
      EXIT.
 
 E000-SUMMARY.
      DISPLAY "SO04:(" WS-TEST-COUNTER "):(0005):"
          "TEST COUNT VALIDATION".
 E000-EXIT.
      EXIT. 
