 IDENTIFICATION DIVISION.
 PROGRAM-ID.    SEQLS02.
 ENVIRONMENT DIVISION.

 CONFIGURATION SECTION. 
 SPECIAL-NAMES.
     DECIMAL-POINT IS COMMA.
 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
     SELECT GOZIN ASSIGN TO "./lineseq.dat" 
            ORGANIZATION IS LINE SEQUENTIAL 
            ACCESS MODE  IS SEQUENTIAL
            FILE STATUS  IS FS.

 DATA DIVISION.
 FILE SECTION.

 FD  GOZIN
     LABEL RECORD IS STANDARD.
 01  GOZIN-REC.
     03 X-IND                         PIC  9(03).
     03 DESCRIPTION                   PIC  X(20).
     03 FILLER                        PIC  X(57).
      
 WORKING-STORAGE SECTION.
 01  FS                              PIC  9(02).

 PROCEDURE DIVISION.
 0000-PROGRAM-ENTRY.
      PERFORM B000-INITIALIZE THRU B000-EXIT.
      PERFORM C000-MAIN-LOGIC THRU C000-EXIT.
      PERFORM D000-CLEANUP THRU D000-EXIT.
      STOP RUN.

 B000-INITIALIZE.
      OPEN INPUT GOZIN.
      DISPLAY "SQ01:(" FS "):(00):"
          "SEQUENTIAL I/O OPEN STATUS".
 B000-EXIT.
     EXIT.

 C000-MAIN-LOGIC.
      READ GOZIN.
      DISPLAY "SR02:(" FS "):(00):"
          "SEQUENTIAL I/O READ STATUS".
      DISPLAY "SR03:(" X-IND "):(001):"
          "DATA FROM READ".
      DISPLAY "SR03:(" DESCRIPTION "):(FIRST RECORD        ):"
          "DATA FROM READ".

      READ GOZIN.
      DISPLAY "SR02:(" FS "):(00):"
          "SEQUENTIAL I/O READ STATUS".
      DISPLAY "SR03:(" X-IND "):(002):"
          "DATA FROM READ".
      DISPLAY "SR03:(" DESCRIPTION "):(SECOND RECORD       ):"
          "DATA FROM READ".

      READ GOZIN.
      DISPLAY "SR02:(" FS "):(00):"
          "SEQUENTIAL I/O READ STATUS".
      DISPLAY "SR03:(" X-IND "):(003):"
          "DATA FROM READ".
      DISPLAY "SR03:(" DESCRIPTION "):(THIRD RECORD        ):"
          "DATA FROM READ".
 C000-EXIT.
      EXIT.

 D000-CLEANUP.
      CLOSE GOZIN.
      DISPLAY "SR04:(" FS "):(00):"
          "SEQUENTIAL I/O CLOSE STATUS".

 D000-EXIT.
     EXIT.  
