/*
 *  Cobol PreProcessor program used with Cobol Translator.
 *
 *
 *  Supports two types of cobol source formats:
 *     Free Format - X/Open
 *	Column one is indicator area:
 *	*	 - Comment
 *	/	 - Comment
 *	D	 - Debug statement
 *	$	 - Compiler Directive
 *      
 *      Continuation is handled by the "&" operator.
 *
 *     Fixed Format - Classic (Ansi 85)
 *	Col	-
 *	1,6	- Striped as Sequence number
 * 	7	-  Indicator Area
 *		   * Comment 
 *		   D debug line
 *		   / Comment
 *		   - Continuation
 *
 *	8,11	- Area A
 *	12,72	- Area B
 *	72, 80  - End of LIne Comment
 *
 *  Tab Expandsion
 *    Expand all tabs to X number of indicated spaces.
 *    Default is to treat tabs as one space.
 *
 *  Primarily parse for source format
 *  --free-format (-f) X/Open Free Format
 *  --fixed-format(-x) X/Open Free Format
 *
 *  Exand Tabs if switch.
 *  --tab <no.>(-t)       // no expansion by default
 * 
 * Level ignored.
 * Warning Levels
 *  -W0		ignore  use of tabs. 
 *  -W[1]	warn	use of tabs. 
 *  -W2		error   cwarn about use of tabs. 
 * 
 */


#define GLOBAL_DEF
//#ifndef INCLUDED_COBPP_H
#include "cobpp.h"
//#endif

extern FILE *yyin;

/* Global Env struct due to yywrap, yylex */

int main( int argc , char** argv ) {

	int funcError = 0;
	int rc =0;
	char *cmdstr =NULL;
/*	char command[] = "/bin/expand -t "; 
*/
	char command[] = "exp.exe -t ";

	globalEnvPtr = &globalEnv ;
	rc = setDefaults( &globalEnv );
	if ( rc != 0 ){
		fprintf(stderr,"Error in setDefaults\n");
		return 9;
	}

	funcError = setOptions( &globalEnv, argc, argv );

	/* error, or help/version printed */
	if ( funcError == 1 ) {
		return 1;
	}

	/* print mini help */
	if ( globalEnv.errFlag != 0  ) {
		printHelp( 0 );
		return 2;
	}
		
	/* everything ok, continue and parse file */

#ifdef DEBUG
	printf("Continue with parse\n");
#endif
/***************************************************************************
 */
#if 0

	for( i = listLength( globalEnv.fnList );0<i;i--) {
		printf("Length of List: %d, %d\n"
			,i,listLength(globalEnv.fnList) 
		);
		fileName = (char*)listGet(globalEnv.fnList,i);

		if ( fileName != NULL ){
			printf(" output: %d \n", strlen( fileName ) );
			printf("File: %s\n", fileName );
		}
	}	
#endif

/****************************************************/
	

/*	if ( globalEnv.tab2space != 0 ) {
		cmdstr = malloc( sizeof(char)*
				 (strlen(command)+3+1+
				 strlen(globalEnv.filename)
				  )
			);

		if ( cmdstr == NULL ) {
			fprintf(stderr,
				"Error mallocing for command string\n"
			);
			return 9;
		}

		if ( globalEnv.tab2space > 99 )
			globalEnv.tab2space = 99 ;
		if ( globalEnv.tab2space < 0 )
			globalEnv.tab2space = 1 ;
		sprintf(cmdstr,"%s%d %s"
			,command
			, globalEnv.tab2space
			, globalEnv.filename
		);	
		yyin = popen(cmdstr,"rw");
		if ( yyin == NULL ) {
			fprintf(stderr,
				"Error opening pipe on file: %s\n"
				,globalEnv.filename
			);
			return 8;
		}
	} else if ( strcmp(globalEnv.filename," ") == 0) {
		yyin = stdin;
	} else { */
                yyin = fopen( globalEnv.filename, "r");
                if ( yyin == NULL ) {
			fprintf(stderr,
				"Error opening file: %s\n"
				,globalEnv.filename
			);
		
			return 8;
		}
//	}

	yylex();


	return 0;
}

