/* ==========================================================================
    <UCONIO.H> = Unix Console Input Output
	-A port/customizing of the CONIO D.O.S library (Console
	 Input/Output) to UNIX.
	 Also, i added some extra functions.

    File Version: UConio-1.0.5-PR
    Date: Tue Sep 19 22:49:09 ART 2000
    Author: Pablo J. Vidal <pablo@pablovidal.org>    
    URL: http://www.pablovidal.org
    
    BUG REPORTS TO: <uconio-bugs@pablovidal.org>
    
    Current Working Functions:
	* u_clrscr()      -   Clear the Screen
	* u_gotoxy()      -   Move the cursor to anywhere on the screen
    [E] * u_beep()        -   Play a single or more beeps on the PC Speaker
	* u_textcolor()   -   Change the Text foreground and background colour
    [E] * u_textattr()    -   Change the Text attributes
        * u_wherex()      -   Gets current x cursor position
        * u_wherey()      -   Gets current y cursor position
	* u_getch()       -   Gets a single character from the stdin
	* u_getche()      -   Gets and echo a single char from stdin to stdout
	* u_normvideo()   -   Reset the Video attribs to Default
	* u_clreol()      -   Clear the current line
	* u_puttext()     -   Create a BOX with characters inside
    [E] * u_vputc()       -   Put a determinated quantity of characters on the
	                      screen
    
    (NOTE: the [E] icon placed before the function name means the
	   contiguous function is an Extra function isnt in conio.h)
	
    ToDo:
	 Write a new tutorial
 ============================================================================ */

/* The Includes */
#include "uconio.h"

struct Properties Properties;

/* ********************************************************************* 
   ** HERE BEGINS THE FUNCTIONS DEFINITIONS                           **
   ********************************************************************* */
   
/* u_clrscr() - The function to clear the screen */
void u_clrscr(void)
    {
	fprintf(stdout, "\033[2J");
	
	Properties.x=0;
	Properties.y=0;
	
	fprintf(stdout, "\033[%i;%iH", def_y, def_x);	    
	fprintf(stdout, "\033[0;0;39m");
    }
    

/* u_gotoxy() - The function to position the cursor anywhere on the 
		screen.  */
void u_gotoxy(short x, short y)
    {
	
	if(x<X_MIN || y<Y_MIN || x>X_MAX || y>Y_MAX) 
	    {
		x = def_x; 
		y = def_y; 
	    }

	Properties.x=x;
	Properties.y=y;

	fprintf(stdout, "\033[%i;%iH", y, x); 
    }	
    

/* u_beep() - And Additional function to play a single or more beeps through
              the PC Speaker (BUILT IN ON CPU). */
void u_beep(register int times)
    {
	while(times>0)
	    {
		putchar('\a');
		times--;
	    }
    }	    


/* u_textcolor() - A function to customize the Text Foreground and 
                   Background colour */
void u_textcolor(short int bg, short int fg)
    {
	int fore;
	int back;
	int attrb;

	
	switch(Attribute)
	    {
		case 0: /* Normal */
			Properties.attr=0;
			attrb=0;
			break;
		case 1: /* Bold */
			Properties.attr=1;
			attrb=1;
			break;
		case 5: /* Blink */
			Properties.attr=5;
			attrb=5;
			break;
		default:
			attrb=0;
			break;
	    }
		
	switch(fg)
	    {
		case 0: /* Black */
			Properties.fg=0;
			fore=30;
			break;
	        case 1: /* Red */
			Properties.fg=1;
			fore=31;
			break;
	    	case 2: /* Green */
			Properties.fg=2;
			fore=32;
			break;
		case 3: /* Brown */
			Properties.fg=3;
			fore=33;
			break;
	    	case 4: /* Blue */
			Properties.fg=4;
			fore=34;
		    	break;
		case 5: /* Magenta */
		    	Properties.fg=5;
			fore=35;
			break;
		case 6: /* Cyan */
			Properties.fg=6;
			fore=36;
			break;
		case 7: /* White */
			Properties.fg=7;
			fore=37;
			break;
		case 8: /* Default Colour */
			Properties.fg=8;
			fore=39;
			break;
		default:		
			Properties.fg=8;
			fore=39;
			break; 
	    }
	
	switch(bg)
	    {
		case 0: /* Black */
			Properties.bg=0;
			back=40;
			break;
		case 1: /* Red */
			Properties.bg=1;
			back=41;
			break;
		case 2: /* Green */
			Properties.bg=2;
			back=42;
			break;
		case 3: /* Brown */
			Properties.bg=3;
			back=43;
			break;
		case 4: /* Blue */
			Properties.bg=4;
			back=44;
			break;
		case 5: /* Magenta */
			Properties.bg=5;
			back=45;
			break;
		case 6: /* Cyan */
			Properties.bg=6;
			back=46;
			break;
		case 7: /* White */
			Properties.bg=7;
			back=47;
			break;
		case 8: /* Default colour */
			Properties.bg=8;
			back=49;
			break;
		default:
			Properties.bg=8;
			back=49;
			break;
	    }
		
	fprintf(stdout, "\033[0;%i;%i;%im", attrb, back, fore);			
    }
	

/* u_textattr() - A function to change the text attributes */
void u_textattr(register int attri)    
    {
	switch(attri)
	    {
		case 0:  /* Normal Text */
			Attribute=0;
			break;
		case 1:  /* Bold Text */
			Attribute=1;
			break;
		case 2:  /* Blink Text */
			Attribute=5;
			break;
		default: /* Default Text Attributes */
			Attribute=0;
			break;
	    }

	fprintf(stdout, "\033[0;%im", Attribute);
    }


/* u_wherex() - A function to get the current 'x' position */
short int u_wherex(void)
    {
    	return Properties.x;
    }
	

/* u_wherey() - A function to get the current 'y' position */
short int u_wherey(void)
    {
	return Properties.y;
    }	


/* u_clreol() - Clear all the characters to the end of the current line */
void u_clreol(void)
    {
	fprintf(stdout, "\e[2K");
    }


/* u_normvideo() - Set the Video Properties to Default */
void u_normvideo(void)
    {
	fprintf(stdout, "\e[0m");
	Properties.attr = 0;
	Properties.fg = 8;
	Properties.bg = 8;
    }    


/* u_puttext() - Create a BOX and put characters inside */
int u_puttext(int left, int top, int right, int bottom, char *string)
    {
	int characters = 0;
	int MaxX, MaxY;
	char *s = string;
	
	if(left<X_MIN || top<Y_MIN || left>X_MAX || top>Y_MAX || right<X_MIN || bottom<Y_MIN || right>X_MAX || bottom>Y_MAX)
	    {
		return (int)EOF;
	    }
	
	for(MaxY=bottom - top; MaxY>0; MaxY--)
	    {
		u_gotoxy(left, top++);
		
		for(MaxX=right - left; *s != '\0' && MaxX>0; MaxX--, s++, characters++)
		    {
			putchar(*s);
		    }
		    
		if(*s=='\0')
		    {
			break;
		    }
		    
	    }
	    
	return characters;
    }    


/* u_getch() - Function to get a single character from the stdin device */
int u_getch(void) 
    {
	static signed int returned = (-1), fd;
	static struct termios nueva, antes;
	fd = fileno(stdin);
	tcgetattr(fd, &antes);
	nueva = antes;
	nueva.c_lflag &= ~(ICANON);
	tcsetattr(fd, TCSANOW, &nueva);
	returned = getchar();
	tcsetattr(fd, TCSANOW, &antes);
	return returned;
    }


/* u_getche() - Function to get a single character from the sdtin device and echo to
		the stdout device */
int u_getche(void)
    {
	static signed int returned = (-1), fd;
	static struct termios nueva, antes;
	fd = fileno(stdin);
	tcgetattr(fd, &antes);
	nueva = antes;
	nueva.c_lflag &= ~(ICANON);
	tcsetattr(fd, TCSANOW, &nueva);
	returned = getchar();
	putchar(returned);
	tcsetattr(fd, TCSANOW, &antes);
	return returned;
    }


/* u_vputc() - Put a determinated number of characters on the screen */
void u_vputc(char *format, ...)
    {
	int i;
	float f;
	char c;
	va_list args;
	
	va_start(args, format);
	
	while(*format)
	    {
		switch(*format++)
		    {
			case 'i':
				i=va_arg(args, int);
				fprintf(stdout, "%i", i);
				break;
				
			case 'f':
				f=va_arg(args, float);
				fprintf(stdout, "%f", f);
				break;
				
			case 'd':
				i=va_arg(args, int);
				fprintf(stdout, "%d", i);
				break;
				
			case 'c':
				c=(char)va_arg(args, int);
				fprintf(stdout, "%c", c);
				break;
		    }
	    }
	
	va_end(chrs);
    }
		