#include <stdio.h>
#include <stdlib.h>

#include "forms.h"
#include "xfaxdefs.h"

int aliasbool = 0;
extern int dblclickline;

char *BuildAliasFile(int check)
{ 
   static char string[MAXSTRING];
   char *home = getenv("HOME");
   
   if(home != NULL)
     sprintf(string,"%s/.%s",home,XFAXALIASES);
   if(check)
   {
      if(CheckForExistence(string) == 0) /* if file doesn't exist */
	sprintf(string,"%s/%s",FAXBASE,XFAXALIASES); /* use system wide */
   }
   
   return string;
}

void SaveAliases(FL_OBJECT *brw)
{  FILE *aliases;
   int i,max;
   char *string;
 
   if (aliasbool) 
      aliasbool = 0; 
   else 
      return;

   string = BuildAliasFile(0);

   if((aliases = fopen(string,"w")) == NULL)   
   {  
      fl_show_alert("",Dialogs[COMMENT_ALIASES_CANTOPEN],"",1);
      return;
   }
   else
   {
      max = fl_get_browser_maxline(brw);
      for(i=1;i<=max;i++)
	fprintf(aliases,"%s\n",fl_get_browser_line(brw,i));
      fclose(aliases);
   }
}

void DeleteAlias(FL_OBJECT *ob, long data)
{
   int linenr;
   
   if((linenr = fl_get_browser(fd_Aliases->AliasViewer)) > 0)
   {
     fl_delete_browser_line(fd_Aliases->AliasViewer,linenr);
     aliasbool = 1;
   }
   else
     fl_show_message("",Dialogs[COMMENT_ALIASES_NOSELECT],"");
}

void BrowserDblClick(FL_OBJECT *ob, long data)
{
   fl_select_browser_line(ob, dblclickline);
   ExportAlias(ob,data);
}

void ReadAliases(FL_OBJECT *ob, long data)
{
   FILE *aliases;
   char *ptr,string[MAXSTRING],name[MAXSTRING],number[MAXSTRING];

   if((aliases = fopen(BuildAliasFile(1),"r")) == NULL)
   {  
      fl_show_message("",Dialogs[COMMENT_ALIASES_NOFOUND],"");
      data = 1;
      return;
   }
   
   data = 0;
   fl_freeze_form(fd_Aliases->Aliases);
   fl_clear_browser(fd_Aliases->AliasViewer);
   
   while(ptr = fgets(string,MAXSTRING -1,aliases), ! feof(aliases))
   {
      /* remove trailing LF to avoid extra line in v0.86 library */
      if(string[strlen(string)-1]=='\n')
	string[strlen(string)-1]=0;

      /* if required, convert aliases file from older format */
        if(strstr(string,"/")==NULL)
	{
           ptr=strstr(string,":");
           if(ptr!=NULL)
	   {
              strcpy(number,ptr+2);
              ptr[-1]='\0';
              strcpy(name,string);
              sprintf(string,"%s/%s//", number, name);
	   }
	}
      
      fl_addto_browser(fd_Aliases->AliasViewer,string);
   }
   fclose(aliases);
   fl_unfreeze_form(fd_Aliases->Aliases);
   aliasbool = 0;
}

void BrowseAliases(FL_OBJECT *ob, long data)
{
   fl_set_browser_fontsize(fd_Aliases->AliasViewer,14);
   
   ReadAliases(ob, data);

   if (data)
      return;
   /* else
      fl_deactivate_form(fd_Xfax->Xfax); */

   fl_show_form(fd_Aliases->Aliases,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,
                Dialogs[ALIASES_TITLE]);
   
   fl_set_browser_dblclick_callback(fd_Aliases->AliasViewer,BrowserDblClick,0);
   fl_set_object_dblclick(fd_Aliases->AliasViewer, 300);
}

void CloseAliases(FL_OBJECT *ob, long data)
{
   SaveAliases(fd_Aliases->AliasViewer);
   fl_activate_form(fd_Xfax->Xfax);
   fl_hide_form(fd_Aliases->Aliases);
}

void AddAlias (FL_OBJECT *ob, long data)
{  FILE *aliases;
   const char *number,*name,*institution,*service;
   char *string;

   string=BuildAliasFile(0);
   
   if(data)
      SaveAliases(fd_Aliases->AliasViewer);

   if((aliases = fopen(string,"a")) == NULL)   
   {  
      fl_show_alert("",Dialogs[COMMENT_ALIASES_CANTOPEN],"",1);
      return;
   }
   else
   {
      number = fl_get_input(fd_Xfax->Number);
      name   = fl_get_input(fd_Xfax->Name);
      institution = fl_get_input(fd_Xfax->Institution);
      service = fl_get_input(fd_Xfax->Service);

      if(strlen(number) == 0)
      {
	 fl_show_message("","Nothing to add !","");
	 return;
      }
      
      fprintf(aliases,"%s/%s/%s/%s\n",number,name,institution,service);
      fclose(aliases);
      ReadAliases(ob,data);
      if(!data) fl_show_message(name,Dialogs[COMMENT_ALIASES_ADDED],"");
   }
}

void ExportAlias (FL_OBJECT *ob, long data)
{
   int linenr;

   char *number,full_line[1024];
   
   if((linenr = fl_get_browser(fd_Aliases->AliasViewer)) > 0)
   {
      strncpy(full_line,fl_get_browser_line(fd_Aliases->AliasViewer,linenr),MAXSTRING -1);
      if((number = strchr(full_line,'')) == NULL)
      {
	 fl_show_message("",Dialogs[COMMENT_ALIASES_CORRUPTED],"");
	 return;
      }

      *number = '\0';
      number+=3;
      while(*number == ' ') number++;

      fl_set_input(fd_Xfax->Number, full_line);

      SwitchSave(1);
      modified = 1;
      if (fpbool) Erase_G3_and_Xpm(1);

      strcpy(full_line, number);

      if((number = strchr(full_line,'')) == NULL)
      {
	 fl_show_message("",Dialogs[COMMENT_ALIASES_CORRUPTED],"");
	 return;
      }

      *number = '\0';
      number+=3;
      while(*number == ' ') number++;

      fl_set_input(fd_Xfax->Name, full_line);

      strcpy(full_line, number);

      if((number = strchr(full_line,'')) == NULL)
      {
	 fl_show_message("",Dialogs[COMMENT_ALIASES_CORRUPTED],"");
	 return;
      }

      *number = '\0';
      number+=3;
      while(*number == ' ') number++;

      fl_set_input(fd_Xfax->Institution, full_line);
      fl_set_input(fd_Xfax->Service, number);
   }
   else
     fl_show_message("",Dialogs[COMMENT_ALIASES_NOSELECT],"");
}
