#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

FILE *fd;

int main(int argc, char **argv)
{
char language[80]="";
char filename[80]="src";
char line[1024];
char *pline, *endline;
int j=0, total=0;
int mode=0;

    if(argc>1) mode=atoi(argv[1]);
    if(argc>2) strcpy(language,argv[2]);

    if(language[0]!='\0') sprintf(filename,"src.%s", language);

    fd=fopen(filename,"r");
    if (fd==NULL) 
      {
      fprintf(stderr, "Can't open source file %s\n", filename);
      return(1);
      }
    
    while(!feof(fd))
    {
       pline=fgets(line, 1000, fd);
       if (pline!=NULL && isalnum(*pline)) ++total;
    }

    fclose(fd);
    fd=fopen(filename,"r");

    if (mode==1)
      printf("char *Dialogs[NUM_DIALOG_LINES];\n\n"
             "char *Builtin_Dialogs[NUM_DIALOG_LINES] = {\n");

    while(!feof(fd))
    {
       pline=fgets(line, 1000, fd);
       if (pline!=NULL)
       {
          endline=line+strlen(line)-1;
          *endline='\0';
          if(isalnum(line[0]) && mode==0) 
	     {
             while(!isspace(*pline)&& pline<endline) ++pline;
             *pline='\0';
             printf("#define %s %d\n", line, j);
             j++;
	     }
          else
          if(isalnum(line[0])) 
	     {
             while(!isspace(*pline) && pline<endline) ++pline;
             *pline='\0';
	     ++pline;
             while(isspace(*pline) && pline<endline) ++pline;
             j++;
             if(j<total && mode==1)
                printf("%s,\n", pline);
             else
                printf("%s\n", pline);
	     }
          else
	  {
             if(mode<=1 || isspace(*line) || *line=='\0') 
                printf("%s\n", line);
             else
             if(mode==2)
	     {
                pline=endline;
                while(*pline!='*' && pline>line) --pline;
                if (pline>line) --pline;
                while(isspace(*pline) && pline>line) --pline;
                if(pline<endline) ++pline;
                *pline='\0';
                pline=line;
                while(*pline!='*' && pline<endline) ++pline;
                if(pline<endline) ++pline;
                while(isspace(*pline) && pline<endline) ++pline;
                printf("# %s\n", pline);
	     }
	  }
       }
    }
    fclose(fd);
  
    if(mode==0)
       printf("\n#define NUM_DIALOG_LINES %d\n"
              "#define BUILTIN_LANGUAGE \"%s\"\n\n", total, language);
    if(mode==1)
       printf("};\n\n");

    return(0);
}
