#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>

#include "forms.h"
#include "xfaxdefs.h"

void QueueViewList()
{
struct dirent *faxdir;
DIR *spooldir;
int count=0;
   
   spooldir = opendir(info->SpoolDir);
   while((faxdir = readdir(spooldir)) != NULL)
   {
      if(count++ <2) continue; /* skip . and .. entries ! */
      fl_add_browser_line(fd_QueueView->List, faxdir->d_name);
   }
   closedir(spooldir);
}  

void QueueViewMessage()
{
char file[MAXCMD];
FILE *in;
char buffer[MAXMESSAGE]="";
char line[MAXSTRING];
char *fptr;
int linenr;

   linenr = fl_get_browser(fd_QueueView->List);
   if (linenr==0) return;
   if (fl_get_browser_line(fd_QueueView->List, linenr)==0)
   {
      fl_set_input(fd_QueueView->Message,"");
      return;
   }
   fl_deselect_browser(fd_QueueView->List);

   sprintf(file, "%s/%s/" FAXCONTENTS, info->SpoolDir, 
        fl_get_browser_line(fd_QueueView->List, linenr));
   if ((in = fopen(file,"r")) != NULL) 
   {
      fl_select_browser_line(fd_QueueView->List, linenr);
      while ((fptr=fgets(line,MAXSTRING-1,in))!=NULL)
        strcat(buffer,line);
      fl_set_input(fd_QueueView->Message,buffer);
   }
   else
      fl_set_input(fd_QueueView->Message,"");
}

void QueueViewOpen(FL_OBJECT *ob, long data)
{
   fl_show_form(fd_QueueView->QueueView,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,"MessageQueue");
   fl_clear_browser(fd_QueueView->List);
   fl_set_input(fd_QueueView->Message, "");
   QueueViewList();
}

void QueueViewClose(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_QueueView->QueueView);
}

void QueueViewSave(FL_OBJECT *ob, long data)
{
const char *file;
FILE *out;
int linenr;

   linenr = fl_get_browser(fd_QueueView->List);
   if (linenr==0) return;

   if((file = fl_show_fselector(Dialogs[COMMENT_CALLBACK_FILETOWRITE],
             "","*",msg_file)) == NULL)  return;

   if ((out = fopen(file,"w")) == NULL) 
   {
      fl_show_message(Dialogs[COMMENT_CALLBACK_CANTOPENFILE], file, 
                      Dialogs[COMMENT_CALLBACK_WRITESORRY]);
      return;
   }
   else
   {
      fprintf(out, fl_get_input(fd_QueueView->Message));
      fclose(out);
      strcpy(msg_file, file);
      printf("%s %s\n", Dialogs[COMMENT_CALLBACK_MSGSAVED], file);
   }
}

void QueueViewPrint(FL_OBJECT *ob, long data)
{
   char cmdbuffer[MAXCMD];
   char *PrintCmd;
   int linenr;

   linenr = fl_get_browser(fd_QueueView->List);
   if (linenr==0) return;

   PrintCmd  = (strlen(info->FaxPrint ) == 0) ? FAXPRINT : info->FaxPrint;
   sprintf(cmdbuffer,"%s %s/%s", PrintCmd, info->SpoolDir,
       fl_get_browser_line(fd_QueueView->List, linenr));
   
   SpawnCmd(cmdbuffer,0); /* fork, no wait !! */
   
}

void QueueViewRemove(FL_OBJECT *ob, long data)
{
int linenr;
char dirname[MAXCMD], msg[MAXCMD];
const char *dir;
DIR *faxdir;

   linenr = fl_get_browser(fd_QueueView->List);
   if (linenr==0) return;

   sprintf(dirname, "%s/%s", info->SpoolDir,
             dir=fl_get_browser_line(fd_QueueView->List,linenr));

   if ((faxdir=opendir(dirname)) == NULL) 
   {
      fl_show_message(Dialogs[COMMENT_QUEUEVIEW_CANTREMOVE], dirname, 
                      Dialogs[COMMENT_CALLBACK_SORRY]);
      return;
   }
  
   closedir(faxdir);

#ifdef FORMS081
   if (!fl_show_question(Dialogs[COMMENT_QUEUEVIEW_DOREMOVE],dir,
                         Dialogs[COMMENT_QUEUEVIEW_SUREREMOVE)))
          return;
#else
   sprintf(msg,"%s\n%s\n%s", Dialogs[COMMENT_QUEUEVIEW_DOREMOVE], dir,
                             Dialogs[COMMENT_QUEUEVIEW_SUREREMOVE]);
   if (!fl_show_question(msg,1)) return;
#endif

   EraseTmpdir(dirname);
   rmdir(dirname);
   
   fl_delete_browser_line(fd_QueueView->List, linenr);
   fl_set_input(fd_QueueView->Message, "");
}
