#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "forms.h"

#include "xfaxdefs.h"
#include "version.h"

char *UserResourceFile(int check)
{
   static char string[MAXSTRING];
   char *home = getenv("HOME");
   
   if(home != NULL)
     sprintf(string,"%s/.%s",home,XFAXRESOURCES);
   if(check)
   {
      if(CheckForExistence(string) == 0)
      { 
      fl_show_message(\
        Dialogs[COMMENT_RESOURCES_NOPERSO1],
        Dialogs[COMMENT_RESOURCES_NOPERSO2],
        Dialogs[COMMENT_RESOURCES_NOPERSO3]);
       *string = 0;
      }
   }
   return string;
}

char *SystemResourceFile(int check)
{
   static char string[MAXSTRING];
   
   sprintf(string,"%s/%s",FAXBASE,XFAXRESOURCES); /* use system wide */
   
   if(check)
   {
      if(CheckForExistence(string) == 0)
      {	
      fl_show_message("",Dialogs[COMMENT_RESOURCES_NOSYSTEM2],
                         Dialogs[COMMENT_RESOURCES_NOSYSTEM3]);
       *string = 0;
      }
   }
   return string;
}

char *ReadString(const char *label,char *value,FILE *rcfile)
{  char string[MAXSTRING];
   char *ptr;
   int count;
   rewind(rcfile);
   
   while(1)
   {
      fgets(string,MAXSTRING,rcfile);
      if(feof(rcfile))
      {
	 *value = 0;
	 return NULL;
      }
      
      /* Include ":" in compare string by setting count 1 higher to avoid
       * confusing resources starting with the same string ! */
      for(ptr=string,count=1; *ptr != ':' && *ptr != '\0';ptr++,count++);
      if(! strncmp(string,label,count))
      {
	 sscanf(string,label,value);
	 break;
      }
   }
   
   return value;
}

void WriteString(const char *label,const char *value,FILE *rcfile)
{
   if(strlen(value) > 0)
     fprintf(rcfile,label,value);
}

void InitTmpdirs(const Xfaxrc *info)
{
   const char *TmpBuildDir;
   char *ptr;
   int  i;

   for (i=0; i<MAXDOCS; i++) 
   {
      doc_page_count[i] = 0;
      doc_index[i] = i;
   }
   
   TmpBuildDir = (strlen(info->TmpBuildDir) == 0) ? 
                    TMPSPOOLDIR : info->TmpBuildDir;

   strncpy(tmpdir,TmpBuildDir,MAXSTRING / 2);
   ptr = strrchr(tempnam(NULL,"xfax"),'/'); /* strip prefix */
   strncat(tmpdir,ptr,MAXSTRING / 2);
   mkdir(tmpdir,0755);   
}

Xfaxrc *LoadUserInfo()
{
   FILE *rcfile;
   static Xfaxrc info;
   int i;

   /* enable all flags by default */
   strcpy(info.Flags,"++++++++H"); 

   if((rcfile = fopen(UserResourceFile(1),"r")) == NULL)
   {
      if((rcfile = fopen(SystemResourceFile(1),"r")) == NULL)
      { 
          InitTmpdirs(&info);
	  return &info;
      }
   }
   
   ReadString("Cover: %[^\n]",   info.Cover,rcfile);
   ReadString("Dialogs: %[^\n]",  info.Dialogs,rcfile);
   ReadString("HelpFile: %[^\n]", info.HelpFile,rcfile);

   ReadString("FaxSend: %[^\n]"  ,info.FaxSend,rcfile);
   ReadString("FaxPrint: %[^\n]" ,info.FaxPrint,rcfile);
   ReadString("G3ToXpm: %[^\n]"  ,info.G3ToXpm,rcfile);
   ReadString("FilterToG3: %[^\n]"  ,info.FilterToG3,rcfile);
   ReadString("ImgTypes: %[^\n]" ,info.ImgTypes,rcfile);

   ReadString("TmpBuildDir: %[^\n]" ,info.TmpBuildDir,rcfile);
   ReadString("SpoolDir: %[^\n]" ,info.SpoolDir,rcfile);
   ReadString("Editor: %[^\n]"   ,info.Editor,rcfile);

   ReadString("Flags: %[^\n]"    ,info.Flags,rcfile);

   ReadString("Name: %[^\n]"    ,info.Name,rcfile);
   ReadString("Function: %[^\n]"   ,info.Function,rcfile);
   ReadString("Department: %[^\n]"   ,info.Department,rcfile);
   ReadString("Telephone: %[^\n]"    ,info.Telephone,rcfile);
   ReadString("Faxnumber: %[^\n]"    ,info.Faxnumber,rcfile);
   ReadString("Email: %[^\n]"   ,info.Email,rcfile);
   ReadString("Headaddr: %[^\n]",info.Headaddr,rcfile);
   fclose(rcfile);
 
   for(i=0; i<8; i++) if(info.Flags[i]!='-') info.Flags[i]='+';
   if(info.Flags[8]!='M' && info.Flags[8]!='L') info.Flags[8]='H';
   info.Flags[9]='\0';

   InitTmpdirs(&info);

   return &info;
}

void SaveUserInfo(const Xfaxrc *info)
{
   FILE *rcfile;
   char *string;
   
   string = UserResourceFile(0);
   if(strlen(string) == 0 || (rcfile = fopen(string,"w")) == NULL)
   { 
      fl_show_message("",Dialogs[COMMENT_RESOURCES_CANTWRITE],"");
      return;
   }

   WriteString("Cover: %s\n"    ,info->Cover,rcfile);
   WriteString("Dialogs: %s\n" ,  info->Dialogs,rcfile);
   WriteString("HelpFile: %s\n\n" ,info->HelpFile,rcfile);

   WriteString("FaxSend: %s\n"   ,info->FaxSend,rcfile);
   WriteString("FaxPrint: %s\n"  ,info->FaxPrint,rcfile);
   WriteString("G3ToXpm: %s\n"   ,info->G3ToXpm,rcfile);
   WriteString("FilterToG3: %s\n\n" ,info->FilterToG3,rcfile);
   WriteString("ImgTypes: %s\n"  ,info->ImgTypes,rcfile);

   WriteString("TmpBuildDir: %s\n"  ,info->TmpBuildDir,rcfile);
   WriteString("SpoolDir: %s\n"  ,info->SpoolDir,rcfile);
   WriteString("Editor: %s\n\n"  ,info->Editor,rcfile);

   WriteString("Flags: %s\n\n"   ,info->Flags,rcfile);

   WriteString("Name: %s\n"      ,info->Name,rcfile);
   WriteString("Function: %s\n"     ,info->Function,rcfile);
   WriteString("Department: %s\n",info->Department,rcfile);
   WriteString("Telephone: %s\n" ,info->Telephone,rcfile);
   WriteString("Faxnumber: %s\n" ,info->Faxnumber,rcfile);
   WriteString("Email: %s\n"     ,info->Email,rcfile);
   WriteString("Headaddr: %s\n"  ,info->Headaddr,rcfile);
   
   fclose(rcfile);
}

void InitFromWin(FD_FromWin *fw)
{
   fw->vdata = (void *)info;
   
   fl_deactivate_form(fd_Xfax->Xfax);
   
   fl_set_input(fw->Name, info->Name); 
   fl_set_input(fw->Function,info->Function);
   fl_set_input(fw->Department,info->Department);
   fl_set_input(fw->Telephone,info->Telephone);
   fl_set_input(fw->Faxnumber,info->Faxnumber);
   fl_set_input(fw->Email,info->Email);
   fl_set_input(fw->Headaddr,info->Headaddr);
   
   fl_show_form(fw->FromWin,FL_PLACE_CENTER,FL_TRANSIENT,"FromWin");
}

void InitHelpWin(FD_HelpWin *fw)
{
const char * HelpFile, *tmp;
char  line[MAXSTRING];
FILE *hfile;

   HelpFile = (strlen(info->HelpFile) == 0) ? HELPFILE : info->HelpFile;

   if(CheckForExistence((char *)HelpFile) == 0)
   {
      tmp = fl_show_fselector(Dialogs[COMMENT_RESOURCES_WHEREHELP],
				  FAXBASE"/help","*",HelpFile);
      if(tmp == NULL) 
            return;
      else
      {
         if (CheckForExistence((char *)tmp))
	 {
            strcpy(info->HelpFile, tmp);
            HelpFile = info->HelpFile;
            SaveUserInfo(info);
            hfile = fopen(HelpFile, "r");
	 }
         else
	 {
            fl_show_message(\
               Dialogs[COMMENT_RESOURCES_NOHELP1],
               Dialogs[COMMENT_RESOURCES_NOHELP2],
               Dialogs[COMMENT_RESOURCES_NOHELP3]);
            return;
	 }
      }
   }
   else
     hfile = fopen(HelpFile, "r");

   fl_freeze_form(fw->HelpWin);
   fl_clear_browser(fw->HelpBrowser);

   while (!feof(hfile))
   {  
      tmp = fgets(line, MAXSTRING -1, hfile);
      if (tmp!=NULL)
      {  
         line[strlen(line)-1] = '\0';
         fl_add_browser_line(fw->HelpBrowser, line);
      }
   }

   fw->vdata = (void *)info;
   
   /* fl_deactivate_form(fd_Xfax->Xfax); */
   
   fl_unfreeze_form(fw->HelpWin);
   fl_show_form(fw->HelpWin,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,
      "HelpWin");
}

void HelpOK(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_HelpWin->HelpWin);
   fl_activate_form(fd_Xfax->Xfax);
}

void AuthorOK(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_AuthorWin->AuthorWin);
   fl_activate_form(fd_Xfax->Xfax);
}

void InitSystemWin(FD_SystemWin *fw)
{
   fw->vdata = (void *)info;
   
   fl_deactivate_form(fd_Xfax->Xfax);
   
   fl_set_input(fw->FaxSend,   info->FaxSend);
   fl_set_input(fw->FaxPrint,info->FaxPrint);
   fl_set_input(fw->TmpBuildDir,info->TmpBuildDir);
   fl_set_input(fw->SpoolDir,info->SpoolDir);
   fl_set_input(fw->ImgTypes,  info->ImgTypes);
   fl_set_input(fw->Editor,  info->Editor);
   fl_set_input(fw->G3ToXpm,  info->G3ToXpm);
   fl_set_input(fw->FilterToG3,  info->FilterToG3);
   
   fl_show_form(fw->SystemWin,FL_PLACE_CENTER,FL_TRANSIENT,"SystemWin");
}

/* callbacks for form FromWin */

void FromOK(FL_OBJECT *ob, long data)
{
   Xfaxrc *info = (Xfaxrc *)fd_FromWin->vdata;
   
   strncpy(info->Name ,fl_get_input(fd_FromWin->Name ),MAXSTRING - 1);
   strncpy(info->Function,fl_get_input(fd_FromWin->Function),MAXSTRING - 1);
   strncpy(info->Department,fl_get_input(fd_FromWin->Department),MAXSTRING - 1);
   strncpy(info->Telephone,fl_get_input(fd_FromWin->Telephone),MAXSTRING - 1);
   strncpy(info->Faxnumber,fl_get_input(fd_FromWin->Faxnumber),MAXSTRING - 1);
   strncpy(info->Email,fl_get_input(fd_FromWin->Email),MAXSTRING - 1);
   strncpy(info->Headaddr,fl_get_input(fd_FromWin->Headaddr),MAXSTRING - 1);

   SaveUserInfo(info);
   
   fl_hide_form(fd_FromWin->FromWin);
   fl_activate_form(fd_Xfax->Xfax);

   modified = 1;
}

void FromCancel(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_FromWin->FromWin);
   fl_activate_form(fd_Xfax->Xfax);
}

/* callbacks for form System */

void SystemOK(FL_OBJECT *ob, long data)
{
   Xfaxrc *info = (Xfaxrc *)fd_SystemWin->vdata;
   char TmpBuildDir[MAXSTRING];

   strncpy(info->FaxSend ,fl_get_input(fd_SystemWin->FaxSend),MAXSTRING - 1);
   strncpy(info->FaxPrint,fl_get_input(fd_SystemWin->FaxPrint),MAXSTRING - 1);

   strncpy(info->G3ToXpm,fl_get_input(fd_SystemWin->G3ToXpm),MAXSTRING - 1);
   strncpy(info->FilterToG3,fl_get_input(fd_SystemWin->FilterToG3 ),MAXSTRING - 1);

   strncpy(info->SpoolDir,fl_get_input(fd_SystemWin->SpoolDir),MAXSTRING - 1);
   strncpy(TmpBuildDir,fl_get_input(fd_SystemWin->TmpBuildDir),MAXSTRING - 1);

   if (strcmp(TmpBuildDir, info->TmpBuildDir))
   {
      EraseTmpdir(tmpdir);
      rmdir(tmpdir);
      strcpy(info->TmpBuildDir, TmpBuildDir);
      InitTmpdirs(info);
   }

   strncpy(info->ImgTypes  ,fl_get_input(fd_SystemWin->ImgTypes),MAXSTRING - 1);
   strncpy(info->Editor  ,fl_get_input(fd_SystemWin->Editor),MAXSTRING - 1);

   SaveUserInfo(info);
   
   fl_hide_form(fd_SystemWin->SystemWin);
   fl_activate_form(fd_Xfax->Xfax);
}

void SystemCancel(FL_OBJECT *ob, long data)
{
   fl_hide_form(fd_SystemWin->SystemWin);
   fl_activate_form(fd_Xfax->Xfax);
}

