#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "forms.h"
#include "xfaxdefs.h"

typedef struct 
{
   DIR *faxdir;
   int number;
   int maxnumber;
   char *dirname;
   char scratch[MAXSTRING];
} VInfo;

char *G3ToXpmCmd;

void FaxViewClose(FL_OBJECT *ob, long data)
{
   VInfo * vi = (VInfo *)fd_FaxView->vdata;
   
   closedir(vi->faxdir);
   fl_hide_form(fd_FaxView->FaxView);
   fl_activate_form(fd_Xfax->Xfax);
}

void SetPageButtons(VInfo *vi)
{
   sprintf(vi->scratch,"%d",vi->number);
   fl_set_object_label(fd_FaxView->PageNumber,vi->scratch);
   
   if(vi->number > 1)
     fl_set_object_lcol(fd_FaxView->FaxViewPrevious,FL_BLACK);
   else
     fl_set_object_lcol(fd_FaxView->FaxViewPrevious,FL_INACTIVE_COL);
     
   if(vi->number < vi->maxnumber)
     fl_set_object_lcol(fd_FaxView->FaxViewNext,FL_BLACK);
   else
     fl_set_object_lcol(fd_FaxView->FaxViewNext,FL_INACTIVE_COL);
}

void FaxViewPage()
{
   char cmdbuffer[MAXCMD];
   char number[MAXSTRING];
   VInfo *vi = (VInfo *)fd_FaxView->vdata;
   FILE *fd;
   int count, rest = vi->number;

   sprintf(number, "%d", vi->number);
   fl_set_input(fd_FaxView->FaxViewGoto, number);
   fl_set_object_label(fd_FaxView->PageNumber, "");
   fl_free_pixmap_pixmap(fd_FaxView->FaxPixmap);   
   fl_hide_object(fd_FaxView->FaxPixmap);
   /* fl_redraw_form(fd_FaxView->FaxView);
   fl_freeze_form(fd_FaxView->FaxView); */

   for (count=1-fpbool; rest>doc_page_count[count]; count++) 
         rest -= doc_page_count[count];

   if (info->Flags[5]=='-') 
      sprintf(vi->scratch, "%s/%s", vi->dirname, XPMPAGE "output");
   else
      sprintf(vi->scratch, "%s/" XPMPAGE "%04d.%03d", 
                   vi->dirname, doc_index[count], rest);

   fd = NULL;

   if (info->Flags[5]=='-' || (fd=fopen(vi->scratch, "r")) == NULL)
   {
     sprintf(cmdbuffer,"%s %s/" G3FAXPAGE "%04d.%03d %s %d",
              G3ToXpmCmd, vi->dirname, doc_index[count], rest,
              vi->scratch, viewsize);
     SpawnCmd(cmdbuffer,1);
   }

   if (fd) fclose(fd);

   fl_set_pixmap_file(fd_FaxView->FaxPixmap,vi->scratch);
   fl_set_input(fd_FaxView->FaxViewGoto, "");
   fl_show_object(fd_FaxView->FaxPixmap);
   SetPageButtons(vi);
   /* fl_unfreeze_form(fd_FaxView->FaxView); */
}

void FaxViewNext(FL_OBJECT *ob, long parent)
{
   VInfo *vi = (VInfo *)fd_FaxView->vdata;

   if(vi->number >= vi->maxnumber) /* check if there are next pages */
      return;
   else
      ++vi->number;
   
   FaxViewPage();
}

void FaxViewPrevious(FL_OBJECT *ob, long parent)
{
   VInfo * vi = (VInfo *)fd_FaxView->vdata;

   if(vi->number <= 1) /* check if there are previous pages */
      return;
   else   
      --vi->number;

   FaxViewPage();
}
   
void FaxViewGoto(FL_OBJECT *ob, long parent)
{
   VInfo * vi = (VInfo *)fd_FaxView->vdata;
   char number[MAXSTRING];
   int i;

   strcpy(number, fl_get_input(fd_FaxView->FaxViewGoto));

   i = atoi(number);
   if (i<1) i = 1;
   if (i>vi->maxnumber) i = vi->maxnumber;
   sprintf(number, "%d", i);
   if (i==vi-> number) 
      return;
   else
      vi->number = i;

   FaxViewPage();
}

void FaxViewCreate()
{
static char HML[12];
char   cmd[MAXCMD];

   if (fd_FaxView) 
   {
       fl_free_form(fd_FaxView->FaxView);
       free(fd_FaxView);
   }

   switch(viewsize)
   {
   case 1: strcpy(HML,Dialogs[MAIN_HIGHRES]); 
           info->Flags[8] = 'H';
           fd_FaxView = (FD_FaxView *) create_form_FaxViewHR(); 
           break;
   case 2: strcpy(HML,Dialogs[MAIN_MEDRES]); 
           info->Flags[8] = 'M';
           fd_FaxView = (FD_FaxView *) create_form_FaxViewMR(); 
           break;
   case 3: strcpy(HML,Dialogs[MAIN_LOWRES]); 
           info->Flags[8] = 'L';
           fd_FaxView = (FD_FaxView *) create_form_FaxViewLR(); 
           break;
   }
   SaveUserInfo(info);
   fl_set_object_label(fd_Xfax->Resolution, HML);
   SetFaxViewLabels();

   sprintf(cmd, "rm -f %s/" XPMPAGE "* ", tmpdir);
   system(cmd);
}

void Resolution(FL_OBJECT *ob, long data)
{
int new;

   new = fl_get_menu(ob);
   if (new!=viewsize) 
   {
      viewsize = new;
      FaxViewCreate();
   }
}
   
void View(FL_OBJECT *ob, long data)
{
   int km, i;
   FL_Coord x,y;
   static VInfo vi; /* MUST be static !!! */

   fd_FaxView->vdata = (void *) &vi; /* hook for Info struct */

   fl_get_mouse(&x,&y,&km);
   fl_show_oneliner(Dialogs[COMMENT_VIEWFAX_WAITXPM],x,y);

   fl_check_forms();

   G3ToXpmCmd = (strlen(info->G3ToXpm) == 0) ? G3TOXPM : info->G3ToXpm;

   BuildFaxPages(fd_Xfax);

   fl_check_forms(); /* only to redraw screen if necessary */

   /* Now convert all pages into pixmap format */

   fl_hide_oneliner();
   if(number_of_pages == 0)
   {
      fl_show_message("",Dialogs[COMMENT_VIEWFAX_NOPAGETOVIEW],"");
      closedir(vi.faxdir);
      return;
   }
   
   vi.maxnumber = number_of_pages;
   vi.number = 0;
   vi.dirname = tmpdir;

   for (i=1; i<fl_get_browser(fd_Xfax->FileList); i++)
      vi.number += doc_page_count[i-fpbool];
   
   sprintf(vi.scratch,"%d",vi.maxnumber);
   fl_set_object_label(fd_FaxView->PageCount,vi.scratch);

   /* fl_deactivate_form(fd_Xfax->Xfax); */
   fl_show_form(fd_FaxView->FaxView,
		FL_PLACE_MOUSE|FL_FREE_SIZE,FL_FULLBORDER,"FaxView");
   
   fl_call_object_callback(fd_FaxView->FaxViewNext); /* show first page */
}
