#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <ctype.h>
#include <sys/timeb.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>

#include <dirent.h>
#include <fcntl.h>

#include "forms.h"

#include "xfaxdefs.h"
#include "version.h"

int dblclickline;

char Templates[NUMTEMPL][80];
char day_mon_str[19][20];
char prevlanguage[80]="";

/* This function converts a string into an array like 'argv' , as is used
 * to start a subprocess with exec.
 */
char **BuildArgv(char *string)
{
   int x,count=0;
   char **argv,*ptr;
   
   /* first count the number of arguments */
   
   ptr = string;
   while(*ptr != '\0')
   {
      while (*ptr != ' ' && *ptr != '\0') ptr++;
      while(*ptr == ' ') ptr++; /* skip spaces */
      count ++;
   }
   count++; /* extra space for NULL pointer */
   
   /* And turn them into an array of separate strings */
   argv = (char **)malloc(count * sizeof(char *));

   argv[0] = ptr = string;
   for(x=1;x<count - 1;x++)
   {
      while (*ptr != ' ') ptr++;
      *ptr++='\0';
      while(*ptr == ' ') ptr++; /* skip spaces */
      argv[x]=ptr;
   }
   argv[x]=NULL;
   return argv;
}

void SpawnCmd(char *cmdbuffer,int flag)
{  char **argv;
   pid_t pid;
   
   if ((pid=fork()) == 0)
   {
      fprintf(stderr,"%s: %s\n",Dialogs[COMMENT_CALLBACK_EXECUTING],cmdbuffer);
      argv = BuildArgv(cmdbuffer);
      execvp(argv[0],argv);
      free(argv);
      exit(0);
   }
   else
   {
      if(flag)
	wait(NULL);
      else
	signal(SIGCHLD,SIG_IGN);
   }
}

int CheckForExistence(char *filename)
{
   FILE *fp;
   
   if((fp=fopen(filename,"r")) != NULL)
   {
      fclose(fp);
      return 1;
   }
   else
     return 0;
}

void CountG3Files()
{
   int count = fpbool+1, number = 1;
   char fname[MAXSTRING];

   number_of_pages = fpbool;

   while(count <= fl_get_browser_maxline(fd_Xfax->FileList))
   {
      sprintf(fname, "%s/%s%04d.%03d", tmpdir, 
                         G3FAXPAGE, doc_index[count-fpbool], number);

      if(CheckForExistence(fname)) 
         ++number;
      else
      {
         --number;
         doc_page_count[count-fpbool] = number;
         number_of_pages += number;
         number = 1;
         ++count;
      }
   }
}

void ParseDialogFile()
{
FILE *fd;
char line[MAXCMD];
char *pline;
int i=0,j,k, length;

   printf("%s  %s\n", Dialogs[COMMENT_CALLBACK_LOADDIAL], info->Dialogs);

   if((fd = fopen(info->Dialogs, "r")) == NULL)
     {
     fl_show_message(Dialogs[COMMENT_CALLBACK_CANTLOADDIAL], 
                     info->Dialogs, Dialogs[COMMENT_CALLBACK_SORRY]);
     return;
     }
  
   while(!feof(fd) && i<NUM_DIALOG_LINES)
     {
     pline = fgets(line, MAXCMD-2, fd);
     if(pline!=NULL && *pline=='\"' )
       {
       length=strlen(line);
       pline=line+length-1;
       while(*pline!='\"' && pline>line+1) --pline;
       *pline='\0';
       pline=line+1;
       if(Dialogs[i]!=Builtin_Dialogs[i]) free(Dialogs[i]);
       Dialogs[i] = (char *)malloc(length * sizeof(char));
       k=0;
       length=strlen(pline);
       for(j=0;j<length;j++)
	 {
         if(pline[j]!='\\') 
           Dialogs[i][k] = pline[j];
         else if(j<length-1)
	   {
           j++;
           switch(pline[j])
	     {
             case 'n' : Dialogs[i][k] = '\n'; break;
             case 't' : Dialogs[i][k] = '\t'; break;
             case '\"' : Dialogs[i][k] = '\"'; break;
             default : Dialogs[i][k] = ' '; break;
	     }
	   }
          k++;
	 }
       Dialogs[i][k] = '\0';
       i++;
       }
     }
   fclose(fd);
}


void EraseTmpdir(char *dirname)
{
   char filename[MAXSTRING];
   struct dirent *g3file;
   DIR *faxdir;
   int count=0;
   
   faxdir = opendir(dirname);
   while((g3file = readdir(faxdir)) != NULL)
   {
      if(count++ <2) continue; /* skip . and .. entries ! */
      strncpy(filename,dirname,MAXSTRING / 2);
      strcat(filename,"/");
      strncat(filename,g3file->d_name,MAXSTRING / 2 -1);
      remove(filename);
   }
   closedir(faxdir);
}

void SetDateTemplates(char DateDialogs[2][256])
{
int j,k,l,m;
char *cptr;

   for (m=0;m<=1;m++)
   {
      j = 7*m; 
      k = 0;
      l = 0;
      cptr = DateDialogs[m];
      while (l<strlen(cptr) && j<7+12*m)
      {
         if (!isspace(cptr[l])) 
	 {
             day_mon_str[j][k]=cptr[l];
             ++k;
	 }
         else
	 {
             day_mon_str[j][k]='\0';
             ++j; k=0;
	 }
         ++l;
      }
   }
}

char *GetTime(int i)
{
time_t tptr;
struct tm *timestr;
static char timeret[256];

   tptr=time(NULL);
   timestr=localtime(&tptr);
   if (i)
      sprintf(timeret, "%s %02d %s %04d %02d:%02d:%02d %s", 
         day_mon_str[timestr->tm_wday],
         timestr->tm_mday,
         day_mon_str[7+timestr->tm_mon],
         1900+timestr->tm_year,
         timestr->tm_hour,
         timestr->tm_min,
         timestr->tm_sec, tzname[0]);
   else
      sprintf(timeret, "%d %02d %02d %04d %02d:%02d:%02d %s\n", 
         timestr->tm_wday,
         timestr->tm_mday,
         timestr->tm_mon,
         1900+timestr->tm_year,
         timestr->tm_hour,
         timestr->tm_min,
         timestr->tm_sec, tzname[0]);
   return(timeret);
}

void 
chprintf(FILE *file, char *format, const char *string1, const char *string2)
{
   if (*string2)
      fprintf(file, format, string1, string2);
}

void
BuildFrontPage(FD_Xfax *fd_Xfax)
{
   FILE *hostfile, *fpfile, *cover, *datefile;
   struct utsname systname;
   char *fptr, *fptrp;
   char DateDialogs[2][256];
   char fpname[MAXSTRING], datefilename[MAXSTRING], domainname[MAXSTRING],
        line[MAXSTRING], progline[MAXSTRING];
   char format[40]="%s %s\n";
   char language[80] = "English";
   char dashline[80] =
     "-------------------------------------------------------------";
   char number[20];


   int i, boolcover=0;

   for(i=0; i<=1; i++)
     strcpy(DateDialogs[i],Dialogs[i]);

   if(strlen(info->Cover) == 0)
      fl_show_message(
         Dialogs[COMMENT_CALLBACK_COVER1],
         Dialogs[COMMENT_CALLBACK_COVER2],
         Dialogs[COMMENT_CALLBACK_COVER3]);
   else
   {
      if((cover = fopen(info->Cover,"r")) == NULL)
	{
        for(i=0;i<NUMTEMPL;i++) strcpy(Templates[i],Dialogs[i+2]);
	fl_show_message(Dialogs[COMMENT_CALLBACK_COVERCANT],
                        info->Cover,
                        Dialogs[COMMENT_CALLBACK_COVER3]);
	}
      else {

        while(!feof(cover))
           {
              fptr=fgets(line,MAXSTRING-1,cover);
              if (fptr && (fptrp=strstr(fptr, "Language:"))!=NULL)
                 {
                 fptrp+=9;
                 while(isspace(*fptrp)&& *fptrp!='0') fptrp++;
                 strcpy(language,fptrp);
                 fptrp=language+strlen(language)-1;
                 while(isspace(*fptrp) && fptrp>language) --fptrp;
                 ++fptrp;
                 *fptrp='\0';
                 break;
		 }
	   }
        fclose(cover);
        cover = fopen(info->Cover,"r");

        sprintf(datefilename, FAXBASE"/dialogs/%s", language);
        if((datefile = fopen(datefilename,"r")) == NULL)
	  {
          strcpy(language,BUILTIN_LANGUAGE);
          strcpy(prevlanguage,language);
          SetDateTemplates(DateDialogs);
          fl_show_message("",Dialogs[COMMENT_CALLBACK_DATESCANT],datefilename);
	  }
        else if(strcmp(language,prevlanguage))
	{
           i=0;
           while(i<=1)
	     {
             if (feof(datefile)) break;
             fgets(line,MAXSTRING-1,datefile);
             if(*line=='\"')
	       {
               strcpy(DateDialogs[i],line+1);
                ++i;
	       }
	     }
           fclose(datefile);
	}

        if(strcmp(language,prevlanguage))
	   {
           strcpy(prevlanguage,language);
           SetDateTemplates(DateDialogs);
	   }

        fptr = info->Cover + strlen(info->Cover);
        while (*fptr != '.' && fptr >= info->Cover) --fptr;
        if(strcmp(fptr,".ps")==0) 
	{
           boolcover = 2;
           strcpy(format, "%s (%s) def\n");
           for(i=0;i<=NUMTEMPL-1;i++) strcpy(Templates[i], PS_Templates[i]);
	}
        else if(strcmp(fptr,".tex")==0 || strcmp(fptr,".ltx")==0) 
	{
           boolcover = 3;
           strcpy(format, "\\def%s{%s}\n");
           for(i=0;i<=NUMTEMPL-1;i++) strcpy(Templates[i], TeX_Templates[i]);
	}
        else
	{
           boolcover = 1;
	   i = -1;
           while(i<NUMTEMPL && !feof(cover))
           {
              fptr=fgets(line,MAXSTRING-1,cover);
              if (fptr && *fptr) line[strlen(line)-1] = '\0';
	   start:
              if (i>=0)
	      {
                 strcpy(Templates[i], line);
                 i++;
	      }
              else 
              if(strncmp(line,">>>",3)==0) 
              {
                 i = 0;
                 goto start;
	      }
	   }
           fclose(cover);
           cover = fopen(info->Cover,"r");
           for(i=0;i<=1;i++) fptr=fgets(line,MAXSTRING-1,cover);
	}
      }
   }
   
   strncpy(fpname, tmpdir, MAXSTRING - 12);
   strcat(fpname, "/frontpage");

   uname(&systname);

   hostfile = fopen("/etc/hosts", "r");
   *domainname=0;
   if (hostfile != NULL)
   {
      while(!feof(hostfile))
      {
         fptr=fgets(line,MAXSTRING-1,hostfile);
         if(fptr!=NULL && *fptr!='#')
	 {
            strcpy(progline,fptr);
            if((fptr=strstr(progline,"#"))!=NULL) *fptr=0;
            if ((fptr=strstr(progline,systname.nodename))!=NULL)
	    {
               strcpy(line,fptr);               
               if((fptr=strstr(line,"."))!=NULL)
	       {
                  ++fptr;
                  strcpy(domainname,fptr);
                  fptr=domainname;
                  while(*fptr!=0 && *fptr!=' ' && *fptr!='\t' ) ++fptr;
                  if (*fptr!=0) *fptr=0;
   	       }
               break;
	    }
	 }
      }
      fclose(hostfile);
   }

   sprintf(progline,"%s  on  %s.%s [%s %s]", 
       PROGRAMNAME, systname.nodename, domainname,
       systname.sysname, systname.release);

   fpfile = fopen(fpname,"w");
   if (fpfile == NULL)
   {
      fl_show_message(Dialogs[COMMENT_CALLBACK_FRONTPAGE1],fpname,
                      Dialogs[COMMENT_CALLBACK_FRONTPAGE3]);
      return;
   }

   if (boolcover == 1)
   {
      fprintf(fpfile,"\n");
      chprintf(fpfile, format, Templates[0], progline);
      fprintf(fpfile,"\n");
   }

   if (boolcover) 
   {
      while(!feof(cover))
      {
         fptr=fgets(line,MAXSTRING-1,cover);
         if(fptr!=NULL) 
	    {
            if(strncmp(line,">>>",3)==0) break;
            fputs(line, fpfile);
	    }
      }
      fclose(cover);
   }

   if (boolcover != 1)
      chprintf(fpfile, format, Templates[0], progline);
   if (boolcover == 0)
      fprintf(fpfile, "\n\n\n\n");
   chprintf(fpfile, format, Templates[1],info->Name);
   chprintf(fpfile, format, Templates[2],info->Function);
   chprintf(fpfile, format, Templates[3],info->Department);
   chprintf(fpfile, format, Templates[4],info->Telephone);
   chprintf(fpfile, format, Templates[5],info->Faxnumber);
   chprintf(fpfile, format, Templates[6],info->Email);
   fprintf(fpfile,"\n\n");

   chprintf(fpfile,  format, Templates[7],fl_get_input(fd_Xfax->Name));
   chprintf(fpfile,  format, Templates[8],fl_get_input(fd_Xfax->Institution));
   chprintf(fpfile,  format, Templates[9],fl_get_input(fd_Xfax->Service));
   chprintf(fpfile,  format, Templates[10],fl_get_input(fd_Xfax->Number));
   fprintf(fpfile,"\n");      

   fprintf(fpfile,  format, Templates[11], GetTime(1));
   
   fprintf(fpfile,"\n");      
   sprintf(number, "%d", number_of_pages);
   fprintf(fpfile,  format, Templates[12], number);
   
   if (boolcover<=1)
      fprintf(fpfile,"\n\n%s\n%s\n\n%s\n%s\n", 
         dashline, Templates[13], (char *) fl_get_input(fd_Xfax->Message), 
         dashline);
   else
   {
      chprintf(fpfile, format, Templates[13], 
          (char *) fl_get_input(fd_Xfax->Message));
      fprintf(fpfile, "%s\n", (boolcover==2)? 
                    "makepagecover":"\\makepagecover\n\\end" );
   }

   fclose(fpfile);
}

void MakeFaxPage(int number)
{
   char string[MAXSTRING], imagetypes[MAXSTRING];
   char filename[MAXCMD], options[MAXCMD], cmdbuffer[MAXCMD];
   char suffix[32];
   char *FilterCmd;
   char *ptr;
   FILE *page;

   /* provide defaults for conversions: crucial for good operation */
   
   FilterCmd = (strlen(info->FilterToG3) == 0) ? FILTERTOG3 : info->FilterToG3;

   strcpy(filename, fl_get_browser_line(fd_Xfax->FileList, number+fpbool));

   ptr = filename;
   while (*ptr != '\t' && *ptr != '\0') ++ptr;
   if (*ptr == '\t') 
   {
      *ptr = '\0';
      ++ptr;
   }
   strcpy(options, ptr);

   if(number==0)
   {
      BuildFrontPage(fd_Xfax);
      strncpy(filename, tmpdir, MAXSTRING - 12);
      strcat(filename, "/frontpage");
   }
   if (doc_page_count[number]>0) return;

   if((page = fopen(filename,"r")) == NULL)
   {
      fl_show_message("",Dialogs[COMMENT_CALLBACK_FAXPAGE], filename);
      return;
   }
   fgets(string,MAXSTRING,page);
   fclose(page);

   sprintf(imagetypes," %s ",info->ImgTypes);

   ptr = filename + strlen(filename);
   while (*ptr != '.' && ptr>=filename) --ptr;
   if (ptr>=filename)
   {
      sprintf(suffix, "%s", ptr);
      suffix[0] = ' ';
   }
   else
      strcpy(suffix," none ");

   if(! strncmp(string,"%!PS",4))
   {
      /* Postscript document */
      sprintf(suffix," ps ");
   }
   else 
   if(! strncmp(string,"%%TeX",5))
   {
      /* TeX document */
      sprintf(suffix," tex ");
   }
   else
   if(! strncmp(string,"%%LaTeX",7))
   {
      /* LaTeX document */
      sprintf(suffix," ltx ");
   }
   else 
   if (strstr(imagetypes,suffix))
   {
      /* Image file */
      sprintf(suffix, " image ");
   }
      /* else ASCII or other type document */

   sprintf(cmdbuffer,"%s %s %s %s " G3FAXPAGE "%04d %s", FilterCmd, 
                 suffix, tmpdir, filename, doc_index[number], options);
   SpawnCmd(cmdbuffer,1);

}

void SaveMessageToFile(const char *file);

void BuildFaxPages(FD_Xfax *fd_Xfax)
{  
int  x, y, max;
char filename[MAXSTRING];

   max = fl_get_browser_maxline(fd_Xfax->FileList);

   x = unsaved;
   if (modified && fpbool) Erase_G3_and_Xpm(1);
   unsaved = x;

   for(x=1;x<=max;x++)
   {
      y = x+fpbool;
      if (y>max) 
      {
         y = 1;
         CountG3Files();
      }
      MakeFaxPage(y-fpbool);
   }
   if (fpbool==0) CountG3Files();
   doc_page_count[0] = fpbool;
   modified = 0;
   sprintf(filename, "%s/" FAXCONTENTS, tmpdir);
   SaveMessageToFile(filename);
}

/* callbacks for form Xfax */

void Help()
{
   InitHelpWin(fd_HelpWin);
}

void Info()
{
char line[120];
   
   sprintf(line,"%s, %s", VERSION,  Dialogs[COMMENT_CALLBACK_COPYRIGHT3]);
   fl_show_message(
      Dialogs[COMMENT_CALLBACK_COPYRIGHT1],
      Dialogs[COMMENT_CALLBACK_COPYRIGHT2],line);
}

void Authors()
{
   fl_show_form(fd_AuthorWin->AuthorWin,
              FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER, "AuthorWin");
}

void About(FL_OBJECT *ob, long data)
{
   switch(fl_get_menu(ob))
   {
    case 1: Help(); break;
    case 2: Info(); break;
    case 3: Authors(); break;
   default: break;
   }
}

void Send(FL_OBJECT *ob, long data)
{
   char *faxnumber;
   char cmdbuffer[MAXCMD];
   char msgbuffer[MAXCMD];
   char filename[MAXSTRING];
   char *ptr;
   FILE *tmp;
   char *SendCmd;
   int km;
   FL_Coord x,y;
   
   SendCmd  = (strlen(info->FaxSend ) == 0) ? FAXSEND  : info->FaxSend;
   
   if((faxnumber = (char *)fl_get_input(fd_Xfax->Number)) == NULL || *faxnumber == 0)
   {
      fl_show_message("",Dialogs[COMMENT_CALLBACK_FAXNUMBER],"");
      return;
   }
   
   /* remove spaces from faxnumber (confuses the argument parser !) */
   ptr = faxnumber;
   while(*++ptr != 0)
     if(*ptr == ' ') *ptr = '-';
   
   if(info->Flags[1]=='+' && strlen(info->Email) == 0)
   {
      fl_show_message("",Dialogs[COMMENT_CALLBACK_USERINFO2],
                         Dialogs[COMMENT_CALLBACK_USERINFO3]);
      return;
   }
   
   fl_get_mouse(&x,&y,&km);

   sprintf(msgbuffer,"%s \n%s %s", 
             Dialogs[COMMENT_CALLBACK_SUBMITTED], SendCmd,
             Dialogs[COMMENT_CALLBACK_PARAMETERS]);
   fl_show_oneliner(msgbuffer,x,y);

   fl_check_forms();

   doc_page_count[0] = 0;

   if(info->Flags[7]=='+') LogViewOpen(ob, data);
   BuildFaxPages(fd_Xfax);
   
   strncpy(filename,tmpdir,MAXSTRING / 2 -1);
   strcat(filename,"/");
   strncat(filename,FAXINFO,MAXSTRING / 2 -1);
   tmp = fopen(filename,"w");

   fprintf(tmp,"ToFaxNumber: %s\n",   faxnumber);
   fprintf(tmp,"FromFaxNumber: %s\n", info->Faxnumber);
   fprintf(tmp,"HeadAddress: %s\n", info->Headaddr);
   fprintf(tmp,"EmailAddress: %s\n",info->Email);
   fprintf(tmp,"EmailFlag: %s\n",(info->Flags[1]=='+')? "True":"False");

   fclose(tmp);

   sprintf(cmdbuffer,"%s %s %s/",SendCmd,faxnumber,tmpdir);
   
   SpawnCmd(cmdbuffer,0); /* fork, no wait !! */
   
   fl_hide_oneliner();
}

void Abort(FL_OBJECT *ob, long data)
{
   fprintf(stderr,"%s: killall faxdirect efax\n", Dialogs[COMMENT_CALLBACK_EXECUTING]);
   system("killall faxdirect efax");
   AdjustClock(0);
}


void Print(FL_OBJECT *ob, long data)
{
   char cmdbuffer[MAXCMD];
   char msgbuffer[MAXCMD];
   char *PrintCmd;
   int km;
   FL_Coord x,y;
   
   PrintCmd  = (strlen(info->FaxPrint ) == 0) ? FAXPRINT : info->FaxPrint;
   
   fl_get_mouse(&x,&y,&km);

   sprintf(msgbuffer,"%s \n%s %s", 
             Dialogs[COMMENT_CALLBACK_PRINTED], PrintCmd,
             Dialogs[COMMENT_CALLBACK_PARAMETERS]);
   fl_show_oneliner(msgbuffer,x,y);
   fl_check_forms();

   BuildFaxPages(fd_Xfax);
   
   sprintf(cmdbuffer,"%s %s/",PrintCmd,tmpdir);
   SpawnCmd(cmdbuffer,0); /* fork, no wait !! */
   
   fl_hide_oneliner();
}

void ProcessMessageFile(char *file)
{  
   FILE *in;
   int nlcount=0, step=0;
   char buffer[MAXMESSAGE]="";
   char line[MAXSTRING];
   char *fptr;
   FL_OBJECT *ob;

   ob = fd_Xfax->OptionsMenu;
   
   if ((in = fopen(file,"r")) == NULL) 
   {
      fl_show_message(Dialogs[COMMENT_CALLBACK_CANTOPENFILE], file, 
                      Dialogs[COMMENT_CALLBACK_READSORRY]);
      return;
   }
   else
   {
      strcpy(msg_file, file);
      while((fptr=fgets(line,MAXSTRING-1,in))!=NULL)
      {
         if (!strncmp(line,"[Recipient]",12)) step = 1;
         if (!strncmp(line,"[Message]",10)) step = 3;
         if (!strncmp(line,"[Documents]",12))
            { 
            step = 5;
            fl_clear_browser(fd_Xfax->FileList);
	    }
         if (!strncmp(line,"[Cover]",8)) step = 7;

         if (step!=4) line[strlen(line)-1]='\0';

         if (step==2 && (fl_get_menu_item_mode(ob,3) & FL_PUP_CHECK))
	    {
            switch(nlcount)
	       {
              case 0: fl_set_input(fd_Xfax->Number,line); break;
              case 1: fl_set_input(fd_Xfax->Name,line); break;
              case 2: fl_set_input(fd_Xfax->Institution,line); break;
              case 3: fl_set_input(fd_Xfax->Service,line); break;
	       }
            nlcount++;
	    }
         if (step==4 && (fl_get_menu_item_mode(ob,4) & FL_PUP_CHECK))
         {
            if(nlcount < MAXMSGLINES) strcat(buffer,line);
            nlcount++;
	    }
         if (step==6 && (fl_get_menu_item_mode(ob,5) & FL_PUP_CHECK))
         {
            if (*line)
	       {
               if(nlcount==0)
		  {
                 if(line[0]=='<' && index(line,'>')!=NULL)
		    {
                    strcpy(line,Dialogs[MAIN_FRONTPAGE]);
                    info->Flags[0]='+';
                    fpbool = 1;
		    }
                 else
		    {
                    nlcount++;
                    doc_index[0] = 0;
                    info->Flags[0]='-';
                    fpbool = 0;
		    }
                 fl_set_menu_item_mode(fd_Xfax->OptionsMenu,1,
                    (fpbool)? FL_PUP_CHECK:FL_PUP_BOX);
		  }
               fl_add_browser_line(fd_Xfax->FileList,line);
	       }
            doc_index[nlcount] = nlcount;
            nlcount++;
	    }
         if (step==8) 
	    {
            strcpy(info->Cover, line);
            ++step;
	    }
         if (step & 1) 
            {
            nlcount =0;
            ++step;
	    }
      }

      SaveUserInfo(info);

      fclose(in);
      if (fl_get_menu_item_mode(ob,4) & FL_PUP_CHECK)
      {
         fptr = buffer + strlen(buffer)-1;
         while (*fptr=='\n' && fptr>buffer) 
         {
            *fptr='\0';
            --fptr;
         }
         fl_set_input(fd_Xfax->Message,buffer);
      }
   }
}

void SaveMessageToFile(const char *file)
{  
   FILE *out;
   int count =0;
   const char *buffer;

   if ((out = fopen(file,"w")) == NULL) 
   {
      fl_show_message(Dialogs[COMMENT_CALLBACK_CANTOPENFILE], file, 
                      Dialogs[COMMENT_CALLBACK_WRITESORRY]);
      return;
   }
   else
   {
      fprintf(out,"[Recipient]\n");
      fprintf(out,"%s\n%s\n%s\n%s\n\n",
          fl_get_input(fd_Xfax->Number),
          fl_get_input(fd_Xfax->Name),
          fl_get_input(fd_Xfax->Institution),
          fl_get_input(fd_Xfax->Service));
      fprintf(out,"[Message]\n");
      buffer = fl_get_input(fd_Xfax->Message);
      while(count < MAXMESSAGE - 1 && buffer[count] != 0)
	fputc(buffer[count++],out);
      fprintf(out,"\n\n[Documents]\n");
      for(count=1;count<=fl_get_browser_maxline(fd_Xfax->FileList);count++)
        fprintf(out,"%s\n",fl_get_browser_line(fd_Xfax->FileList,count));
      fprintf(out,"\n[Cover]\n%s\n", info->Cover);
      fclose(out);
      printf("%s %s\n", Dialogs[COMMENT_CALLBACK_MSGSAVED], file);
   }
}   

void SaveMessageFile()
{  
const char *file;

   if((file = fl_show_fselector(Dialogs[COMMENT_CALLBACK_FILETOWRITE],
					msg_file_dir,"*",msg_file)) == NULL)
     return;

   strcpy(msg_file_dir,fl_get_directory());
   SaveMessageToFile(file);
   strcpy(msg_file, file);
   SwitchSave(0);
}

void SaveMessage(FL_OBJECT *ob, long data)
{
   SaveMessageFile();
}

void ShouldISaveData()
{
#ifdef FORMS081
   if (unsaved &&
       fl_show_question(Dialogs[COMMENT_CALLBACK_UNSAVEDDATA],"",""))
          SaveMessageFile();
#else
   if (unsaved &&
       fl_show_question(Dialogs[COMMENT_CALLBACK_UNSAVEDDATA],1))
          SaveMessageFile();
#endif
}

void LoadMessageFile()
{  char *file;
   
   ShouldISaveData();

   if((file = (char *) fl_show_fselector(Dialogs[COMMENT_CALLBACK_FILETOLOAD],
				       msg_file_dir,"*",msg_file)) == NULL)
     return;

   strcpy(msg_file_dir,fl_get_directory());
   ProcessMessageFile(file);
   printf("%s %s", Dialogs[COMMENT_CALLBACK_FILETOLOAD], file);
   EraseTmpdir(tmpdir);
   SwitchSave(0);
   modified = 0;
}

void LoadMessage(FL_OBJECT *ob, long data)
{
   LoadMessageFile();
}

void Exit(FL_OBJECT *ob, long data)
{

   ShouldISaveData();

#ifdef FORMS081
   if(! fl_show_question(Dialogs[COMMENT_CALLBACK_DOYOUQUIT],"",""))
     return;
#else
   if(! fl_show_question(Dialogs[COMMENT_CALLBACK_DOYOUQUIT],1))
     return;
#endif
   EraseTmpdir(tmpdir);
   rmdir(tmpdir);
   exit(0);
}

void FileMenu(FL_OBJECT *ob, long data)
{  
   switch(fl_get_menu(ob))
   {
    case 1: LoadMessageFile(); 
            break;
    case 2: SaveMessageFile();
            break;
    case 3: EditData();
            break;
    case 4: SwitchSave(1); modified = 1;
            fl_set_input(fd_Xfax->Number,"");
            fl_set_input(fd_Xfax->Name,"");
            fl_set_input(fd_Xfax->Institution,"");
            fl_set_input(fd_Xfax->Service,"");
            break;
    case 5: SwitchSave(1); modified = 1;
            fl_set_input(fd_Xfax->Message,"");
            break;
    case 6: SwitchSave(1); modified = 1;
            fl_clear_browser(fd_Xfax->FileList); 
            if (fpbool) 
               fl_add_browser_line(fd_Xfax->FileList,Dialogs[MAIN_FRONTPAGE]);
            break;
    case 7: QueueViewOpen(ob,data);
            break;
    case 8: fl_call_object_callback(fd_Xfax->Exit);
            break;
    default: /* Can't happen !! */ break;
   }
}

void OptionsMenu(FL_OBJECT *ob, long data)
{
const char *tmp;
int i, bool;
   
   switch(i=fl_get_menu(ob))
   {
    case 1:
    case 2: 
    case 3: 
    case 4:
    case 5:
    case 6:
    case 7:
      if((bool=(fl_get_menu_item_mode(ob,i) & FL_PUP_CHECK)))
	 info->Flags[i-1]='+';
      else
	 info->Flags[i-1]='-';
      if (i==1)
      {
         fpbool = (bool!=0);
         if(fpbool)
           fl_insert_browser_line(fd_Xfax->FileList,1,Dialogs[MAIN_FRONTPAGE]);
         else
           fl_delete_browser_line(fd_Xfax->FileList,1);
         SwitchSave(1);
         modified = 1;
      }
      SaveUserInfo(info); 
      if (i==7) 
      {
         if (bool) fl_show_object(fd_Xfax->Clock);
             else  fl_hide_object(fd_Xfax->Clock);
      }
      break;

    case 8:
      InitFromWin(fd_FromWin); 
      break;
      
    case 9:
      tmp = fl_show_fselector(Dialogs[COMMENT_CALLBACK_NEWDIALOGS],
				  FAXBASE"/dialogs","*",info->Dialogs);
      if(tmp != NULL)
      {
	 strncpy(info->Dialogs,tmp,MAXSTRING);
	 SaveUserInfo(info);
         ParseDialogFile();
         SetAllLabels();
      }
      break;

    case 10:
      tmp = fl_show_fselector(Dialogs[COMMENT_CALLBACK_NEWHELPFILE],
				  FAXBASE"/help","*",info->HelpFile);
      if(tmp != NULL)
      {
	 strncpy(info->HelpFile,tmp,MAXSTRING);
	 SaveUserInfo(info);
      }
      break;

    case 11:
      modified = 1;
      doc_index[0] = 0;
      InitSystemWin(fd_SystemWin); break;

    default: /* Can't happen !! */ break;
   }
}

void SwitchCover(FL_OBJECT *ob, long data)
{
const char *tmp;

   tmp = fl_show_fselector(Dialogs[COMMENT_CALLBACK_NEWFRONTPAGE],
				  FAXBASE"/covers","*",info->Cover);
   if(tmp != NULL)
   {
      SwitchSave(1);
      modified = 1;
      strncpy(info->Cover,tmp,MAXSTRING);
      SaveUserInfo(info);
   }
}

void EditData()
{
   char cmdbuffer[MAXSTRING];
   char tmpname[MAXSTRING];
   char *EditCmd;
   struct stat state1, state2;

   EditCmd = (strlen(info->Editor) == 0) ? EDITOR : info->Editor;
   
   fl_show_message(Dialogs[COMMENT_CALLBACK_APPROPRIATE1],
                   Dialogs[COMMENT_CALLBACK_APPROPRIATE2],
                   Dialogs[COMMENT_CALLBACK_APPROPRIATE3]);

   strncpy(tmpname, tmpdir, MAXSTRING - 10);
   strcat(tmpname, "/faxdata");
   
   SaveMessageToFile(tmpname);
   stat(tmpname, &state1);

   sprintf(cmdbuffer,"%s %s",EditCmd,tmpname);
   SpawnCmd(cmdbuffer,1); /* just spawn : wait for return */

   stat(tmpname, &state2);
   
   if(state1.st_mtime != state2.st_mtime)
   {
      ProcessMessageFile(tmpname);
      EraseTmpdir(tmpdir);
      modified = 1;
      SwitchSave(1);
   }
   else
      remove(tmpname);
}

void EditMsg(FL_OBJECT *ob, long data)
{
   FILE *out;
   char cmdbuffer[MAXSTRING], tmpname[MAXSTRING];
   char buffer[MAXMESSAGE]="";
   char line[MAXSTRING];
   char *fptr;
   char *EditCmd;
   struct stat state1, state2;
   int nlcount;

   EditCmd = (strlen(info->Editor) == 0) ? EDITOR : info->Editor;
   
   strncpy(tmpname, tmpdir, MAXSTRING - 10);
   strcat(tmpname, "/message");
   
   if ((out = fopen(tmpname,"w")) != NULL) 
   {
      fprintf(out, fl_get_input(fd_Xfax->Message));
      fclose(out);
   }
   else
   { 
      fl_show_message(Dialogs[COMMENT_CALLBACK_TEMPORARY], tmpdir, 
                      Dialogs[COMMENT_CALLBACK_SORRY]);
      return;
   }

   stat(tmpname, &state1);

   sprintf(cmdbuffer,"%s %s",EditCmd,tmpname);
   SpawnCmd(cmdbuffer,1); /* just spawn : wait for return */

   stat(tmpname, &state2);
   
   if(state1.st_mtime != state2.st_mtime)
   {
      out = fopen(tmpname,"r");
      nlcount = 0;
      while ((fptr=fgets(line,MAXSTRING-1,out))!=NULL)
      {
         if(nlcount < MAXMSGLINES) strcat(buffer,line);
         nlcount++;
      }
      fl_set_input(fd_Xfax->Message, buffer);
      fclose(out);
      modified = 1;
      SwitchSave(1);
   }
   remove(tmpname);
}

void SwitchSave(int mode)
{
   unsaved = mode;
}

void SaveFlag(FL_OBJECT *ob, long data)
{
   modified = 1;
   SwitchSave(1);
}

void DeselectOthers(FL_OBJECT *ob, long data)
{
   int linenr;
   linenr = fl_get_browser(ob);
   if(linenr)
   {
     if(linenr>0) dblclickline=linenr;
     fl_deselect_browser(ob);
     fl_select_browser_line(ob, linenr);
   }
}

void ShowData(FL_OBJECT *ob, long data)
{  
char firstline[MAXCMD], 
     databuf[MAXSTRING], sizebuf[MAXSTRING], fname[MAXSTRING];
struct stat buf;
char *ptr = fname;

int i,j;

    i = fl_get_browser(fd_Xfax->FileList);
    
    if (i)
    {
       j = i - fpbool;

       strcpy(fname,fl_get_browser_line(fd_Xfax->FileList,i));
       while (*ptr!= '\t' && *ptr!= '\0') ++ptr;
       if (*ptr == '\t') *ptr = '\0';
       if (j==0) sprintf(fname,"%s/frontpage", tmpdir);
       if (stat(fname, &buf)==0)
       {
          sprintf(sizebuf, "File size:   %ld", (long int)buf.st_size);
          if (doc_page_count[j])
	  {
             if (doc_page_count[j]==1)
                sprintf(databuf, "G3 fax file(s):     %s/" 
                        G3FAXPAGE"%04d.0001",
                        tmpdir, doc_index[j]);
             else
                sprintf(databuf, "G3 fax file(s):     %s/" 
                        G3FAXPAGE"%04d.0001  ->  %04d",
                        tmpdir, doc_index[j], doc_page_count[j]);
	  }
          else
	  {
             sprintf(databuf, "%s %s", Dialogs[COMMENT_CALLBACK_NOG3FILE],
                     tmpdir);
             strcat(sizebuf, databuf);
             strcpy(databuf, Dialogs[COMMENT_CALLBACK_CREATEG3]);
	  }
       }
       else
       {
          sprintf(sizebuf, Dialogs[COMMENT_CALLBACK_DOESNOTEXIST]);
          if (j==0)
             sprintf(databuf, Dialogs[COMMENT_CALLBACK_WILLCREATEIT]);
          else
             sprintf(databuf, Dialogs[COMMENT_CALLBACK_REMOVE_CREATE]);
       }
       sprintf(firstline, "%s     %s", Dialogs[COMMENT_CALLBACK_SOURCEFILE],
                  fname);
       fl_show_message(firstline, sizebuf, databuf);
    }
    else
       fl_show_message(Dialogs[COMMENT_CALLBACK_TMPBUILDDIR1], tmpdir, 
            Dialogs[COMMENT_CALLBACK_TMPBUILDDIR3]);
}

void AddFile(FL_OBJECT *ob, long data)
{  
char *file;
int  i;
   
   file = (char *)fl_show_fselector(Dialogs[COMMENT_CALLBACK_FILETOADD],
                                         dir_file_to_add,"*","");
   if (file != NULL) 
   {
      strcpy(dir_file_to_add,fl_get_directory());
      fl_freeze_form(fd_Xfax->Xfax);
      fl_addto_browser(fd_Xfax->FileList,file);
      fl_unfreeze_form(fd_Xfax->Xfax); /* necessary to force a redraw */ 
      i = fl_get_browser_maxline(fd_Xfax->FileList);
      doc_index[i-fpbool] = doc_index[i-fpbool-1]+1;
      doc_page_count[i-fpbool] = 0;
      SwitchSave(1);
      modified = 1;
   }
}

void Erase_G3_and_Xpm(int linenr)
{
int i,j;
char cmdline[MAXCMD];

   i = linenr-fpbool;
   j = doc_index[i];
   doc_page_count[i] = 0;

   sprintf(cmdline, "\
cd %s ; \
rm -f " G3FAXPAGE "%04d.* " XPMPAGE "%04d.* " XPMPAGE "output ",
tmpdir, j, j);

   system(cmdline);
}

void StartEditor(FL_OBJECT *ob, long data)
{  
char cmdbuffer[MAXCMD], line[MAXCMD];
const char *tmpname;
struct stat state1, state2;
int linenr;
char *ptr;
char *EditCmd;
FILE *in;
   
   EditCmd = (strlen(info->Editor) == 0) ? EDITOR : info->Editor;
   
   if((linenr = fl_get_browser(fd_Xfax->FileList)) > 0) 
   {
     tmpname = fl_get_browser_line(fd_Xfax->FileList,linenr);
     strcpy(line, tmpname);
     ptr = line;
     while(*ptr != '\0' && *ptr != '\t') ++ptr;
     if (*ptr == '\t')
     {
        *ptr = '\0';
        tmpname = line;
     }
   }
   else
   {
     if((tmpname = fl_show_fselector(Dialogs[COMMENT_CALLBACK_FILETOEDIT],
				       "","*","")) == NULL)
       return;
   }
   
   if (linenr == 1 && 
       (fl_get_menu_item_mode(fd_Xfax->OptionsMenu,1) & FL_PUP_CHECK) > 0)
      return;

   stat(tmpname, &state1);

   sprintf(cmdbuffer,"%s %s",EditCmd,tmpname);
   SpawnCmd(cmdbuffer,1); /* just spawn : wait for return */

   if((in=fopen(tmpname, "r"))!=NULL)
   {
      stat(tmpname, &state2);
      fclose(in);
      if (state1.st_mtime != state2.st_mtime ) 
      {
         SwitchSave(1);
         modified = 1;
         Erase_G3_and_Xpm(linenr);
      }
      if (linenr==0)
	{
        fl_freeze_form(fd_Xfax->Xfax);
        fl_addto_browser(fd_Xfax->FileList,tmpname);
        fl_unfreeze_form(fd_Xfax->Xfax);
	}
   }
}

void RemoveFile()
{
   int linenr, j;
   
   if((linenr = fl_get_browser(fd_Xfax->FileList)) > 0)
   {
      fl_delete_browser_line(fd_Xfax->FileList,linenr);
      SwitchSave(1);
      modified = 1;
      Erase_G3_and_Xpm(linenr);
      if (linenr == 1 && 
         (fl_get_menu_item_mode(fd_Xfax->OptionsMenu,1) & FL_PUP_CHECK) > 0)
      {
         fl_set_menu_item_mode(fd_Xfax->OptionsMenu,1, FL_PUP_BOX);
         info->Flags[0]='-';
         fpbool = 0;
         SaveUserInfo(info);
      }
      else
      {
         for (j=linenr; j<=fl_get_browser_maxline(fd_Xfax->FileList); j++)
	 {
            doc_index[j-fpbool] = doc_index[j-fpbool+1];
            doc_page_count[j-fpbool] = doc_page_count[j-fpbool+1];
         }
      }
   }
   else
     fl_show_message("",Dialogs[COMMENT_CALLBACK_NOFILESELECT],"");
}

void NewSetting(long data)
{  char line[MAXCMD], newline[MAXCMD];
   char title[MAXSTRING], fname[MAXSTRING];
   char options[MAXSTRING], old_options[MAXSTRING];
   char *ptr;   
   const char *tmp;
   int linenr;
   
   switch (data)
   {
     case 2: strcpy(title, Dialogs[COMMENT_CALLBACK_NEWFILENAME]);
             break;
     case 3: strcpy(title, Dialogs[COMMENT_CALLBACK_NEWFONT]);
             break;
     case 4: strcpy(title, Dialogs[COMMENT_CALLBACK_NEWGEOMETRY]);
             break;
     default: break;
   }

   if((linenr = fl_get_browser(fd_Xfax->FileList)) > 0)
   {
     if (data == 0)
         {
         modified = 1;
         Erase_G3_and_Xpm(linenr);
         return;
         }
     strcpy(line, fl_get_browser_line(fd_Xfax->FileList,linenr));
     ptr = line;
     while (*ptr != '\t' && *ptr != '\0') ++ptr;
     if (*ptr == '\t') 
     {
        *ptr = '\0';
        ++ptr;
     }
     strcpy(fname,line);
     strcpy(options,ptr);
     strcpy(old_options,ptr);
   }
   else
   {
     fl_show_message("",Dialogs[COMMENT_CALLBACK_NOFILESELECT],"");
     return;
   }
 
   if (*ptr=='\0' && data==3) 
       strcpy(options,"\tCourier@12");

   if (*ptr=='\0' && data==4) 
       strcpy(options,"\t[2-4]:120%+30+50mm");
 
   if (data == 2)
      tmp = fl_show_input(title, fname);
   else
      tmp = fl_show_input(title, options);

   if(tmp != NULL)
   {
      if(data == 2 && !strcmp(tmp,""))
      {
         fl_delete_browser_line(fd_Xfax->FileList,linenr);
         SwitchSave(1);
         modified = 1;
         Erase_G3_and_Xpm(linenr);
         return;
      }
      if(data == 2 && strcmp(fname,tmp))
      {
         sprintf(newline,"%s\t%s", tmp, options);
         fl_replace_browser_line(fd_Xfax->FileList,linenr,newline);
         SwitchSave(1);
         modified = 1;
         Erase_G3_and_Xpm(linenr);
      }
      if(data >= 3 && strcmp(old_options,tmp))
      {
         sprintf(newline,"%s\t%s", fname, tmp);
         fl_replace_browser_line(fd_Xfax->FileList,linenr,newline);
         SwitchSave(1);
         modified = 1;
         Erase_G3_and_Xpm(linenr);
      }
   }
}


void ModifyMenu(FL_OBJECT *ob, long data)
{  
   switch(fl_get_menu(ob))
   {
    case 1: RemoveFile();
            break;
    case 2: 
            NewSetting(2);
            break;
    case 3: 
            NewSetting(3);
            break;
    case 4: 
            NewSetting(4);
            break;
    case 5: 
            NewSetting(0);
            break;
    default:
            break;
   }
}
