#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "forms.h"

#include "xfaxdefs.h"
#include "fax.xpm"
#include "twilogo.xpm"
#include "ujflogo.xpm"

FD_Xfax *fd_Xfax;
FD_HelpWin *fd_HelpWin;
FD_AuthorWin *fd_AuthorWin;
FD_FromWin *fd_FromWin;
FD_SystemWin *fd_SystemWin;
FD_LogView *fd_LogView;
FD_QueueView *fd_QueueView;
FD_FaxView *fd_FaxView;
FD_Aliases *fd_Aliases;
Xfaxrc *info;

char msg_file[MAXSTRING] = "";
char msg_file_dir[MAXSTRING] = "";
char dir_file_to_add[MAXSTRING];
char tmpdir[MAXSTRING];
int  modified = 0;
int  unsaved = 0;
int  fpbool;
int  doc_index[MAXDOCS];
int  doc_page_count[MAXDOCS];
int  number_of_pages;
int  viewsize;

void SetFileMenu(FL_OBJECT *ob)
{
   fl_set_menu(ob,Dialogs[XFAXMAIN_FILE_MENU]);
}

void SetOptionsMenu(FL_OBJECT *ob)
{
int i;

   fl_set_menu(ob,Dialogs[XFAXMAIN_OPTIONS_MENU]);

   for(i=1;i<=7;i++)
     fl_set_menu_item_mode(ob,i,(info->Flags[i-1]=='+')? 
         FL_PUP_CHECK:FL_PUP_BOX);

   fpbool = (info->Flags[0]=='+');
}

void SetFaxViewLabels()
{
   fl_set_object_label(fd_FaxView->FaxViewClose,Dialogs[FAXVIEW_CLOSE]);
   fl_set_object_label(fd_FaxView->FaxViewPrevious,Dialogs[FAXVIEW_PREVIOUS]);
   fl_set_object_label(fd_FaxView->FaxViewNext,Dialogs[FAXVIEW_NEXT]);
   fl_set_object_label(fd_FaxView->FaxViewGoto,Dialogs[FAXVIEW_GOTO]);
   fl_set_object_label(fd_FaxView->FaxViewPage,Dialogs[FAXVIEW_PAGE]);
   fl_set_object_label(fd_FaxView->FaxViewOf,Dialogs[FAXVIEW_OF]);
}

void SetAllLabels()
{
FD_FSELECTOR *fs;
int view, res;

fl_freeze_form(fd_Xfax->Xfax);

fl_set_resource("flQuestion.yes.label",Dialogs[RESOURCE_YES]);
fl_set_resource("flQuestion.no.label",Dialogs[RESOURCE_NO]);
fl_set_resource("*.ok.label",Dialogs[RESOURCE_OK]);
fl_set_resource("*.cancel.label",Dialogs[RESOURCE_CANCEL]);
fl_set_resource("*.clear.label",Dialogs[RESOURCE_CLEAR]);

fs = fl_get_fselector_fdstruct();
fl_set_object_label(fs->ready,Dialogs[RESOURCE_FS_READY]);
fl_set_object_label(fs->cancel,Dialogs[RESOURCE_CANCEL]);
fl_set_object_label(fs->resbutt,Dialogs[RESOURCE_FS_RESCAN]);
fl_set_object_label(fs->dirlabel,Dialogs[RESOURCE_FS_DIRECT]);
fl_set_object_label(fs->patlabel,Dialogs[RESOURCE_FS_PATTERN]);

fl_set_object_label(fd_Xfax->FileMenu,Dialogs[MAIN_FILE]);
fl_set_object_label(fd_Xfax->OptionsMenu,Dialogs[MAIN_OPTIONS]);
fl_set_object_label(fd_Xfax->Number,Dialogs[MAIN_FAXNUMB]);
fl_set_object_label(fd_Xfax->Name,Dialogs[MAIN_NAME]);
fl_set_object_label(fd_Xfax->Institution,Dialogs[MAIN_INSTITU]);
fl_set_object_label(fd_Xfax->Service,Dialogs[MAIN_SERVICE]);
fl_set_object_label(fd_Xfax->FileList,Dialogs[MAIN_DOCS]);
fl_set_menu(fd_Xfax->Resolution,Dialogs[MAIN_RESMENU]);
fl_set_object_label(fd_Xfax->View,Dialogs[MAIN_VIEWFAX]);
fl_set_object_label(fd_Xfax->Send,Dialogs[MAIN_SENDFAX]);
fl_set_object_label(fd_Xfax->Print,Dialogs[MAIN_PRINTFAX]);
fl_set_object_label(fd_Xfax->ViewLog,Dialogs[MAIN_VIEWLOG]);
fl_set_object_label(fd_Xfax->Exit,Dialogs[MAIN_EXIT]);
fl_set_object_label(fd_Xfax->AddFile,Dialogs[MAIN_ADDFILE]);
fl_set_object_label(fd_Xfax->EditDoc,Dialogs[MAIN_EDITDOC]);
fl_set_object_label(fd_Xfax->Info,Dialogs[MAIN_INFO]);
fl_set_object_label(fd_Xfax->Modify,Dialogs[MAIN_MODIFY]);
fl_set_menu(fd_Xfax->Modify,Dialogs[MAIN_MODIFYMENU]);
fl_set_object_label(fd_Xfax->Copyright1,Dialogs[MAIN_COPYRIGHT1]);
fl_set_object_label(fd_Xfax->Copyright2,Dialogs[MAIN_COPYRIGHT2]);
fl_set_object_label(fd_Xfax->About,Dialogs[MAIN_ABOUT]);
fl_set_menu(fd_Xfax->About,Dialogs[MAIN_ABOUTMENU]);
fl_set_object_label(fd_Xfax->Message,Dialogs[MAIN_MESSAGE]);
fl_set_object_label(fd_Xfax->Aliases,Dialogs[MAIN_ALIASES]);
fl_set_object_label(fd_Xfax->Cover,Dialogs[MAIN_SETCOVER]);
fl_set_object_label(fd_Xfax->EditMsg,Dialogs[MAIN_EDITMSG]);

fl_set_object_label(fd_HelpWin->HelpOK,Dialogs[HELPWIN_OK]);
fl_set_object_label(fd_HelpWin->HelpWinTitle,Dialogs[HELPWIN_TITLE]);

fl_set_object_label(fd_AuthorWin->Author1,Dialogs[AUTHORWIN_ADDR1]);
fl_set_object_label(fd_AuthorWin->Author2,Dialogs[AUTHORWIN_ADDR2]);
fl_set_object_label(fd_AuthorWin->AuthorOK,Dialogs[AUTHORWIN_OK]);
fl_set_object_label(fd_AuthorWin->AuthorWinTitle,Dialogs[AUTHORWIN_TITLE]);

fl_set_object_label(fd_FromWin->FromWinTitle,Dialogs[FROMWIN_TITLE]);
fl_set_object_label(fd_FromWin->FromOK,Dialogs[FROMWIN_OK]);
fl_set_object_label(fd_FromWin->FromCancel,Dialogs[FROMWIN_CANCEL]);
fl_set_object_label(fd_FromWin->Name,Dialogs[FROMWIN_NAME]);
fl_set_object_label(fd_FromWin->Department,Dialogs[FROMWIN_DEPARTM]);
fl_set_object_label(fd_FromWin->Telephone,Dialogs[FROMWIN_TELEPH]);
fl_set_object_label(fd_FromWin->Faxnumber,Dialogs[FROMWIN_FAXNUMBER]);
fl_set_object_label(fd_FromWin->Email,Dialogs[FROMWIN_EMAIL]);
fl_set_object_label(fd_FromWin->Headaddr,Dialogs[FROMWIN_HEADADDR]);
fl_set_object_label(fd_FromWin->Function,Dialogs[FROMWIN_FUNCTION]);

fl_set_object_label(fd_SystemWin->SystemWinTitle,Dialogs[SYSTEMWIN_TITLE]);
fl_set_object_label(fd_SystemWin->SystemOK,Dialogs[SYSTEMWIN_OK]);
fl_set_object_label(fd_SystemWin->SystemCancel,Dialogs[SYSTEMWIN_CANCEL]);
fl_set_object_label(fd_SystemWin->SystemWarning,Dialogs[SYSTEMWIN_WARNING]);
fl_set_object_label(fd_SystemWin->SystemLabelDir,Dialogs[SYSTEMWIN_LABELDIR]);
fl_set_object_label(fd_SystemWin->SystemLabelProc,Dialogs[SYSTEMWIN_LABELPROC]);
fl_set_object_label(fd_SystemWin->SystemLabelConv,Dialogs[SYSTEMWIN_LABELCONV]);
fl_set_object_label(fd_SystemWin->SystemLabelImg,Dialogs[SYSTEMWIN_LABELIMG]);
fl_set_object_label(fd_SystemWin->SystemLabelEditor,Dialogs[SYSTEMWIN_EDITOR]);
fl_set_object_label(fd_SystemWin->TmpBuildDir,Dialogs[SYSTEMWIN_TMPDIR]);
fl_set_object_label(fd_SystemWin->SpoolDir,Dialogs[SYSTEMWIN_SPOOLDIR]);
fl_set_object_label(fd_SystemWin->FaxSend,Dialogs[SYSTEMWIN_SENDFAX]);
fl_set_object_label(fd_SystemWin->FaxPrint,Dialogs[SYSTEMWIN_PRINT]);
fl_set_object_label(fd_SystemWin->FilterToG3,Dialogs[SYSTEMWIN_FILTERG3]);
fl_set_object_label(fd_SystemWin->G3ToXpm,Dialogs[SYSTEMWIN_G3TOXPM]);

fl_set_object_label(fd_LogView->LogViewClose,Dialogs[LOGVIEW_CLOSE]);
fl_set_object_label(fd_LogView->LogViewAbort,Dialogs[LOGVIEW_ABORT]);
fl_set_object_label(fd_LogView->LogViewWrite,Dialogs[LOGVIEW_WRITE]);
fl_set_object_label(fd_LogView->LogViewClear,Dialogs[LOGVIEW_CLEARLOG]);
fl_set_object_label(fd_LogView->AutoRaise,Dialogs[LOGVIEW_RAISE]);
fl_set_object_label(fd_LogView->LogViewTitle,Dialogs[LOGVIEW_TITLE]);

fl_set_object_label(fd_QueueView->QueueViewClose,Dialogs[QUEUEVIEW_CLOSE]);
fl_set_object_label(fd_QueueView->QueueViewPrint,Dialogs[QUEUEVIEW_PRINT]);
fl_set_object_label(fd_QueueView->QueueViewSave,Dialogs[QUEUEVIEW_SAVE]);
fl_set_object_label(fd_QueueView->QueueViewRemove,Dialogs[QUEUEVIEW_REMOVE]);
fl_set_object_label(fd_QueueView->QueueViewLabelList,Dialogs[QUEUEVIEW_LISTMSG]);
fl_set_object_label(fd_QueueView->QueueViewLabelContents,Dialogs[QUEUEVIEW_CONTENTS]);
fl_set_object_label(fd_QueueView->QueueViewTitle,Dialogs[QUEUEVIEW_TITLE]);

fl_set_object_label(fd_Aliases->AliasClose,Dialogs[ALIASES_CLOSE]);
fl_set_object_label(fd_Aliases->AliasExport,Dialogs[ALIASES_EXPORT]);
fl_set_object_label(fd_Aliases->AliasImport,Dialogs[ALIASES_IMPORT]);
fl_set_object_label(fd_Aliases->AliasDelete,Dialogs[ALIASES_DELETE]);
fl_set_object_label(fd_Aliases->AliasUndelete,Dialogs[ALIASES_UNDELETE]);
fl_set_object_label(fd_Aliases->AliasTitle,Dialogs[ALIASES_TITLE]);
/* fl_set_object_label(fd_Aliases->AliasCopyright,Dialogs[ALIASES_COPYRIGHT]);
 */

SetFaxViewLabels();

if(info->Flags[0]=='+') 
  fl_replace_browser_line(fd_Xfax->FileList,1,Dialogs[MAIN_FRONTPAGE]);

switch(info->Flags[8])
   {   
      case 'M': view = FAXVIEW_TITLEM; res = MAIN_MEDRES; break;
      case 'L': view = FAXVIEW_TITLEL; res = MAIN_LOWRES; break;
      default : view = FAXVIEW_TITLEH; res = MAIN_HIGHRES; break;
   }
fl_set_object_label(fd_Xfax->Resolution, Dialogs[res]);
fl_set_object_label(fd_FaxView->FaxViewTitle, Dialogs[view]);

SetFileMenu(fd_Xfax->FileMenu);
SetOptionsMenu(fd_Xfax->OptionsMenu);

fl_unfreeze_form(fd_Xfax->Xfax);

}

int MessageFilter(FL_OBJECT *ob,const char *old,const char *cur,int c)
{
   int nlcounter;
   const char *ptr = old;

   if(c == '\n')
   {
      nlcounter = 1;
      while(*ptr != 0)
	if(*ptr++ == '\n') nlcounter++;
      if(nlcounter >= MAXMSGLINES)
	return FL_INVALID|FL_RINGBELL;
      /* refuse to avoid cursor runs out of the window */
   }
   return FL_VALID;
}

void Usage(char *naam)
{
   fprintf(stderr, "\n%s  : %s %s\n",Dialogs[XFAXMAIN_USAGE1], naam,
                                     Dialogs[XFAXMAIN_USAGE2]);
   fprintf(stderr, "\n");
   exit(1);
}

void Initialize(int argc, char *argv[])
{  
   fl_set_goodies_font(FL_NORMAL_TEXT,14); /* a little bigger ! */
   fl_setpup_fontsize(14);
   fl_set_fselector_placement(FL_PLACE_MOUSE|FL_FREE_SIZE);

   fl_set_pixmap_data(fd_Xfax->Logo,fax_xpm);
   fl_set_pixmap_data(fd_AuthorWin->Logo1,twilogo_xpm);
   fl_set_pixmap_data(fd_AuthorWin->Logo2,ujflogo_xpm);

   info = LoadUserInfo();

   if(info->Flags[6]=='-') 
      fl_hide_object(fd_Xfax->Clock);

   fl_set_button(fd_LogView->AutoRaise,(info->Flags[7]=='+')); 

   switch(info->Flags[8])
   {   
      case 'H': viewsize = 1; break;
      case 'M': viewsize = 2; break;
      case 'L': viewsize = 3; break;
      default : viewsize = 1; break;
   }
   
   RedirectIO(stderr);
   RedirectIO(stdout);

   fl_set_input_maxchars(fd_Xfax->Message,MAXMESSAGE -1);
#ifndef FORMS081
   fl_set_input_hscrollbar(fd_Xfax->Message,FL_ON);
   fl_set_input_vscrollbar(fd_Xfax->Message,FL_ON);
#endif
   fl_set_input_maxchars(fd_Xfax->Message,MAXMESSAGE -1);
   fl_set_input_filter(fd_Xfax->Message,MessageFilter);  

   if(strcmp(info->Dialogs,FAXBASE"/dialogs/dialog."BUILTIN_LANGUAGE))
      ParseDialogFile();

   if (info->Flags[0]=='+') 
      fl_insert_browser_line(fd_Xfax->FileList, 1, Dialogs[MAIN_FRONTPAGE]);

   getcwd(dir_file_to_add,sizeof(dir_file_to_add));
   strcpy(msg_file_dir,dir_file_to_add);
}

int main(int argc, char *argv[])
{
char *basename, *ptr;
int i;

   basename=argv[0];
   
   /* parse options */
   
   if (argc>=2)
   { 
      if (strncmp(argv[1],"-h",2)==0 || argc>2)
         Usage(basename);
      else
         strcpy(msg_file, argv[1]);
   }

   fl_initialize(&argc, argv, 0, 0, 0);

   for(i=0; i<NUM_DIALOG_LINES; i++) Dialogs[i] = Builtin_Dialogs[i];

   fd_Xfax = create_form_Xfax();
   fd_HelpWin = create_form_HelpWin();
   fd_AuthorWin = create_form_AuthorWin();
   fd_FromWin = create_form_FromWin();
   fd_SystemWin = create_form_SystemWin();
   fd_LogView = create_form_LogView();
   fd_QueueView = create_form_QueueView();
   fd_Aliases = create_form_Aliases();

   Initialize(argc,argv);

   if(*msg_file)
      {
 	 if(*msg_file!='/') 
           getcwd(msg_file_dir,sizeof(msg_file_dir));
         else
	   {
           strcpy(msg_file_dir,msg_file);
           ptr = msg_file_dir + strlen(msg_file_dir) -1;
           while (*ptr!='/' && ptr> msg_file_dir) --ptr;
           if (*ptr=='/') *ptr = '\0';
	   }
      }

   FaxViewCreate();
      
   SetAllLabels();
   if (*msg_file) ProcessMessageFile(msg_file);

   /* show the first form */

   fl_show_form(fd_Xfax->Xfax,FL_PLACE_CENTER,FL_FULLBORDER,"Xfax");
   while(1)
     fl_do_forms();
   return 0;
}



