#include "xfax.h"
#include "dialogdefs.h"

/* #define FORMS081  TRUE */   /* don't use extensions from 0.84 or higher */

#define MAXLOGLINE   500   /* Max number of lines in the log viewer */
#define MAXSTRING    250
#define MAXDOCS      100

#ifdef  FORMS081
#define MAXMESSAGE   500
#define MAXMSGLINES    6   /* Max number of lines in the message part */
#else
#define MAXMESSAGE  1500
#define MAXMSGLINES   20   /* Max number of lines in the message part */
#endif

#define MAXCMD      4000

/* some presets to use if there is no system or user resource file : */
#define TMPSPOOLDIR  "/tmp"

#define HELPFILE  FAXBASE"/help"

#define FAXSEND   FAXBASE"/bin/faxdirect"
#define FAXPRINT  FAXBASE"/bin/faxprint"
#define G3TOXPM   FAXBASE"/bin/g3toxpm"
#define FILTERTOG3  FAXBASE"/bin/anytog3"

#define XFAXRESOURCES  "xfaxrc"
#define XFAXALIASES    "xfaxaliases"

#define FAXCONTENTS    "faxcontents"
#define G3FAXPAGE      "g3fax_"
#define XPMPAGE        "xpm_"
#define FAXINFO        "faxinfo"

#define HR 1
#define MR 2
#define LR 3
#define VIEWERSIZE HR /*  set the desired windowsize to either HR,MR or LR */

/* Next typedef MUST be identical to the definition of the FaxView struct,
 * which can be either HR, MR or LR !!!!!! Check with xfax.h to be sure.
 */

extern int viewsize;
extern int dblclickline;

typedef struct {
	FL_FORM *FaxView;
	void *vdata;
	long ldata;
	FL_OBJECT *FaxViewTitle;
	FL_OBJECT *FaxViewPage;
	FL_OBJECT *FaxViewOf;
	FL_OBJECT *FaxPixmap;
	FL_OBJECT *FaxViewClose;
	FL_OBJECT *FaxViewPrevious;
	FL_OBJECT *FaxViewNext;
	FL_OBJECT *FaxViewGoto;
	FL_OBJECT *PageNumber;
	FL_OBJECT *PageCount;
} FD_FaxView;

typedef struct 
{
   char Name[MAXSTRING];
   char Function[MAXSTRING];
   char Department[MAXSTRING];
   char Telephone[MAXSTRING];
   char Faxnumber[MAXSTRING];
   char Email[MAXSTRING];
   char Headaddr[MAXSTRING];
   char FaxSend[MAXSTRING];
   char FaxPrint[MAXSTRING];
   char Cover[MAXSTRING];
   char Dialogs[MAXSTRING];
   char HelpFile[MAXSTRING];
   char G3ToXpm[MAXSTRING];
   char FilterToG3[MAXSTRING];
   char ImgTypes[MAXSTRING];
   char TmpBuildDir[MAXSTRING];
   char SpoolDir[MAXSTRING];
   char Editor[MAXSTRING];
   char Flags[MAXSTRING];
} Xfaxrc;

extern FD_Xfax *fd_Xfax;
extern FD_HelpWin *fd_HelpWin;
extern FD_AuthorWin *fd_AuthorWin;
extern FD_FromWin *fd_FromWin;
extern FD_SystemWin *fd_SystemWin;
extern FD_LogView *fd_LogView;
extern FD_QueueView *fd_QueueView;
extern FD_FaxView *fd_FaxView;
extern FD_Aliases *fd_Aliases;
extern Xfaxrc *info;

extern char *Dialogs[NUM_DIALOG_LINES];
extern char *Builtin_Dialogs[NUM_DIALOG_LINES];
extern char *PS_Templates[NUMTEMPL];
extern char *TeX_Templates[NUMTEMPL];
extern char msg_file[MAXSTRING];
extern char msg_file_dir[MAXSTRING];
extern char dir_file_to_add[MAXSTRING];
extern char tmpdir[MAXSTRING];
extern int  modified;
extern int  unsaved;
extern int  fpbool;
extern int  doc_index[MAXDOCS];
extern int  doc_page_count[MAXDOCS];
extern int  number_of_pages;

/* External function declarations */

char   *BuildResourceFile();
char   *ReadString(const char *label,char *string,FILE *rcfile);
void   InitHelpWin(FD_HelpWin *fd_HelpWin);
void   InitFromWin(FD_FromWin *fd_FromWin);
void   InitSystemWin(FD_SystemWin *fd_SystemWin);
Xfaxrc *LoadUserInfo();
void   InitTmpdirs(const Xfaxrc *info);
void   SaveUserInfo(const Xfaxrc *info);
void   RedirectIO(FILE *iohandle);
void   SetFaxViewLabels();
void   SetAllLabels();
void   BuildFaxPages(FD_Xfax *fd_Xfax);
void   BuildFrontPage(FD_Xfax *fd_Xfax);
void   SpawnCmd(char *cmdbuffer,int flag);
void   EraseTmpdir(char *dirname);
void   AdjustClock(int data);
int    CheckForExistence(char *filename);



