 /* File: FPORT__FOPEN.C  **M ** This implements a wrapper for the fopen() routine.  This wrapper is needed < ** to help support fcntl similation, and extended filenames. ** ** 19-Mar-1999	J. MalmbergC ** 12-Jan-2000	J. Malmberg	"b" mode and "ctx=rec" do not get along. G ** 20-Feb-2000	J. Malmberg	Found bug in open() that allowed directories 0 **				to be opened for write.  Assume is present  **				here, so preemptive strikeO ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"   #include <errno.h>    (  /* Prototype this as it will be used */' /*-----------------------------------*/  FILE * lib$callg        (void * arglist, E 	FILE * (* externproc) (const char *file, const char * a_mode, ...));   : FILE * fport__fopen(const char *file, const char * a_mode) {  char vmspath[FPORT__C_MAXRSS]; FILE * fptr; struct fport__attr_st attr;  char * attrs[4]; char * shr_opt;  char * ctx_opt;  unsigned long stat_options; ! const char * rop_opt = "rop=nlk";  unsigned long arglist[14];
 int bin_flag;  int bad_dir_flag; ' struct fport___rms_filenos_st rms_info;  unsigned long rms_ptrs[2];  -     stat_options = fport__get_stat_options();        bin_flag = 0; 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      { % 	shr_opt = "shr=put,get,upd,del,upi";  	if (a_mode[0] != 0) 	{ 	    if (a_mode[0] == 'b') 	    { 		bin_flag = 1;  	    }	 	    else  	    { 		if (a_mode[1] != 0)  		{  		    if (a_mode[1] == 'b')  		    {  			bin_flag = 1; 		    } 
 		    else 		    {  			if (a_mode[2] != 0) 			{ 			    if (a_mode[1] == 'b') 				bin_flag = 1;  			} 		    }  		}  	    } 	} 	if (bin_flag) 	{ 	    ctx_opt = "ctx=cvt";  	} 	else  	{ 	    ctx_opt = "ctx=rec";  	}     }      else     {  	shr_opt = "shr=nil";  	ctx_opt = "ctx=cvt";      }   0      /* Convert the file specification to VMS *//     /*---------------------------------------*/      fptr = NULL;     if (file[0] != 0)      { 
     int i;   	fport__get_default_file_attr  	       (vmspath,  		file, 	 		&attr);    	bad_dir_flag = 0;   	if (S_ISDIR(attr.st_mode))  	{ 	    if (a_mode[0] != 0) 	    { 		if (a_mode[0] != 'r')  		{  		    bad_dir_flag = 1;  		}  		else 		{  		    if (a_mode[1] != 0)  		    {  			if (a_mode[1] == '+') 			{ 			    bad_dir_flag = 1; 			} 		    }  		}  	    } 	}   	if (bad_dir_flag == 0)  	{ 	int filedesc;   	    i = 0;  	    attrs[0] = 0; 	    attrs[1] = 0; 	    attrs[2] = 0; 	    attrs[3] = 0;   	    if (attr.rfm[0] != '\0')  	    { 		attrs[i] = attr.rfm;3 		if ((attrs[i][4] == 'f') || (attrs[i][4] == 'u'))  		    ctx_opt = "ctx=bin"; 		i++; 	    } /*	    else  	    { 		if (bin_flag)  		{  		    attrs[i] = "rfm=fix"; 
 		    i++; 		}  	    } */ 	    if (attr.fsz[0] != '\0')  	    { 		attrs[i] = attr.fsz; 		i++; 	    } 	    if (attr.rat[0] != '\0')  	    { 		attrs[i] = attr.rat; 		i++; 	    } 	    if (attr.mrs[0] != '\0')  	    { 		attrs[i] = attr.mrs; 	    } /*	    else  	    { 		if (bin_flag)  		    attrs[i] = "mrs=512";  	    } */ 	    arglist[0] = 7;* 	    arglist[1] = (unsigned long) vmspath;) 	    arglist[2] = (unsigned long) a_mode; * 	    arglist[3] = (unsigned long) shr_opt;* 	    arglist[4] = (unsigned long) ctx_opt;( 	    arglist[5] = (unsigned long) "acc";; 	    arglist[6] = (unsigned long) fport___rms_acc_callback; + 	    arglist[7] = (unsigned long) rms_ptrs;   8 	    if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0) 	    {' 		arglist[8] = (unsigned long) rop_opt;  		arglist[0] = 8;  	    }   	    if (attrs[0] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[0];  	    }   	    if (attrs[1] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[1];  	    }   	    if (attrs[2] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[2];  	    }   	    if (attrs[3] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[3];  	    }  & 	    fptr = lib$callg(arglist, fopen);   	    if (fptr == NULL) 	    { 		rms_info.fab1 = 0; 		rms_info.rab1 = 0; 	    }	 	    else  	    { 		rms_info.fab1 = rms_ptrs[0]; 		rms_info.rab1 = rms_ptrs[1]; 	    }  3 	    rms_info.idcode = FPORT___RMS_FILENOS_VERSION;  	    rms_info.fab2 = 0;  	    rms_info.rab2 = 0;  	    rms_info.bufsize = 0; 	    rms_info.wrtindx = 0; 	    rms_info.readindx = 0;  	    rms_info.bufptr = 0;  	    rms_info.bufend = 0;  	    rms_info.offset = 0; % 	    rms_info.hiwater = attr.st_size;    	    filedesc = fileno(fptr);    	    if (filedesc >= 0) , 		fport___put_rms_info(filedesc, &rms_info); 	} 	else  	{ 	    fptr = NULL;  	    errno = EISDIR; 	}     }      return fptr; } 