 /* File: FPORT__FREOPEN.C  **O ** This implements a wrapper for the freopen() routine.  This wrapper is needed < ** to help support fcntl similation, and extended filenames. ** ** 19-Mar-1999	J. MalmbergC ** 12-Jan-2000	J. Malmberg	"b" mode and "ctx=rec" do not get along.  **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include "frontport_private.h"   #include <stdlib.h>  #include <errno.h>    (  /* Prototype this as it will be used */' /*-----------------------------------*/  FILE * lib$callg        (void * arglist,  	FILE * (* externproc)A 	 (const char *file, const char * a_mode, FILE * fileptrm, ...));   L FILE * fport__freopen(const char *file, const char * a_mode, FILE * fileptr) {  char vmspath[FPORT__C_MAXRSS]; FILE * fptr; char * attrs[4]; struct fport__attr_st attr; 
 int filedesc;  unsigned long call_stat; char * shr_opt;  char * ctx_opt;  unsigned long stat_options; ! const char * rop_opt = "rop=nlk";  unsigned long arglist[14];
 int bin_flag;  int bad_dir_flag; ' struct fport___rms_filenos_st rms_info;  unsigned long rms_ptrs[2];  -     stat_options = fport__get_stat_options();        bin_flag = 0; 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      { % 	shr_opt = "shr=put,get,upd,del,upi";  	if (a_mode[0] != 0) 	{ 	    if (a_mode[0] == 'b') 	    { 		bin_flag = 1;  	    }	 	    else  	    { 		if (a_mode[1] != 0)  		{  		    if (a_mode[1] == 'b')  		    {  			bin_flag = 1; 		    } 
 		    else 		    {  			if (a_mode[2] != 0) 			{ 			    if (a_mode[1] == 'b') 				bin_flag = 1;  			} 		    }  		}  	    } 	} 	if (bin_flag) 	{ 	    ctx_opt = "ctx=cvt";  	} 	else  	{ 	    ctx_opt = "ctx=rec";  	}     }      else     {  	shr_opt = "shr=nil";  	ctx_opt = "ctx=cvt";      }   ;      /* Clean up any locking stream that might be around */ :     /*--------------------------------------------------*/     if (fileptr != NULL)     {      short int chan;      int save_errno;   1 	 /* Use info from RMS callback for fake fcntl */ 0 	/*-------------------------------------------*/ 	filedesc = fileno(fileptr);  + 	fport___get_rms_info(filedesc, &rms_info);   & 	 /* Finish writing out last buffer */% 	/*--------------------------------*/  	if (rms_info.wrtindx != 0)  	{. 	    fport___flush_write(filedesc, &rms_info);   	    if (rms_info.bufptr != 0) 	    {  		free((void *)rms_info.bufptr); 		rms_info.bufptr = 0; 	    } 	}    0 	fport___close_lock_stream(filedesc, &rms_info);     }   0      /* Convert the file specification to VMS *//     /*---------------------------------------*/      fptr = NULL;     if (file[0] != 0)      { 
     int i;   	fport__get_default_file_attr  	       (vmspath,  		file, 	 		&attr);    	bad_dir_flag = 0;   	if (S_ISDIR(attr.st_mode))  	{ 	    if (a_mode[0] != 0) 	    { 		if (a_mode[0] != 'r')  		{  		    bad_dir_flag = 1;  		}  		else 		{  		    if (a_mode[1] != 0)  		    {  			if (a_mode[1] == '+') 			{ 			    bad_dir_flag = 1; 			} 		    }  		}  	    } 	}   	if (bad_dir_flag == 0)  	{ 	    i = 0;  	    attrs[0] = 0; 	    attrs[1] = 0; 	    attrs[2] = 0; 	    attrs[3] = 0;   	    if (attr.rfm[0] != '\0')  	    { 		attrs[i] = attr.rfm;3 		if ((attrs[i][4] == 'f') || (attrs[i][4] == 'u'))    		ctx_opt = "ctx=bin"; 		i++; 	    }	 	    else  	    { 		if (bin_flag)  		{  		    attrs[i] = "rfm=fix"; 
 		    i++; 		}  	    } 	    if (attr.fsz[0] != '\0')  	    { 		attrs[i] = attr.fsz; 		i++; 	    } 	    if (attr.rat[0] != '\0')  	    { 		attrs[i] = attr.rat; 		i++; 	    } 	    if (attr.mrs[0] != '\0')  	    { 		attrs[i] = attr.mrs; 	    }	 	    else  	    { 		if (bin_flag)  		attrs[i] = "mrs=512";  	    }   	    arglist[0] = 9;' 	    arglist[1] = (unsigned long) file; ) 	    arglist[2] = (unsigned long) a_mode; * 	    arglist[3] = (unsigned long) fileptr;* 	    arglist[4] = (unsigned long) shr_opt;* 	    arglist[5] = (unsigned long) ctx_opt;( 	    arglist[6] = (unsigned long) "acc";; 	    arglist[7] = (unsigned long) fport___rms_acc_callback; + 	    arglist[8] = (unsigned long) rms_ptrs;   8 	    if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0) 	    {' 		arglist[9] = (unsigned long) rop_opt;  		arglist[0] = 9;  	    }   	    if (attrs[0] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[0];  	    }   	    if (attrs[1] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[1];  	    }   	    if (attrs[2] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[2];  	    }   	    if (attrs[3] != NULL) 	    { 		arglist[0]++; 1 		arglist[arglist[0]] = (unsigned long) attrs[3];  	    }  ( 	    fptr = lib$callg(arglist, freopen);  3 	    rms_info.idcode = FPORT___RMS_FILENOS_VERSION;    	    if (fptr == NULL) 	    { 		rms_info.fab1 = 0; 		rms_info.rab1 = 0; 	    }	 	    else  	    { 		rms_info.fab1 = rms_ptrs[0]; 		rms_info.rab1 = rms_ptrs[1]; 	    }   	    rms_info.bufsize = 0; 	    rms_info.wrtindx = 0; 	    rms_info.readindx = 0;  	    rms_info.bufptr = 0;  	    rms_info.bufend = 0;  	    rms_info.offset = 0; % 	    rms_info.hiwater = attr.st_size;   / 	    fport___put_rms_info(filedesc, &rms_info);  	} 	else  	{ 	    fptr = NULL;  	    errno = EISDIR; 	}     }        return fptr; } 