 /* File: FPORT__FTRUNCATE.C  **J ** This implements a wrapper for the ftruncate() routine.  This wrapper isL ** needed to export the ftruncate routine in the fport shared image from the ** backport library. ** ** 19-Mar-1999	J. Malmberg> ** 01-Apr-2000	J. Malmberg	2nd Attempt to fix so that it worksF ** 30-Jul-2000	J. Malmberg	Need to just pad the file with NULL records+ **				So that stream format files opened in  **				record mode will work.O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h"   #include "frontport_private.h"   #include <unistd.h>  #include <stdio.h> #include <stdlib.h>  #include <stat.h>  #include <errno.h> #include <string.h>    #include <rms.h> /* #include <ssdef.h> */ #if 0  unsigned long SYS$EXTEND        (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    unsigned long SYS$TRUNCATE        (struct RAB * rab,  	void (*err)(struct RAB *rab), 	void (*suc)(struct RAB *rab));  #endif  0 int fport__ftruncate(int filedesc, off_t length) { 
 int ret_stat;  unsigned long stat_options;   -     stat_options = fport__get_stat_options(); 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      { #     char filename[FPORT__C_MAXRSS];      char *ret_name;      struct FAB * fab1;     struct RAB * rab1;  E 	 /* Surprise, if opened with "ctx=rec", ftruncate will not extend */ D 	/*---------------------------------------------------------------*/ 	if (length >= 0)  	{# 	     /* Try to fake it this way */ " 	    /*-------------------------*/ 	    if (filedesc >= 0)  	    { 	    stat_t stbuf; 	    unsigned long call_stat; , 	    struct fport___rms_filenos_st rms_info;  ' 		 /* Get the fab and rab structures */ & 		/*--------------------------------*/8 		call_stat = fport___get_rms_info(filedesc, &rms_info);  + 		 /* Find out if extending or shrinking */ * 		/*------------------------------------*/% 		ret_stat = fstat(filedesc, &stbuf);    		if (ret_stat >= 0) 		{  		     /* Must extend this */  		    /*------------------*/! 		    if (stbuf.st_size < length)  		    {  		    char * ret_name;% 		    char filename[FPORT__C_MAXRSS];  		    int file_delta;  		    int left; $ 		    char buffer[FPORT___C_MAXREC]; 		    int fd2; 		    int end_pos; 		    char * ctx_opt;  		    int buf_size;   9 			 /* We need to guess about force record mode or bin */ 8 			/*-------------------------------------------------*/& 			if ((stbuf.st_fab_rfm == FAB$C_FIX)* 			    || (stbuf.st_fab_rfm == FAB$C_UDF)) 			{ 			    ctx_opt = "ctx=bin";  			} 			else  			{ 			    ctx_opt = "ctx=rec";  			}   			 /* Extend does not work */ 			/*----------------------*/ - 			ret_name = getname(filedesc, filename, 1); 
 			fd2 = open  			       (filename, 				O_RDWR,  				0, 				ctx_opt, 				"shr=upd,del,put,get");   % 			end_pos = lseek(fd2, 0, SEEK_END);   / 			 /* Calculate how much to extend the file */ . 			/*---------------------------------------*/! 			file_delta = length - end_pos;  			left = file_delta;   ' 			 /* Make sure the buffer is clear */ & 			/*-------------------------------*/ 			buf_size = rms_info.bufsize;  			if (buf_size == 0) # 			    buf_size = FPORT___C_MAXREC; ' 			memset(buffer, 0, rms_info.bufsize);    			while (left > 0)  			{ 			int wrt_stat;   			    if (left > buf_size)  				left = buf_size;  + 			    wrt_stat = write(fd2, buffer, left);  			    if (wrt_stat > 0) 			    {' 				file_delta = file_delta - wrt_stat;  				left = file_delta; 			    } 			    else  			    {
 				break; 			    } 			}   			close(fd2); 		    } 
 		    else 		    { O  /* ftruncate access violates when testing with "ctx=rec" on stream file :-( */ N /*--------------------------------------------------------------------------*/ #if 0  			if (stbuf.st_size != length)  			{. 			    ret_stat = ftruncate(filedesc, length); 			} 			else  #endif 			{; 			     /* ftruncate to zero if already zero gives error */ : 			    /*-----------------------------------------------*/ 			    ret_stat = 0; 			} 		    }  		}   @ 		 /* Deal with this the best we can, remember what was tried */? 		/*---------------------------------------------------------*/  		rms_info.hiwater = length;8 		call_stat = fport___put_rms_info(filedesc, &rms_info);   	    }	 	    else  	    { 		ret_stat = -1; 		errno = EINVAL;  	    } 	} 	else  	{ 	    errno = EINVAL; 	    ret_stat = -1;  	}     }      else     { 2 	 /* Under normal conditions, ftruncate is fine */1 	/*--------------------------------------------*/ ( 	ret_stat = ftruncate(filedesc, length);     }        return ret_stat; } 