' /* File: FPORT__GET_DEFAULT_FILE_ATTR.C  **N ** This procedure determines the target VMS filename and attributes to be used ** when creating a file. ** ** 26-Mar-1999	J. Malmberg? ** 20-Mar-2000	J. Malmberg	Start of optimization to return more   **				information back to callerO ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include <string.h>  #include <fabdef.h>  #include <fcntl.h> #include <errno.h>  F static char fport___template_prefix[81] = "FPORT__TEMPLATES:TEMPLATE";  9 void fport__set_template_prefix(const char * templprefix)  {  char * cptr;  =     cptr = strncpy(fport___template_prefix, templprefix, 80); $     fport___template_prefix[80] = 0; }     ! void fport__get_default_file_attr         (char * vfilename,  	const char * ufilename, 	struct fport__attr_st * attr) {  unsigned long options; stat_t statbuffer;
 int ret_stat;  char oldname[FPORT__C_MAXRSS]; int errno_save; 
 int tst_stat;          attr->st_mode = 0;     attr->st_size = 0;     attr->st_fab_rfm = 0;      attr->st_fab_rat = 0;      attr->st_fab_fsz = 0;      attr->pad = 0;     attr->st_fab_mrs = 0;      attr->vms_ctime[0] = 0;      attr->vms_ctime[1] = 0;      attr->vms_mtime[0] = 0;      attr->vms_mtime[1] = 0;      attr->vms_btime[0] = 0;      attr->vms_btime[1] = 0;      attr->display_name[0] = 0;     attr->rfm[0] = '\0';     attr->fsz[0] = '\0';     attr->rat[0] = '\0';     attr->mrs[0] = '\0';        /* Get the file options */      /*----------------------*/     errno_save = errno; )     options = fport__get_fname_options();   $      /* Check the old format name */#     /*---------------------------*/ G     tst_stat = fport__unix_fname_to_vms(vfilename, ufilename, options);      if (tst_stat < 0)      {      unsigned long option1;    	 /* Try again as a directory */ 	/*--------------------------*/ . 	option1 = options | FPORT__M_FNAME_DIRECTORY;B 	tst_stat = fport__unix_fname_to_vms(oldname, ufilename, option1);   	if (tst_stat < 0) 	{4 	    if ((options & FPORT__M_FNAME_EXTLASTDOT) != 0) 	    {1 		option1 = options & ~FPORT__M_FNAME_EXTLASTDOT; % 		tst_stat = fport__unix_fname_to_vms ! 			(oldname, ufilename, option1);  	    } 	}   	if (tst_stat >= 0)  	{- 	     /* A file with the old format exists */ , 	    /*-----------------------------------*/  	    strcpy(vfilename, oldname); 	}     }        if (tst_stat == 2)/ 	fport__vms_dir_to_fname(vfilename, vfilename);     ,     ret_stat = stat(vfilename, &statbuffer);         if (ret_stat < 0)      { 
     int fnum;      char testname[518];   # 	 /* Finally look for a template */ " 	/*-----------------------------*/ 	strcpy(testname, "dna="); 	strcat(testname, vfilename); = 	fnum = open(fport___template_prefix, O_RDONLY, 0, testname);  	if (fnum >= 0)  	{) 	    ret_stat = fstat(fnum, &statbuffer);  	    close(fnum);  	}     }          if (ret_stat >= 0)     {      char * atstr1;     int ratcnt;   $ 	attr->st_mode = statbuffer.st_mode;$ 	attr->st_size = statbuffer.st_size;* 	attr->st_fab_rfm = statbuffer.st_fab_rfm;* 	attr->st_fab_rat = statbuffer.st_fab_rat;* 	attr->st_fab_fsz = statbuffer.st_fab_fsz;* 	attr->st_fab_mrs = statbuffer.st_fab_mrs;  + 	 /* We found something, copy the values */ * 	/*-------------------------------------*/ 	atstr1 = NULL;  	switch(statbuffer.st_fab_rfm) 	{ 	case FAB$C_FIX: 	    atstr1 = "rfm=fix";9 	    sprintf(attr->fsz, "fsz=%d", statbuffer.st_fab_fsz);  	    break;  	case FAB$C_STM: 	    atstr1 = "rfm=stm"; 	    break;  	case FAB$C_STMCR: 	    atstr1 = "rfm=stmcr"; 	    break;  	case FAB$C_STMLF: 	    atstr1 = "rfm=stmlf"; 	    break;  	case FAB$C_UDF: 	    atstr1 = "rfm=udf"; 	    break;  	case FAB$C_VAR: 	    atstr1 = "rfm=var"; 	    break;  	case FAB$C_VFC: 	    atstr1 = "rfm=vfc"; 	    break;  	}   	if (atstr1 != NULL) 	{ 	    strcat(attr->rfm, atstr1);  	}   	ratcnt = 0;   	strcpy(attr->rat, "rat="); 4 	if ((statbuffer.st_fab_rat & FAB$M_CR) == FAB$M_CR) 	{ 	   strcat(attr->rat,"cr"); 
 	   ratcnt++;  	}6 	if ((statbuffer.st_fab_rat & FAB$M_FTN) == FAB$M_FTN) 	{ 	   if (ratcnt > 0)  		strcat(attr->rat,","); 	   strcat(attr->rat,"ftn");
 	   ratcnt++;  	}6 	if ((statbuffer.st_fab_rat & FAB$M_PRN) == FAB$M_PRN) 	{ 	   if (ratcnt > 0)  		strcat(attr->rat,","); 	   strcat(attr->rat,"prn");
 	   ratcnt++;  	}6 	if ((statbuffer.st_fab_rat & FAB$M_BLK) == FAB$M_BLK) 	{ 	   if (ratcnt > 0)  		strcat(attr->rat,","); 	   strcat(attr->rat,"blk");
 	   ratcnt++;  	}6 	if ((statbuffer.st_fab_rat & FAB$M_MSB) == FAB$M_MSB) 	{ 	   if (ratcnt > 0)  		strcat(attr->rat,","); 	   strcat(attr->rat,"msb");
 	   ratcnt++;  	}   	if (ratcnt == 0)  	{ 	    attr->rat[0] = '\0';  	}   	if (statbuffer.st_fab_mrs > 0)  	{9 	    sprintf(attr->mrs, "mrs=%d", statbuffer.st_fab_mrs);  	}     }      errno = errno_save;  } 