 /* File: FPORT__GETCWD.C **N ** This implements a wrapper for the getcwd() routine.  The wrapper implements ** extended filename support.  ** ** 19-Mar-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h"   #include <unistd.h>  #include <string.h>  #include <stdlib.h>  #include <errno.h>  / char * fport__getcwd(char * buffer, size_t len)  {  char vmspath[FPORT__C_MAXRSS]; char unixpath[FPORT__C_MAXRSS];  char * ret_stat; unsigned long options; char * tempptr;  int malloc_flag;       tempptr = NULL;      malloc_flag = 0;        /* Handle NULL buffers */     /*---------------------*/ .     if ((len >= 0) && (len < FPORT__C_MAXRSS))     {  	if (buffer == NULL) 	{ 	    tempptr = malloc(len);  	    if (tempptr != NULL)  		malloc_flag = 1; 	} 	else  	    tempptr = buffer;   	if (tempptr != NULL)  	{8 	    ret_stat = getcwd(vmspath, FPORT__C_MAXRSS - 1, 1);   	    if (ret_stat != NULL) 	    {/ 		 /* Convert the file specification to UN*X */ . 		/*----------------------------------------*/B 		options = fport__get_fname_options() | FPORT__M_FNAME_DIRECTORY;7 		fport__vms_fname_to_unix(unixpath, vmspath, options);   " 		strncpy(tempptr, unixpath, len); 		tempptr[len - 1] = 0;  	    }	 	    else  	    { 		if (malloc_flag != 0)  		    free(tempptr); 		tempptr = ret_stat;  	    } 	} 	else  	{ 	    errno = ENOMEM; 	}     }      else     {  	if (len <= 0) 	    errno = EINVAL; 	if (len > FPORT__C_MAXRSS)  	    errno = ERANGE;     }        return tempptr;  } 