 /* File: FPORT__GETENV_TRNLNM.C  **N ** This procedure implements the TRNLNM system service to look like a getenv() ** call. **K ** This allows it to be used instead of the C runtime library getenv() call # ** if #define getenv fport__getenv.  **J ** The reason for doing this is that various versions of the VAX and DEC CO ** runtime libraries handle the results of translating a logical name or symbol  ** differently.  **J ** This routine will translate the logical name into static storage or the+ ** storage location passed to this routine.  ** ** 30-May-2000	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h"    /* VMS definitions */ /*-----------------*/  #include <ssdef.h> #include <descrip.h> #include <lnmdef.h>    #pragma member_alignment save # #pragma nomember_alignment longword  struct item_list_3 {     unsigned short buflen;     unsigned short item_code;      char * buffer;     unsigned short * ret_len;  };  #pragma member_alignment restore   unsigned long SYS$TRNLNM#        (const unsigned long * attr, ( 	const struct dsc$descriptor_s * tabnam,( 	const struct dsc$descriptor_s * lognam,# 	const unsigned char * access_mode,  	struct item_list_3 * itmlst);      /* Standard C Routines */ /*---------------------*/  #include <stdarg.h>  #include <string.h>   ) static char fport___getenv_logical[2048];   3 char * fport__getenv_trnlnm(const char * name, ...)  { . const $DESCRIPTOR(table_desc, "LNM$FILE_DEV");, const unsigned long attr = LNM$M_CASE_BLIND;" struct dsc$descriptor_s name_desc; char * ret_val;  int max_len; char * buf_ptr;  int arg_cnt;       ret_val = NULL;        va_count(arg_cnt);  )     if ((arg_cnt == 1) || (arg_cnt == 3))      {  	if (arg_cnt == 3) 	{ 	va_list ap;   	    va_start(ap, name); 	    max_len = va_arg(ap, int); " 	    buf_ptr = va_arg(ap, char *);   	} 	else  	{ 	    max_len = 2047;& 	    buf_ptr = fport___getenv_logical; 	}   	if (max_len > 0)  	{ 	unsigned long call_stat;  	struct item_list_3 item[2]; 	unsigned short result;   + 	    name_desc.dsc$w_length = strlen(name); , 	    name_desc.dsc$a_pointer = (char *)name;+ 	    name_desc.dsc$b_dtype = DSC$K_DTYPE_T; + 	    name_desc.dsc$b_class = DSC$K_CLASS_S;    	    item[0].buflen = max_len;% 	    item[0].item_code = LNM$_STRING;  	    item[0].buffer = buf_ptr; 	    item[0].ret_len = &result;    	    item[1].buflen = 0; 	    item[1].item_code = 0;    	    call_stat = SYS$TRNLNM , 		(&attr, &table_desc, &name_desc, 0, item);  0 	    if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	    {- 		 /* Null terminate and return the string */ , 		/*--------------------------------------*/ 		ret_val = buf_ptr; 		buf_ptr[result] = 0; 	    }   	}       }        return ret_val;  } 