 /* Getopt for GNU.G    NOTE: getopt is now part of the C library, so if you don't know what I    "Keep this file name-space clean" means, talk to roland@gnu.ai.mit.edu     before changing it!  /    Copyright (C) 1987, 88, 89, 90, 91, 92, 1993 "    	Free Software Foundation, Inc.  J    This program is free software; you can redistribute it and/or modify itH    under the terms of the GNU General Public License as published by theF    Free Software Foundation; either version 2, or (at your option) any    later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software:    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */   /*C ** 08-Apr-1998	J. Malmberg	Added memory.h for memset() and memcpy() B ** 10-Apr-1998	J. Malmberg	Added VMS style / format for VMS builds. **				VMS convention is also for "=" or ":" to. **				delimit parameters options.  That is not **				implemented yet. **F ** 20-Mar-1999	J. Malmberg	Converted for insertion in frontport shared **				image. **: ** 04-Sep-1999	J. Malmberg	Adjust to compile with DECC 6.0 **G ** 22-Dec-1999	J. Malmberg	Users are expecting to be able to have white + **				space before an option name, but this - **				routine was returning it as part of the  **				argument.  ** */   #ifdef HAVE_CONFIG_H #include "config.h"  #endif   #ifndef __STDC__ #  ifndef const  #    define const  #  endif #endif    L /* This tells Alpha OSF/1 not to define a getopt prototype in <stdio.h>.  */ #ifndef _NO_PROTO  #define _NO_PROTO  #endif   #include <stdio.h> #include <ctype.h>   /* #include "tailor.h" */  #define HAVE_MEMORY_H 1    #ifdef HAVE_MEMORY_H #include <memory.h>  #endif  K /* Comment out all this code if we are using the GNU C Library, and are not I    actually compiling the library itself.  This code is part of the GNU C I    Library, but also included in many other GNU distributions.  Compiling C    and linking in this code is a waste when using the GNU C library H    (especially if it is a shared library).  Rather than having every GNUL    program understand `configure --with-gnu-libc' and omit the object files,F    it is simpler to just do this in the source for each such file.  */  1 #if defined (_LIBC) || !defined (__GNU_LIBRARY__)     1 /* This needs to come after some library #include &    to get __GNU_LIBRARY__ defined.  */ #ifdef	__GNU_LIBRARY__F /* Don't include stdlib.h for non-GNU C libraries because some of them1    contain conflicting prototypes for getopt.  */  #include <stdlib.h>  #endif	/* GNU C library.  */  C /* If GETOPT_COMPAT is defined, `+' as well as `--' can introduce a C    long-named option.  Because this is not POSIX.2 compliant, it is     being phased out.  */ /* #define GETOPT_COMPAT */   M /* This version of `getopt' appears to the caller like standard Unix `getopt' D    but it behaves differently for the user, since it allows the user7    to intersperse the options with the other arguments.   ?    As `getopt' works, it permutes the elements of ARGV so that, B    when it is done, all the options precede everything else.  ThusK    all application programs are extended to handle flexible argument order.   I    Setting the environment variable POSIXLY_CORRECT disables permutation. ,    Then the behavior is completely standard.  E    GNU application programs can use a third alternative mode in which N    they can distinguish the relative order of options and other arguments.  */   #include "frontport.h" #include "fport__getopt.h" #include <stdlib.h>  /* #include "getopt.h" */   1 /* For communication from `getopt' to the caller. 8    When `getopt' finds an option that takes an argument,'    the argument value is returned here. ,    Also, when `ordering' is RETURN_IN_ORDER,5    each non-option ARGV-element is returned here.  */    /* char *optarg = 0; */   3 /* Index in ARGV of the next element to be scanned. 8    This is used for communication to and from the caller>    and for communication between successive calls to `getopt'.  G    On entry to `getopt', zero means this is the first call; initialize.   C    When `getopt' returns EOF, this is the index of the first of the :    non-option elements that the caller should itself scan.  =    Otherwise, `optind' communicates from one call to the next 0    how much of ARGV has been scanned so far.  */  6 /* XXX 1003.2 says this must be 1 before any call.  */ /* int optind = 0; */   4 /* The next char to be scanned in the option-element<    in which the last option character we returned was found.8    This allows us to pick up the scan where we left off.  >    If this is zero, or a null string, it means resume the scan-    by advancing to the next ARGV-element.  */    static char *nextchar;  7 /* Callers store zero here to inhibit the error message      for unrecognized options.  */   /* int opterr = 1; */   5 /* Set to an option character which was unrecognized. C    This must be initialized on some systems to avoid linking in the *    system's own getopt implementation.  */   #define BAD_OPTION '\0'  /* int optopt = BAD_OPTION; */  J /* Describe how to deal with options that follow non-option ARGV-elements.  *    If the caller did not specify anything,;    the default is REQUIRE_ORDER if the environment variable 1    POSIXLY_CORRECT is defined, PERMUTE otherwise.   7    REQUIRE_ORDER means don't recognize them as options; <    stop option processing when the first non-option is seen.    This is what Unix does.G    This mode of operation is selected by either setting the environment @    variable POSIXLY_CORRECT, or using `+' as the first character$    of the list of option characters.  G    PERMUTE is the default.  We permute the contents of ARGV as we scan, N    so that eventually all the non-options are at the end.  This allows optionsH    to be given in any order, even with programs that were not written to    expect this.   G    RETURN_IN_ORDER is an option available to programs that were written M    to expect options and other ARGV-elements in any order and that care about E    the ordering of the two.  We describe each non-option ARGV-element A    as if it were the argument of an option with character code 1. D    Using `-' as the first character of the list of option characters"    selects this mode of operation.  H    The special argument `--' forces an end of option-scanning regardlessD    of the value of `ordering'.  In the case of RETURN_IN_ORDER, onlyC    `--' can cause `getopt' to return EOF with `optind' != ARGC.  */    static enum  { )   REQUIRE_ORDER, PERMUTE, RETURN_IN_ORDER  } ordering;      #ifdef	__GNU_LIBRARY__@ /* We want to avoid inclusion of string.h with non-GNU libraries4    because there are many ways it can cause trouble.D    On some systems, it contains special magic macros that don't work    in GCC.  */ #include <string.h>  #define	my_index	strchr  #define	my_strlen	strlen #else   0 /* Avoid depending on library functions or files$    whose names are inconsistent.  */   #if __STDC__ || defined(PROTO)   #ifdef __GNUC__ & extern char *getenv(const char *name);4 extern int  strcmp (const char *s1, const char *s2);; extern int  strncmp(const char *s1, const char *s2, int n);  #endif  $ static int my_strlen(const char *s);1 static char *my_index (const char *str, int chr);  #else  extern char *getenv ();  #endif  
 static int my_strlen (str)       const char *str;  {    int n = 0;   while (*str++)     n++;   return n;  }   
 static char *  my_index (str, chr)       const char *str; 
      int chr;  {    while (*str)     {        if (*str == chr) 	return (char *) str;        str++;     }    return 0;  }    #endif				/* GNU C library.  */     ' /* Handle permutation of arguments.  */   @ /* Describe the part of ARGV that contains non-options that haveK    been skipped.  `first_nonopt' is the index in ARGV of the first of them; 9    `last_nonopt' is the index after the last of them.  */    static int first_nonopt; static int last_nonopt;   . /* Exchange two adjacent subsequences of ARGV.9    One subsequence is elements [first_nonopt,last_nonopt) D    which contains all the non-options that have been skipped so far.A    The other is elements [last_nonopt,optind), which contains all >    the options processed since those non-options were skipped.  G    `first_nonopt' and `last_nonopt' are relocated so that they describe C    the new indices of the non-options in ARGV after they are moved.   F    To perform the swap, we first reverse the order of all elements. SoC    all options now come before all non options, but they are in the F    wrong order. So we put back the options and non options in original.    order by reversing them again. For example:'        original input:      a b c -x -y '        reverse all:         -y -x c b a '        reverse options:     -x -y c b a '        reverse non options: -x -y a b c  */   #if __STDC__ || defined(PROTO)# static void exchange (char **argv);  #endif   static void  exchange (argv)       char **argv;  {    char *temp, **first, **last;  7   /* Reverse all the elements [first_nonopt, optind) */    first = &argv[first_nonopt];   last  = &argv[optind-1];   while (first < last) {A     temp = *first; *first = *last; *last = temp; first++; last--;    } %   /* Put back the options in order */    first = &argv[first_nonopt];)   first_nonopt += (optind - last_nonopt); "   last  = &argv[first_nonopt - 1];   while (first < last) {A     temp = *first; *first = *last; *last = temp; first++; last--;    }   )   /* Put back the non options in order */    first = &argv[first_nonopt];   last_nonopt = optind;    last  = &argv[last_nonopt-1];    while (first < last) {A     temp = *first; *first = *last; *last = temp; first++; last--;    }  }     E /* Scan elements of ARGV (whose length is ARGC) for option characters     given in OPTSTRING.  I    If an element of ARGV starts with '-', and is not exactly "-" or "--",o@    then it is an option element.  The characters of this elementC    (aside from the initial '-') are option characters.  If `getopt'rN    is called repeatedly, it returns successively each of the option characters$    from each of the option elements.  I    If `getopt' finds another option character, it returns that character,uI    updating `optind' and `nextchar' so that the next call to `getopt' canoG    resume the scan with the following option character or ARGV-element.s  B    If there are no more option characters, `getopt' returns `EOF'.?    Then `optind' is the index in ARGV of the first ARGV-element @    that is not an option.  (The ARGV-elements have been permuted5    so that those that are not options now come last.)e  E    OPTSTRING is a string containing the legitimate option characters.fB    If an option character is seen that is not listed in OPTSTRING,M    return BAD_OPTION after printing an error message.  If you set `opterr' to H    zero, the error message is suppressed but we still return BAD_OPTION.  M    If a char in OPTSTRING is followed by a colon, that means it wants an arg,aO    so the following text in the same ARGV-element, or the text of the followingmI    ARGV-element, is returned in `optarg'.  Two colons mean an option thateG    wants an optional arg; if there is text in the current ARGV-element, A    it is returned in `optarg', otherwise `optarg' is set to zero.   H    If OPTSTRING starts with `-' or `+', it requests different methods of)    handling the non-option ARGV-elements.VC    See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.e  5    Long-named options begin with `--' instead of `-'.iG    Their names may be abbreviated as long as the abbreviation is uniqueiA    or is an exact match for some defined option.  If they have an K    argument, it follows the option name in the same ARGV-element, separated C    from the option name by a `=', or else the in next ARGV-element.aI    When `getopt' finds a long-named option, it returns 0 if that option'soA    `flag' field is nonzero, the value of the option's `val' fieldb    if the `flag' field is zero.t  E    The elements of ARGV aren't really const, because we permute them.eA    But we pretend they're const in the prototype to be compatibleb    with other systems.  ;    LONGOPTS is a vector of `struct option' terminated by an +    element containing a name which is zero.t  G    LONGIND returns the index in LONGOPT of the long-named option found. G    It is only valid when a long-named option has been found by the mosta    recent call.t  =    If LONG_ONLY is nonzero, '-' as well as '--' can introducen    long-named options.  */   intiF _getopt_internal (argc, argv, optstring, longopts, longind, long_only)      int argc;      char *const *argv;       const char *optstring;E#      const struct option *longopts;s      int *longind;      int long_only;i {    int option_index;P  
   optarg = 0;   >   /* Initialize the internal data when the first call is made.G      Start processing options with ARGV-element 1 (since ARGV-element 0o=      is the program name); the sequence of previously skippedw+      non-option ARGV-elements is empty.  */h     if (optind == 0)     {A.       first_nonopt = last_nonopt = optind = 1;         nextchar = NULL;  L       /* Determine how to handle the ordering of options and nonoptions.  */         if (optstring[0] == '-') 	{ 	  ordering = RETURN_IN_ORDER; 	  ++optstring;a 	}#       else if (optstring[0] == '+')  	{ 	  ordering = REQUIRE_ORDER; 	  ++optstring;  	}2       else if (getenv ("POSIXLY_CORRECT") != NULL) 	ordering = REQUIRE_ORDER;
       else 	ordering = PERMUTE;     }n  ,   if (nextchar == NULL || *nextchar == '\0')     {u       if (ordering == PERMUTE) 	{H 	  /* If we have just processed some options following some non-options,7 	     exchange them so that the options come first.  */e  < 	  if (first_nonopt != last_nonopt && last_nonopt != optind) 	    exchange ((char **) argv);R" 	  else if (last_nonopt != optind) 	    first_nonopt = optind;*  ) 	  /* Now skip any additional non-options A 	     and extend the range of non-options previously skipped.  */    	  while (optind < argca9 		 && (argv[optind][0] != '-' || argv[optind][1] == '\0') 
 #ifdef VMS9 		 && (argv[optind][0] != '/' || argv[optind][1] == '\0')e #endif #ifdef GETOPT_COMPAT 		 && (longopts == NULLf< 		     || argv[optind][0] != '+' || argv[optind][1] == '\0') #endif				/* GETOPT_COMPAT */e 		 ) 	    optind++; 	  last_nonopt = optind; 	}  B       /* Special ARGV-element `--' means premature end of options. 	 Skip it like a null option,.B 	 then exchange with previous non-options as if it were an option,2 	 then skip everything else like a non-option.  */  9       if (optind != argc && !strcmp (argv[optind], "--"))s 	{ 	  optind++;  < 	  if (first_nonopt != last_nonopt && last_nonopt != optind) 	    exchange ((char **) argv);x( 	  else if (first_nonopt == last_nonopt) 	    first_nonopt = optind;  	  last_nonopt = argc;   	  optind = argc;r 	}  =       /* If we have done all the ARGV-elements, stop the scanoA 	 and back over any non-options that we skipped and permuted.  */n         if (optind == argc)g 	{8 	  /* Set the next-arg-index to point at the non-optionsE 	     that we previously skipped, so the caller will digest them.  */o# 	  if (first_nonopt != last_nonopt)t 	    optind = first_nonopt;h 	  return EOF; 	}  @       /* If we have come to a non-option and did not permute it,G 	 either stop the scan or describe it to the caller and pass it by.  */E  =       if ((argv[optind][0] != '-' || argv[optind][1] == '\0')o
 #ifdef VMS9 	  && (argv[optind][0] != '/' || argv[optind][1] == '\0')  #endif #ifdef GETOPT_COMPAT 	  && (longopts == NULL < 	      || argv[optind][0] != '+' || argv[optind][1] == '\0') #endif				/* GETOPT_COMPAT */  	  ) 	{! 	  if (ordering == REQUIRE_ORDER)h 	    return EOF; 	  optarg = argv[optind++];w 	  return 1; 	}  3       /* We have found another option-ARGV-element. $ 	 Start decoding its characters.  */  "       nextchar = (argv[optind] + 1
 #ifdef VMS 		  + (longopts != NULL &&< 		     (argv[optind][1] == '-') || argv[optind][1] == '/')); #else 4 		  + (longopts != NULL && argv[optind][1] == '-')); #endif     }      if (longopts != NULL!       && ((argv[optind][0] == '-'i- 	   && (argv[optind][1] == '-' || long_only))  #ifdef GETOPT_COMPAT 	  || argv[optind][0] == '+' #endif				/* GETOPT_COMPAT */s
 #ifdef VMS 	  || argv[optind][0] == '/' #endif 	  )).     {T       const struct option *p;        char *s = nextchar;e       int exact = 0;       int ambig = 0;)       const struct option *pfound = NULL;        int indfound = 0;u         while (*s && *s != '=')  	s++;t  L       /* Test all options for either exact match or abbreviated matches.  */3       for (p = longopts, option_index = 0; p->name;f 	   p++, option_index++)0 	if (!strncmp (p->name, nextchar, s - nextchar)) 	  {- 	    if (s - nextchar == my_strlen (p->name))a 	      { 		/* Exact match found.  */ 
 		pfound = p;t 		indfound = option_index; 		exact = 1; 		break; 	      } 	    else if (pfound == NULL)  	      {$ 		/* First nonexact match found.  */
 		pfound = p;/ 		indfound = option_index; 	      }	 	    elseU* 	      /* Second nonexact match found.  */ 	      ambig = 1;p 	  }         if (ambig && !exact) 	{ 	  if (opterr)7 	    fprintf (stderr, "%s: option `%s' is ambiguous\n",c 		     argv[0], argv[optind]);$ 	  nextchar += my_strlen (nextchar); 	  optind++; 	  return BAD_OPTION;t 	}         if (pfound != NULL)y 	{ 	  option_index = indfound;s 	  optind++;
 	  if (*s) 	    {C 	      /* Don't test has_arg with >, because some C compilers don'tc$ 		 allow it to be used on enums.  */ 	      if (pfound->has_arg)  		optarg = s + 1;r 	      elset 		{c 		  if (opterr)  		    { ' 		      if (argv[optind - 1][1] == '-')G 			/* --option */  			fprintf (stderr,t5 				 "%s: option `--%s' doesn't allow an argument\n",V 				 argv[0], pfound->name); 		      else 			/* +option or -option */  			fprintf (stderr,t8 			     "%s: option `%c%s' doesn't allow an argument\n",4 			     argv[0], argv[optind - 1][0], pfound->name); 		    }s% 		  nextchar += my_strlen (nextchar);s 		  return BAD_OPTION; 		}s 	    }! 	  else if (pfound->has_arg == 1)o 	    { 	      if (optind < argc)o 		optarg = argv[optind++]; 	      else  		{e 		  if (opterr)s@ 		    fprintf (stderr, "%s: option `%s' requires an argument\n",# 			     argv[0], argv[optind - 1]);e% 		  nextchar += my_strlen (nextchar);t2 		  return optstring[0] == ':' ? ':' : BAD_OPTION; 		}s 	    }$ 	  nextchar += my_strlen (nextchar); 	  if (longind != NULL)  	    *longind = option_index;r 	  if (pfound->flag) 	    {% 	      *(pfound->flag) = pfound->val;  	      return 0; 	    } 	  return pfound->val; 	}J       /* Can't find it as a long option.  If this is not getopt_long_only,8 	 or the option starts with '--' or is not a valid short 	 option, then it's an error. / 	 Otherwise interpret it as a short option.  */ .       if (!long_only || argv[optind][1] == '-' #ifdef GETOPT_COMPAT 	  || argv[optind][0] == '+' #endif				/* GETOPT_COMPAT */c. 	  || my_index (optstring, *nextchar) == NULL) 	{ 	  if (opterr) 	    {" 	      if (argv[optind][1] == '-') 		/* --option */6 		fprintf (stderr, "%s: unrecognized option `--%s'\n", 			 argv[0], nextchar);f 	      else{ 		/* +option or -option */6 		fprintf (stderr, "%s: unrecognized option `%c%s'\n",( 			 argv[0], argv[optind][0], nextchar); 	    } 	  nextchar = (char *) ""; 	  optind++; 	  return BAD_OPTION;  	}     }s  6   /* Look at and handle the next option-character.  */     {s     char c = *nextchar++;r)     char *temp = my_index (optstring, c);o  J     /* Increment `optind' when we start to process its last character.  */     if (*nextchar == '\0')       ++optind;   !     if (temp == NULL || c == ':')*       {l 	if (opterr) 	  { #if 0  	    if (c < 040 || c >= 0177)H 	      fprintf (stderr, "%s: unrecognized option, character code 0%o\n", 		       argv[0], c); 	 	    elseoG 	      fprintf (stderr, "%s: unrecognized option `-%c'\n", argv[0], c);n #else 8 	    /* 1003.2 specifies the format of this message.  */@ 	    fprintf (stderr, "%s: illegal option -- %c\n", argv[0], c); #endif 	  } 	optopt = c; 	return BAD_OPTION;o       }r     if (temp[1] == ':')h       {e 	if (temp[2] == ':') 	  {B 	    /* This is an option that accepts an argument optionally.  */ 	    if (*nextchar != '\0')o 	      { 		optarg = nextchar; 		optind++;m 	      }	 	    elseo 	      optarg = 0; 	    nextchar = NULL;  	  } 	else  	  {0 	     /* Chew up any whitespace - J. Malmberg *// 	    /*--------------------------------------*/t3 	    while ((*nextchar != 0) && isspace(*nextchar))e 	    {
 		nextchar++;t 	    }  8 	    /* This is an option that requires an argument.  */ 	    if (*nextchar != '\0')  	      { 		optarg = nextchar;> 		/* If we end this ARGV-element by taking the rest as an arg,1 		   we must advance to the next element now.  */r 		optind++;  	      } 	    else if (optind == argc)m 	      {
 		if (opterr)w 		  {  #if 0BA 		    fprintf (stderr, "%s: option `-%c' requires an argument\n",t 			     argv[0], c); #elses9 		    /* 1003.2 specifies the format of this message.  */oA 		    fprintf (stderr, "%s: option requires an argument -- %c\n",l 			     argv[0], c); #endif 		  } 
 		optopt = c;f 		if (optstring[0] == ':') 		  c = ':'; 		else 		  c = BAD_OPTION;a 	      }	 	    elseg/ 	      /* We already incremented `optind' once; @ 		 increment it again when taking next ARGV-elt as argument.  */ 	      optarg = argv[optind++];e 	    nextchar = NULL;I 	  }       }U
     return c;e   }  }L   inte% fport__getopt (argc, argv, optstring)'      int argc;      char *const *argv;l      const char *optstring;i {i1   return _getopt_internal (argc, argv, optstring,   			   (const struct option *) 0, 			   (int *) 0,	 			   0);e }m   inte: getopt_long (argc, argv, options, long_options, opt_index)      int argc;      char *const *argv;t      const char *options;i'      const struct option *long_options;l      int *opt_index; { L   return _getopt_internal (argc, argv, options, long_options, opt_index, 0); }e  + #endif	/* _LIBC or not __GNU_LIBRARY__.  */e t   #ifdef TESTt  ? /* Compile with -DTEST to make an executable for use in testingt(    the above definition of `getopt'.  */   intt main (argc, argv)a      int argc;      char **argv;  {e   int c;   int digit_optind = 0;r     while (1)      { 3       int this_option_optind = optind ? optind : 1;   2       c = getopt (argc, argv, "abc:d:0123456789");       if (c == EOF)  	break;O         switch (c) 	{
 	case '0':
 	case '1':
 	case '2':
 	case '3':
 	case '4':
 	case '5':
 	case '6':
 	case '7':
 	case '8':
 	case '9':? 	  if (digit_optind != 0 && digit_optind != this_option_optind)n? 	    printf ("digits occur in two different argv-elements.\n");i% 	  digit_optind = this_option_optind;  	  printf ("option %c\n", c);g	 	  break;   
 	case 'a': 	  printf ("option a\n");f	 	  break;s  
 	case 'b': 	  printf ("option b\n");h	 	  break;n  
 	case 'c':1 	  printf ("option c with value `%s'\n", optarg);c	 	  break;u   	case BAD_OPTION:n	 	  break;V  	 	default:e< 	  printf ("?? getopt returned character code 0%o ??\n", c); 	}     }t     if (optind < argc)     {r,       printf ("non-option ARGV-elements: ");       while (optind < argc)n  	printf ("%s ", argv[optind++]);       printf ("\n");     }      exit (0);E }    #endif /* TEST */ 