  /* File: FPORT__GET_SAMBA_MODE.C **A ** This procedure modifies the given protection mask to match the $ ** what the UN*X samba port expects. **D ** It is assumed that the filename has already been converted to VMS* ** acceptable format, and the file exists. **L ** Note: These attributes can be displayed but not set through SAMBA at this **       time. **G ** Note: The VMS port of SAMBA seems to require that a file gets opened F **	 multiple times to get some information.  There must be some way to  **	 optimize this into one call. **L ** Originally I planned to use ACEs for the DOS HIDDEN, SYSTEM, and READONLYN ** attributes.  However, it was pointed out to me at DECUS by Robert Gezelter,G ** a software consultant, that most users would expect a mapping to the % ** standard OpenVMS protection codes.  **J ** This is much easier to implement than the ACEs, so I am doing it on theL ** first pass for this code.  I still think that that using ACEs is the onlyH ** way to get the full functionallity.  If that is implemented later, it? ** should require a logical name to activate the funtionallity.  **K ** Any changes will only be done if the user has sufficient privileges, and K ** the SYSTEM and READONLY attributes may not be accurate, as a VMS ACE may M ** override it.  This is why I think that ACEs are the only way to accurately  ** implement this feature. ** **: ** For the attribute matching, the following will be used: **F ** The ARCHIVE bit will not be able set by the user.  It will indicate. ** if a backup date has been set for the file. **J ** The HIDDEN bit will not be able to be set by the user.  There is no way7 ** to encode this information without bad side effects.  **H ** The SYSTEM bit will indicate if the none of the VMS protection fieldsL ** has DELETE access to a file.  Setting it from SAMBA will clear the DELETEK ** bits from all of the VMS protection groups.  Clearing it from SAMBA will B ** only enable the DELETE bit for the VMS SYSTEM protection group. **F ** The READONLY bit will indicate that the VMS OWNER, GROUP, and WORLDJ ** protection groups have neither DELETE or WRITE access.  Setting it fromL ** SAMBA will clear the DELETE and WRITE access from these groups.  ClearingK ** it from SAMBA will enable the WRITE and DELETE access only for the owner  ** of the file.  ** ** ** 22-Aug-1999	J. Malmberg **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/ #ifndef _VMS_V6_SOURCE #define _VMS_V6_SOURCE 1 #endif  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport_private.h" #include "frontport.h"   #include <sys/stat.h>  #include <ssdef.h> #include <rms.h> #include <descrip.h> #include <string.h>  #include <acldef.h>  #include <chpdef.h>  #include <armdef.h>  #include <prvdef.h>  #ifdef __GNUC__  #include <rms$routines.h>  #else   $      /* Prototype these correctly */#     /*---------------------------*/  unsigned long SYS$OPEN        (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    unsigned long SYS$CLOSE         (struct FAB * fab,  	void (*err)(struct FAB *fab), 	void (*suc)(struct FAB *fab));    #endif     #pragma member_alignment save # #pragma nomember_alignment longword  struct itmlst3_st {      unsigned short buflen;     unsigned short itemcode;     char * bufaddr;      unsigned short * retlen; };  #pragma member_alignment restore   unsigned long SYS$GET_SECURITY/        (const struct dsc$descriptor_s * clsnam, ( 	const struct dsc$descriptor_s * objnam, 	const unsigned long * objhan, 	const unsigned long * flags, " 	const struct itmlst3_st * itmlst, 	unsigned long * contxt, 	const unsigned long * acmode);    unsigned long SYS$CHECK_ACCESS%        (const unsigned long * objtyp, ( 	const struct dsc$descriptor_s * objnam,( 	const struct dsc$descriptor_s * usrnam,# 	const struct itmlst3_st * itemlst,  	unsigned long * contxt,( 	const struct dsc$descriptor_s * clsnam, 	void * objpro,  	void * usrpro);   unsigned long SYS$SETPRV    (unsigned long enbflg,      const void * prvadr,     unsigned long prmflg,      void * prvprv);    unsigned long SYS$IDTOASC     (unsigned long id,      unsigned short * namlen,%     struct dsc$descriptor_s * nambuf,      unsigned long * resid,     unsigned long * attrib,      unsigned long * contxt);    # void LIB$SIGNAL(unsigned long,...);     A mode_t fport__get_samba_mode(const char * filename, mode_t umode)  { $ const $DESCRIPTOR(file_dsc, "FILE");( const $DESCRIPTOR(system_dsc, "SYSTEM");0 const char * samba_readonly = "SAMBA__READONLY";, const char * samba_hidden = "SAMBA__HIDDEN";, const char * samba_system = "SAMBA__SYSTEM";  % struct dsc$descriptor_s filename_dsc; % struct dsc$descriptor_s username_dsc;  unsigned long call_stat; unsigned long objtype; mode_t ret_mode; struct FAB tstfab; struct XABDAT tstxab;  int dos_archive; struct itmlst3_st itemlist[4]; unsigned long flags; /* char ace_buf[2049]; ** unsigned short ace_buf_len; */ int len; int dos_system;  int dos_hidden;  int dos_readonly;  unsigned long objtyp;  unsigned long arm_vector;  unsigned long priv_used; unsigned long stat_option; unsigned long old_priv[2];  G  /* Use const instead of #DEFINE makes symbols available to debugger */ F /*------------------------------------------------------------------*/$ const unsigned long PRIV_ENABLE = 1;% const unsigned long PRIV_DISABLE = 0; 8 const unsigned long root_priv[2] = { PRV$M_SYSPRV  , 0};       dos_archive = 0;     dos_hidden = 0;      dos_system = 0;      dos_readonly = 0;      ret_mode = umode;        old_priv[0] = 0;     old_priv[1] = 0;       len = strlen(filename);      if (len > 0)     {   G 	 /* The archive bit is clear if there is a backup date for the file */ F 	/*-----------------------------------------------------------------*/  " 	 /* Set up the FAB for a parse */! 	/*----------------------------*/ ) 	memset(&tstfab, 0, sizeof (struct FAB));  	tstfab = cc$rms_fab; , 	memset(&tstxab, 0, sizeof (struct XABDAT)); 	tstxab = cc$rms_xabdat;    ) 	 /* Use RMS to get all the file dates */ ( 	/*-----------------------------------*/ 	tstfab.fab$l_dna = 0; 	tstfab.fab$b_dns = 0;% 	tstfab.fab$l_fna = (char *)filename;  	tstfab.fab$b_fns = len; 	tstfab.fab$l_xab = &tstxab; 	tstfab.fab$b_fac = FAB$M_GET;> 	tstfab.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET | FAB$M_SHRPUT 				| FAB$M_SHRUPD;     % 	call_stat = SYS$OPEN(&tstfab, 0, 0); , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{ 	unsigned long * bdptr;   ' 	     /* Has a backup date been set? */ & 	    /*-----------------------------*/1 	    bdptr = (unsigned long *) &tstxab.xab$q_bdt; , 	    if ((bdptr[0] == 0) && (bdptr[1] == 0)) 	    { 		dos_archive = 1; 	    }   	     /* Close up the file */  	    /*-------------------*/* 	    call_stat = SYS$CLOSE(&tstfab, 0, 0); 	}    ( 	 /* Elevate the privilege if you can */' 	/*----------------------------------*/ = 	call_stat = SYS$SETPRV(PRIV_ENABLE, root_priv, 0, old_priv); , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{  2 	     /* Find out what method of manging to use */1 	    /*----------------------------------------*/ - 	    stat_option = fport__get_stat_options();    	    objtype = ACL$C_FILE;  3 	    filename_dsc.dsc$a_pointer = (char *)filename; % 	    filename_dsc.dsc$w_length = len; . 	    filename_dsc.dsc$b_dtype = DSC$K_DTYPE_T;. 	    filename_dsc.dsc$b_class = DSC$K_CLASS_S;   	    itemlist[0].buflen = 4;( 	    itemlist[0].itemcode = CHP$_ACCESS;0 	    itemlist[0].bufaddr = (char *) &arm_vector; 	    itemlist[0].retlen = 0;   	    itemlist[1].buflen = 4;* 	    itemlist[1].itemcode = CHP$_PRIVUSED;/ 	    itemlist[1].bufaddr = (char *) &priv_used;  	    itemlist[1].retlen = 0;   	    itemlist[2].buflen = 0; 	    itemlist[2].itemcode = 0;  " 	     /* Test for SYSTEM access */! 	    /*------------------------*/ A 	    if ((stat_option & FPORT__M_STAT_SET_SAMBA_SYSTEM_ACE) == 0)  	    {   		arm_vector = ARM$M_DELETE;    & 		 /* Old Method, just check access */% 		/*-------------------------------*/  		call_stat = SYS$CHECK_ACCESS 		       (&objtype,  			&filename_dsc,  			&system_dsc,  			itemlist, 			0,  			0,  			0,  			0);  - 		if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		{ 3 		     /* Was the access through the SYSPRV bits */ 2 		    /*----------------------------------------*/; 		    if ((priv_used & (CHP$M_SYSPRV | CHP$M_GRPPRV)) == 0)  		    { ' 			if ((priv_used & CHP$M_BYPASS) != 0)  			    dos_system = 1; 		    }  		}  		else 		{ " 		    if (call_stat == SS$_NOPRIV) 			dos_system = 1; 		}  	    }	 	    else  	    {" 		 /* Currently not implemented */! 		/*---------------------------*/  	    }      $ 	     /* Test for READONLY access */# 	    /*--------------------------*/ C 	    if ((stat_option & FPORT__M_STAT_SET_SAMBA_READONLY_ACE) == 0)  	    { 	    char username[14];  	    unsigned short ulen;  	    unsigned long id; 	    uid_t uid;  	    gid_t gid;   ( 		username_dsc.dsc$a_pointer = username;! 		username_dsc.dsc$w_length = 14; + 		username_dsc.dsc$b_dtype = DSC$K_DTYPE_T; + 		username_dsc.dsc$b_class = DSC$K_CLASS_S;*   		uid = getuid();B 		gid = getgid();i( 		id = (uid & 0xFFFF) + (gid * 0x10000);  = 		call_stat = SYS$IDTOASC(id, &ulen, &username_dsc, 0, 0, 0);I- 		if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		{r' 		    username_dsc.dsc$w_length = ulen;   . 		    arm_vector = ARM$M_DELETE + ARM$M_WRITE;    * 		     /* Old Method, just check access */) 		    /*-------------------------------*/S" 		    call_stat = SYS$CHECK_ACCESS 		       (&objtype,p 			&filename_dsc,e 			&username_dsc,e 			itemlist, 			0,  			0,i 			0,i 			0);  1 		    if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		    {I8 			if ((priv_used & (CHP$M_SYSPRV | CHP$M_BYPASS)) != 0) 			    dos_readonly = 1; 		    }e
 		    else 		    {f 			if (call_stat == SS$_NOPRIV)  			{ 			    dos_readonly = 1; 			} 			elsen 			{& 			     /* This is only for testing */% 			    /* LIB$SIGNAL(call_stat);   */m 			} 		     } 		}f 	    }	 	    elsec 	    {) 	         /* Currently not implemented */y( 	        /*---------------------------*/ 	    }    ! 	     /* Set the READONLY mode */u  	    /*-----------------------*/ 	    if (dos_readonly == 1)c7 		ret_mode = ret_mode & ~(S_IWUSR | S_IWGRP | S_IWOTH);l      	     /* Mangle the user bits */ 	    /*----------------------*/a 	    if (dos_archive == 0)! 		ret_mode = ret_mode & ~S_IXUSR;s	 	    elsel  		ret_mode = ret_mode | S_IXUSR;    > 	      /* Need to determine what a HIDDEN designation means */7 	     /*  Assume SAMBA__HIDDEN ACE is for the file	  */e< 	    /*---------------------------------------------------*/ 	    if (dos_hidden == 0)T! 		ret_mode = ret_mode & ~S_IXOTH;e	 	    else   		ret_mode = ret_mode | S_IXOTH;     	     /* Set the SYSTEM mode */e 	    /*---------------------*/ 	    if (dos_system == 0)f! 		ret_mode = ret_mode & ~S_IXGRP;D	 	    elses  		ret_mode = ret_mode | S_IXGRP;   	}  & 	 /* Drop back to the old privilege */% 	/*--------------------------------*/m' 	if ((old_priv[1] & PRV$M_SYSPRV) != 0)i 	{; 	    call_stat = SYS$SETPRV(PRIV_DISABLE, root_priv, 0, 0);i 	}       }h     return ret_mode; }a    ? void fport__set_samba_mode(const char * filename, mode_t umode)S {i)     /* This will need to be done later */a  H     /* It is just not practical to code it so that it takes into account9     ** access to the file that can be obtained from ACLs.i     */ }*