 /* File: FPORT__OPENDIR.C  **O ** This implements a wrapper for the opendir() routine.  The wrapper implements  ** extended filename support.  ** ** 19-Mar-1999	J. MalmbergF ** 08-Jul-2000	J. Malmberg	Added support for enumerated "/" and "/DEV"2 **				contents through interpreting logical names.H ** 30-Sep-2000	J. Malmberg	libfildef.h does not exist on OpenVMS VAX 7.1 **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include "frontport.h" #include <stdlib.h>  #include <string.h>  #include <errno.h> #include <ctype.h>   #include <descrip.h> #include <ssdef.h> #include <rms.h> #include <lnmdef.h> + #if defined(NAML$C_BID) && defined(__ALPHA)  #include <libfildef.h> #endif  ! #pragma __member_alignment __save % #pragma __nomember_alignment longword  struct item_list_3 {     unsigned short buflen;     unsigned short item_code;      char * buffer;     unsigned short * ret_len;  };$ #pragma __member_alignment __restore   unsigned long SYS$TRNLNM#        (const unsigned long * attr, ( 	const struct dsc$descriptor_s * tabnam,( 	const struct dsc$descriptor_s * lognam,# 	const unsigned char * access_mode, $ 	const struct item_list_3 * itmlst);   unsigned long SYS$DEVICE_SCAN -        (struct dsc$descriptor_s * return_dev,  	unsigned short * retlen, - 	const struct dsc$descriptor_s * device_name, # 	const struct item_list_3 * itmlst,  	unsigned long * context);   unsigned long LIB$FIND_FILE 5        (const struct dsc$descriptor_s * filespec_dsc, , 	struct dsc$descriptor_s * res_filespec_dsc, 	unsigned long * context, 2 	const struct dsc$descriptor_s * def_filespec_dsc,2 	const struct dsc$descriptor_s * rel_filespec_dsc, 	unsigned long * status_value, 	unsigned long * flags);   unsigned long LIB$FIND_FILE_END         (unsigned long context);    #ifndef LIB$M_FIL_LONG_NAMES #define LIB$M_FIL_LONG_NAMES 4 #endif  - FPORT__DIR * fport__opendir(const char *file)  {  char vmspath[FPORT__C_MAXRSS]; FPORT__DIR * ret_stat; unsigned long options; unsigned long call_stat;. const $DESCRIPTOR(table_desc, "LNM$FILE_DEV");, const unsigned long attr = LNM$M_CASE_BLIND;" struct dsc$descriptor_s name_desc;       ret_stat = NULL;       if (file[0] != 0)      {      int len;
     int flen;   & 	options = fport__get_fname_options();  % 	options |= FPORT__M_FNAME_DIRECTORY; 2 	fport__unix_fname_to_vms(vmspath, file, options); 	len = strlen(vmspath);  	flen = strlen(file);  	if (vmspath[len - 1] == ':')  	{
 	int toff;   	    if (flen > 4) 	    { 	    char * tptr;   ! 		tptr = strpbrk(&file[1],"\\/");  		if (tptr != NULL) ' 		    toff = (int)tptr - (int)&file[1];  		else 		    toff = 1;  	    }	 	    else  	    { 		toff = flen; 	    }   	    if (toff >= 3)  	    { 		if ((toupper(file[1]) == 'D') ! 		   && (toupper(file[2]) == 'E') " 		   && (toupper(file[3]) == 'V')) 		{  		struct item_list_3 item[3];  		unsigned short string_result;  		unsigned long max_index; 		unsigned long length;  		unsigned short max_index_len;  		unsigned short length_len;   		    item[0].buflen = 4; ) 		    item[0].item_code = LNM$_MAX_INDEX; * 		    item[0].buffer = (char *)&max_index;' 		    item[0].ret_len = &max_index_len;    		    item[1].buflen = 4; & 		    item[1].item_code = LNM$_LENGTH;' 		    item[1].buffer = (char *)&length; $ 		    item[1].ret_len = &length_len;   		    item[2].buflen = 0;  		    item[2].item_code = 0;  ( 		    name_desc.dsc$a_pointer = vmspath;' 		    name_desc.dsc$w_length = len - 1; , 		    name_desc.dsc$b_dtype = DSC$K_DTYPE_T;, 		    name_desc.dsc$b_class = DSC$K_CLASS_S;   		    call_stat = SYS$TRNLNM- 			(&attr, &table_desc, &name_desc, 0, item);   1 		    if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		    {  			if (max_index > 0)  			{7 			    options = options | FPORT__M_FNAME_LOGICAL_LIST;  			} 		    } 
 		    else 		    { 2 			options = options | FPORT__M_FNAME_DEVICE_LIST; 		    }  		}  	    } 	}( 	ret_stat = malloc(sizeof (FPORT__DIR));     }        if (ret_stat != NULL)      {  	 /* Reset the context */  	/*-------------------*/ 	ret_stat->context = 0;  	ret_stat->count = 0;  	ret_stat->find_flags = 0;+ #if defined(NAML$C_BID) && defined(__ALPHA) 1 	if ((options & FPORT__M_FNAME_DEVICE_LIST) == 0)  	{1 	    ret_stat->find_flags = LIB$M_FIL_LONG_NAMES;  	} #endif 	ret_stat->file_opts = options;   0 	 /* Save the path, so that readdir can parse *// 	/*------------------------------------------*/ 3 	strncpy(ret_stat->path, vmspath, FPORT__C_MAXRSS); ) 	ret_stat->path[FPORT__C_MAXRSS - 1] = 0;    	 /* set up the file scan */ 	/*----------------------*/  	ret_stat->template[0] = '*';  	ret_stat->template[1] = '.';  	ret_stat->template[2] = '*';  	ret_stat->template[3] = ';';  	ret_stat->template[4] = 0;   - 	if ((options & FPORT__M_FNAME_VERSION) != 0)  	{! 	    ret_stat->template[4] = '*';  	    ret_stat->template[5] = 0;  	}  1 	if ((options & FPORT__M_FNAME_DEVICE_LIST) != 0)  	    ret_stat->template[1] = 0;        }      else     { " 	 /* Only if unable to malloc() */! 	/*----------------------------*/  	errno = ENFILE;     }        return ret_stat; }       $  /* Clean up the directory search */# /*===============================*/ & int fport__closedir(FPORT__DIR * dirp) { 
 int ret_stat;  unsigned long call_stat;       ret_stat = -1;       if (dirp != NULL)      {  	call_stat = SS$_NORMAL; 	if (dirp->context !=  0)  	{= 	    if ((dirp->file_opts & FPORT__M_FNAME_DEVICE_LIST) == 0)  	    {/ 		call_stat = LIB$FIND_FILE_END(dirp->context);  	    } 	}  , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{ 	    ret_stat = 0; 	} 	free(dirp);     }        return ret_stat; }       ,  /* Start the directory search over again */+ /*=======================================*/ ( void fport__rewinddir(FPORT__DIR * dirp) {  unsigned long call_stat;  <      /* Simple, end file contect, reset context and count */;     /*---------------------------------------------------*/      if (dirp != NULL)      {  	if (dirp->context != 0) 	{= 	    if ((dirp->file_opts & FPORT__M_FNAME_DEVICE_LIST) == 0)  	    {/ 		call_stat = LIB$FIND_FILE_END(dirp->context);  	    }	 	    else  	    { 		dirp->find_flags = 0;  	    } 	} 	dirp->context = 0;  	dirp->count = 0;      }  }     -  /* Find a previous postion in a directory */ , /*----------------------------------------*/4 void fport__seekdir(FPORT__DIR * dirp, long int loc) {  char ret_name[FPORT__C_MAXRSS]; * struct dsc$descriptor_s test_filespec_dsc;) struct dsc$descriptor_s res_filespec_dsc; ) struct dsc$descriptor_s def_filespec_dsc;  unsigned long call_stat; unsigned long find_stat; long i;   /     if ((dirp != NULL) && (dirp->count != loc))      {  	call_stat = SS$_NORMAL; 	if (dirp->context != 0) 	{= 	    if ((dirp->file_opts & FPORT__M_FNAME_DEVICE_LIST) == 0)  	    {/ 		call_stat = LIB$FIND_FILE_END(dirp->context);  	    }	 	    else  	    { 		dirp->find_flags = 0;  	    } 	}, 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{ 	unsigned long topts;    	    dirp->context = 0;  	    dirp->count = 0;  	    i = 0; 2 	    test_filespec_dsc.dsc$a_pointer = dirp->path;9 	    test_filespec_dsc.dsc$w_length = strlen(dirp->path); 3 	    test_filespec_dsc.dsc$b_dtype = DSC$K_DTYPE_T; 3 	    test_filespec_dsc.dsc$b_class = DSC$K_CLASS_S;   5 	    def_filespec_dsc.dsc$a_pointer = dirp->template; < 	    def_filespec_dsc.dsc$w_length = strlen(dirp->template);2 	    def_filespec_dsc.dsc$b_dtype = DSC$K_DTYPE_T;2 	    def_filespec_dsc.dsc$b_class = DSC$K_CLASS_S;  / 	    res_filespec_dsc.dsc$a_pointer = ret_name; 5 	    res_filespec_dsc.dsc$w_length = FPORT__C_MAXRSS; 2 	    res_filespec_dsc.dsc$b_dtype = DSC$K_DTYPE_T;2 	    res_filespec_dsc.dsc$b_class = DSC$K_CLASS_S;  F 	    topts = FPORT__M_FNAME_DEVICE_LIST | FPORT__M_FNAME_LOGICAL_LIST;   	    while (i <= loc)  	    {% 		if ((dirp->file_opts & topts) == 0)  		{  		    call_stat = LIB$FIND_FILE  			       (&test_filespec_dsc, 				&res_filespec_dsc, 				&dirp->context,  				&def_filespec_dsc, 				0, 				&find_stat,  				&dirp->find_flags);   1 		    if ((call_stat & SS$_NORMAL) != SS$_NORMAL) 	 			break; 
 		    i++; 		}  		else 		{ ? 		    if ((dirp->file_opts & FPORT__M_FNAME_LOGICAL_LIST) != 0)  		    {  			i = loc; 
 		 	break; 		    } 
 		    else 		    {   		    unsigned long dcontext[2]; 		    unsigned short retlen;  0 			 /* List all of the devices, one at a time *// 			/*----------------------------------------*/  			dcontext[0] = dirp->context; " 			dcontext[1] = dirp->find_flags;   			call_stat = SYS$DEVICE_SCAN 			       (&res_filespec_dsc,  				&retlen, 				&def_filespec_dsc, 				(struct item_list_3 *) 0,  				dcontext);   			dirp->context = dcontext[0]; " 			dirp->find_flags = dcontext[1]; 		    }  		}  	    } 	    dirp->count = i;  	}     }  }     1  /* Report the current position in a directory */ 0 /*============================================*/* long int fport__telldir(FPORT__DIR * dirp) {  long int ret_stat;       ret_stat = dirp->count;      return ret_stat; } 