9 /* File: FPORT__PWRK_FNAME_TO_UNIX.C was VMS_2_LONGFILE.C  **N ** The routine converts a mangled VMS filename into a long file specification. **L ** This decodes names that have been translated into VMS specification usingF ** the same algorithm as Pathworks, back into the original characters. ** ** 28-Sep-1998	J. Malmberg: ** 03-Apr-1999	J. Malmberg	Converted for frontport libraryJ ** 27-Jun-2000	J. Malmberg	Dropping support for deep directories VMS < 7.2N *****************************************************************************/N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/      /* Standard C Library */  /*--------------------*/ #include <string.h>  #include <ctype.h>    /* Application specific */  /*----------------------*/ #include "frontport.h"   void fport__pwrk_fname_to_unix        (char * outfile,  	const char * infile,  	unsigned long option) { $ const char sys_disk[] = "SYS$DISK:"; char *tptr; 	 int indx; 	 int ondx;  int len; int dirflag; int dotcnt; 	 char sep;  int ods5_flag; int dunder_flag; unsigned long call_stat; char * devname; 
 int ret_stat;  int dev_check;  + const char ods2_delimiters[] = "[]<>_.;-%"; - const char ods5_delimiters[] = "[]<>.;-%& ^"; ( const char ods5_special[] = ".,;[]%^&U";1 const char hexchars[] = "0123456789ABCDEFabcdef";  char tempbuf[FPORT__C_MAXRSS]; char * delimiters;         /* Default the separator */     /*-----------------------*/      dunder_flag = 0;     ods5_flag = 0;     sep = '\\'; >     if ((option & FPORT__M_FNAME_UNIX) == FPORT__M_FNAME_UNIX) 	sep = '/';   ?     dev_check = fport__vms_dev_translate(outfile, infile, sep);      if (dev_check == 0)      {   7 	 /* Need to know how long the file specification is */ 6 	/*-------------------------------------------------*/ 	len = strlen(infile);  
 	indx = 0;
 	ondx = 0;
 	dirflag = 0;  	dotcnt = 0;   	tptr = strchr(infile,':');  	if (tptr == NULL) 	{  	    devname = (char *)sys_disk; 	} 	else  	{ 	int slen1;   ) 	     /* Process the device terminator */ ( 	    /*-------------------------------*/% 	    slen1 = (int)tptr - (int)infile; % 	    strncpy(tempbuf, infile, slen1);    	    tptr++; 	    indx = slen1 + 1; 	    ondx = slen1; 	    tempbuf[ondx] = sep;  	    ondx++; 	    devname = (char *)infile; 	}  - 	call_stat = fport__check_disk_type(devname);     $ 	if (call_stat & FPORT__M_DISK_ODS5) 	{* 	    delimiters = (char *)ods5_delimiters; 	    ods5_flag = 1;  	} 	else  	{* 	    delimiters = (char *)ods2_delimiters; 	}  8 	if ((option & FPORT__M_FNAME_UNIX) && (ods5_flag == 0)) 	    dunder_flag = 1;      	 /* Main parsing loop */  	/*-------------------*/ 	while (indx < len)  	{
 	int slen;   	    slen = len - indx; / 	    tptr = strpbrk(&infile[indx], delimiters);    	    if (tptr != NULL) 	    {* 		slen = (long)tptr - (long)&infile[indx]; 	    }  2 	    strncpy(&tempbuf[ondx], &infile[indx], slen); 	    ondx = ondx + slen; 	    indx = indx + slen;  ' 	     /* Add the separator if needed */ & 	    /*-----------------------------*/ 	    if (tptr != NULL) 	    {  ) 		if ((ods5_flag == 1) && (*tptr == '^'))  		{  		char * char1;  		char * char2;   " 		     /* ODS5 Special handling */! 		    /*-----------------------*/  		    char1 = tptr + 1; + 		    char2 = strchr(ods5_special, *char1); * 		    if ((char2 != NULL) && (indx < len)) 		    { ( 			 /* Assume a valid escape sequence */' 			/*--------------------------------*/  			if (char2[0] != 'U')  			{ 			    indx++; 			    if (char2[0] == '_')  			    { 				tempbuf[ondx] = ' '; 			    } 			    else  			    { 				tempbuf[ondx] = char2[0];  			    } 			    ondx++; 			    indx++; 			} 			else  			{ 			    if ((indx + 4) < len) 			    { 			    char * char3; 			    int coffset;  			    char nibble;   # 				 /* Uh-oh, Unicode! - Try it */ " 				/*--------------------------*/ 				indx += 2; 				char2++;% 				char3 = strchr(hexchars, *char2);  				if (char3 != NULL) 				{  				    char2++;1 				    coffset = (long) char3 - (long) hexchars;  				    if (coffset > 15)  					coffset = coffset - 6; ' 				    nibble = (coffset << 4) & 0xF0;   ) 				    char3 = strchr(hexchars, *char2);  				    if (char3 != NULL)	 				    { - 					coffset = (long)char3 - (long) hexchars;  					if (coffset > 15) 					    coffset = coffset - 6; ' 					nibble = nibble | (coffset & 0xF);  					tempbuf[ondx] = nibble; 					ondx++;  + 					 /* Process second octet of UNICODE */ * 					/*---------------------------------*/
 					char2++; & 					char3 = strchr(hexchars, *char2); 					if (char3 != NULL)  					{- 					    coffset =(long)char3-(long)hexchars;  					    if (coffset > 15) 						coffset = coffset - 6;( 					    nibble = (coffset << 4) & 0xF0; 					    char2++; * 					    char3 = strchr(hexchars, *char2); 					    if (char3 != NULL) 
 					    { 						coffset = (long) char3 							- (long) hexchars;  						if (coffset > 15)   						    coffset = coffset - 6;& 						nibble =nibble |(coffset & 0xF); 						tptr = tptr + 6; 						indx = indx + 6; 					 	tempbuf[ondx] = nibble;
 						ondx++; 
 					    }
 					    else 
 					    {" 						 /* return a bad filespec */! 						/*-----------------------*/ 
 						tptr++; 
 						indx++; 
 						ondx--; 
 					    } 					}	 					else  					{ 					     /* Try to recover */ 					    /*----------------*/  					    tptr++; 					    indx++; 					    ondx--; 					}	 				    }  				    else	 				    { % 					 /* Keep from looping forever */ $ 					/*---------------------------*/ 					tptr++; 					indx++;	 				    }  				}  				else 				{ 4 				     /* bad filespec, don't get stuck in loop */3 				    /*---------------------------------------*/  				    tptr++;  				    indx++;  				}  			    } 			    else  			    {2 				 /* Bad file spec, do not get stuck in loop */1 				/*-----------------------------------------*/  				tptr++;  				indx++;  			    } 			} 		    } 
 		    else 		    {  		    int coffset; 		    int nibble;   $ 			char2 = strchr(hexchars, *char1); 			if (char2 != NULL)  			{ 			    char1++; 0 			    coffset = (long) char2 - (long) hexchars; 			    if (coffset > 15) 				coffset = coffset - 6;  & 			    nibble = (coffset << 4) & 0xF0;  ( 			    char2 = strchr(hexchars, *char1); 			    if (char2 != NULL)  			    {- 				coffset = (long) char2 - (long) hexchars;  				if (coffset > 15)  				    coffset = coffset - 6;& 				nibble = nibble | (coffset & 0xF); 				tptr = tptr + 3; 			 	indx = indx + 3;  			 	tempbuf[ondx] = nibble; 				ondx++;  			    } 			    else  			    { 				tptr++;  				indx++;  			    } 			}
 		    else 		    { 
 			tptr++;
 			indx++; 		    }  		}  	    }	 	    else  	    {' 		 /* Close the directory processing */ % 		/*-------------------------------*/ ' 		if ((*tptr == ']') || (*tptr == '>'))  		{  		    dirflag = 0;
 		    tptr++; 
 		    indx++; # 		    if (tempbuf[ondx - 1] != sep)  		    {  			tempbuf[ondx] = sep; 
 			ondx++; 		    }  	 	}   		 /* Convert [-] to /../ */ 		/*---------------------*/  		if (*tptr == '-')  		{ 
 		char tchar; 
 		int tstart;  		int tend;   5 		     /* If this is the start of a directory, fix */ 4 		    /*------------------------------------------*/ 		    tchar = tptr[-1]; A 		    tstart = ((tchar == '<')||(tchar == '[') || (tchar =='.'));  		    tchar = tptr[1];A 		    tend = ((tchar == '>') || (tchar == ']') || (tchar =='.')); + 		    if ((dirflag == 1) && tstart && tend)  		    {  			tempbuf[ondx] = '.'; 
 			ondx++; 			tempbuf[ondx] = '.';  		    } 
 		    else 		    { 2 			 /* This is otherwise legal, pass it through */1 			/*------------------------------------------*/  			tempbuf[ondx] = *tptr;  		    } 
 		    ondx++; 
 		    indx++; 
 		    tptr++;  		}   ( 		 /* Convert the wild card character */' 		/*---------------------------------*/  	   	if (*tptr == '%') 	 	{
 		    tptr++; 
 		    indx++;  		    tempbuf[ondx] = '?';
 		    ondx++;  		}   1 		 /* Delimit directory, extension, or version */ 0 		/*------------------------------------------*/ 		if (*tptr == '.')  		{ 
 		    tptr++; 
 		    indx++;  		    if (dirflag != 0)  		    {   			 /* separate the directory */ 			/*------------------------*/  			tempbuf[ondx] = sep; 
 			ondx++; 		    } 
 		    else 		    {  			 /* Treat as extension */ 			/*--------------------*/  			if (dotcnt == 0)  			{ 			    dotcnt++; 			    tempbuf[ondx] = '.';  			    ondx++;  ( 			     /* Strip off directory suffix */' 			    /*----------------------------*/ 4 			    if ((option & FPORT__M_FNAME_DIRECTORY) != 0) 			    {5 			        if ((len - indx >= 3) && (tptr[3] == '\0') . 				  || (tptr[3] == '.') || (tptr[3] == ';')) 				{  				char tdir[3]; # 				    tdir[0] = toupper(tptr[0]); # 				    tdir[1] = toupper(tptr[1]); # 				    tdir[2] = toupper(tptr[2]);    				    if ((tdir[0] == 'D')3 				      && (tdir[1] == 'I')  && (tdir[2] == 'R')) 	 				    {  					indx = len; 					ondx--; 					tempbuf[ondx] = '\0'; 					break; 	 				    }  				}  			    } 			} 		    }  		}   ! 		 /* Start directory handling */   		/*--------------------------*/' 		if ((*tptr == '[') || (*tptr == '<'))  		{  		    dirflag = 1;
 		    tptr++; 
 		    indx++; 3 		    if ((ondx > 0) && (tempbuf[ondx - 1] != sep))w 		    {L 		 	tempbuf[ondx] = sep; 		 	ondx++;  		    }  		    if (*tptr == '.')f 		    {f 		    char *tdirptr; 		    char *tdevptr; 		    char *tdevptr1;V$ 		    char tdirbuf[FPORT__C_MAXRSS];  . 			 /* Need to insert the default directory */- 			/*--------------------------------------*/p7 			tdirptr = fport__getcwd(tdirbuf, FPORT__C_MAXRSS-1);- 			if (tdirptr != NULL)p 			{ 			int dlen;  - 			     /* The first segment is the device */*, 			    /*---------------------------------*/& 			    tdevptr = strchr(tdirbuf, sep); 			    if (tdevptr != NULL)= 			    {- 				 /* The second segment starts the path */,, 				/*------------------------------------*/$ 				tdevptr1 = strchr(tdevptr, sep); 				if (tdevptr1 != NULL)n 				    tdevptr = tdevptr1;r 			    } 			    if (tdevptr != NULL)  			    { 				tptr++;d 				tdevptr++; 				dlen = strlen(tdevptr) - 1;(+ 				strncpy(&tempbuf[ondx], tdevptr, dlen);T 				ondx = ondx + dlen;d 				tempbuf[ondx] = 0; 			    } 			} 		    }T 	 	}  8 		 /* Handle escape sequences (Assume ASCII code set) */7 		/*-------------------------------------------------*/e% 		if ((*tptr == '_') && (indx < len))o 		{t 		    if (tptr[1] == '_')  		    {i 		    char *char1; 		    char *char2; 		    int nibble;t 		    int coffset;   			char1 = tptr + 2;  2 			 /* Check to see if this a really a HEX code */1 			/*------------------------------------------*/=$ 			char2 = strchr(hexchars, *char1); 			if (char2 != NULL)n 			{ 			    char1++;-0 			    coffset = (long) char2 - (long) hexchars; 			    if (coffset > 15) 			    coffset = coffset - 6;-  & 			    nibble = (coffset << 4) & 0xF0;  ( 			    char2 = strchr(hexchars, *char1); 			    if (char2 != NULL)  			    {- 				coffset = (long) char2 - (long) hexchars;[ 				if (coffset > 15)* 				    coffset = coffset - 6;& 				nibble = nibble | (coffset & 0xF); 				tptr = tptr + 4; 				indx = indx + 4; 				tempbuf[ondx] = nibble;r 				ondx++;  			    } 			} 			if (char2 == NULL)  			{+ 			     /* Not really an escape sequence */o* 			    /*-------------------------------*/ 			    tptr = tptr + 2;] 			    indx = indx + 2;r 			    tempbuf[ondx] = '_';" 			    ondx++; 			    tempbuf[ondx] = '_';l 			    ondx++; 			}   		    }e
 		    else 		    {-5 			 /* Check to see if this is a double underscore */f4 			/*---------------------------------------------*/+ 			if ((tptr[1] == '5') && (dunder_flag) &&'6 		 	    ((tptr[2] & 0xdf) == 'F') && (tptr[3] == '_')) 			{ 			    tptr = tptr + 4;h 			    indx = indx + 4;* 			    tempbuf[ondx] = '_';l 			    ondx++; 			    tempbuf[ondx] = '_';- 			    ondx++; 			} 			else/ 			{ 			     /* Unchanged */d 			    /*-----------*/ 			    tempbuf[ondx] = *tptr;t 			    ondx++; 			    tptr++; 			    indx++; 			} 		    }= 		}r    		 /* Version number support? */ 		/*-------------------------*/v9 		if ((*tptr == ';') || ((*tptr == '.') && (dotcnt > 0)))/ 		{ * 		    if (option & FPORT__M_FNAME_VERSION) 		    {b2 			 /* Append the version following a semicolon */1 			/*------------------------------------------*/s 			tempbuf[ondx] = *tptr;v
 			ondx++;
 			indx++;
 			tptr++; 		    }o
 		    else 		    {e1 			 /* Skip the rest of the file specification */ 0 			/*-----------------------------------------*/ 			indx = len + 1; 		    } ' 		} /* End of version number support */m  ( 	    } /* End of ODS5 / ODS2 handling */   	} /* End delimiter handling */n       } /* End of parsing loop */n  /      /* Make sure that it is NULL terminated */<.     /*--------------------------------------*/     tempbuf[ondx] = '\0';f       strcpy(outfile, tempbuf);i     }  }NL) 	    {* 		slen = (long)tptr - (long)&infile[indx]; 	    }  2 	    strncpy(&tempbuf[ondx], &infile[indx], slen); 	    ondx = ondx + slen; 	    indx = indx + slen;  ' 	     /* Add the separator if needed */ & 	    /*-----------------------------*/ 	    if (tptr != NULL) 	    {  ) 		if ((ods5_flag == 1) && (*tptr == '^'))  		{  		char * char1;  		char * char2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                