 /* File: FPORT__READ.C **E ** This is a wrapper for the read() function, so that it would handle ( ** reading a stream file in record mode. ** ** 06-Mar-2000	J. Malmberg **M ****************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h" #include "frontport_private.h"   #include <rms.h> #include <devdef.h>    #include <unixio.h>  #include <string.h>  #include <stdlib.h>   ? ssize_t fport__read(int filedesc, void * buffer, size_t nbytes)  {  unsigned long stat_options;  ssize_t ret_stat;  int eof;  ;      /* Get the stat options, is fcntl() locking active? */ :     /*--------------------------------------------------*/     ret_stat = 0;      eof = 0;-     stat_options = fport__get_stat_options(); 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      {      unsigned long call_stat;+     struct fport___rms_filenos_st rms_info;      struct FAB *fab1;      struct RAB *rab1;      int flush_stat;      char * cbuffer;     - 	 /* Get the RMS attributes for the stream */ , 	/*---------------------------------------*/7 	call_stat = fport___get_rms_info(filedesc, &rms_info); $ 	fab1 = (struct FAB *)rms_info.fab1;$ 	rab1 = (struct RAB *)rms_info.rab1; 	flush_stat = 0;  5 	if ((fab1 != NULL) && (fab1->fab$l_dev & DEV$M_RND))  	{ 	int toread; 	int r_cnt;    	    cbuffer = buffer; 	    toread = nbytes;   . 	    if (rms_info.wrtindx > rms_info.readindx)' 		rms_info.readindx = rms_info.wrtindx;      	    while (toread > 0)  	    {7 		 /* Copy any data in read buffer to program buffer */ 6 		/*------------------------------------------------*/ 		if ((rms_info.bufend > 0) &&+ 		   (rms_info.bufend > rms_info.readindx))  		{  		int tlen;  		char * tptr;  1 		    tlen = rms_info.bufend - rms_info.readindx;  		    if (tlen > toread) 			tlen = toread;   : 		    tptr = (char *) rms_info.bufptr + rms_info.readindx;- 		    memcpy(&cbuffer[ret_stat], tptr, tlen);  		    ret_stat += tlen;  		    rms_info.readindx +=tlen;  		    toread -= tlen;  		}  		else 		{ % 		    /* We have hit the EOF, quit */ $ 		   /*---------------------------*/ 		   if (eof == 1) 		   {	 			break;  		   } 		}   # 		 /* Need to read in more data? */ " 		/*----------------------------*/+ 		if (rms_info.readindx >= rms_info.bufend)  		{  		int read_stat;  - 		     /* Do we need to allocate a buffer? */ , 		    /*----------------------------------*/* 		    if ((char *)rms_info.bufptr == NULL) 		    {   $ 			if (fab1->fab$b_rfm == FAB$C_FIX) 			{ 			int rec_size; 			int no_bufs;   / 			     /* Special case, use a bigger buffer */ . 			    /*-----------------------------------*/" 			    rec_size = fab1->fab$w_mrs; 			    if ((rec_size & 1) == 1)  				rec_size++;    			    if (rec_size != 0)  			    {* 				no_bufs = FPORT___C_MAXREC / rec_size;* 				rms_info.bufsize = rec_size * no_bufs; 			    } 			    else  			    { 				 /* Should not occur! */ 				/*-------------------*/ ( 				rms_info.bufsize = FPORT___C_MAXREC; 			    } 			} 			else  			{* 			    rms_info.bufsize = fab1->fab$w_mrs; 			} 			if (rms_info.bufsize == 0) + 			    rms_info.bufsize = FPORT___C_MAXREC;   * 			rms_info.bufptr = (unsigned long)malloc 						(rms_info.bufsize);  		    }   % 		     /* Flush any pending writes */ $ 		    /*--------------------------*/ 		    if (rms_info.wrtindx > 0)  		    { , 			fport___flush_write(filedesc, &rms_info); 			rms_info.wrtindx = 0; 			rms_info.readindx = 0;  		    }    		    rms_info.readindx = 0; 		    read_stat = read9 			(filedesc, (char *)rms_info.bufptr, rms_info.bufsize);    		    if (read_stat > 0) 		    {  			rms_info.readindx = 0;  			rms_info.bufend = read_stat;  		    } 
 		    else 		    {  			eof = 1;  			rms_info.bufend = 0;  			rms_info.readindx = 0;  		    }  		}  		else 		{  		    break; 		}  	    }  & 	    if ((ret_stat == 0) & (eof == 1)) 		ret_stat = -1; 	} 	else  	{! 	     /* No special processing */   	    /*-----------------------*// 	    ret_stat = read(filedesc, buffer, nbytes);  	}   	if (ret_stat >= 0) ! 	    rms_info.offset += ret_stat; 7 	call_stat = fport___put_rms_info(filedesc, &rms_info);        }      else     {  	 /* No special processing */  	/*-----------------------*/+ 	ret_stat = read(filedesc, buffer, nbytes);      }        return ret_stat; } 