< /* File: FPORT__UNIX_DEV_TRANSLATE.C was VMS_DEV_TRANSLATE.C **L ** The routine translates /DEV/widget type names to be FPORT__VMS_DEV_widget@ ** style logical names.  FPORT__VMS_DEV may be overridden by the+ ** fport__set_unix_device_prefix() routine.  **L ** Too keep things simple, any non-alphanumeric characters are replaced with ** underscores.  **8 ** This allows a site to handle UNIX raw devices better. **# ** 09-Dec-1998	J. Malmberg	Original B ** 01-Jul-2000	J. Malmberg	Start of unix "/" emulation for chroot.M ****************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/    /* Standard UNIX Includes */  /*------------------------*/ #include <string.h>  #include <ctype.h>    /* Application specific */  /*----------------------*/ #include "frontport.h"  : static char fport___device_prefix[41] = "FPORT__VMS_DEV_";* static int fport___device_prefix_len = 15;  5  /* Allow the program to specify the device prefix */ 4 /*------------------------------------------------*/: void fport__set_unix_device_prefix(const char * devprefix) {  char * nstr;  9     nstr = strncpy(fport___device_prefix, devprefix, 40); "     fport___device_prefix[40] = 0;>     fport___device_prefix_len = strlen(fport___device_prefix); }     B int fport__unix_dev_translate(char * outfile, const char * infile) { & const char sys_login[] = "SYS$LOGIN:"; char * tptr; int i; int ret; int len;       ret = 0;
     i = 0;2     if ((infile[i] == '\\') || (infile[i] == '/'))     {  	i++;    	if (infile[i] != 0) 	{
 	int toff;   	    len = strlen(&infile[i]); 	    if (len > 3)  	    {# 		tptr = strpbrk(&infile[i],"\\/"); % 		toff = (int)tptr - (int)&infile[i];  	    }	 	    else  	    {
 		toff = len;  	    } 	    if (toff >= 3)  	    {! 		if ((toupper(infile[i]) == 'D') & 		    && (toupper(infile[i+1]) == 'E')' 		    && (toupper(infile[i+2]) == 'V'))  		{  		int ondx;   - 		    strcpy(outfile, fport___device_prefix);  		    ondx = strlen(outfile);  		    i = i + toff + 1;  		    ret = 1;   		    if (infile[i] == 0)  		    { 
 			ondx--; 			outfile[ondx] = 0;  		    } . 		    while ((ondx < 253) && (infile[i] != 0)) 		    {  			if (isalnum(infile[i]))! 			    outfile[ondx] = infile[i];  			else  			    outfile[ondx] = '_';    			i++; 
 			ondx++; 		    }  		    outfile[ondx] = ':';
 		    ondx++;  		    outfile[ondx] = '\0';  		}  	    } 	} 	else  	{
 	char * tstr;   5 	     /* This is the root directory, treat special */ 4 	    /*-------------------------------------------*/  , 	    strcpy(outfile, fport___device_prefix); 	    strcat(outfile, "ROOT"); 
 	    ret = 1;   = 	     /* Fall back in case the logical name does not exist */ < 	    /*---------------------------------------------------*/* 	    tstr = fport__getenv_trnlnm(outfile); 	    if (tstr == NULL) 	    { 		strcpy(outfile, sys_login);  	    } 	}     }      return ret;  }   L int fport__vms_dev_translate (char * outfile, const char * infile, char sep) {  int ret; int val; int x;       ret = 0;  &     x = fport___device_prefix_len - 1;4     val = strncmp(fport___device_prefix, infile, x);     if (val == 0)      {      int len;   	len = strlen(&infile[x]);  ! 	 /* Check for ROOT as special */   	/*---------------------------*/ 	if (len == 5) 	{
 	int val2;, 	    val2 = strncmp(&infile[x], "_ROOT", 5); 	    if (val2 == 0)  	    { 		outfile[0] = sep;  		outfile[1] = 0; 
 		ret = 1; 	    } 	} 	if (ret == 0) 	{ 	int i; 
 	int ondx;  
 	    ret = 1;  	    outfile[0] = sep; 	    outfile[1] = 'd'; 	    outfile[2] = 'e'; 	    outfile[3] = 'v';   	    ondx = 4; 	    for (i = 0; i < 253; i++) 	    {- 		if ((infile[x] == 0) || (infile[x] == ':'))  		    break;   		if (infile[x] == '_')  		    outfile[ondx] = sep; 		else  		    outfile[ondx] = infile[x]; 		x++;	 		ondx++;  	    } 	    outfile[ondx] = 0;  	}     }        return ret;  } 