9 /* File: FPORT__UNIX_FNAME_TO_PWRK.C was LONGFILE_2_VMS.C  **H ** This routine attempts to convert a long file specification into a VMS ** file specification. **K ** Normally names will be translated using what should be same algorithm as > ** Pathworks for characters that are not legal VMS file names. **F ** If an apparently legal VMS file specification is passed, it will beL ** returned unchanged.  This means a file specification with any of ":[]<>". **L ** Full translations are not possible as VMS file specifications are limited9 ** to 39 characters followed by a 39 character extension.  **L ** No check is done to make sure that the length of a component fits in sideM ** of VMS restrictions: 64 for Device, 39 characters for any other component. K ** I do not have access to the ODS5 spec at this time, but it may handle an  ** otherwise illegal name. **J ** The file specification must fit in a 256 character limitation when thisI ** routine is done with it.  A larger buffer is allocated in anticipation ( ** of the modifications needed for ODS5. **G ** A partial file specification passed will get a partial one returned.  **5 ** Some enhancements are also implemented by options.  **M **  1.	If (option & FPORT__M_FNAME_EXTLASTDOT) Then best try for extension on  **	last dot.I **	Normally the first dot found is used to delimit the file by Pathworks. G **	It makes more sense to use the last dot found as it is considered to F **	delimit the extension.  This is the way that Windows products work. **K **  2.	If (option & FPORT__M_FNAME_DEEPDIR) Allow deeper directory nesting. ? **	Normally VMS file parsing limits directories to be 8 levels. F **	Directories can be extended to be 15 levels from a physical device.C **	Since a concealed rooted directory is usually only one directory A **	from a physical device name, this will usually give 16 levels.  **	(feature removed) **K **  The function returns a 1 for a file found, and 2 for a directory found.  **M ** In most cases this routine will be passed only the file name and extension D ** to be converted.  It is intended to handle this case the fastest. **# ** 13-Jul-1998	J. Malmberg	Original  **B ** 21-Dec-1998	J. Malmberg	Bug in some versions of the C RTL, some2 **				of the routines can not handle <> delimiting **				the directory. **- ** 06-Nov-1999	J. Malmberg	Better prototyping  **A ** 12-Nov-1999	J. Malmberg	Bug found but not fixed.  If the first + **				character passed is a ~ (tilde), then . **				SYS$LOGIN: must be prepended to the file **				specification. **H ** 02-Dec-1999	J. Malmberg	Found bug where non-existant directory at the- **				begining of the path was being returned  **				as a null specification. **1 **			*	Fixed the above bug so ~ is now treated as  **				SYS$LOGIN: **1 **			*	Started to add ODS5 support.  I have to do 3 **				quite a bit of parsing to even determine that ' **				I am dealing with an ODS5 device. 2 **				Then the parsing must be started over almost, **				completely.  This is best handled by a. **				dedicated routine.  For now, just a flag **				will be set. **F ** 16-Jan-2000	J. Malmberg	Failing boundary conditions, rewrote a bit. **E ** 26-Jan-2000	J. Malmberg	Now fixing the ~ handling has come back to 2 **				haunt.  A Windows system uses a leading ~ to2 **				indicate a temporary file.  So this handling1 **				is wrong in that case.  Making it a default 5 **				may break Unix programs.  However this behavior . **				is not well documented.  The only way to/ **				handle this correctly is to add an option 3 **				FPORT__M_FNAME_TILDE that when set will cause . **				the leading ~ character to be processed. **H ** 17-Feb-2000	J. Malmberg	Found documentation that ~/ is SYS$LOGIN, not/ **				just a leading ~.  Good that makes things 4 **				easier.  Also need to force the dot processing- **				for when it is known to be a directory.  **; ** 11-Jun-2000	J. Malmberg	Started adding more EFS support. J ** 27-Jun-2000	J. Malmberg	Dropping support for deep directories VMS < 7.2* **				To do it right is too CPU intensive.1 **				Also simplifying algorithm for interpreting  **				file specifications. **+ **				A segment is a portion of a unix file ) **				specification delimited by slashes.  **1 **				If the first segment is preceded by a slash 2 **				it will be checked to see if it is a logical **				name.  **D ** 09-Jul-2000	J. Malmberg	Found feature in DECC$TO_VMS.  Under some- **				conditions involving a concealed rooted - **				logical that does not have the terminal - **				attribute, and a directory with out the % **				terminating slash, it generates , **				garbage for the directory terminators.M ****************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  %  /* VMS System Service definitions */ $ /*--------------------------------*/ #include <ssdef.h>      /* Standard Unix Includes */  /*------------------------*/ #include <string.h>  #include <stdio.h> #include <unixlib.h> #include <ctype.h>    /* Application specific */  /*----------------------*/ #include "frontport.h"   static char *fport___tmp_name;  6 static int fport___parse_routine(char *name, int type) { #     strcpy(fport___tmp_name, name);   F      /* Translation continues as long as success status is returned */E     /*-------------------------------------------------------------*/      return (0);  }      int fport__unix_fname_to_pwrk         (char * outfile,  	const char * infile,  	unsigned long option) {  char * tptr; static char * const goodchars = H   "0123456789-_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$*%";+ static char * const sys_disk = "SYS$DISK:"; - static char * const sys_login = "SYS$LOGIN:";  char tempfile[FPORT__C_MAXRSS];  char temp_dev[FPORT__C_MAXRSS];  int d1;  int ods5_flag; int tilde_flag;  int start_slash;
 int ret_stat;  unsigned long disk_flags;  unsigned long vms_flags;	 int ondx;  int rooted; 	 char lch;   
     ondx = 0;      vms_flags = 0;     ods5_flag = 0;     ret_stat = -1;     disk_flags = 0;      start_slash = 0;     outfile[0] = 0;      rooted = 0;      lch = 0;  ,      /* Handle the special case of /DEV/? */+     /*-----------------------------------*/ 4     d1 = fport__unix_dev_translate(outfile, infile);     if (d1 == 1)     {  	ret_stat = 1; 	return ret_stat;      }         /* Simple case of . */      /*------------------*//     if ((infile[0] == '.') && (infile[1] == 0))      {  	getcwd(outfile, 254, 1);  	ret_stat = 2; 	return ret_stat;      }   E      /* Look for a colon, or brackets in the source specification. */ D     /*------------------------------------------------------------*/"     tptr = strpbrk(infile, ":[<");<     if ((tptr != NULL) && (tptr == "[") && (tptr != infile))     {  	 /* ODS-5 support hack */ 	/*--------------------*/  	if (tptr[-1] == '^')  	{! 	    tptr = strpbrk(infile,":<");  	}     } .     if ((tptr != NULL) || (infile[0] == '\0'))     { ' 	 /* Assume to already be VMS format */ & 	/*---------------------------------*/ 	if (outfile != infile)  	    strcpy(outfile, infile);      }      else     { ' 	 /* Must fix things up the hard way */ & 	/*---------------------------------*/     int len;
     int indx;      int tindx;     char * ldptr;      char * lslash;     char * lslash1;      int dev_flag; 
     int olen;      int seglen;      int segsize;     int temp_dev_len;      char * logdev;     int logdev_len;    	 /* Initialize variables */ 	/*----------------------*/  	dev_flag = 0;
 	indx = 0;
 	olen = 0; 	tilde_flag = 0; 	logdev_len = 0; 	logdev = NULL;     . 	 /* Leave some space for testing directory */- 	/*----------------------------------------*/ ' 	memset(temp_dev, 0 , sizeof temp_dev); ' 	memset(tempfile, 0 , sizeof tempfile);  	tindx = 0;   ( 	vms_flags = fport__vms_support_flags();    - 	 /* Need to know the length of the string */ , 	/*---------------------------------------*/ 	len = strlen(infile);  1 	 /* find the last . in the file specification */ 0 	/*-------------------------------------------*/ 	ldptr = strrchr(infile, '.');  5 	 /* find the last slash in the file specification */ 4 	/*-----------------------------------------------*/  	lslash = strrchr(infile, '\\');  	lslash1 = strrchr(infile, '/'); 	if (lslash < lslash1) 	    lslash = lslash1;   	 /* Handle a leading '~' */ 	/*----------------------*/ * 	if ((option & FPORT__M_FNAME_TILDE) == 0) 	{  4 	     /* Unix specifications mean ~ == SYS$LOGIN: */3 	    /*------------------------------------------*/ H 	    if ((infile[0] == '~') && ((infile[1] == '/')||(infile[1] =='\\'))) 	    { 		strcpy(temp_dev, sys_login);# 		temp_dev_len = strlen(sys_login);  		dev_flag = 1; 	 		indx++; 	 		indx++;  		tilde_flag = 1;  		start_slash = 1; 	    } 	}   	 /* Handle a leading '.' */ 	/*----------------------*/  	if (infile[0] == '.') 	{ 	    start_slash = 1; 1 	    if ((infile[1] == '.') || (infile[1] == '/') 5 	      || (infile[1] == '\\') || (infile[1] == '\0'))  	    { 		strcpy(temp_dev, sys_disk); " 		temp_dev_len = strlen(sys_disk); 		dev_flag = 1;  	    } 	}   	 /* Handle a leading '-' */ 	/*----------------------*/  	if (infile[0] == '-') 	{  	    strcpy(temp_dev, sys_disk);% 	    temp_dev_len = strlen(sys_disk);T 	    dev_flag = 1; 	    start_slash = 1;  	}    / 	 /* Now build up the new file specification */N. 	/*-----------------------------------------*/ 	do  	{
 	char * dptr; 
 	int blen; 	char * ulptr; 	char *wildptr;l 	int wild_len;  % 	     /* Skip over a leading slash */s$ 	    /*---------------------------*/9 	    if ((infile[indx] == '\\') || (infile[indx] == '/'))a 	    { 		if (indx == 0) 		    start_slash = 1;	 		indx++;V 	    } 	    if (indx > len) 		break;  1 	     /* Also thow away any occurances of "./" */ 0 	    /*---------------------------------------*/  	    while (infile[indx] == '.') 	    { 	    char dchar;   		dchar = infile[indx+1];r( 		if ((dchar == '\\') || (dchar == '/')) 		{  		    indx = indx + 2; 		}, 		else 		    break; 	    }  0 	     /* Scan string for directory delimiters *// 	    /*--------------------------------------*/ * 	    tptr = strpbrk(&infile[indx], "\\/");    / 	     /* Calculate the length of the segment */n. 	    /*-------------------------------------*/ 	    if (tptr != NULL)" 		seglen = (tptr - &infile[indx]);	 	    elsen 		seglen = len - indx;   	    segsize = seglen;   	    if (dev_flag == 0)E 	    {  ; 		 /* If this is the first segment, check for wild chars */h: 		/*----------------------------------------------------*/( 		wildptr = strpbrk(&infile[indx],"*?"); 		if (wildptr != NULL) 		{t3 		    wild_len = (int)wildptr - (int)&infile[indx];i  ) 		     /* If a wildcard, not a device! */ ( 		    /*------------------------------*/ 		    if (wild_len <= seglen)  		    {i 			strcpy(temp_dev, sys_disk);# 			temp_dev_len = strlen(sys_disk);d 			dev_flag = 1; 			start_slash = 1;. 		    }e 	 	} 	    }     	     /* Look for .. */l 	    /*-------------*// 	    if ((seglen == 2) && (infile[indx] == '.')1 		&& (infile[indx + 1] == '.'))  	    {. 		strncpy(&tempfile[tindx], &infile[indx], 2); 		tindx = tindx + 2; 		indx = indx + 2; 	    }	 	    elsei 	    {6 		 /* Scan string for dots and exception characters */5 		/*-----------------------------------------------*/*$ 		dptr = strchr(&infile[indx], '.');* 		blen = strspn(&infile[indx], goodchars); 		if (blen > seglen) 		{e 		    blen = seglen; 		    if (dev_flag == 0) 		    {	+ 			strncpy(&tempfile[0], &infile[indx], 2);e 		    }  		}t  = 		 /* Must figure out if this is to use ODS5 parsing rules */I< 		/*------------------------------------------------------*/. 		if ((tempfile[0] == 0) && (outfile[0] == 0)) 		{p 		    if (temp_dev[0] == 0)9, 			strncpy(temp_dev, &infile[indx], seglen);  . 		    logdev = fport__getenv_trnlnm(temp_dev); 		    if (logdev != NULL)l 		    {c  2 			 /* HACK to work arround DECC$TO_VMS feature */1 			/*------------------------------------------*/d 			logdev_len = strlen(logdev);*! 		 	lch = logdev[logdev_len - 1];d$ 			if ((lch == ']') || (lch == '>')) 			{) 			    if (logdev[logdev_len - 2] == '.')e 			    {/ 				 /* The next segment must be a directory */e. 				/*--------------------------------------*/ 				rooted = 1;l 			    } 			} 		    }02 		    if ((disk_flags & FPORT__M_DISK_NODEV) == 0) 		    {*. 			if ((start_slash != 0) || (logdev != NULL)) 			{ 			    if (logdev != NULL) 			    {0 				disk_flags = fport__check_disk_type(logdev); 			    } 			} 		    } 
 		    else 		    {o1 			disk_flags = fport__check_disk_type(sys_disk);r 		    }p  1 		    if ((disk_flags & FPORT__M_DISK_ODS5) != 0)o 			ods5_flag = 1;    		}    		if (ods5_flag == 1)l 		{t2 		    option = option & FPORT__M_FNAME_EXTLASTDOT;0 		    option = option & ~ FPORT__M_FNAME_DUNDER; 		}     ' 		 /* Fix any leading '-' characters */u& 		/*--------------------------------*/ 		if (infile[indx] == '-') 		{  		    seglen--;  		    if (ods5_flag == 0)t 		    {h$ 			strcpy(&tempfile[tindx], "__2D"); 			tindx = tindx + 4;y 		    }*
 		    else 		    {e# 			strcpy(&tempfile[tindx], "^2D");  			tindx = tindx + 3;e 		    	indx++; 		    }e 		}r  ) 		 /* Need to mangle double underlines */o( 		/*----------------------------------*/ 		if (dev_flag != 0) 		{  		int xlen;e  ) 		    ulptr = strchr(&infile[indx], '_');n= 		    if ((ulptr != NULL) & (option & FPORT__M_FNAME_DUNDER))* 		    {f* 			xlen = (int)ulptr - (int)&infile[indx];2 			if ((xlen < (seglen - 2)) && (ulptr[1] == '_')) 			{( 			    if (ulptr < &infile[blen + indx]) 				blen = xlen; 			} 		    }  		}   / 		 /* See if bad characters need to be fixed */	. 		/*----------------------------------------*/' 		if (( blen < seglen) && (seglen > 0))  		{	7 		     /* Need to fix the buffer up for this segment */ 6 		    /*--------------------------------------------*/ 		    while (seglen > 0) 		    {* 		    int escflag; 		    char ch;   			if (blen > 0) 			{6 			    strncpy(&tempfile[tindx], &infile[indx], blen); 			    seglen = seglen - blen; 			    indx = indx + blen; 			    tindx = tindx + blen; 			}   			if (seglen <= 0) 
 			    break;e  # 			 /* Process the bad character */s" 			/*---------------------------*/ 			ch = infile[indx] & 0xFF;     			switch (ch) 			{   			case '.':, 			     /* last segment, one dot is legal */+ 			    /*--------------------------------*/u 			    escflag = 0;A# 			    if ((segsize + indx) >= len)  			    {0 				if ((option & FPORT__M_FNAME_DIRECTORY)== 0) 				{O/ 				    if (option & FPORT__M_FNAME_EXTLASTDOT) 	 				    {s   					 /* Last dot is legal */i 					/*-------------------*/  					if (&infile[indx] == ldptr) 					{ 					    tempfile[tindx] = ch; 					    tindx++;t 					    escflag = 1;, 					}	 				    }9 				    else	 				    {= 					 /* First dot is legal */ 					/*--------------------*//  					if ( &infile[indx] == dptr) 					{ 					    tempfile[tindx] = ch; 					    tindx++;s 					    escflag = 1;d 					}	 				    }  				}- 			    }  % 			     /* End of special dot test */e$ 			    /*-------------------------*/ 			    if (escflag == 0) 			    { 				if (ods5_flag == 0)- 				{- 				int nybble;r 				char thex;   				    tempfile[tindx] = '_'; 				    tindx++; 				    tempfile[tindx] = '_'; 				    tindx++;! 				    nybble = (ch >> 4) & 0xF;/ 				    thex = nybble + '0'; 				    if (thex > '9')t 					thex = nybble - 10 + 'A'; 				    tempfile[tindx] = thex;- 				    tindx++; 				    nybble = ch & 0xF; 				    thex = nybble + '0'; 				    if (thex > '9')c 					thex = nybble - 10 + 'A'; 				    tempfile[tindx] = thex;t 				    tindx++; 				}r 				else 				{8 				    tempfile[tindx] = '^'; 				    tindx++; 				    tempfile[tindx] = ch;  				    tindx++; 				}  			    }
 			    break;o   			case '_':& 			     /* Handle a true underscore */% 			    /*--------------------------*/11 			    if ((option & FPORT__M_FNAME_DUNDER) != 0)s 			    { 				tempfile[tindx] = '_'; 				tindx++; 				tempfile[tindx] = '5'; 				tindx++; 				tempfile[tindx] = 'F'; 				tindx++; 				tempfile[tindx] = '_'; 				tindx++; 			    } 			    elsea 			    { 				tempfile[tindx] = ch;u 				tindx++; 				tempfile[tindx] = ch;  				tindx++; 			    } 			    indx++; 			    seglen--;
 			    break;-   			case '?':* 			     /* Handle a PC / Un*x wild card */) 			    /*------------------------------*/  			    if (ods5_flag == 0) 				tempfile[tindx] = '%'; 			    elsef 				tempfile[tindx] = ch;- 			    tindx++;i
 			    break;)   			default:=( 			     /* Special character encoding */' 			    /*----------------------------*/  			    if (ods5_flag == 0) 			    { 			    int nybble; 			    char thex;    				tempfile[tindx] = '_'; 				tindx++; 				tempfile[tindx] = '_'; 				tindx++; 				nybble = (ch >> 4) & 0xF;t 				thex = nybble + '0'; 				if (thex > '9'))! 				    thex = nybble - 10 + 'A';/ 				tempfile[tindx] = thex;  				tindx++; 				nybble = ch & 0xF; 				thex = nybble + '0'; 				if (thex > '9')t! 				    thex = nybble - 10 + 'A';) 				tempfile[tindx] = thex;a 				tindx++; 			    } 			    else- 			    { 			    int printable;i   				printable = isprint(ch); 				if (printable) 				{  				    switch (ch)s	 				    {s 				    case ' ':  				    case ',':- 				    case ';':/ 				    case '[':  				    case ']':  				    case '^':l 				    case '&':l 					tempfile[tindx] = '^'; 
 					tindx++;g 				    default: 					tempfile[tindx] = ch;
 					tindx++;n 					break;n
 				     } 				}e 				else 				{v 				int nybble;i 				char thex;  ' 				     /* how to do UNICODE right? */a& 				    /*--------------------------*/ 				    tempfile[tindx] = '^'; 				    tindx++;! 				    nybble = (ch >> 4) & 0xF;i 				    thex = nybble + '0'; 				    if (thex > '9')* 					thex = nybble - 10 + 'A'; 				    tempfile[tindx] = thex;  				    nybble = ch & 0xF; 				    thex = nybble + '0'; 				    if (thex > '9')  					thex = nybble - 10 + 'A'; 				    tempfile[tindx] = thex;-  * 				} /* End of special ODS5 characters */  " 			    } /* End of default case */  ( 			} /* End of bad character switch() */  & 			 /* Done with this bad character */% 			/*------------------------------*/s 			seglen--;
 			indx++;   			if (seglen <= 0)- 			{ 			    tempfile[tindx] = 0;-
 			    break;t 			}  % 			 /* Look for next bad character */,$ 			/*-----------------------------*/+ 			blen = strspn(&infile[indx], goodchars); & 			ulptr = strchr(&infile[indx], '_'); 			if (blen > seglen)_ 			    blen = seglen;   $ 			 /* Look for double underlines */# 			/*----------------------------*/-: 			if ((ulptr != NULL) & (option & FPORT__M_FNAME_DUNDER)) 			{ 			int xlen; 			int segtst;  . 			    xlen = (int)ulptr - (int)&infile[indx];6 			    if ((xlen < (seglen - 2)) && (ulptr[1] == '_')) 			    {% 				if (ulptr < &infile[blen + indx])s 				    blen = xlen; 			    } 			}  ) 		     /* End if Fix up bad characters */i( 		    /*------------------------------*/ 		    }  		}  		else 		{=  2 		     /* No modifications needed, just copy it */1 		    /*---------------------------------------*/m 		    if (seglen > 0)e4 			strncpy(&tempfile[tindx], &infile[indx], seglen); 		    tindx = tindx + seglen;  		    indx = indx + segsize; 		}  	    }   	     /* close the directory */e 	    /*---------------------*/% 	    if ((indx < len) && (tindx > 0))a 	    { 		tempfile[tindx] = '/';
 		tindx++; 	    }  + 	     /* Increment rooted flag if needed */- 	    /*------------------*/-' 	    if ((rooted >= 1) & (segsize > 0)); 		rooted++;t   	} while (indx < len);   	tempfile[tindx] = '\0';   	if (rooted == 3)* 	{
 	int len1; 	char * tchar1;-
 	int len2;  8 	     /* decc$to_vms does not to this the way we need */7 	    /*----------------------------------------------*/  	    ret_stat = 2;    	     /* Find the first slash */ 	    /*----------------------*/*$ 	    tchar1 = strchr(tempfile, '/'); 	    if (tchar1 != NULL) 	    {% 		len1 = (int)tchar1 - (int)tempfile;;   		 /* Copy the first segment */f 		/*------------------------*/# 		strncpy(outfile, tempfile, len1);	   		 /* Add a :[ */a 		/*----------*/ 		outfile[len1] = ':';	 		len1++;m 		outfile[len1] = '[';	 		len1++;-    		 /* Copy the second segment */ 		/*-------------------------*/  		tchar1++;l! 		strcpy(&outfile[len1], tchar1);n   		len2 = strlen(outfile) - 1;- 		if (outfile[len2] != '/') 
 		    len2++;l   		 /* Add a ] to close it */ 		/*---------------------*/d 		outfile[len2] = ']';	 		len2++;  		outfile[len2] = '\0';  	    }	 	    else  	    { 		 /* should not ever happen */s 		/*------------------------*/ 		outfile[0] = '\0'; 	    } 	} 	elset 	{+ 	     /* If no errors, return the result */=* 	    /*---------------------------------*/ 	    if (tindx > 0)i 	    { 	    int dir_flag;
 	    int num;*   		dir_flag = 1;-( 		if (option & FPORT__M_FNAME_DIRECTORY) 		{ % 		    if (tempfile[tindx - 1] != '/')  		    {; 			tempfile[tindx] = '/';s 			tindx++;	 			tempfile[tindx] = '\0'; 		    }  		}   ! 		if (tempfile[tindx - 1] == '/')o 		    dir_flag = 2;-   		 /* Probe the file */n 		/*----------------*/$ 		fport___tmp_name = &outfile[ondx];C 	 	num = decc$to_vms(tempfile, fport___parse_routine, 0, dir_flag);  		if (num > 0) 		{= 		    ret_stat = 1;  		    if (dir_flag == 2) 			ret_stat = 2;  7 		     /* If disk && last char ':' then add [000000] */-6 		    /*--------------------------------------------*/2 		    if ((disk_flags & FPORT__M_DISK_NODEV) == 0) 		    {n 		    int olen;    			olen = strlen(outfile);  ( 			if ((logdev != NULL) && (lch != ':')) 			    olen = 0;0 			if ((olen > 1) && (outfile[olen - 1] == ':')) 			{# 			    strcat(outfile, "[000000]");  			    ret_stat = 2; 			} 		    }-   		}- 		else 		    outfile[0] = '\0'; 	    }	 	    else0 	    { 		outfile[0] = '\0'; 	    } 	}     }s     return ret_stat; }i