 /* File: FPORT__WRITE.C  **F ** This is a wrapper for the write() function, so that it would handle( ** writing a stream file in record mode. ** ** 06-Mar-2000	J. Malmberg **M ****************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/   #include "frontport.h" #include "frontport_private.h"   #include <rms.h> #include <devdef.h>    #include <unixio.h>  #include <string.h>  #include <stdlib.h>   F ssize_t fport__write(int filedesc, const void * buffer, size_t nbytes) { " const char * stm_delim = "\f\v\n"; unsigned long stat_options;  ssize_t ret_stat;  char * cbuffer;        ret_stat = 0;      cbuffer = (char *)buffer;   ;      /* Get the stat options, is fcntl() locking active? */ :     /*--------------------------------------------------*/-     stat_options = fport__get_stat_options(); 7     if ((stat_options & FPORT__M_STAT_FCNTL_LOCK) != 0)      {      unsigned long call_stat;+     struct fport___rms_filenos_st rms_info;      struct FAB *fab1;      struct RAB *rab1;   - 	 /* Get the RMS attributes for the stream */ , 	/*---------------------------------------*/7 	call_stat = fport___get_rms_info(filedesc, &rms_info); $ 	fab1 = (struct FAB *)rms_info.fab1;$ 	rab1 = (struct RAB *)rms_info.rab1;  5 	if ((fab1 != NULL) && (fab1->fab$l_dev & DEV$M_RND))  	{
 	int towrite; 
 	int wrtstrt; 
 	int bufstrt;  	int flush_stat;   	    towrite = nbytes; 	    flush_stat = 0; 	    wrtstrt = 0;    	    bufstrt = 0;   , 	     /* Do we need to allocate a buffer? */+ 	    /*----------------------------------*/ ) 	    if ((char *)rms_info.bufptr == NULL)  	    {# 		if (fab1->fab$b_rfm == FAB$C_FIX)  		{  		int rec_size;  		int num_bufs;   . 		     /* Special case, use a bigger buffer */- 		    /*-----------------------------------*/ ! 		    rec_size = fab1->fab$w_mrs;  		    if ((rec_size & 1) == 1) 			rec_size++;   		    if (rec_size != 0) 		    { * 			num_bufs = FPORT___C_MAXREC / rec_size;* 			rms_info.bufsize = rec_size * num_bufs; 		    } 
 		    else 		    {  			 /* Should not occur! */  			/*-------------------*/' 			rms_info.bufsize = FPORT___C_MAXREC;  		    }  		}  		else 		{ ) 		    rms_info.bufsize = fab1->fab$w_mrs;  		}  		if (rms_info.bufsize == 0)* 		    rms_info.bufsize = FPORT___C_MAXREC;  = 		rms_info.bufptr = (unsigned long) malloc(rms_info.bufsize);  	    }    * 	     /* Is it time to extend the file? */) 	    /*--------------------------------*/ , 	    if (rms_info.offset > rms_info.hiwater) 	    { 	    int log_end;  	    int file_delta; 	    int left; 	    int wrt_stat;  2 		 /* fport__lseek will have flushed the buffer */1 		/*-------------------------------------------*/ 7 		memset((char *)rms_info.bufptr, 0, FPORT___C_MAXREC);   2 		file_delta = rms_info.offset - rms_info.hiwater; 		left = file_delta;) 		log_end = lseek(filedesc, 0, SEEK_SET);   / 		 /* Extend the file over the skipped range */ . 		/*----------------------------------------*/ 		while (left > 0) 		{ ( 		    if (left > (FPORT___C_MAXREC - 1)) 			left = FPORT___C_MAXREC - 1;   / 		    wrt_stat = write(filedesc, buffer, left);  		    if (wrt_stat > 0)  		    { & 			file_delta = file_delta - wrt_stat; 			left = file_delta;   			rms_info.hiwater += wrt_stat; 		    } 
 		    else 		    { 	 			break;  		    }  		}    	    }  " 	     /* Now write out the data */! 	    /*------------------------*/  	    while (towrite > 0) 	    { 	    unsigned long buffree;  	    unsigned long rec_end_max;  	    int tindx;  	    int tsize;  	    long block_offset;  	    char * delimptr;  	    char * tptr; 
 	    int eor;   ( 		 /* How much room is in the buffer? */' 		/*---------------------------------*/ 
 		eor = 0;" 		block_offset = rms_info.wrtindx;+ 		if (rms_info.wrtindx < rms_info.readindx)  		{ ' 		    block_offset = rms_info.readindx;   # 		     /* Append on to last read */ " 		    /*------------------------*/+ 		    rms_info.wrtindx = rms_info.readindx;  		}   , 		buffree = rms_info.bufsize - block_offset; 		delimptr = NULL; 		tsize = towrite;   		 /* Default the maximum */ 		/*---------------------*/  		rec_end_max = tsize;  . 		 /* How many bytes to a record boundary?  */- 		/*---------------------------------------*/  		tptr = &cbuffer[wrtstrt];      		switch(fab1->fab$b_rfm)  		{  		case FAB$C_STM:   ' 		     /* Delimiters: FF,VT,LF,CR/LF */ & 		    /*----------------------------*/) 		    delimptr = strstr(tptr, stm_delim);  		    if (delimptr != NULL)  		    { 3 			rec_end_max = (long) delimptr - (long) tptr + 1;  			eor = 1;  		    }  		    break;  5 		 /* The C RTL makes everything look like a STMLF */ 4 		/*----------------------------------------------*/ 		case FAB$C_STMLF:  		case FAB$C_STMCR:  		case FAB$C_VAR:  		     /* Delimiters: LF */  		    /*----------------*/+ 		    delimptr = memchr(tptr, '\n', tsize);  		    if (delimptr != NULL)  		    {  			eor = 1; ! 			rec_end_max = (long)delimptr -  				(long)tptr + 1;  		    }  		    break;   		case FAB$C_FIX: 2 		     /* Simple fixed records, pass as default */1 		    /*---------------------------------------*/ 
 		default:8 		     /* Many types will get mangled, no help for it */7 		    /*---------------------------------------------*/  		    rec_end_max = buffree; 		    if (towrite < buffree) 			rec_end_max = towrite; 
 		    else 			eor = 1;  		}    		 /* Fill up the buffer */  		/*--------------------*/% 		if (rec_end_max > rms_info.bufsize) % 		    rec_end_max = rms_info.bufsize;   " 		tptr = (char *) rms_info.bufptr; 		memcpy 		   (&tptr[block_offset], 		    &cbuffer[wrtstrt], 		    rec_end_max);    		wrtstrt += rec_end_max;  		towrite -= rec_end_max;  		block_offset += rec_end_max;" 		rms_info.wrtindx = block_offset;# 		rms_info.readindx = block_offset;   + 		 /* fix up the prefix and write it out */ * 		/*------------------------------------*/ 		if (eor == 1)  		{ < 		    flush_stat = fport___flush_write(filedesc, &rms_info); 		    block_offset = 0;  		    rms_info.wrtindx = 0;  		    rms_info.readindx = 0; 		    rms_info.bufend = 0; 		}  		else 		{  		    break; 		}    	    }  . 	     /* We either wrote it, or buffered it */- 	    /*------------------------------------*/  	    if (flush_stat >= 0)  	 	ret_stat = nbytes; 	 	    else  		ret_stat = -1;   	} 	else  	{! 	     /* No special processing */   	    /*-----------------------*/0 	    ret_stat = write(filedesc, buffer, nbytes); 	}   	if (ret_stat >= 0)  	{! 	    rms_info.offset += ret_stat;   * 	     /* Remember the file was extended */) 	    /*--------------------------------*/ , 	    if (rms_info.offset > rms_info.hiwater)% 		rms_info.hiwater = rms_info.offset;  	}7 	call_stat = fport___put_rms_info(filedesc, &rms_info);      }      else     {  	 /* No special processing */  	/*-----------------------*/, 	ret_stat = write(filedesc, buffer, nbytes);       }      return ret_stat; } 