I /***********************************************************************/ F /*********************************************************************> * This software is Copyright (C) 1988 by Steven Dorner and theK * University of Illinois Board of Trustees, and by CSNET.  No warranties of B * any kind are expressed or implied.  No support will be provided.H * This software may not be redistributed without prior consent of CSNET.9 * You may direct questions to dorner@garcon.cso.uiuc.edu. G **********************************************************************/   H /***********************************************************************H * This is a client program for CSO's nameserver.  It attempts to contactC * the nameserver running on garcon.cso.uiuc.edu, and query it about I * entries.  The following entries in /etc/hosts (if you're using one) and " * /etc/services will help matters: * 
 * /etc/hosts: * * 128.174.5.58  garcon.cso.uiuc.edu garcon *  * /etc/services:0 * ns      105/tcp     ns        # CSO nameserverJ *************************************************************************/
 #ifdef VMS /* 		    P H   for   V A X / V M S     C   Ported to VAX/VMS Version 5.3 using VAXC 3.2 and TGV MultiNet 3.0 G   by Mark Sandrock, UIUC School of Chemical Sciences Computing Services ?   and R. Kevin Oberman, Lawrence Livermore National Laboratory.      VMS 4.4 implementation notes:   ?   1) VAXCRTL does not supply the following routines used by PH:   ?     a) fork		-- SYS$CREPRC or LIB$SPAWN should be used instead. D     b) execlp		-- VAXCRTL does provide execl, but it is too limited.;     c) popen/pclose	-- VAXCRTL does provide "pipe" instead. I     d) index/rindex	-- VAXCRTL "strchr/strrchr" functions are equivalent. ,     e) getpass		-- implemented in this file.9     f) unlink		-- VAXCRTL does provide "delete" function.   A   2) VAX/VMS does not provide the following utilities used by PH:   6     a) /usr/ucb/more	-- VMS PH does not do paging yet.8     b) /usr/ucb/vi	-- EDT or TPU should be used instead.  C   3) The VAXCRTL "getenv" function does not recognize the following E      environment names. SYS$TRNLNM could be used instead, if need be:   C     a) PAGER: specifies "pager" other than the default (TYPE/PAGE). =     b) EDITOR: specifies editor other than the default (EDT).   A   4) The SOCKET INTERFACE implemented by TGV MultiNet 3.0 returns F      a channel number rather than a standard file descriptor, and thusH      is not compatible with the UNIX-style i/o functions such as fdopen,H      read and write. Instead MultiNet provides special versions of read/;      write called socket_read/socket_write for network i/o.   H   5) The VMS VAXC include files are used wherever possible, with severalJ      exceptions as noted in the MultiNet Programmer's Guide. The followingI      include files do not exist under VMS VAXC 3.2 and were simply copied       over from uxc (4.3 bsd):        a) #include <sgtty.h>      b) #include <syslog.h>  
   Change log:   D   05-May-1988   12:09   MTS	Initial port of ph.c,v 2.15 to vms_ph.c./ 				Initial port of cryptit.c to vms_cryptit.c.   @   13-Feb-1991	16:08	MTS	Has it really been that long?  Re-ported+ 				ph v4.10 under VMS 5.3 and WIN/TCP 5.1.   ;   15-Oct-1991   14:44   RKO     Modified for MultiNet V3.0.  /*L ***************************************************************************/  O static char *rcsid = "VAX/VMS: ph.c,v 4.10 91/10/15 14:44:00 sandrock-oberman";    #include stdio #include signal 6 #include "multinet_root:[multinet.include.sys]types.h"7 #include "multinet_root:[multinet.include.sys]socket.h" 
 #include file 
 #include stat 7 #include "multinet_root:[multinet.include.netinet]in.h" 2 #include "multinet_root:[multinet.include]netdb.h" #include ctype /* #include <strings.h> */8 #include descrip    /* VMS descriptor structures defs */6 #include iodef      /* VMS I/O function definitions */7 #include ssdef      /* VMS System Status definitions */ 6 #include ttdef      /* VMS terminal characteristics */= #include "termdefs.h"   /* VMS defs for setterm() function */    #else C static char *rcsid = "$Date: 91/02/06 07:24:53 $$Revision: 4.10 $"; > static char *srcid = "$Source: /nameserv/Src/Ph/RCS/ph.c,v $";   #include <stdio.h> #include <signal.h>  #include <sys/types.h> #include <sys/wait.h>  #include <sys/socket.h>  #include <sys/file.h>  #include <sys/stat.h>  #include <netinet/in.h>  #include <netdb.h> #include <ctype.h> #include <strings.h> #ifdef hpux  #include <memory.h> : #define bcopy(source,dest,count)	memcpy(dest,source,count)* #define index(string,ch) strchr(string,ch), #define rindex(string,ch) strrchr(string,ch) #else  #ifndef NeXT
 void bcopy();  #endif #endif #endif   #include "replies.h"  H /*********************************************************************** * vital defines H ***********************************************************************/1 #define MAXSTR      2048  /* max string length */ 2 #define MAXVAL      14000   /* max value length */3 #define DELIM       " \t\n"/* command delimiters */ I #define MAXARGS	    20    /* maximum # of arguments in PH environ var. */ H /***********************************************************************/ * declarations for a couple of useful functions H ***********************************************************************/ char   *GetValue();  char   *strtok();  char   *getenv(); 
 #ifdef VMS; char *strchr();             /* VMS equivalent of "index" */ < char *strrchr();            /* VMS equivalent of "rindex" */ #define index(a,b) strchr(a,b)  #define rindex(a,b) strrchr(a,b)   #define GetQValue(aLine)    \ )       (strchr(strchr(aLine,':')+1,':')+1)  #else  FILE   *popen();   #define GetQValue(aLine)    \ '       (index(index(aLine,':')+1,':')+1)  #endif char *malloc();  char *getpass(); void exit(), free(), perror(); char *makestr();  I /************************************************************************ .  * declarations for the functions in this fileJ  ************************************************************************/ int main();  char *issub(); int ContactQI(); int DoId();  int PrintResponse(); int GetGood(); void EnvOptions(); void ComplainAboutService(); void ComplainAboutHost();  void Interactive();  int DoCommand(); int DoOtherWPage();  int DoOther(); #ifdef MACC  int DoFields();  #endif
 int DoHelp();  int DoQuery(); /* int DoLogin(); */
 int DoQuit(); 
 int DoEdit(); 
 int DoMake();  int EditValue(); int UpdateValue(); int DoFields();  int DoMe();  /* int DoPassword(); int DoLogout();  void VetPassword(); */ int AllDigits(); int PrintQResponse();  /* void DoAutoLogin(); */  void SkipMacdef(); /* int TryLogin(); */  void EmailLine();  void NotRegisteredLine();  FILE *OpenPager(); int DoSwitch();   H /************************************************************************ * These are external for convenience' sakeH ***********************************************************************/ #ifdef MACC_ECHO int maccecho =0; #endif
 #ifdef VMS< int  ToQI;		/* write to this to tell the nameserver stuff */7 int  FromQI;		/* read nameserver responses from here */  char ToQIBuf[MAXSTR];  int ToQILen; #define qprintf		\   {			\      char *ToQI=ToQIBuf;	\      sprintf  #define qflush(foobar)		\       ToQILen = strlen(ToQIBuf);	\   }				\$   socket_write(ToQI,ToQIBuf,ToQILen) #else ? FILE   *ToQI;		/* write to this to tell the nameserver stuff */ : FILE   *FromQI;		/* read nameserver responses from here */ #define qprintf fprintf  #define qflush fflush  #endif7 char  MyAlias[MAXSTR];  /* currently logged-in alias */ + char   *Me;		/* the name of this program */ @ char *MyPassword=NULL;  /* password read from .netrc (if any) */I /************************************************************************   * switches J  ************************************************************************/+ int NoNetrc = 0;	/* -n don't read .netrc */ 6 char *UseHost = 0;	/* -s use server on what machine */$ int UsePort = 0;	/* -p use port # */6 int NoReformat=1;	/* -i don't reformat email fields */( int NoPager=0;		/* -m don't use pager */0 int NoBeautify=0;	/* -b don't beautify output */* int NoLabels=0;		/* -l don't use labels */% int Confirm=0;		/* -c confirm Edit */ 6 char *DefType=0;	/* -t prepend this type to queries */4 char *ReturnFields=NULL;/* -f give list of fields */H /*********************************************************************** * and the fun begins... H ***********************************************************************/ int main(argc, argv) int   argc; 
 char  **argv;  {    int theCode=LR_ERROR;    int optionsCount;    char buffer[4096]; #ifdef MACC_ECHO
 	int margc=0;  #endif
 #ifdef VMS( char *temps;          /* temp strings */ #endif   /*+    * figure out what this program is called     */ 
 #ifdef VMS
   Me = " ph";  #else    Me = rindex(*argv,'/');  #endif	   if (Me) 	     Me++;    else     Me = *argv;    EnvOptions(CLIENT);    if (strcmp(CLIENT,Me))   {      sprintf(buffer,"-t %s",Me);      (void) OptionLine(buffer);     EnvOptions(Me);    } /   optionsCount = ProcessOptions(--argc,++argv);    argc -= optionsCount;    argv += optionsCount;      if (!ContactQI())    { <     fputs("Sorry--phone book not available now.\n", stderr);
 #ifdef VMS     exit(SS$_CONNECFAIL);  #else      exit(1); #endif   }      /*    * identify ourselves     */ /   if ((theCode=DoId())>=400) exit(theCode/100);    if (argc==0)<     Interactive();      /* no arguments--interactive mode */   else   { +     /* make a query out of the arguments */        strcpy(buffer,"query ");      for (; argc; argc--, argv++)     {        strcat(buffer,*argv);        if (argc > 1)  	strcat(buffer," ");     }      strcat(buffer,"\n");      theCode = DoCommand(buffer);     qprintf(ToQI,"\nquit\n");      qflush(ToQI);    } 
 #ifdef VMS   exit(SS$_NORMAL);  #else (   exit(theCode > 299 ? theCode/100 : 0); #endif }   H /***********************************************************************!  * contact the central nameserver I  ***********************************************************************/  int ContactQI()  { &   int   sock;         /* our socket */F   static struct sockaddr_in QI;    /* the address of the nameserver */>   struct servent *theNs;    	   /* nameserver service entry */B   static struct hostent *theHost;  /* host entry for nameserver */   char host[80];   char *baseHost;    int backupNum=0;   int mightBackup;     /* create the socket */ )   sock = socket(PF_INET, SOCK_STREAM, 0);    if (sock < 0)      return (0);    QI.sin_family = AF_INET;     /* find the proper port */   if (UsePort)     QI.sin_port = UsePort;3   else if (theNs = getservbyname(NSSERVICE, "tcp"))    {       QI.sin_port = theNs->s_port;   }    else   {   /*    ComplainAboutService(); */&     QI.sin_port = htons(FALLBACKPORT);   }      /* find the proper host */&   baseHost = UseHost ? UseHost : HOST;#   if (mightBackup=(*baseHost=='.')) ,     sprintf(host,"%s%s",NSSERVICE,baseHost);   else     strcpy(host,baseHost);   
   for (;;)   {      /* create the socket */ +     sock = socket(PF_INET, SOCK_STREAM, 0);      if (sock < 0)        return (0);      QI.sin_family = AF_INET;&     if (theHost = gethostbyname(host))     { >       bcopy(theHost->h_addr, (char *) &QI.sin_addr.s_addr, 4);     }      else if (!backupNum)     {        ComplainAboutHost(host);/       QI.sin_addr.s_addr = htonl(FALLBACKADDR); ?       theHost = gethostbyaddr(&QI.sin_addr.s_addr, 4, AF_INET);      }      else     { 2       fprintf(stderr,"No more backups to try.\n");       return(0);     }    #     /* connect to the nameserver */ >     if (connect(sock, (struct sockaddr *)&QI, sizeof(QI)) < 0)     {        perror(host);        if (mightBackup)       {          backupNum++;5 	sprintf(host,"%s%d%s",NSSERVICE,backupNum,baseHost);        } 
       else         return (0);      }      else break;    }      if (backupNum)V     fprintf(stderr,"WARNING--backup host %s; information may be out of date.\n",host);   /* open path to nameserver */ 
 #ifdef VMSB   ToQI = sock;        /* copy socket channel for netwrite calls */9   FromQI = sock;            /* ditto for netread calls */  #else )   if ((ToQI = fdopen(sock, "w")) == NULL)    {      perror("to qi");     return (0);    }   !   /* open path from nameserver */ +   if ((FromQI = fdopen(sock, "r")) == NULL)    {      perror("from qi");     return (0);    }  #endif   UseHost = theHost->h_name;   UsePort = QI.sin_port;   
   return (1);  }   H /***********************************************************************& * identify ourselves to the nameserverH ***********************************************************************/
 int DoId() { #   qprintf(ToQI,"id %d\n",getuid());    qflush(ToQI);    return (PrintResponse(-1));  }   H /***********************************************************************9  * print what the QI (Query Interpreter; nameserver) says @  * read replies from nameserver until code indicates a completedE  * command.  This routine does not beautify the responses in any way. ,  * if doPaging is 1, the pager will be used.+  * if doPaging is 0, no pager will be used. >  * if doPaging is -1, the response will not be printed at all.I  ***********************************************************************/  int PrintResponse(doPaging) ( int doPaging;       /* use the pager? */ { *   char  scratch[MAXSTR];  /* some space */3   int   code=LR_ERROR;         /* the reply code */    FILE   *theOutput;  "   theOutput = OpenPager(doPaging);9   while (GetGood(scratch, MAXSTR, FromQI))  /* read it */    {      code = atoi(scratch); N     if (doPaging!= -1 || code>=400) fputs(scratch, theOutput);   /* echo it */     if (code >= LR_OK)       break;   } 
 #ifdef VMS #else    if (theOutput != stdout)     pclose(theOutput); #endif  :   return (code);        /* all done.  return final code */ }   H /***********************************************************************& * get a non-comment line from a stream- * a comment is a line beginning with a # sign H ***********************************************************************/) int GetGood(theString, maxChars, theFile) 6 char   *theString;        /* space to put the chars */4 int   maxChars;         /* max # of chars we want */
 #ifdef VMS4 int   theFile;        /* stream to read them from */ { ( static char Qbuf [MAXSTR+4] = { '\0' } ;8 static int  pos = {0}, end = {0}, len = {0}, tend = {0}; char *linp;   
   for (;;)   {      if (pos >= len)      { /       len = socket_read(theFile,Qbuf,maxChars);        if (len <= 0) return (0);        Qbuf [len] = '\0';       pos = 0;     }   >     linp = index(Qbuf+pos, '\n'); /* find next newline char */     if (linp == NULL)      { F       strncpy(theString, Qbuf+pos, len-pos+1); /* Copy what we have */;       end = len-pos;            /* no newline chars left */ 6       pos = 0;	        	  /* Start at the beginning *//       len = socket_read(theFile,Qbuf,maxChars);        if (len <= 0) return (0);        Qbuf [len] = '\0';       linp = index(Qbuf, '\n'); 0       strncpy(theString+end, Qbuf, linp-Qbuf+1);       tend = linp + end - Qbuf; %       *(theString+tend-pos+1) = '\0';        end = tend - end;      }      else     { @       end = linp - Qbuf;          /* convert pointer to index */.       strncpy(theString, Qbuf+pos, end-pos+1);$       *(theString+end-pos+1) = '\0';     } G     pos = end + 1;                /* save new position for next time */  #else   : FILE  *theFile;             /* stream to read them from */ { 
   for (;;)   { /     (void) fgets(theString, maxChars, theFile);  #endif     if (*theString != '#')3       return (1);     /* not a comment; success! */      else     if (!*theString)7       return (0);     /* empty string==end of stream */    }  }   H /***********************************************************************< * complain that there isn't an entry for ns in /etc/servicesH ***********************************************************************/ void ComplainAboutService()  { N   fprintf(stderr, "Warning--there is no entry for ``%s'' in /etc/services;\n",       NSSERVICE); E   fputs("please have your systems administrator add one.\n", stderr);*O   fprintf(stderr, "I'm going to use port %d in the meantime.\n", FALLBACKPORT);  }h  H /***********************************************************************= * complain that there isn't an entry for garcon in /etc/hosts H ***********************************************************************/ void ComplainAboutHost(name) char *name;i {cB   fprintf(stderr, "Warning--unable to find address for ``%s''.\n",
     name);E   fprintf(stderr, "I'm going to use address 0x%x in the meantime.\n",        FALLBACKADDR); }*  H /***********************************************************************' * the interactive portion of the clientnH ***********************************************************************/ typedef struct command Command;e struct command { 5   char   *cName;        /* the name of the command */r5   int   cLog;         /* must be logged in to use? */.:   int   (*cFunc) ();    /* function to call for command */ };   Command CommandTable[] = {*   "help", 0, DoHelp,   "?", 0, DoHelp,*   "query", 0, DoQuery, #ifndef MACC   CLIENT, 0, DoQuery,    "me", 1, DoMe,   "edit", 1, DoEdit,   "make", 1, DoMake, /*  "password", 1, DoPassword,   "passwd", 1, DoPassword,   "login", 0, DoLogin,   "logout", 1, DoLogout, */e #endif
 #ifdef MACC  e   "fields", 0, DoFields, #else.   "fields", 0, DoOtherWPage,   "switch", 0, DoSwitch, #endif #ifndef MACC   "add", 1, DoOther,   "delete", 1, DoOther,    "set", 0, DoOther, #endif   "quit", 0, DoQuit,   "bye", 0, DoQuit,e   "exit", 0, DoQuit,	   0, 0, 0  };  H /*********************************************************************** * the main looprH ***********************************************************************/> int LastCode = 0;	/* the response from the previous command */ void Interactive() {e9   char  inputLine[MAXSTR];  /* space for an input line */)
   char *spot;-  5   *MyAlias = 0;         /* nobody logged in yet... */D #ifndef MACC   puts(rcsid);W /*  printf("Send mail to %s to get your password (see \"help password\").\n",PASSW); */e<   printf("Mail other questions or comments to %s.\n",ADMIN); #elseG;   printf("Lookup - ELECTRONIC MAIL DIRECTORY SERVICE\n\n"); =   printf("Please mail questions or comments to %s.\n",ADMIN);  #endif     /*    * print database status    */e#   LastCode = DoOther("status\n",0);      /*    * autologin if possible    */  /* #ifndef MACC    if (!NoNetrc) DoAutoLogin();	 #endif */s     puts(" ");      while (1)r   {I#     (void) signal(SIGPIPE,SIG_IGN);i #ifdef MACC_ECHO   if (!maccecho)     printf("%s> ",Me); #elsek     printf("%s> ",Me); #endif(     (void) fflush(stdout);  /* prompt */     spot=inputLine;i     do {7       if (!fgets(spot, MAXSTR-(spot-inputLine), stdin))  	return;        /* read line */ -       spot = inputLine + strlen(inputLine)-2; %       if (*spot=='\\') *spot++ = ' ';        else spot=inputLine-1;     }>     while (spot>=inputLine); #ifdef MACC_ECHO 	if (maccecho)$     		printf("%s> %s",Me,inputLine); #endif  J     if (!(LastCode=DoCommand(inputLine)))   /* is it a command we know? */B       LastCode = DoOther(inputLine);    /* unrecognized command */   }5 }t  H /***********************************************************************E * look at input line, and if we have a specific command for it, do itaH ***********************************************************************/ int DoCommand(inputLine). char   *inputLine;        /* the input line */ {y*   char  scratch[MAXSTR];  /* some space */=   char   *theToken;       /* a token from the command line */u0   Command *theCommand;    /* the command name */   Command *doMe;   int   len;  B   /* make a safe copy of the input line, so we can play with it */   strcpy(scratch, inputLine);o  +   if (!(theToken = strtok(scratch, DELIM)))S-     return (LR_ERROR);       /* blank line */   %   /* search command table linearly */i   doMe = NULL;   len = strlen(theToken);iB   for (theCommand = CommandTable; theCommand->cName; theCommand++)3     if (!strncmp(theCommand->cName, theToken, len))      {3@       if (doMe)       /* we found 2 commands that match (bad) */       {/( 	printf("%s is ambiguous.\n", theToken); 	return (LR_ERROR);e       }e?       doMe = theCommand;  /* we found a command that matches */<     }e  :   if (doMe)           /* found one and only one command */   {e     /* expand command name */c'     theToken = strtok((char *)0, "\n");<I     sprintf(inputLine, "%s %s\n", doMe->cName, theToken ? theToken : "");f       /* execute command */t      if (doMe->cLog && !*MyAlias)?       printf("You must be logged in to use %s.\n",doMe->cName);f     else)       return((*doMe->cFunc) (inputLine));*     return (LR_ERROR);   }*  *   return (0);         /* didn't find it */ }   H /***********************************************************************B * execute a command for which we do nothing special; use the pagerH ***********************************************************************/ int DoOtherWPage(inputLine)G char   *inputLine; {#4   qprintf(ToQI,"%s",inputLine);   /* send command */   qflush(ToQI);*0   return (PrintResponse(1));  /* get response */ }s  H /***********************************************************************D * execute a command for which we do nothing special; don't use pagerH ***********************************************************************/ int DoOther(inputLine) char   *inputLine; { 4   qprintf(ToQI,"%s",inputLine);   /* send command */   qflush(ToQI); 0   return (PrintResponse(0));  /* get response */ }(   #ifdef MACC  int DoFields(inputLine)' char   *inputLine; { *   printf("Field Name     Description\n"); -   printf("------------------------------\n"); (   printf("name          Person Name\n");>   printf("email         Electronic Mail Address if exists\n");1   printf("phone         Telephone Number One\n");*1   printf("phone2        Telephone Number Two\n");n;   printf("address       Street Address of the Building\n");**   printf("building      Building Name\n");<   printf("department    Department Number One of Person\n");<   printf("department2   Department number Two of Person\n");H   printf("appointment   Appointment Classification Code Number One \n");G   printf("appointment2  Appointment Classification Code Number Two\n");e&   printf("title         Title One\n");&   printf("title2        Title Two\n");W   printf("alias         Unique Name built from First Letter of First Name, Last\n");   o1   printf("              Name and a Number\n\n"); d   return(LR_OK); }n #endif  H /*********************************************************************** * execute a query request H ***********************************************************************/ int DoQuery(inputLine) char   *inputLine; {*   char scratch[4096];*
   char *args; !   int noReformatWas = NoReformat;e   int code;*  1   if (ReturnFields && !issub(inputLine,"return"))*   {*'     args=inputLine+strlen(inputLine)-1;;.     sprintf(args," return %s\n",ReturnFields);2     for (;*args;args++) if (*args==',') *args=' ';   } !   if (!NoBeautify && !NoReformat)    {T*     char *ret = issub(inputLine,"return");.     if (ret) NoReformat = !issub(ret,"email");   }i+   if (!DefType || issub(inputLine,"type="))    {l7      qprintf(ToQI,"%s",inputLine);   /* send command */I      qflush(ToQI);   }I   else   {o     strcpy(scratch,inputLine);!     args = strtok(scratch," \t");m     args = strtok(0,"\n");
     if (args)i     {iO       qprintf(ToQI,"query type=\"%s\" %s\n",DefType,args);   /* send command */-       qflush(ToQI);*     }      else     {p#       qprintf(ToQI,"%s",inputLine);*       qflush(ToQI);n     }f   }    ?   code = (NoBeautify ? PrintResponse(1) : PrintQResponse(1,0));*   NoReformat = noReformatWas;*   return (code); }*  H /*********************************************************************** * execute a login requestsH ***********************************************************************/ int DoLogin(inputLine) char   *inputLine; {e8   char  encryptMe[MAXSTR];  /* string from nameserver */;   char  encrypted[MAXSTR];  /* string from ns, encrypted */s:   char   *password;       /* user's nameserver password */
   int   code;r   char scratch[MAXSTR];d     strcpy(scratch,inputLine);C   (void) strtok(scratch,DELIM);	/* the login part of the command */*1   if (!strtok(0,DELIM))		/* check for an alias */    { C     printf("Enter nameserver alias: ");	/* ask for missing alias */*)     fgets(scratch,sizeof(scratch),stdin);)$     if (!*scratch) return(LR_ERROR);*     sprintf(inputLine,"login %s",scratch);   }h  :   qprintf(ToQI,"%s",inputLine);   /* send login request */   qflush(ToQI);e  +   for (;;)          /* read the response */    {f,     if (!GetGood(encryptMe, MAXSTR, FromQI))     {f8       fprintf(stderr, "Whoops--the nameserver died.\n");       exit(1);     }      code = atoi(encryptMe);vB     if (code != LR_LOGIN)   /* intermediate or strange response */       fputs(encryptMe, stdout);i.     if (code >= LR_OK)    /* final response */       break;   }=     if (code == LR_LOGIN)g   { /     /* the nameserver has issued a challenge */ (     password = MyPassword ? MyPassword :+ 		  getpass("Enter nameserver password: ");e     crypt_start(password);  1     /* encrypt the challenge with the password */ D     encryptMe[strlen(encryptMe) - 1] = '\0';    /* strip linefeed */F     encrypted[encryptit(encrypted, index(encryptMe, ':') + 1)] = '\0';  '     /* send the encrypted text to qi */ ,     qprintf(ToQI, "answer %s\n", encrypted);     qflush(ToQI);q        /* get the final response */     for (;;)     { .       if (!GetGood(encryptMe, MAXSTR, FromQI))       {f3 	fprintf(stderr, "Whoops--the nameserver died.\n");d	 	exit(1);n       };       code = atoi(encryptMe);        fputs(encryptMe, stdout);f.       if (code >= LR_OK)  /* final response */ 	break;?     }e   }:  )   if (code == LR_OK)      /* logged in */*   {*/     strcpy(MyAlias, index(encryptMe, ':') + 1);a      *index(MyAlias, ':') = '\0';B     VetPassword(password);  /* make sure password is reasonable */   }    else     *MyAlias = '\0';   return(code);s }e  H /*********************************************************************** * execute a quit requestH ***********************************************************************/ int DoQuit(inputLine)s char   *inputLine; {0   DoOther("quit\n");
 #ifdef VMS   exit(SS$_NORMAL);B #else @   exit(LastCode<LR_OK || LastCode >=LR_MORE ? LastCode/100 : 0); #endif }f  H /*********************************************************************** * edit a fieldH ***********************************************************************/ int DoEdit(inputLine)  char   *inputLine; {    char   *theField;    char   *theAlias;o   char   *theValue;    int theCode=LR_OK;   char confirm[10];   7   (void) strtok(inputLine, DELIM);  /* skip ``edit'' */?.   if (!(theField = strtok((char *) 0, DELIM)))   { $     (void) DoCommand("help edit\n");     return(LR_ERROR);t   }h  .   if (!(theAlias = strtok((char *) 0, DELIM)))     theAlias = MyAlias;k  G   if ((theValue = GetValue(theAlias, theField)) && EditValue(theValue))    { 9     for (theCode=UpdateValue(theAlias,theField,theValue);o&          400<=theCode && theCode<=499;2 	 theCode=UpdateValue(theAlias,theField,theValue))     {!       if (!isatty(0)) break;*       printf("Shall I try again [y/n]? ");+       fgets(confirm,sizeof(confirm),stdin);e0       if (*confirm!='y' && *confirm!='Y') break;     } 1     if (theCode<300 && !strcmp(theField,"alias"))p       strcpy(MyAlias,theValue);    }    return(theCode); }   H /***********************************************************************. * get the value of a field from the nameserverH ***********************************************************************/" char *GetValue(theAlias, theField) char   *theAlias;  char   *theField;  { =   static char theValue[MAXVAL];     /* will hold the value */"   char   *vSpot;   char  scratch[MAXSTR];
   int   code;,  $   if (!strcmp(theField, "password"))   {d4     puts("Use the ``password'' command, not edit.");     return (NULL);   }r     /* do the query */B   qprintf(ToQI, "query alias=%s return %s\n", theAlias, theField);   qflush(ToQI);      *theValue = '\0';;  J   /* read qi response lines, concatenating the responses into one value */1   for (vSpot = theValue;; vSpot += strlen(vSpot))r   {"*     if (!GetGood(scratch, MAXSTR, FromQI))     {H8       fprintf(stderr, "Ding-dong the server's dead!\n");       exit(0);     }*)     if ((code = atoi(scratch)) == -LR_OK)*M       strcpy(vSpot, index(GetQValue(scratch), ':') + 2);  /* part of value */*     else     if (code >= LR_OK)(       break;        /* final response */     else)       fputs(scratch, stdout);   /* ??? */(   }R  %   if (code != LR_OK)      /* error */*     fputs(scratch, stdout);*  +   return (code == LR_OK ? theValue : NULL);u }   H /*********************************************************************** * Edit a valueH ***********************************************************************/ int EditValue(theValue)t1 char   *theValue;         /* the value to edit */e {i8   char   *theFileName;    /* name of temp file to use */   char   *mktemp();*
 #ifdef VMS$   struct dsc$descriptor_s cli_input;7   char  template[28], f1[28], f2[28], edit_command[64];    int   istat; #elset   char  template[20];r #endif7   int   fd;         /* file descriptor for temp file */ 3   static char newValue[MAXVAL];     /* new value */h7   char   *editor;           /* editor program to use */ 8   int   bytes;            /* numnber of bytes in file */   register char *from, *to;-<   int   badChar;          /* did we find a bad character? */
   int   junk;R   char scratch[80];   &   /* put the value into a temp file */
 #ifdef VMS/   strcpy(template, "SYS$SCRATCH:PHXXXXXX.TMP"); !   theFileName = mktemp(template);d   strcpy (f1, theFileName);*   strcpy (f2, theFileName);*C   strcat (f1, ";1");      /* versions needed for delete function */    strcat (f2, ";2");'   if ((fd = creat(theFileName, 0)) < 0)* #else*$   strcpy(template, "/tmp/phXXXXXX");!   theFileName = mktemp(template);h;   if ((fd = open(theFileName, O_RDWR | O_CREAT, 0777)) < 0)  #endif   {      perror(theFileName);     return (0);n   }   0   if (write(fd, theValue, strlen(theValue)) < 0)   {f     perror(theFileName);     (void) close(fd);}     return (0);o   }0     (void) close(fd);,  &   /* run an editor on the temp file */
 #ifdef VMS#   if (!(editor = getenv("EDITOR")))o     editor = "EDIT/TPU";     strcpy(edit_command, editor);n   strcat(edit_command, " ");$   strcat(edit_command, theFileName);L   cli_input.dsc$w_length = strlen(edit_command);  /* descriptor for spawn */)   cli_input.dsc$a_pointer = edit_command;,(   cli_input.dsc$b_class = DSC$K_CLASS_S;(   cli_input.dsc$b_dtype = DSC$K_DTYPE_T;  5   if( (istat = LIB$SPAWN(&cli_input)) != SS$_NORMAL )    {n     (void) delete (f1);t     exit(istat);   }h #else #   if (!(editor = getenv("EDITOR")))  #ifdef hpux=     editor = "/usr/bin/vi";u #else)     editor = "/usr/ucb/vi";n #endif  
   if (fork()) %     (void) wait((union wait *)&junk);(   else   {d5     (void) execlp(editor, editor, theFileName, NULL); :     fprintf(stderr,"Whoops!  Failed to exec %s\n",editor);     exit(1);   }  #endif  %   /* does the user want the value? */    if (Confirm)   {      do     { '       printf("Change the value [y]? ");*       gets(scratch);     }i0     while (*scratch && !index("yYnN",*scratch));   }       /* read the value back out */ &   if ((fd = open(theFileName, 0)) < 0)   {h     perror(theFileName);
 #ifdef VMS #else      (void) unlink(theFileName);m #endif     return (0);l   }   
 #ifdef VMS #else    (void) unlink(theFileName);r #endif  3   if ((bytes = read(fd, newValue, MAXSTR - 1)) < 0)*   {*     perror(theFileName);     (void) close(fd);n
 #ifdef VMS4     (void) delete (f1);   /* delete 1st temp file */4     (void) delete (f2);   /* delete 2nd temp file */ #endif     return (0);e   }(   (void) close(fd);e
 #ifdef VMS4   (void) delete (f1);     /* delete 1st temp file */4   (void) delete (f2);     /* delete 2nd temp file */ #endif   newValue[bytes] = 0;     /* did the value change? */g>   if (Confirm && *scratch && *scratch!='y' && *scratch!='Y' ||"       !strcmp(newValue, theValue))     return (0);*  9   /* copy new value into old, stripping bad characters */o   badChar = 0;5   for (to = theValue, from = newValue; *from; from++)*     if (*from == '"')d     {i       *to++ = '\\';r       *to++ = '"';     }e     else%     if (*from >= ' ' && *from <= '~')n       *to++ = *from;     else     if (*from == '\t')     {x       *to++ = '\\';        *to++ = 't';     }      else     if (*from == '\n')     {*>       if (*(from + 1))  /* skip terminating newline from vi */       {n 	*to++ = '\\';
 	*to++ = 'n';*       }*     }*     else       badChar = 1;  
   *to = 0;  ?   if (badChar)        /* complain if we found bad characters */n   {fD     fputs("Illegal characters were found in your value.\n", stderr);Q     fputs("Please use only printable characters, newlines, and tabs.\n", stderr);n>     fputs("The offending characters were removed.\n", stderr);   }0  
   return (1);e }A  H /***********************************************************************, * update a nameserver field with a new valueH ***********************************************************************/- int UpdateValue(theAlias, theField, theValue)D char   *theAlias;  char   *theField;r char   *theValue;  {DR   qprintf(ToQI, "change alias=%s make %s=\"%s\"\n", theAlias, theField, theValue);   qflush(ToQI);      return(PrintResponse(0));  }eH /*********************************************************************** * print info on current userH ***********************************************************************/ /*ARGSUSED*/ int DoMe(inputLine)* char   *inputLine; {0   if (!*MyAlias)   {t     return(DoHelp("help me"));   }i  8   qprintf(ToQI, "query alias=%s return all\n", MyAlias);   qflush(ToQI);*  >   return(NoBeautify ? PrintResponse(0) : PrintQResponse(0,0)); }n  H /*********************************************************************** * set command-line switchesSH ***********************************************************************/ int DoSwitch(inputLine)E char   *inputLine; {Y&   inputLine = strtok(inputLine,DELIM);"   if (!OptionLine(strtok(0,"\n")))   { G     printf("The following things can be changed with \"switch\":\n\n");"A     printf("  Paging is %s; use \"switch -%c\" to turn it %s.\n",d     	NoPager ? "OFF" : "ON",     	NoPager ? 'M' : 'm',      	NoPager ? "on" : "off"); M     printf("  Email reformatting is %s; use \"switch -%c\" to turn it %s.\n",      	NoReformat ? "OFF" : "ON",      	NoReformat ? 'R' : 'r',      	NoReformat ? "on" : "off");O     printf("  Query beautification is %s; use \"switch -%c\" to turn it %s.\n",n     	NoBeautify ? "OFF" : "ON",r     	NoBeautify ? 'B' : 'b',      	NoBeautify ? "on" : "off");I     printf("  Label printing is %s; use \"switch -%c\" to turn it %s.\n",      	NoLabels ? "OFF" : "ON",i     	NoLabels ? 'L' : 'l',     	NoLabels ? "on" : "off");L     printf("  Edit confirmation is %s; use \"switch -%c\" to turn it %s.\n",     	Confirm ? "ON" : "OFF",     	Confirm ? 'c' : 'C',      	Confirm ? "off" : "on");5J     printf("  Default entry type is %s; use \"switch -%c%s\" to %s %s.\n",     	DefType ? DefType : "OFF",f     	DefType ? 'T' : 't', $     	DefType ? "" : " name-of-type",'     	DefType ? "turn it" : "set it to",*' 	DefType ? "off" : "\"name-of-type\""); M     printf("  Default field list is %s; use \"switch -%c%s\" to %s to %s.\n", 0         ReturnFields ? ReturnFields : "default", 	ReturnFields ? 'F' : 'f',+ 	ReturnFields ? "" : " field1,field2,... ", $ 	ReturnFields ? "revert" : "set it",5 	ReturnFields ? "default" : "\"field1,field2,...\"");hL     printf("\nThe following things cannot be changed with \"switch\":\n\n");E     printf("  Connected to server %s at port %d\n", UseHost,UsePort); E     printf("  The .netrc file was %sread.\n", NoNetrc ? "not " : "");    }    return(LR_OK); }T  H /***********************************************************************, * change a field value from the command lineH ***********************************************************************/ int DoMake(inputLine)  char   *inputLine; {    int theCode=LR_ERROR;o     if (!*MyAlias)     DoHelp("help make");   else   { 9     qprintf(ToQI,"change alias=%s %s",MyAlias,inputLine);      qflush(ToQI);o     theCode = PrintResponse(0);r   }c   return(theCode); }p   H /*********************************************************************** * change passwordtH ***********************************************************************/ int DoPassword(inputLine)  char   *inputLine; {(   char  password[80];e   char   *confirm;   char   *theAlias;e   int theCode=LR_ERROR;'     if (!*MyAlias)   {*$     return(DoHelp("help password"));   }*     /* which alias to use? */t"   (void) strtok(inputLine, DELIM);.   if (!(theAlias = strtok((char *) 0, DELIM)))     theAlias = MyAlias;*     /* get the password */4   strcpy(password, getpass("Enter new password: "));#   if (!*password) return(LR_ERROR); '   confirm = getpass("Type it again: ");r    if (strcmp(confirm, password))   {s8     fprintf(stderr, "Sorry--passwords didn't match.\n");     return(theCode);   }tH   VetPassword(confirm);     /* complain if we don't like the password */  %   /* encrypt and send the password */*0   password[encryptit(password, confirm)] = '\0';J   qprintf(ToQI, "change alias=%s make password=%s\n", theAlias, password);   qflush(ToQI);e  $   /* see what the nameserver says */G   if ((theCode=PrintResponse(0)) == LR_OK && !strcmp(theAlias,MyAlias))      crypt_start(confirm);D   return(theCode); }n  H /*********************************************************************** * log out the current userH ***********************************************************************/ int DoLogout(inputLine)r char   *inputLine; {e   *MyAlias = '\0';   return(DoOther(inputLine));e }A  H /***********************************************************************( * complain about passwords we don't likeH ***********************************************************************/ void VetPassword(thePassword)p char   *thePassword; {C3   if (strlen(thePassword) < 5 ||    /* too short */m-     AllDigits(thePassword)) /* digits only */nG     fputs("That is an insecure password; please change it.\n", stderr);  }r  H /*********************************************************************** * is a string all digitsH ***********************************************************************/ int AllDigits(theString) register char *theString;* {*!   for (; *theString; theString++)      if (!isdigit(*theString))*       return (0);*
   return (1);* }*  H /*********************************************************************** * print the response to a querya1 * this strips out all the nameserver reply codes.sH ***********************************************************************/+ int PrintQResponse(reformatEmail,amHelping)n int reformatEmail; int amHelping; {a   char  theLine[MAXSTR];   int   theCode=LR_ERROR;e   int   currentPerson = 0;   int   thePerson;   register char *cp;   FILE   *theOutput;   char  nickname[MAXSTR];(   char  alias[MAXSTR];   char  email[MAXSTR];   int copiedEmail=0;     theOutput = OpenPager(1);I  O   *alias = *email = *nickname = 0; /* haven't found an alias or nickname yet */="   if (NoReformat) reformatEmail=0;   /* get the response */*   while (GetGood(theLine, MAXSTR, FromQI))   {%     theCode = atoi(theLine);     if (theCode == LR_NUMRET)T     {  #ifdef MACCl 	cp = strchr(theLine,':'); 	if ( cp != 0)Q 	fprintf(theOutput,"\n%s\n",cp+1); /* strchr returns pointer to : then add one */1 #endif MACCp     }0     elseJ     if (theCode == -LR_OK || theCode == -LR_AINFO || theCode == -LR_ABSENT        || theCode == -LR_ISCRYPT)     {*0       thePerson = atoi(index(theLine, ':') + 1);       /* output a delimiter */%       if (thePerson != currentPerson)(       {) 	if (*alias && !*email) & 	  NotRegisteredLine(alias,theOutput); 	else if (*email)  	{# 	  EmailLine(email,alias,nickname);n% 	  fputs(GetQValue(email),theOutput);  	  *email = 0; 	}@ 	fputs("----------------------------------------\n", theOutput); 	currentPerson = thePerson;v 	copiedEmail=0;c       }	       if (reformatEmail)       {* 	cp = GetQValue(theLine);/ 	while (*cp && *cp==' ') cp++; 	if (!strncmp("alias",cp,5)) 	{ 	  copiedEmail = 0;i 	  strcpy(alias,theLine);a 	  continue; 	}! 	else if (!strncmp("email",cp,5))r 	{ 	  strcpy(email,theLine);L 	  copiedEmail = 1;h 	  continue; 	}$ 	else if (!strncmp("nickname",cp,8)) 	{ 	  copiedEmail = 0;T 	  strcpy(nickname,theLine); 	  continue; 	}" 	else if (*cp==':' && copiedEmail) 	  continue; 	else) 	  copiedEmail = 0;t       }        /* output the line */\!       if (NoLabels && !amHelping)o:         fputs(index(GetQValue(theLine),':')+2, theOutput);
       else-         fputs(GetQValue(theLine), theOutput);u     }      else if (theCode != LR_OK)-       fputs(theLine, theOutput);  /* error */=       if (theCode >= LR_OK)e     {r       if (*alias && !*email)$ 	NotRegisteredLine(alias,theOutput);       else if (*email)       {e! 	EmailLine(email,alias,nickname);a 	/* output the line */ 	if (NoLabels && !amHelping)3 	  fputs(index(GetQValue(email),':')+2, theOutput);; 	elses& 	  fputs(GetQValue(email), theOutput);       }e       break;     }:   }1     /* final "delimiter" */    if (currentPerson)C     fputs("----------------------------------------\n", theOutput);    
 #ifdef VMS #elser   if (theOutput != stdout)     (void) pclose(theOutput);t #endif     return(theCode); }f   #ifndef NeXTH /***********************************************************************E * break a string into tokens.  this code is NOT lifted from sysV, butO * was written from scratch.eH ***********************************************************************/ /*I  * function:   strtok purpose:  to break a string into tokens parameters:;L  * s1 string to be tokenized or 0 (which will use last string) s2 delimitersJ  * returns:  pointer to first token.  Puts a null after the token. returns  * NULL if no tokens remain. *  */* char   * strtok(s1, s2) char   *s1, *s2; {*   static char *old = 0;*   char   *p1, *p2;     if (!(s1 || old))o     return (NULL);   p1 = (s1 ? s1 : old);o)   while (*p1 && (index(s2, *p1) != NULL))R	     p1++;s
   if (*p1)   {d     p2 = p1;+     while (*p2 && (index(s2, *p2) == NULL))        p2++;*     if (*p2)     {*       *p2 = '\0';*       old = ++p2;*     }d     else       old = 0;     return (p1);   }*   else     return (NULL); }* #endif
 #ifdef VMS /*        setterm.cL  *  *    module in termlib   *,  *    contains routines to set terminal mode  *1  *    V1.0 19-jul-84  P. Schleifer  Initial drafto  */u   setterm(characteristic, state) long  *characteristic, *state; {    int     status;    long    efn;   long    new_state;   short     term_chan;   struct char_buff  mode;=   struct mode_iosb  term_iosb;    $DESCRIPTOR(term_desc, "TT:");     /* get event flag */   status = lib$get_ef(&efn);.   if ( status != SS$_NORMAL ) return (status);     /* get channel to terminal */ 4   status = sys$assign(&term_desc, &term_chan, 0, 0);,   if (status != SS$_NORMAL) return (status);  Q   /* if characteristic is BROADCAST, ECHO, or TYPEAHEAD, state must be toggled */,^   if (*characteristic == BROADCAST || *characteristic == ECHO || *characteristic == TYPEAHEAD)     new_state = !(*state);   else     new_state = *state;t     /* get current mode */\   status = sys$qiow(efn, term_chan, IO$_SENSEMODE, &term_iosb, 0, 0, &mode, 12, 0, 0, 0, 0);g   if (status != SS$_NORMAL || term_iosb.stat != SS$_NORMAL) { sys$dassgn(term_chan); return (status); }*  %   /* change characteristics buffer */i   if (new_state == ON)'     mode.basic_char |= *characteristic;h   else*     mode.basic_char &= ~(*characteristic);  1   /* $ SET TERM/...  and then deassign channel */,Z   status = sys$qiow(efn, term_chan, IO$_SETMODE, &term_iosb, 0, 0, &mode, 12, 0, 0, 0, 0);     sys$dassgn(term_chan);   lib$free_ef(&efn);  ,   if (status != SS$_NORMAL) return (status);   else return (term_iosb.stat);f }h  H /*********************************************************************** * get password from stdina * < * implement for VMS, since VAXCRTL lacks getpass() function.H ***********************************************************************/ char *getpass(prompt) 
 char *prompt;  {x   static char line [12];1 static int echo = {ECHO}, off = {OFF}, on = {ON};t  <   printf(prompt); (void) fflush(stdout);        /* prompt */   setterm(&echo, &off);R
   gets(line);a   setterm(&echo, &on);   puts("");l   return(line);c }c #endif  H /***********************************************************************0 * use .netrc to login to nameserver, if possibleH ***********************************************************************/ void DoAutoLogin() { '   FILE *netrc;    /* the .netrc file */*3   char pathName[1024];/* pathname of .netrc file */d<   struct stat theStat;/* permissions, etc. of .netrc file */;   char key[80], val[80];    /* line from the .netrc file */tG   char *token;    /* token (word) from the line from the .netrc file */_,   char *alias=NULL;   /* the user's alias */-   char *pw=NULL;    /* the user's password */h     /*7    * manufacture the pathname of the user's .netrc filer    */m/   sprintf(pathName,"%s/.netrc",getenv("HOME"));*     /*%    * make sure its permissions are oke    */r    if (stat(pathName,&theStat)<0)     return;n   if (theStat.st_mode & 077)3     return;             /* refuse insecure files */      /*    * try to open itr    */ #   if (!(netrc=fopen(pathName,"r")))      return;v     /*(    * look for a ``machine'' named ``ph''    */"*   while (2==fscanf(netrc,"%s %s",key,val))   {e6     if (!strcmp(key,"machine") && !strcmp(val,CLIENT))     {F       /*9        * found an entry for ph.  look now for other itemsu	        */ .       while (2==fscanf(netrc,"%s %s",key,val))       {<2 	if (!strcmp(key,"machine"))     /* new machine */ 	{) 	    if (alias) {free(alias);alias=NULL;}   	    if (pw) {free(pw);pw=NULL;} 	    break;  	} 	else if (!strcmp(key,"login"))e7 	    alias=strcpy(malloc((unsigned)strlen(val)+1),val);t" 	else if (!strcmp(key,"password"))4 	    pw=strcpy(malloc((unsigned)strlen(val)+1),val);3 	else if (!strcmp(key,"macdef")) SkipMacdef(netrc);t  ' 	if (alias && pw && TryLogin(alias,pw))(
 	  goto done;(       })     } 6     else if (!strcmp(key,"macdef")) SkipMacdef(netrc);   }t   done:_   if (alias) free(alias);i   if (pw) free(pw);e	   return;n }.  H /***********************************************************************" * skip a macdef in the .netrc fileH ***********************************************************************/ void SkipMacdef(netrc) FILE *netrc; {n   int c, wasNl;A   4   for (wasNl=0;(c=getc(netrc))!=EOF;wasNl=(c=='\n'))      if (wasNl && c=='\n') break; }E  H /***********************************************************************  * try a login alias and passwordH ***********************************************************************/ int TryLogin(alias,password) char *alias; char *password;e {"   char loginLine[80];    int success;     /*    * construct a login linee    */s(   sprintf(loginLine,"login %s\n",alias);     /*    * set our passwordf    */e   MyPassword=password;     /*    * try the login    */l!   success = DoLogin(loginLine,0);c     /*    * reset our passwordu    */o   MyPassword = NULL;&   while (*password) *password++ = 'x';     /*$    * return our success (or failure)    */n   return(success); }f    H /*********************************************************************** * execute a help requestH ***********************************************************************/ int DoHelp(inputLine)i char   *inputLine; {l   char scratch[256];   char *token;      strcpy(scratch,inputLine);<   token = strtok(scratch+4,DELIM);	/* the word after help */E   if (token && !strcmp(token,"native")) /* looking for native help */f=     strcpy(scratch,inputLine);		/* leave the command alone */e   elseM     sprintf(scratch,"help %s %s",CLIENT,inputLine+4); /* insert identifier */c     2   qprintf(ToQI,"%s",scratch);   /* send command */   qflush(ToQI); ?   return (NoBeautify ? PrintResponse(0) : PrintQResponse(0,1));h }c  I /************************************************************************+5  * reformat an email line to include an alias addressrJ  * this is kind of a hack since we're working on an already-formatted lineJ  ************************************************************************/$ void EmailLine(email,alias,nickname) char *email; char *alias; char *nickname;  {    char scratch[MAXSTR];i1   char *emSpot;		/* beginning of email account */=4   char *alSpot;		/* beginning of nameserver alias */2   char *niSpot;		/* beginning of nickname field */      if (*nickname)   { .     emSpot = index(GetQValue(email), ':') + 2;1     niSpot = index(GetQValue(nickname), ':') + 2;      *index(niSpot,'\n') = 0;     *index(emSpot,'\n') = 0;     /*       * overwrite the email label      */t3     strcpy(niSpot-2-strlen("email to"),"email to");e>     niSpot[-2] = ':';	/* strcpy clobbered the colon; repair */(     sprintf(scratch,"@%s\n",MAILDOMAIN);     strcat(nickname,scratch);*?     strcpy(email,nickname);		/* leave it in the "email" line */n4     *nickname = 0;			/* we're done with the alias */   }i   else if (*alias)   { .     emSpot = index(GetQValue(email), ':') + 2;.     alSpot = index(GetQValue(alias), ':') + 2;     *index(alSpot,'\n') = 0;     *index(emSpot,'\n') = 0;     /*       * overwrite the email label      */*3     strcpy(alSpot-2-strlen("email to"),"email to");s>     alSpot[-2] = ':';	/* strcpy clobbered the colon; repair */(     sprintf(scratch,"@%s\n",MAILDOMAIN);     strcat(alias,scratch);<     strcpy(email,alias);		/* leave it in the "email" line */1     *alias = 0;			/* we're done with the alias */,   }i };  I /************************************************************************(/  * put out a ``not registered'' line with alias*J  ************************************************************************/' void NotRegisteredLine(alias,theOutput)* char *alias; FILE *theOutput; {h   char scratch[MAXSTR];u   register char *cp;      strcpy(scratch,alias);%   cp = index(GetQValue(scratch),':');    strcpy(cp-8,"email to:");h,   strcpy(cp+1," (no address registered)\n");   /* output the line */s   if (NoLabels)c6     fputs(index(GetQValue(scratch),':')+2, theOutput);   else)     fputs(GetQValue(scratch), theOutput);f'   *alias = 0; 				/* done with alias */  }   I /************************************************************************   * process a set of options J  ************************************************************************/ int ProcessOptions(argc,argv)"	 int argc;B char **argv; {    int count = 0;   /*    * options processingt    */o3   for (;argc && **argv=='-'; argc--,argv++,count++)    {t&     for ((*argv)++; **argv; (*argv)++)     {O       switch(**argv)       {L! 	case 'r': NoReformat = 1; break;f! 	case 'R': NoReformat = 0; break;o 	case 'n': NoNetrc = 1; break; 	case 'N': NoNetrc = 0; break; 	case 'm': NoPager = 1; break; 	case 'M': NoPager = 0; break;! 	case 'b': NoBeautify = 1; break;r! 	case 'B': NoBeautify = 0; break;t 	case 'l': NoLabels = 1; break;y 	case 'L': NoLabels = 0; break;: 	case 'C': Confirm = 1; break; 	case 'c': Confirm = 0; break;
 	case 's': 	  if (argv[0][1]) 	  {  	    if (UseHost) free(UseHost);" 	    UseHost = makestr(*argv + 1); 	    goto whilebottom; 	  } 	  else if (argc>1)n 	  {  	    if (UseHost) free(UseHost);  	    UseHost = makestr(argv[1]); 	    argc--,argv++,count++;. 	    goto whilebottom; 	  } 	  elsetK 	    fprintf(stderr,"-%c option given without server hostname.\n", **argv); 	 	  break;h
 	case 't': 	  if (argv[0][1]) 	  {  	    if (DefType) free(DefType);" 	    DefType = makestr(*argv + 1); 	    goto whilebottom; 	  } 	  else if (argc>1)d 	  {  	    if (DefType) free(DefType);  	    DefType = makestr(argv[1]); 	    argc--,argv++,count++;* 	    goto whilebottom; 	  } 	  elseeF 	    fprintf(stderr,"-%t option given without entry type.\n", **argv);	 	  break;*
 	case 'f': 	  if (argv[0][1]) 	  {* 	    if (ReturnFields) free(ReturnFields);' 	    ReturnFields = makestr(*argv + 1);  	    goto whilebottom; 	  } 	  else if (argc>1)o 	  {* 	    if (ReturnFields) free(ReturnFields);% 	    ReturnFields = makestr(argv[1]);o 	    argc--,argv++,count++;o 	    goto whilebottom; 	  } 	  else*F 	    fprintf(stderr,"-%t option given without field list.\n", **argv);	 	  break;*
 	case 'F':( 	  if (ReturnFields) free(ReturnFields); 	  ReturnFields = 0;	 	  break;h
 	case 'T': 	  if (DefType) free(DefType); 	  DefType = 0;r	 	  break; 
 	case 'p': 	  if (isdigit(argv[0][1]))  	  {& 	    UsePort = htons(atoi(*argv + 1)); 	    goto whilebottom; 	  }( 	  else if (argc>1 && isdigit(*argv[1])) 	  {$ 	    UsePort = htons(atoi(argv[1])); 	    argc--,argv++,count++;A 	    goto whilebottom; 	  } 	  elserG 	    fprintf(stderr,"-%c option given without port number.\n", **argv);o	 	  break;L	 	default: 3 	  fprintf(stderr,"Unknown option: -%c.\n",**argv);p       }      }d     whilebottom:;t   }e   return(count); }   I /*************************************************************************  * Process a lineful of optionssJ  ************************************************************************/ OptionLine(line) char *line;i {(   int argc;    char *argv[MAXARGS];   char *token;      if (!line || !*line) return;   J   for (argc=0,token=strtok(line,DELIM);token;argc++,token=strtok(0,DELIM))     argv[argc] = token;    argv[argc] = 0;o   $   return(ProcessOptions(argc,argv)); }*  I /************************************************************************ +  * OpenPager - open the user's chosen pager*J  ************************************************************************/ FILE *OpenPager(doPaging)=
 int doPaging;n {O   char *thePager;    FILE *theOutput;   
 #ifdef VMS@   return(stdout);     /* simpler to skip paging for right now */ #else    if (NoPager || doPaging!=1)*     return(stdout);*   else   {*-     if ((thePager = getenv("PAGER")) == NULL)p #ifdef hpuxP!       thePager = "/usr/bin/more";o #else !       thePager = "/usr/ucb/more";t #endif3     if ((theOutput = popen(thePager, "w")) == NULL)e       theOutput = stdout;e     return(theOutput);   }* #endif }*  I /************************************************************************i4  * makestr - make a copy of a string in malloc-spaceJ  ************************************************************************/ char *makestr(str)
 char *str; {i
   char *copy;(
   int len;      len = strlen(str);   if (copy=malloc(len+1))      strcpy(copy,str);*   return(copy);* }*  I /************************************************************************u0  * issub - is one string a substring of another?J  ************************************************************************/ char *issub(string, sub) char   *string;m char   *sub; {n   int   len;     len = strlen(sub);   for (; *string; string++) #     if (!strncmp(string, sub, len))o       return (string);
   return (0);O }u  H /***********************************************************************6  * EnvOptions - grab some options from the environmentI  ***********************************************************************/e void EnvOptions(name)m char *name;m {=   char buffer[80];   register char *np,*bp;  )   for (np=name,bp=buffer; *np; np++,bp++) ,     *bp = islower(*np) ? toupper(*np) : *np;
   *bp = 0;   OptionLine(getenv(buffer));i }'