 /*4     send logging information to error logger mailbox   */ #include <ssdef.h> #include <starlet.h> #include <iodef.h>* #include <LIB$ROUTINES.H>       /* DECC */* #include <STR$ROUTINES.H>       /* DECC */ #include <lnmdef.h>  #include <libdef.h>  #include <descrip.h> #include <builtins.h>  #include <string.h>  #include <stdlib.h>  #include <stdio.h> #include <stdarg.h>      #include "vms_data.h"  #include "errlog_client.h" #include "mbxq.h"  #include "util.h"    #define ERRLOG_INITIAL 0 #define ERRLOG_OPEN    1 #define ERRLOG_PENDING 2  $ typedef struct PendingQE    Pending;$ typedef struct PendingQE*  pPending;   struct PendingQE {9     RQE  q;      /* put here to keep alignment right ! */      pSTRING msg; };  * static RQE              PendQHead = {0,0};$ #define PendQ           (&PendQHead)% static  int             npending = 0;  #define MAXPENDING      30  ) static longword         locked       = 0; ) static longword         initializing = 0; ) static longword         logging      = 0; ) static pSTRING          prefix       = 0; & static unsigned int     log_level = 2;6 static int              errlog_state = ERRLOG_INITIAL;$ static pMbxQ            ErrLogQueue;( #define LOGMBX          "CRINOIDLOG_MBX"" static $DESCRIPTOR(d_mbx, LOGMBX); #define MAXMSG          256    static void errlog_init(void);! static void errlog_pendAST(void);     int errlog_level(unsigned int l) { *     if (l == L_NULLTYPE) return log_level;E     errlog(0,"Changing logging level from !XL to !XL", log_level, l);      return log_level = l;  }      static void  errlog_init(void)  {      int iss;     word chan;     pSTRING mbx;     pMBX m;   "     iss = _BBSSI(0,&initializing);     if (iss==1) return; /     if (errlog_state == ERRLOG_OPEN) goto done;   $     mbx = translate_logical(LOGMBX);     if (!mbx) goto done;     destroy_STRING(mbx);  !     m = assign_new_MBX(LOGMBX,0);      if (!m) goto done;  Z     ErrLogQueue = MbxQ_new(m, MBXQ$_WRITE|MBXQ$M_RETRY|MBXQ$M_SEGMENT|MBXQ$M_NOLOG, NULL);. /*    MbxQ_setbacklog(ErrLogQueue, 50);     */(     MbxQ_setname(ErrLogQueue, "Errlog");       if (ErrLogQueue) {#         errlog_state = ERRLOG_OPEN;            while (1) {              pPending p;   (             iss = lib$remqhi(PendQ, &p);-             if (iss == LIB$_QUEWASEMP) break; .             if (VMS_ERR(iss)) lib$signal(iss);  S             MbxQ_write(ErrLogQueue, asciz_pSTRING(p->msg), strlen_pSTRING(p->msg)); #             destroy_STRING(p->msg);              free(p);	         }      }    done: #     (void) _BBCCI(0,&initializing); $     if (errlog_state == ERRLOG_OPEN)C         errlog(0,"Starting error logging at level !XL", log_level);  }     1 int errlog(unsigned int level, char *format, ...)  {      va_list ap; ,     int iss, args, i, header, fao_param[32];     int status = SS$_NORMAL;
     int l;     unsigned q;      word length1, length2;1     static $DESCRIPTOR(hcontrol1,"!+{!6XL:!SL}"); 3     static $DESCRIPTOR(hcontrol2,"[!AS !6XL:!SL]"); 1     pSTRING message1, message2, message, control;   "     if (locked) return SS$_NORMAL;I     if (errlog_state == ERRLOG_INITIAL || errlog_state == ERRLOG_PENDING)          errlog_init();H     if (errlog_state != ERRLOG_OPEN && errlog_state != ERRLOG_PENDING) {         status = SS$_SHUT;         goto done;     } B     if ((level & L_LEVMASK)  > (log_level & L_LEVMASK)) goto done;V     if ((level & L_ALLTYPES) != 0 && (level & log_level & L_ALLTYPES) == 0) goto done;       q = level >> L_MINTYPE;      l = level &  L_LEVMASK;   #     message1 = new_STRING2(MAXMSG); 5     if (!message1) {status = SS$_INSFMEM; goto done;} /     control = prefix ? &hcontrol2 : &hcontrol1; =     iss = sys$fao(control, &length1, message1, prefix, q, l); 1     if (VMS_ERR(iss)) {status =  iss; goto done;} '     strlen_pSTRING(message1) = length1;   !     control = new_STRING(format); 4     if (!control) {status = SS$_INSFMEM; goto done;}-     message2 = new_STRING2(MAXMSG - length1); 5     if (!message2) {status = SS$_INSFMEM; goto done;}        va_start(ap,format);       va_count(args); ?     for (i = 0; i < args-1; i++) fao_param[i] = va_arg(ap,int);      va_end(ap); ;     iss = sys$faol(control, &length2, message2, fao_param); 0     if (VMS_ERR(iss)) {status = iss; goto done;}&     strlen_pSTRING(message2)= length2;       destroy_STRING(control);0     message = concat_STRING(message1, message2);     destroy_STRING(message1);      destroy_STRING(message2);   )     if (errlog_state == ERRLOG_PENDING) { >         if (__ATOMIC_INCREMENT_LONG(&npending) < MAXPENDING) {1             pPending p = malloc(sizeof(Pending));                if (p) {!                 p->msg = message; *                 iss = lib$insqti(p,PendQ);#                 if (VMS_ERR(iss)) { ,                     destroy_STRING(message);                     free(p);                 }              } else {(                 destroy_STRING(message);
             }          } else {/             __ATOMIC_DECREMENT_LONG(&npending); $             destroy_STRING(message);	         }      } else {Q         MbxQ_write(ErrLogQueue, asciz_pSTRING(message), strlen_pSTRING(message));           destroy_STRING(message);     }    done:      return status; }      int  islogging(unsigned int level)  {      if (locked) return 0; P     if (errlog_state != ERRLOG_OPEN && errlog_state != ERRLOG_PENDING) return 0;A     if ((level & L_LEVMASK)  > (log_level & L_LEVMASK)) return 0; U     if ((level & L_ALLTYPES) != 0 && (level & log_level & L_ALLTYPES) == 0) return 0; 
     return 1;  }        #include "msg.h"   struct MSGTEXT {
     int code;      char *text;  };   #define MSGDEF(c,t)  {c,t}  $ static struct MSGTEXT messages[] = {.     MSGDEF(MSG$_DELPROC   , "DELETE PROCESS"),.     MSGDEF(MSG$_DEVOFFLIN , "DEVICE OFFLINE"),0     MSGDEF(MSG$_TRMHANGUP , "TERMINAL HANG UP"),-     MSGDEF(MSG$_DEVONLIN  , "DEVICE ONLINE"), 4     MSGDEF(MSG$_ABORT     , "PARTNER ABORTED LINK"),/     MSGDEF(MSG$_CONFIRM   , "CONNECT CONFIRM"), 8     MSGDEF(MSG$_CONNECT   , "INBOUND CONNECT INITIATE"),=     MSGDEF(MSG$_DISCON    , "PARTNER DISCONNECTED - HANGUP"), :     MSGDEF(MSG$_EXIT      , "PARTNER EXITED PREMATURELY"),D     MSGDEF(MSG$_INTMSG    , "INTERRUPT MESSAGE - UNSOLICITED DATA"),:     MSGDEF(MSG$_PATHLOST  , "NFW - PATH LOST TO PARTNER"),.     MSGDEF(MSG$_PROTOCOL  , "PROTOCOL ERROR"),.     MSGDEF(MSG$_REJECT    , "CONNECT REJECT"),6     MSGDEF(MSG$_THIRDPARTY, "THIRD PARTY DISCONNECT"),/     MSGDEF(MSG$_TIMEOUT   , "CONNECT TIMEOUT"), 5     MSGDEF(MSG$_NETSHUT   , "Network shutting down"), :     MSGDEF(MSG$_NODEACC   , "Node has become accessible"),<     MSGDEF(MSG$_NODEINACC , "Node has become inaccessible"),;     MSGDEF(MSG$_EVTAVL    , "Events are available to EVL"), >     MSGDEF(MSG$_EVTRCVCHG , "Event receiver database change"),1     MSGDEF(MSG$_INCDAT    , "X25 INCOMING DATA"), 1     MSGDEF(MSG$_RESET     , "X25 CIRCUIT RESET"),   #     MSGDEF(MSG$_BUSY     , "BUSY"), &     MSGDEF(MSG$_ENVDATA  , "ENVDATA"),#     MSGDEF(MSG$_IDLE     , "IDLE"), %     MSGDEF(MSG$_LOGLEV   , "LOGLEV"), %     MSGDEF(MSG$_ERRLOG   , "ERRLOG"), (     MSGDEF(MSG$_HEARTBEAT, "HEARTBEAT"),%     MSGDEF(MSG$_LUBDUB   , "LUBDUB"), (     MSGDEF(MSG$_STUBREADY, "STUBREADY"),'     MSGDEF(MSG$_USERNAME , "USERNAME"), (     MSGDEF(MSG$_PROCPRIVS, "PROCPRIVS"),(     MSGDEF(MSG$_PROCQUOTA, "PROCQUOTA"),(     MSGDEF(MSG$_PROCFLAGS, "PROCFLAGS"),'     MSGDEF(MSG$_STARTPID , "STARTPID"), (     MSGDEF(MSG$_PROCSTART, "PROCSTART"),'     MSGDEF(MSG$_PROCPROG , "PROCPROG"), (     MSGDEF(MSG$_PROCPRIOR, "PROCPRIOR"),'     MSGDEF(MSG$_PROCTMBX , "PROCTMBX"), &     MSGDEF(MSG$_PROCNAME , "PROCNAME") };   char * msg_text(int code) { 
     int j;/     static char unknown[] = "Unknown MSG code"; 9     if (code <= 0 || code >= MSG$_MAXMSG) return unknown;   C     for (j = 0; j < sizeof(messages)/sizeof(struct MSGTEXT); j++) { >         if (messages[j].code == code) return messages[j].text;     }      return unknown;  }   : #define TOHEX(i) ((i) < 0x0a ? '0'+(i) : 'A' + (i) - 0x0A)   int 5 logdump(int level, char *header, void *buf, int size)  { 
     int j, l; (     char c, *p, *pb, cbuf[17], bbuf[60];  "     if (locked) return SS$_NORMAL;I     if (errlog_state == ERRLOG_INITIAL || errlog_state == ERRLOG_PENDING)          errlog_init();F     if (errlog_state != ERRLOG_OPEN && errlog_state != ERRLOG_PENDING)         return SS$_SHUT;A     if ((level & L_LEVMASK)  > (log_level & L_LEVMASK)) return 1; U     if ((level & L_ALLTYPES) != 0 && (level & log_level & L_ALLTYPES) == 0) return 1;        pb = (char *) buf;     while (size > 0) {#         l = (size > 16)? 16 : size;            p = bbuf; !         for (j = 0; j < l; j++) {              c = *pb++;(             *p++ = TOHEX((c>>4) & 0x0F);#             *p++ = TOHEX(c & 0x0F);              *p++ = ' '; (             cbuf[j] = (c == 0)? '.' : c;	         }          *p++ = '\0';         cbuf[l] = '\0';          printable(cbuf);<         errlog(level,"!AZ [!AZ] |!AZ|", header, bbuf, cbuf);           size -= l;     }      return SS$_NORMAL; }    char * dumpstring(char *s, int n) { $     int len = 1+(3*n-1)+1+1+1+n+1+1;
     int j;     char *p, *p0;        if (n < 0) return 0;       p = p0 = malloc(len);      if (!p) return 0;        *p = 0;      if (n == 0) return p;        *p++ = '[';      for (j = 0; j < n; j++) {          char c = s[j];$         *p++ = TOHEX((c>>4) & 0x0F);         *p++ = TOHEX(c & 0x0F);          *p++ = ' ';      }      *(p-1) = ']';      *p++ = ' ';      *p++ = '|';        for (j = 0; j < n; j++) {          char c = s[j];         if (!c) c = '.';         *p++ = c;      }      *p++ = '|';      *p = 0;      printable(p0);     return p0; }        void errlog_lock(void)  {      locked = 1;  }    void errlog_unlock(void)  {      locked = 0;  }      void errlog_pending(int tmax) {      int iss;     longword time[2];   ,     if (errlog_state == ERRLOG_OPEN) return;"     errlog_state = ERRLOG_PENDING;       if (tmax <= 0) return;       sec2vms(tmax, time);  1     iss = sys$setimr(0,time,&errlog_pendAST,0,0);  }    static void  errlog_pendAST(void) {      int iss;     pPending p;   ,     if (errlog_state == ERRLOG_OPEN) return;"     errlog_state = ERRLOG_INITIAL;       while (1) { $         iss = lib$remqhi(PendQ, &p);)         if (iss == LIB$_QUEWASEMP) break;           if (VMS_ERR(iss)) break;           destroy_STRING(p->msg);          free(p);     }  }      void errlog_prefix(char *s) { 0     if (prefix) prefix = destroy_STRING(prefix);     prefix = new_STRING(s);  } 