 /*/     standalone process to do mailbox -> logfile     */  #include <stdio.h> #include <string.h>  #include <ssdef.h> #include <starlet.h> #include <iodef.h> #include <stdlib.h>  #include <libdef.h> * #include <LIB$ROUTINES.H>       /* DECC */ #include <lnmdef.h>  #include <psldef.h>  #include <prvdef.h>  #include <descrip.h> #include <rms.h>   #include "vms_data.h"  #include "util.h"  #include "errlog_client.h"  , #define MAXMSG          DEFAULT_MAILBOX_SIZE( #define LOGMBX          "CRINOIDLOG_MBX"/ #define ERRMBX          "CRINOIDLOG_STDERR_MBX" , #define COMMAND_LOGICAL "CRINOIDLOG_COMMAND") #define FILE_LOGICAL    "CRINOIDLOG_FILE"    #define TYPE_ERRLOG     1  #define TYPE_STDERR     2  #define TYPE_TIMER      3    typedef struct LOGNTRY    Log; typedef struct LOGNTRY*  pLog; struct LOGNTRY {
     int type;      word chan;     IOSB iosb;     char buffer[MAXMSG+1];     int  full; };   typedef struct LNMDEF    LNM;  typedef struct LNMDEF*  pLNM;    struct LNMDEF {      pSTRING name;      pSTRING equiv;     pSTRING table;     byte    acmode;  };   static Log             ltimer; static Log             lerrlog;  static Log             lstderr;  static struct FAB      outfab; static struct RAB      outrab;# static longword        t_expire[2]; $ static char            logfile[256];   #define LOGFLUSHTIME   20 * #define LOGFILE        "LOGGER_OUTPUT.LOG"   int     initialize(void);  int     set_timer(void); int     logentry(pLog p); " void    queue_logmbx_read(pLog p); void    logger_AST(pLog p);  int     check_for_stop(); ' pLNM    translate_logical2(char *name); = int     define_logical(char *name, char *value, char *table);  int     openlog(void); int     closelog(void);  pLNM    destroy_LNM(pLNM l);     int  main() { *     int iss, activity, do_flush, do_check;     int dirty = 0;     int run = 1;     pSTRING log;  <     errlog_lock();      /* no logging while we're logging */  *     log = translate_logical(FILE_LOGICAL);7     strcpy(logfile, log ? asciz_pSTRING(log): LOGFILE); !     if (log) destroy_STRING(log);          iss = initialize(); !     if (VMS_ERR(iss)) return iss;        while (run) {          iss = sys$hiber();%         if (VMS_ERR(iss)) return iss;   +         activity = do_flush = do_check = 0;            if (lerrlog.full) {              activity = 1;              dirty++;N             do_check |= strstr(lerrlog.buffer, "CRINOIDLOG_COMMAND:") != NULL;%             iss = logentry(&lerrlog); )             if (VMS_ERR(iss)) return iss; (             queue_logmbx_read(&lerrlog);	         }            if (lstderr.full) {              activity = 1;              dirty++;N             do_check |= strstr(lstderr.buffer, "CRINOIDLOG_COMMAND:") != NULL;%             iss = logentry(&lstderr); )             if (VMS_ERR(iss)) return iss; (             queue_logmbx_read(&lstderr);	         }            if (ltimer.full) {/             do_flush = !activity && dirty != 0;                do_check = 1;              iss = set_timer();)             if (VMS_ERR(iss)) return iss; 	         }            if (do_check) { $             run = !check_for_stop();	         }            do_flush |= dirty > 10;          if (do_flush) { %             iss = sys$flush(&outrab); )             if (VMS_ERR(iss)) return iss;              dirty = 0;	         }      }      iss = closelog();      return iss;  }      int  initialize(void) {      int iss;     longword pmask = 0x1100;     word len, ch_mbx, ch_mbx2;&     pSTRING mbx1 = new_STRING(LOGMBX);&     pSTRING mbx2 = new_STRING(ERRMBX);     pLNM q;      pPrivs p0, p1;  E     q = translate_logical2(LOGMBX);     /* another logger running? */      if (q) return SS$_ABORT;     destroy_LNM(q);   D     /* temp mbx's go into system table where others can find them */  W     iss = define_logical("LNM$TEMPORARY_MAILBOX","LNM$SYSTEM","LNM$PROCESS_DIRECTORY"); !     if (VMS_ERR(iss)) return iss;   7     /* need SYSNAM priv to write to the system table */        p0 = Current_Privs();      if (!p0->prv$v_sysnam) {         p1 = new_Privs();          p1->prv$v_sysnam = 1;          iss = Set_Privs(p1);,         if (VMS_ERR(iss)) return SS$_NOPRIV;     }        /* create log mailbox */  C     iss = sys$crembx(0,&ch_mbx,MAXMSG,pmask,0,PSL$C_USER,mbx1,0,0); !     if (VMS_ERR(iss)) return iss;      lerrlog.chan = ch_mbx;     lerrlog.type = TYPE_ERRLOG;        /* create stderr mailbox */   D     iss = sys$crembx(0,&ch_mbx2,MAXMSG,pmask,0,PSL$C_USER,mbx2,0,0);!     if (VMS_ERR(iss)) return iss;      lstderr.chan = ch_mbx2;      lstderr.type = TYPE_STDERR;        /* reset privs */        if (!p0->prv$v_sysnam) {         Reset_Privs(p1);         destroy_Privs(p1);     }      destroy_Privs(p0);       /* open the logfile */       iss = openlog();!     if (VMS_ERR(iss)) return iss;   F     /* set up flush timer ... also used for checking command logical*/  $     sec2vms(LOGFLUSHTIME, t_expire);     ltimer.type = TYPE_TIMER;      iss = set_timer();!     if (VMS_ERR(iss)) return iss;   !     /* queue the mailbox reads */         queue_logmbx_read(&lerrlog);      queue_logmbx_read(&lstderr);       return SS$_NORMAL; }      int  set_timer(void)  {      int iss;       ltimer.full = 0;  ;     iss = sys$setimr(0, t_expire, &logger_AST, &ltimer, 0); !     if (VMS_ERR(iss)) return iss;        return SS$_NORMAL; }        int  logentry(pLog p) {      int iss, length;1     static $DESCRIPTOR(d_format1,"(!8XL !%D): "); 8     static $DESCRIPTOR(d_format2,"(!8XL STDERR !%D): ");     $DESCRIPTOR(d_buffer,"");      pSTRING pFormat;%     char header_buffer[100+2*MAXMSG];        iss = p->iosb.status;      if (iss != SS$_ENDOFFILE) { *         if (VMS_ERR(iss)) lib$signal(iss);           pFormat = &d_format1; 9         if (p->type == TYPE_STDERR) pFormat = &d_format2;   /         d_buffer.dsc$a_pointer = header_buffer; 7         d_buffer.dsc$w_length  = sizeof(header_buffer);          length = 0; C         iss = sys$fao(pFormat,&length,&d_buffer,p->iosb.dvispec,0); *         if (VMS_ERR(iss)) lib$signal(iss);  ?         memcpy(header_buffer+length, p->buffer, p->iosb.count);   2         outrab.rab$w_rsz = length + p->iosb.count;)         outrab.rab$l_rbf = header_buffer;          iss = sys$put(&outrab); <         if (VMS_ERR(iss)) lib$signal(iss, outrab.rab$l_stv);     }      return SS$_NORMAL;   }        void queue_logmbx_read(pLog p)  {      int iss;       p->full  = 0;      p->iosb.status = 0;   Z     iss = sys$qio(0,p->chan,IO$_READVBLK,&p->iosb,&logger_AST,p,p->buffer,MAXMSG,0,0,0,0);&     if (VMS_ERR(iss)) lib$signal(iss); }    void logger_AST(pLog p) {      int iss;       p->full = 1;"     if (p->iosb.count <= MAXMSG) {(         p->buffer[p->iosb.count] = '\0';     } else {         p->buffer[0] = '\0';     }      iss = sys$wake(0,0);&     if (VMS_ERR(iss)) lib$signal(iss);   }    int  check_for_stop() {      int iss, stop = 0;     pLNM q;      pPrivs p0, p1;  ,     q = translate_logical2(COMMAND_LOGICAL);       if (q) {;         stop = strcmp(asciz_pSTRING(q->equiv),"STOP") == 0;   <         if (strcmp(asciz_pSTRING(q->equiv),"NEWLOG") == 0) {             iss = closelog(); '             if (VMS_ERR(iss)) return 1;              iss = openlog();'             if (VMS_ERR(iss)) return 1; 	         }            p0 = Current_Privs();           if (!p0->prv$v_sysnam) {             p1 = new_Privs(); !             p1->prv$v_sysnam = 1;               iss = Set_Privs(p1);'             if (VMS_ERR(iss)) return 1; 	         }   6         iss = sys$dellnm(q->table,q->name,&q->acmode);#         if (VMS_ERR(iss)) return 1;           if (!p0->prv$v_sysnam) {             Reset_Privs(p1);             destroy_Privs(p1);	         }          destroy_Privs(p0);           destroy_LNM(q);      }      return stop; }        pLNM translate_logical2(char *name) {      int iss;&     $DESCRIPTOR(table,"LNM$FILE_DEV");     pItemList i;     word l_equ, l_tab;  !     pLNM l = malloc(sizeof(LNM));      if (!l) return 0;         l->name  = new_STRING(name);      l->equiv = new_STRING2(256);      l->table = new_STRING2(256);       i = new_ItemList(3);\     i = add_Item(i, LNM$_STRING, asciz_pSTRING(l->equiv), strlen_pSTRING(l->equiv), &l_equ);\     i = add_Item(i, LNM$_TABLE,  asciz_pSTRING(l->table), strlen_pSTRING(l->table), &l_tab);C     i = add_Item(i, LNM$_ACMODE, &l->acmode, sizeof(l->acmode), 0);   3     iss = sys$trnlnm(0,&table,l->name,0,(char *)i);        destroy_ItemList(i);     if (iss == SS$_NOLOGNAM)         return destroy_LNM(l);  &     if (VMS_ERR(iss)) lib$signal(iss);%     strlen_pSTRING(l->equiv) = l_equ; %     strlen_pSTRING(l->table) = l_tab; *     asciz_pSTRING(l->equiv)[l_equ] = '\0';*     asciz_pSTRING(l->table)[l_tab] = '\0';  
     return l;  }        int 
 openlog(void)  {      int iss;       /* open the log file */        outfab = cc$rms_fab;!     outfab.fab$b_fac = FAB$M_PUT; $     outfab.fab$b_shr = FAB$M_SHRGET;     outfab.fab$l_fna = logfile; '     outfab.fab$b_fns = strlen(logfile); !     outfab.fab$b_org = FAB$C_SEQ;       outfab.fab$b_rat = FAB$M_CR;!     outfab.fab$b_rfm = FAB$C_VAR;        iss = sys$create(&outfab);!     if (VMS_ERR(iss)) return iss;        outrab = cc$rms_rab;     outrab.rab$l_fab = &outfab;        iss = sys$connect(&outrab); !     if (VMS_ERR(iss)) return iss;      return SS$_NORMAL; }    int  closelog(void) {      int iss;       iss = sys$flush(&outrab); !     if (VMS_ERR(iss)) return iss;  /*      iss = sys$truncate(&outrab);!     if (VMS_ERR(iss)) return iss;  */"     iss = sys$disconnect(&outrab);!     if (VMS_ERR(iss)) return iss;        iss = sys$close(&outfab); !     if (VMS_ERR(iss)) return iss;      return SS$_NORMAL; }    pLNM destroy_LNM(pLNM l)  {      if (!l) return 0; *     if (l->name ) destroy_STRING(l->name);+     if (l->equiv) destroy_STRING(l->equiv); +     if (l->table) destroy_STRING(l->table);      free(l);
     return 0;  } 