 /*$     A single tentacle of the CRINOID */   #include <stdio.h> #include <errno.h> #include <ctype.h> #include <stat.h>  #include <signal.h>    #include <ssdef.h> #include <starlet.h> #include <libdef.h>  #include <lnmdef.h>  #include <iodef.h> #include <descrip.h> #include <psldef.h>  #include <jpidef.h>  #include <dvidef.h>  #include <impdef.h> * #include <LIB$ROUTINES.H>       /* DECC */   #include "EXTERN.h"  #include "perl.h"    #include "mbxq.h"  #include "pipe2.h" #include "msg.h" #include "util.h"  #include "tentacle.h"  #include "perlxsi.c" #include "errlog_client.h"  / int decc$stat(char *file, struct stat *buffer); % #define SIGNAL_ERR(s)   lib$signal(s)   * static longword             MasterPID = 0;3 static int                  Heartbeats_Pending = 0; - static int                  work_in_progress; ( static pENV                 EnvBase = 0;/ static pSCRIPT              Script_Base = NULL; , static int                  Script_Max  = 5;, static int                  Script_Count= 0;$ static pMbxQ                StatusQ;% static pMbxQ                CommandQ; % static longword             StatusEF; 5 static RQE                  GotMsgQueueHead = {0, 0}; . #define GotMsgQ             (&GotMsgQueueHead)- static PerlInterpreter      *script_perl = 0; 2 #define MASTER_SCRIPT       "CRINOID_home:oyster."2 #define MASTER_OPT1         "-ICRINOID_root:[lib]" #define HEARTBEAT_TIMEOUT   30# #define DEFAULT_LOG_LEVEL   L_ERROR        /*/  *  status goes back to a mailbox on SYS$OUTPUT @  *      note that we don't have an input, until we create one...  */   + int main(int argc, char** argv, char** env)  {      int iss, net_shut;     longword time[2];      pMbxE e;
     pMM m;     pMBX commandMBX;     pMBX statusMBX;      pSTRING loglev;        errlog_pending(20);      errlog_prefix("TENTACLE");%     errlog(L_CRITICAL,"starting up");   4     loglev = translate_logical("TENTACLE_LOGLEVEL");K     errlog_level(loglev ? atoi(asciz_pSTRING(loglev)) : DEFAULT_LOG_LEVEL); '     if (loglev) destroy_STRING(loglev);        signal(SIGABRT, SIG_IGN);   /     statusMBX = assign_new_MBX("SYS$OUTPUT",0); D     errlog(L_BABBLE,"Status MBX  opened, unit !UW",statusMBX->unit);,     if (!statusMBX) SIGNAL_ERR(SS$_INSFMEM);I     StatusQ = MbxQ_new(statusMBX, MBXQ$_WRITE|MBXQ$M_RETRY, &status_AST); *     if (!StatusQ) SIGNAL_ERR(SS$_INSFMEM);  $     commandMBX= new_MBX(0, MAX_MSG);E     errlog(L_BABBLE,"Command MBX opened, unit !UW",commandMBX->unit);         iss = lib$get_ef(&StatusEF);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss);     iss = sys$clref(StatusEF);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss);     iss = sec2vms(30, time);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss);  .     iss = sys$setimr(StatusEF, time, 0, 0, 0);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss);  4     send_status(MSG$_DEVONLIN,commandMBX->unit,0,0);       iss = sys$waitfr(StatusEF); &     if (VMS_ERR(iss)) SIGNAL_ERR(iss);H     errlog(L_BABBLE,"Response from DEVONLINE, MasterPID:!XL",MasterPID);)     if (MasterPID == 0) return SS$_ABORT;   >     CommandQ = MbxQ_new(commandMBX, MBXQ$_READ, &command_AST);+     if (!CommandQ) SIGNAL_ERR(SS$_INSFMEM);        init_ENV();   4     errlog(L_BABBLE,"starting to process commands");     init_perl();       heartbeat_AST();     net_shut = 0;        while (!net_shut) { &         iss = lib$remqhi(GotMsgQ, &e);$         if (iss == LIB$_QUEWASEMP) {=             errlog(L_BABBLE,"Entering hibernation at !%T",0);              iss = sys$hiber();.             if (VMS_ERR(iss)) SIGNAL_ERR(iss);"         } else if (VMS_ERR(iss)) {G             errlog(L_ERROR,"Error on command dequeue, status=!XL",iss);              SIGNAL_ERR(iss);         } else {             m = (pMM) e->buf; p             errlog(L_BABBLE,"Message, code = !UL (!AZ) from PID=!XL",m->code,msg_text(m->code),e->iosb.dvispec);/             if (e->iosb.dvispec != MasterPID) { S                 errlog(L_ERROR,"Unsolicited message from PID=!XL",e->iosb.dvispec);              } else {"                 switch (m->code) {&                     case MSG$_CONNECT:$                         init_perl();,                         handle_connection();#                         init_ENV(); D                         send_status(MSG$_IDLE,commandMBX->unit,0,0);                         break;$                     case MSG$_ABORT:@                         errlog(L_INFO,"ABORT message received");#                         init_ENV(); D                         send_status(MSG$_IDLE,commandMBX->unit,0,0);                         break;&                     case MSG$_NETSHUT:B                         errlog(L_INFO,"NETSHUT message received");%                         net_shut = 1;                          break;&                     case MSG$_ENVDATA:&                         do_envdata(e);                         break;%                     case MSG$_ERRLOG: %                         do_errlog(e);                          break;%                     case MSG$_LOGLEV: %                         do_loglev(e);                          break;                 } 
             }              MbxQ_dispose(e);	         }      }      return SS$_NORMAL; }          void command_AST(pMbxE e) {      int iss;     word chan;     pMM m = (pMM) e->buf;   n     errlog(L_BABBLE,"Command_AST fired, iss=0x!XW code=!UW (!AZ)",e->iosb.status, m->code, msg_text(m->code));       iss = e->iosb.status; 9     if (VMS_ERR(iss)) SIGNAL_ERR(iss);      /* I guess */        switch (m->code) {"             case MSG$_LUBDUB     :%                 Heartbeats_Pending--;                   MbxQ_dispose(e);                 return; "             case MSG$_ABORT      :'                 if (work_in_progress) { 5                     errlog(L_ERROR,"SIGABRT raised"); #                     raise(SIGABRT);                  }                  break;"             case MSG$_DISCON     :"             case MSG$_EXIT       :"             case MSG$_PATHLOST   :"             case MSG$_PROTOCOL   :"             case MSG$_THIRDPARTY :"             case MSG$_TIMEOUT    :"             case MSG$_NETSHUT    :&                 SIGNAL_ERR(SS$_ABORT);     }   !     iss = lib$insqti(e, GotMsgQ); &     if (VMS_ERR(iss)) SIGNAL_ERR(iss);       iss = sys$wake(0,0);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss); }      int 1 send_status(word code, word unit, char *s, int n)  {      int iss;	     MM M; 1     int length = sizeof(M.code) + sizeof(M.unit);        M.code = code;     M.unit = unit;[     errlog(L_BABBLE,"returning status code=!UW (!AZ) unit=!UW",code, msg_text(code), unit);         if (s && n > 0 && n < 255) {         M.info[0] = n;          memcpy(&M.info+1, s, n);         length += n + 1;     }   +     return MbxQ_write(StatusQ, &M, length);  }    void status_AST(pMbxE e)  {      if (MasterPID == 0) { $         MasterPID = e->iosb.dvispec;         sys$setef(StatusEF);     }  }      int  handle_connection()  {      pENV e;      char dev[100];     pMBX m_in = 0, m_out = 0;      pPipe2 p_stdin  = 0;     pPipe2 p_stdout = 0;     pPipe2 p_stderr = 0;  C     errlog(L_INFO,"CONNECT message received, running Perl script");   "     e = find_ENV("CRINOID:>PERL");
     if (!e) {          tu_strcpy(dev, "NL:");     } else {,         m_in   = assign_new_MBX(e->value,0);         if (!m_in) goto done; '         m_out  = new_MBX(0,m_in->size); '         p_stdin = Pipe_new(m_in,m_out); +         sprintf(dev,"_MBA%d:",m_out->unit);      }      freopen(dev,"rb",stdin);2     errlog(L_BABBLE,"stdin remapped to !AZ", dev);     m_in = m_out = 0;   "     e = find_ENV("CRINOID:<PERL");
     if (!e) {          tu_strcpy(dev, "NL:");     } else {.         m_out    = assign_new_MBX(e->value,0);         if (!m_out) goto done;*         m_in     = new_MBX(0,m_out->size);(         p_stdout = Pipe_new(m_in,m_out);         Pipe_pack(p_stdout);*         sprintf(dev,"_MBA%d:",m_in->unit);     } '     freopen(dev,"wb",stdout,"ctx=bin"); 3     errlog(L_BABBLE,"stdout remapped to !AZ", dev);      m_in = m_out = 0;   #     e = find_ENV("CRINOID:2<PERL"); 
     if (!e) {          tu_strcpy(dev, "NL:");     } else {.         m_out    = assign_new_MBX(e->value,0);*         m_in     = new_MBX(0,m_out->size);(         p_stderr = Pipe_new(m_in,m_out);*         sprintf(dev,"_MBA%d:",m_in->unit);     } '     freopen(dev,"wb",stderr,"ctx=bin"); 3     errlog(L_BABBLE,"stderr remapped to !AZ", dev);      m_in = m_out = 0;        setbuf(stdin,NULL);      /*setbuf(stdout,NULL);  */     setbuf(stderr,NULL);     clearerr(stdin);       work_in_progress = 1;      exec_perl();     signal(SIGABRT, SIG_IGN);      work_in_progress = 0;        fflush(stdout);      fsync(fileno(stdout));     Pipe_flush(p_stdout);      printf("</DNETCGI>");        fflush(stdout);      fsync(fileno(stdout));     fflush(stderr);      fsync(fileno(stderr));   done: #     if (m_in)    destroy_MBX(m_in); %     if (m_out)    destroy_MBX(m_out); '     if (p_stdin) Pipe_destroy(p_stdin); *     if (p_stdout) Pipe_destroy2(p_stdout);*     if (p_stderr) Pipe_destroy2(p_stderr);
     return 1;  }    int  init_perl(void)  {      int iss, curscripttime; 9     char *embed_argv[] = {0, MASTER_OPT1, MASTER_SCRIPT};u     static int scripttime = -1;      struct stat st;i    L     curscripttime = (decc$stat(MASTER_SCRIPT, &st) != -1) ? st.st_mtime : 0;F     if (script_perl && curscripttime == scripttime) return SS$_NORMAL;     scripttime = curscripttime;h       if (script_perl) {K         errlog(L_INFO,"Master script changed, reloading perl interpreter");*#         perl_destruct(script_perl);c         perl_free(script_perl);h     }c     script_perl = perl_alloc();       perl_construct(script_perl);.     if (!script_perl) SIGNAL_ERR(SS$_INSFMEM);  *     iss = perl_parse(script_perl, xs_init,=         sizeof(embed_argv)/sizeof(char *), embed_argv, NULL);t2     if (iss != 0 && VMS_ERR(iss)) SIGNAL_ERR(iss);      iss = perl_run(script_perl);     return iss;t }      int  exec_perl(void)e {      int iss;     pENV e1, e2;     char *args[] = {0, 0, 0};   #     e1 = find_ENV("SCRIPT_BINDIR");t&     e2 = find_ENV("SCRIPT_BARE_NAME");      if (e1) args[0] = e1->value;      if (e2) args[1] = e2->value;;     errlog(L_BABBLE,"running !AZ/!AZ",e1->value,e2->value);n       construct_perlENV();E     iss = perl_call_argv("main::RunScript",G_DISCARD | G_EVAL, args);g
     return 1;& }M     void% send_perlENV(char *name, char *value)_ {l     dSP;     PUSHMARK(sp); (     XPUSHs(sv_2mortal(newSVpv(name,0)));)     XPUSHs(sv_2mortal(newSVpv(value,0)));f     PUTBACK;)     perl_call_pv("SetSafeENV",G_DISCARD);_;     errlog(L_BABBLE, "$PerlENV{'!AZ'} = '!AZ'",name,value);T }    int  construct_perlENV(void)  {i     pENV e = EnvBase;n       while (e) {a         if (e->state) { +             send_perlENV(e->name,e->value); 	         }m         e = e->next;     } 
     return 1;m }d   pENV+ add_ENV(char *name, char *value, int state)  {r
     char *qp;)     pENV p;g       if (p = find_ENV(name)) {L         qp = p->value;+         p->value = malloc(strlen(value)+1);E         if (!p->value) {             if (qp) free(qp);G             return 0;_	         }          strcpy(p->value,value);e         if (qp) free(qp);      } else {'         p = (pENV) malloc(sizeof(ENV));T         if (!p) return 0;,)         p->name = malloc(strlen(name)+1);n         if (!p->name) {              free(p);             return 0;n	         }X         strcpy(p->name, name);  +         p->value = malloc(strlen(value)+1);S         if (!p->value) {'             if (p->name) free(p->name);,             free(p);             return 0;i	         }          strcpy(p->value,value);          p->next = EnvBase;         EnvBase = p;     }t     p->state = state;R
     return p;E }i   pENV find_ENV(char *name) {;     pENV p = EnvBase;        while (p) { 0         if (strcmp(p->name,name) == 0) return p;         p = p->next;     }R
     return 0;e }s   void clear_ENV(void)n {X     pENV p, qp = EnvBase;y         while (p=qp) {         qp = p->next;N#         if (p->name) free(p->name);s%         if (p->value) free(p->value);s         free(p);     }I     EnvBase = 0; }O   void init_ENV(void) {_
     int j;     char *default_blank[] = {          "SUBFUNCTION",<         "SERVER_SOFTWARE", "SERVER_NAME", "SERVER_PROTOCOL",5         "SERVER_PORT", "REQUEST_METHOD", "PATH_INFO", 8         "PATH_TRANSLATED", "SCRIPT_NAME", "SCRIPT_PATH",D         "QUERY_STRING", "REMOTE_USER", "REMOTE_ADDR", "REMOTE_PORT",C         "REMOTE_HOST", "AUTH_TYPE", "REMOTE_IDENT", "CONTENT_TYPE",           "CONTENT_LENGTH", NULL};       clear_ENV();  0     for (j = 0; default_blank[j] != NULL; j++) {'         add_ENV(default_blank[j],"",0);g     }R  /     add_ENV("GATEWAY_INTERFACE", "CGI/1.0", 1);  }    void dump_ENV(FILE *fp) {      pENV p = EnvBase;        while (p) { K         fprintf(fp,"Env{\"%s\"}(%d) = \"%s\"\n",p->name,p->state,p->value);t         p = p->next;     }; }      void do_errlog(pMbxE e) {M   }P   void do_loglev(pMbxE e) {L     pMM m = (pMM) e->buf;      unsigned level;.  +     memcpy(&level, m->info, sizeof(level));        errlog_level(level); }      void do_envdata(pMbxE e)  {      pMM  m     = (pMM) e->buf;     char *s    = m->info;d,     char *send = (char *) m + e->iosb.count;     char *p, *q;
     int n;     static char *cname, *cval;*     static int   lname,  lval, doing_name;       if (m->unit == 0) {a         init_ENV();          doing_name = 1;L)         cname = malloc(1); *cname = '\0'; )         cval  = malloc(1); *cval  = '\0';          lname = lval = 0;L     }n       while (s < send) {         p = s;#         while (*p && p < send) p++;_         n = p-s;         if (doing_name) {F"             q = malloc(lname+n+1);             strcpy(q,cname);             free(cname);             cname = q;             strncat(cname,s,n);              cname[n] = '\0';             lname += n; $             if (!*p) doing_name = 0;         } else {!             q = malloc(lval+n+1);              strcpy(q, cval);             free(cval);M             cval = q;              strncat(cval,s,n);             cval[n] = '\0';              lval += n;             if (!*p) {&                 add_ENV(cname,cval,1);                 free(cname);                 free(cval);)1                 cname = malloc(1); *cname = '\0';M1                 cval  = malloc(1); *cval  = '\0';d!                 lname = lval = 0;.                 doing_name = 1;)
             } 	         }t         s = p + 1;     }  }N       void heartbeat_AST(void)  {      int iss;     static int initialized = 0;D      static longword t_expire[2];  !     if (Heartbeats_Pending > 0) {d8         errlog(L_CRITICAL,"Heartbeat stopped, exiting");         fake_netshut();          return;_     }s       if (!initialized) {r-         sec2vms(HEARTBEAT_TIMEOUT, t_expire);          initialized = 1;     }   7     iss = sys$setimr(0,t_expire, &heartbeat_AST, 0, 0);C&     if (VMS_ERR(iss)) SIGNAL_ERR(iss);     Heartbeats_Pending++;_&     send_status(MSG$_HEARTBEAT,0,0,0); }L   void fake_netshut(void) {R     int iss;     static MbxE E;     pMbxE e = &E;      pMM   m = (pMM) e->buf;         e->iosb.dvispec = MasterPID;     m->code = MSG$_NETSHUT;q  !     iss = lib$insqhi(e, GotMsgQ);)     iss = sys$wake(0,0); } sys$wake(0,0);&     if (VMS_ERR(iss)) SIGNAL_ERR(iss); }      int 1 send_status(word code, word unit, char *s, int n)  {      int iss;	     MM M; 1     int length = sizeof(M.code) + sizeof(M.unit);        M.code = code;     M.unit = unit;[     errlog(L_BABBLE,"returning status code=!UW (!AZ) unit=!UW",code, msg_text(code), unit);         if (s && n > 0 && n < 255) {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   