dnl Copyright 1988-92, 1994-95, 1999, 2000 
dnl Free Software Foundation, Inc. 
dnl Please see COPYING for a description of your rights and 
dnl responsibilities with this software. 
dnl 
dnl Automatically generated from files in the m4 directory. 
dnl Do not edit. 
dnl 
dnl 
dnl From m4/checkprog.m4 -- 
dnl 
AC_DEFUN(GST_CHECK_PROG, [
  AC_CHECK_PROG([$1], [$2], [$2], ifelse([$3], , $ac_aux_dir/missing [$2], [$3]))
])dnl
dnl 
dnl 
dnl From m4/dld_api.m4 -- 
dnl 
AC_DEFUN(GST_KIND_DLD, [

# Test even if we don't use dynamic loading
AC_MSG_CHECKING(which dynamic loading API is to be used)
exec AC_FD_MSG>/dev/null

AC_ARG_WITH(dld, 
	[  --with-dld=path         set path to dynamic linking libraries
  --without-dld      	  don't look for a way to enable dynamic linking])


test "$with_dld" && test -d "$with_dld" && LDFLAGS="$LDFLAGS -L$with_dld"

which=
# for syntax is: Header Library Function Result
DLD_MODULE=none
test $PLATFORM = win32 && DLD_MODULE=win32
for item in	ltdl.h ltdl lt_dlopenext ltdl		\
		dlfcn.h dl dlopen libdl			\
		dl.h dld shl_load hpux			\
  		dld.h dld dld_get_func gnu		\
		kernel/image.h c load_add_on beos	\
		ldfcn.h ld load aix			; do
  which=x$which
  case $which in
    x)    header=$item ;;
    xx)   lib=$item ;;
    xxx)  func=$item ;;
    xxxx) which=
      AC_CHECK_HEADER($header, [
	AC_CHECK_LIB($lib, $func, [
	  test $lib = c || LIBS="$LIBS -l$lib"
	  DLD_MODULE=$item
	  break
        ])
      ]) ;;
  esac
done

test "$silent" != yes && exec AC_FD_MSG>&1
AC_MSG_RESULT($DLD_MODULE)

DLD_MODULE=dld_$DLD_MODULE
test "$with_dld" = no && DLD_MODULE=dld_none
if test "$DLD_MODULE" != dld_none; then
  AC_DEFINE(HAVE_DLD)
  AC_CACHE_CHECK(for leading _ in shared libraries, gst_cv_dlsym_underscore,
    path_to_libc=`ls /lib/lib*c.so /usr/lib/lib*c.so \
	     /lib/lib*c.sl /usr/lib/lib*c.sl \
             /bin/cygwin*.dll /gnuwin32/cygwin*.dll \
             /lib/lib*c.a* /usr/lib/lib*c.a 2> /dev/null | sed -n 1p`

    AC_TRY_RUN([
      #ifdef OLDCC
      typedef char *voidPtr;
      #else
      typedef void *voidPtr;
      #endif
      #define __GSTDLD__			/* avoid including dld_gst.h */
      #include "$srcdir/lib/$DLD_MODULE.c"	/* include the wrappers here */
      main(argc, argv)
           int	argc;
           char	**argv;
      {
	voidPtr lib;
	gst_dld_init(*argv);
	lib = gst_dld_open("$path_to_libc");
	exit(gst_dld_sym(lib, "printf") == NULL);
      }], gst_cv_dlsym_underscore=no, gst_cv_dlsym_underscore=yes
  ))

  if test "$gst_cv_dlsym_underscore" = yes; then
    AC_DEFINE(NEED_DLSYM_UNDERSCORE)
  fi
fi

AC_SUBST(DLD_MODULE)
])dnl
dnl 
dnl 
dnl From m4/double.m4 -- 
dnl 
AC_DEFUN(GST_DOUBLE_ALIGNMENT, [

AC_CACHE_CHECK(for double alignment, gst_cv_double_alignment, [
AC_TRY_RUN([
  main(argc)
  int argc;
  {
    long vec[3];
    double *testptr;

    /* The argument to exit is always 0, and the reference to argc
     * has no purpose other than that to fool the optimizer -- of
     * course argc != -1, so exit's parameter will always be 0 and
     * the test will only fail if the program segfaults.
     */
    testptr = (double *) &vec[1];
    exit (*testptr == 1.0 && argc == -1);
  }],
  gst_cv_double_alignment=SIZEOF_CHAR_P,
  gst_cv_double_alignment="2 * SIZEOF_CHAR_P",
  gst_cv_double_alignment="2 * SIZEOF_CHAR_P")     dnl Assume the worst
])

AC_DEFINE_UNQUOTED(DOUBLE_ALIGNMENT, $gst_cv_double_alignment)

])dnl
dnl 
dnl 
dnl From m4/ext_goto.m4 -- 
dnl 
AC_DEFUN(GST_C_GOTO_VOID_P, [

AC_CACHE_CHECK(for goto void *, gst_cv_c_goto_void_p,
[AC_TRY_COMPILE(, [
    void *x = &&label;
    goto *x;
    label: ],
    gst_cv_c_goto_void_p=yes, gst_cv_c_goto_void_p=no)
])
test $gst_cv_c_goto_void_p = yes && AC_DEFINE(HAVE_GOTO_VOID_P)

])dnl
dnl 
dnl 
dnl From m4/inet.m4 -- 
dnl 
AC_DEFUN(GST_INET_SOCKETS, [

AC_CHECK_LIB(socket, listen)
AC_CHECK_LIB(nsl, gethostbyname)

ok_so_far=yes
AC_CHECK_FUNC(socket, , ok_so_far=no)
AC_CHECK_HEADER(netinet/in.h, , ok_so_far=no)
AC_CHECK_HEADER(arpa/inet.h, , ok_so_far=no)
test $ok_so_far = yes && AC_DEFINE(HAVE_INET_SOCKETS)


])dnl
dnl 
dnl 
dnl From m4/localtime.m4 -- 
dnl 
AC_DEFUN(GST_FUNC_LOCALTIME, [

AC_CACHE_CHECK(whether localtime caches the timezone, emacs_cv_localtime_cache,
[AC_REQUIRE([AC_HEADER_TIME])
AC_TRY_RUN(
    [#if defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <sys/time.h>
    #endif
    #if !defined(HAVE_SYS_TIME_H) || defined(TIME_WITH_SYS_TIME)
    # include <time.h>
    #endif
    #if STDC_HEADERS
    # include <stdlib.h>
    #endif

    extern char **environ;
    unset_TZ ()
    {
      char **from, **to;
      for (to = from = environ; (*to = *from); from++)
        if (! (to[0][0] == 'T' && to[0][1] == 'Z' && to[0][2] == '='))
          to++;
    }
    char TZ_GMT0[] = "TZ=GMT0";
    char TZ_PST8[] = "TZ=PST8";
    main()
    {
      time_t now = time ((time_t *) 0);
      int hour_GMT0, hour_unset;
      if (putenv (TZ_GMT0) != 0)
        exit (1);
      hour_GMT0 = localtime (&now)->tm_hour;
      unset_TZ ();
      hour_unset = localtime (&now)->tm_hour;
      if (putenv (TZ_PST8) != 0)
        exit (1);
      if (localtime (&now)->tm_hour == hour_GMT0)
        exit (1);
      unset_TZ ();
      if (localtime (&now)->tm_hour != hour_unset)
        exit (1);
      exit (0);
    }],
    emacs_cv_localtime_cache=no, emacs_cv_localtime_cache=yes,

    [# Assume the worst when cross-compiling.
    emacs_cv_localtime_cache=yes])
])
test $emacs_cv_localtime_cache = yes && AC_DEFINE(LOCALTIME_CACHE)

])dnl
dnl 
dnl 
dnl From m4/mmap.m4 -- 
dnl 
AC_DEFUN(GST_FUNC_MMAP, [
  AC_CHECK_FUNCS(mmap getpagesize)

  if test $ac_cv_func_mmap != yes; then
    AC_MSG_ERROR([GNU Smalltalk requires mmap])
  fi

AC_CACHE_CHECK(where to allocate the heap, gst_cv_mmap_base, [
  AC_TRY_RUN([
#include <sys/mman.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#include <stdio.h>

#ifndef MAP_FAILED
#define MAP_FAILED ((char *) -1)
#endif

#if defined(MAP_ANONYMOUS) && !defined(MAP_ANON)
#define MAP_ANON MAP_ANONYMOUS
#endif

#ifdef MAP_ANON
#define mmap_page(where, flags)				        \
  mmap ((where), pagesize, PROT_READ | PROT_WRITE | PROT_EXEC,	\
	(flags) | MAP_PRIVATE | MAP_ANON, -1, 0)

#else /* no MAP_ANON */

#define mmap_page(where, flags)			                \
  mmap ((where), pagesize, PROT_READ | PROT_WRITE | PROT_EXEC,	\
	(flags) | MAP_PRIVATE, fd, 0)

#endif /* no MAP_ANON */

#define BIG_STEP (256 << 20)
#define SMALL_STEP (16 << 20)

main()
{
#ifndef _WIN32
  char *guess;
  int pagesize;
  int step;
  FILE *fp;

/* Open file descriptor for the file to which heaps are mapped
 * (/dev/zero). */

#ifndef MAP_ANON
  int fd;
  fd = open ("/dev/zero", O_RDWR);
#endif

#ifdef HAVE_GETPAGESIZE
  pagesize = getpagesize();
#else
#ifdef _SC_PAGE_SIZE
  pagesize = sysconf(_SC_PAGE_SIZE);
#else
#ifdef _SC_PAGESIZE
  pagesize = sysconf(_SC_PAGESIZE);
#else
#ifdef	PAGESIZE
  pagesize = PAGESIZE;
#else
#ifdef	EXEC_PAGESIZE
  pagesize = EXEC_PAGESIZE;
#else
#ifdef	NBPG
#ifndef	CLSIZE
#define	CLSIZE 1
#endif
  pagesize = NBPG * CLSIZE;
#else
#ifdef	NBPC
  pagesize = NBPC
#else
  pagesize = 4096;		/* Just punt and use reasonable value */
#endif /* no NBPC */
#endif /* no NBPG */
#endif /* no EXEC_PAGESIZE */
#endif /* no PAGESIZE */
#endif /* no _SC_PAGESIZE */
#endif /* no _SC_PAGE_SIZE */
#endif /* no getpagesize() */

  fp = fopen ("mmapbase", "w");
  guess = mmap_page(NULL, 0);
  step = BIG_STEP;
  for (guess += step; step >= SMALL_STEP; step >>= 1, guess -= step)
    if (mmap_page(guess + BIG_STEP, MAP_FIXED) != MAP_FAILED 
	&& mmap_page(guess, MAP_FIXED) != MAP_FAILED) {
      fprintf (fp, "0x%x\n", guess);
      fclose (fp);
      exit (0);
    }

  guess -= step;
  step = BIG_STEP;
  for (guess -= step; step >= SMALL_STEP; step >>= 1, guess += step)
    if (mmap_page(guess, MAP_FIXED) != MAP_FAILED
        && mmap_page(guess + BIG_STEP, MAP_FIXED) != MAP_FAILED) {
      fprintf (fp, "0x%x\n", guess);
      fclose (fp);
      exit (0);
    }

  fclose (fp);
  exit (1);
#else /* WIN32 */
  exit (0);
#endif /* WIN32 */
}
],
  gst_cv_mmap_base=`cat mmapbase 2>/dev/null`,
  AC_MSG_ERROR([a valid heap base address could not be determined]))

  rm -f mmapbase 2> /dev/null
])

AC_DEFINE_UNQUOTED(MMAP_BASE, [((char *)${gst_cv_mmap_base})])

])dnl
dnl 
dnl 
dnl From m4/obstack.m4 -- 
dnl 
AC_DEFUN(GST_FUNC_OBSTACK, [

AC_CACHE_CHECK(for obstacks, am_cv_func_obstack, [
  AC_TRY_LINK([#include "obstack.h"],
	      [struct obstack *mem;obstack_free(mem,(char *) 0)],
	      am_cv_func_obstack=yes,
	      am_cv_func_obstack=no)
  if test $am_cv_func_obstack = yes; then
    AC_DEFINE(HAVE_OBSTACK)
  else
    LIBOBJS="$LIBOBJS obstack.o"
  fi
])


])dnl
dnl 
dnl 
dnl From m4/oldansi.m4 -- 
dnl 
AC_DEFUN(GST_C_OLDCC, [

AC_CACHE_CHECK(for old ANSI CC (no void *), gst_cv_c_oldcc,
[AC_TRY_COMPILE(, [void *x; ],
    gst_cv_c_oldcc=no, gst_cv_c_oldcc=yes)
])
test $gst_cv_c_oldcc = yes && AC_DEFINE(OLDCC)

])dnl
dnl 
dnl 
dnl From m4/readline.m4 -- 
dnl 
AC_DEFUN(GST_HAVE_READLINE, [

AC_ARG_WITH(readline, 
	[  --with-readline=path    set path to readline and termcap libraries
  --without-readline      don't try to detect readline])


if test "$with_readline" != no; then
  AC_CACHE_CHECK(how to link with readline, gst_cv_readline_libs, [
    test "$with_readline" && test -d "$with_readline" && \
      LDFLAGS="$LDFLAGS -L$with_readline"
    gst_cv_readline_libs="not found"
    ac_save_LIBS="$LIBS"
    for lib in "" -ltermcap -ltermlib -lncurses; do
      LIBS="$ac_save_LIBS -lreadline $lib"
      AC_TRY_LINK(
	[#include <stdio.h>
	#include <readline/readline.h>],
	[char *l = readline("")],
	[gst_cv_readline_libs="-lreadline $lib"
	break])
    done
    LIBS="$ac_save_LIBS"
  ])

  if test "$gst_cv_readline_libs" != "not found"; then
    LIBS="$LIBS $gst_cv_readline_libs"
    AC_DEFINE(HAVE_READLINE)
  fi
fi

])dnl
dnl 
dnl 
dnl From m4/signed.m4 -- 
dnl 
AC_DEFUN(GST_C_SIGNED, [

AC_CACHE_CHECK(for signed, gst_cv_c_signed,
[AC_TRY_COMPILE(, [signed int x; ],
    gst_cv_c_signed=yes, gst_cv_c_signed=no)
])
test $gst_cv_c_signed = no && AC_DEFINE_UNQUOTED(signed, )

])dnl
dnl 
dnl 
dnl From m4/strtoul.m4 -- 
dnl 
AC_DEFUN(GST_FUNC_STRTOUL, [

# Check for strtoul.  Under some versions of AIX, strtoul returns
# an incorrect terminator pointer for the string "0".
AC_CACHE_CHECK(for strtoul, gst_cv_working_strtoul, [
  exec AC_FD_MSG>/dev/null
  AC_CHECK_FUNC(strtoul, gst_cv_working_strtoul=yes, gst_cv_working_strtoul=no)
  if test $gst_cv_working_strtoul = yes; then
    AC_TRY_RUN([
      extern int strtoul();
      int main()
      {
	char *string = "0";
	char *term;
	int value;
	value = strtoul(string, &term, 0);
	exit((value != 0) || (term != (string+1)));
      }], ,
      [gst_cv_working_strtoul="yes, but broken"],
      [gst_cv_working_strtoul="yes, but cross-compiling"])
  fi
  test "$silent" != yes && exec AC_FD_MSG>&1
])

test "$gst_cv_working_strtoul" != yes && LIBOBJS="$LIBOBJS strtoul.o"

])dnl
dnl 
dnl 
dnl From m4/symbolset.m4 -- 
dnl 
AC_DEFUN(GST_C_SYMBOLSET, [

# This test outputs the list of symbols which /bin/cc or /lib/cpp
# define and which we had the foresight to guess at.  When
# cross-compiling, we only consider /lib/cpp.
AC_CACHE_CHECK(builtin preprocessor symbol set, gst_cv_machine_defines,
[   syms="AMIX BIT_MSF BSD BSD4_3 BSD_NET2 CMU CRAY DGUX DOLPHIN DPX2 \
	GO32 GOULD_PN HP700 I386 I80960 I960 Lynx M68000 M68K MACH \
	MIPSEB MIPSEL MSDOS MTXINU MULTIMAX MVS \
	M_COFF M_I186 M_I286 M_I386 M_I8086 M_I86 M_I86SM \
	M_SYS3 M_SYS5 M_SYSIII M_SYSV M_UNIX M_XENIX \
	NeXT OCS88 OSF1 PARISC PC532 PORTAR POSIX \
	PWB R3000 RES RISC6000 RT Sun386i SVR3 SVR4 \
	SYSTYPE_BSD SYSTYPE_SVR4 SYSTYPE_SYSV Tek4132 Tek4300 \
	UMAXV USGr4 USGr4_2 UTEK UTS UTek UnicomPBB UnicomPBD Utek \
	VMS WIN32 Xenix286 \
	_AIX _AIX32 _AIX370 _AM29000 _COFF _CRAY _CX_UX _EPI \
	_IBMESA _IBMR2 _M88K _M88KBCS_TARGET \
	_MIPSEB _MIPSEL _M_COFF _M_I86 _M_I86SM _M_SYS3 \
	_M_SYS5 _M_SYSIII _M_SYSV _M_UNIX _M_XENIX _NLS _PGC_ _R3000 \
	_SYSTYPE_BSD _SYSTYPE_BSD43 _SYSTYPE_SVR4 \
	_SYSTYPE_SYSV _SYSV3 _U370 _UNICOS \
	__386BSD__ __BIG_ENDIAN __BIG_ENDIAN__ __BSD_4_4__ \
	__CYGWIN__ __CYGWIN32__ __DGUX__ __DPX2__ __H3050R __H3050RX \
	__LITTLE_ENDIAN __LITTLE_ENDIAN__ __MACH__ _MSC_VER \
	__MIPSEB __MIPSEB__ __MIPSEL __MIPSEL__ \
	__Next__ __OS2__ __OSF1__ __PARAGON__ __PGC__ __PWB __STDC__ \
	__SVR4_2__ __UMAXV__ __WIN32__ _WIN32 \
	____386BSD____ __alpha __alpha__ __amiga \
	__bsd4_2 __bsd4_2__ __bsdi__ __convex__ \
	__host_mips__ \
	__hp9000s200 __hp9000s300 __hp9000s400 __hp9000s500 \
	__hp9000s500 __hp9000s700 __hp9000s800 \
	__hppa __hpux __hp_osf __i286 __i286__ __i386 __i386__ \
	__i486 __i486__ __i860 __i860__ __ibmesa __ksr1__ __linux__ \
	__m68k __m68k__ __m88100__ __m88k __m88k__ \
	__mc68000 __mc68000__ __mc68020 __mc68020__ \
	__mc68030 __mc68030__ __mc68040 __mc68040__ \
	__mc88100 __mc88100__ __mips __mips__ \
	__motorola__ __osf__ __pa_risc __sparc__ __stdc__ \
	__sun __sun__ __svr3__ __svr4__ __ultrix __ultrix__ \
	__unix __unix__ __uxpm__ __uxps__ __vax __vax__ \
	_host_mips _mips _unix \
	a29k aegis aix aixpc alliant alpha am29000 amiga \
	ansi ardent apollo ardent att386 att3b \
	bsd bsd43 bsd4_2 bsd4_3 bsd4_4 bsdi bull \
	cadmus clipper concurrent convex cray ctix \
	dmert encore gcos gcx gimpel gould \
	hbullx20 hcx host_mips hp200 hp300 hp700 hp800 \
	hp9000 hp9000s300 hp9000s400 hp9000s500 \
	hp9000s700 hp9000s800 hp9k8 hppa hpux \
	i186 i286 i386 i486 i8086 \
	i80960 i860 iAPX286 ibm ibm032 ibmrt interdata is68k \
	ksr1 linux luna luna88k m68k m88100 m88k \
	mc300 mc500 mc68000 mc68010 mc68020 mc68030 \
	mc68040 mc68060 mc68k mc68k32 mc700 \
	mc88000 mc88100 merlin mert mips mvs n16 \
	ncl_el ncl_mr \
	news1500 news1700 news1800 news1900 news3700 \
	news700 news800 news900 ns16000 ns32000 \
	ns32016 ns32332 ns32k nsc32000 os osf \
	parisc pc532 pdp11 plexus posix pyr \
	riscix riscos scs sequent sgi sinix sony sony_news \
	sonyrisc sparc sparclite spectrum stardent stratos \
	sun sun3 sun386 svr4 sysV68 sysV88 \
	titan tower tower32 tower32_200 tower32_600 tower32_700 \
	tower32_800 tower32_850 tss u370 u3b u3b2 u3b20 u3b200 \
	u3b20d u3b5 ultrix unix unixpc unos vax venix vms \
	xenix z8000"

   if test $cross_compiling != yes; then
      # Some cpp's do not define any symbols, but instead let /bin/cc do it
      # for them.  For such machines, not using CPP to run this test (instead
      # creating a program which printf's them to stdout) may prove useful.
      (echo "#include <stdio.h>"			;\
      echo "main ()" 					;\
      echo "{"						;\
      Q=\\\"						;\
      for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "  printf(\"$Q$i$Q, \");"			;\
	echo "#endif"					;\
      done						;\
      echo "  printf (\"\n\");"				;\
      echo "  exit (0);"				;\
      echo "}")						>conftest.$ac_ext

      dnl Stolen from AC_TRY_RUN's definition
      AC_TRY_EVAL(ac_link) && gst_cv_machine_defines=`./conftest 2>/dev/null`
    fi
    if test -z "$gst_cv_machine_defines"; then
      (for i in $syms; do				 \
	echo "#ifdef $i"				;\
	echo "\"$i\","					;\
	echo "#endif"					;\
      done)						>conftest.$ac_ext

      gst_cv_machine_defines=`(eval "$ac_cpp conftest.$ac_ext") | grep ","`
    fi
    rm -rf conftest*
])

AC_DEFINE_UNQUOTED(MACHINE_DEFINES, $gst_cv_machine_defines)

])dnl
dnl 
dnl 
dnl From m4/tcltk.m4 -- 
dnl 
AC_DEFUN(GST_HAVE_TCLTK, [

AC_ARG_WITH(tcl, 
	[  --with-tcl=path         set path to tclConfig.sh [default=ask tclsh]])

AC_ARG_WITH(tk, 
	[  --with-tk=path          set path to tkConfig.sh [default=same as Tcl]])

AC_MSG_CHECKING(for Tcl 8.x)
if test -z "$with_tcl" -o "$with_tcl" = yes; then
  exec AC_FD_MSG>/dev/null
  AC_PATH_PROG(TCLSH, tclsh)
  test "$silent" != yes && exec AC_FD_MSG>&1
  if test -n "$TCLSH"; then
    # Remove the last component from the path
    with_tcl=`echo 'puts $tcl_library' | $TCLSH | sed 's,\(.*\)/.*,\1,'`
  else
    with_tcl=no
  fi
fi
if test -z "$with_tk" -o "${with_tk}" = yes; then
  with_tk=$with_tcl
fi
test -f "$with_tcl/tclConfig.sh" || with_tcl=no
test -f "$with_tk/tkConfig.sh" || with_tk=no

AC_MSG_RESULT($with_tcl)
AC_MSG_CHECKING(for Tk 8.x)
AC_MSG_RESULT($with_tk)

AC_CACHE_CHECK(how to link with Tcl/Tk 8.x, gst_cv_tcltk_libs, [
  exec AC_FD_MSG>/dev/null

  gst_cv_tcltk_libs="not found"

  if test "$with_tcl" != no -a "$with_tk" != no; then
    # Get the values we need from the Tcl/Tk configuration files
    . $with_tcl/tclConfig.sh
    . $with_tk/tkConfig.sh

    # The indirection is required by Tcl/Tk
    gst_cv_tcltk_libs="$TCL_LIBS $TK_XLIBSW $TCL_LIB_SPEC $TK_LIB_SPEC"
    gst_cv_tcltk_libs=`eval echo $gst_cv_tcltk_libs`
    gst_cv_tcltk_includes="$TK_XINCLUDES -I$TCL_PREFIX/include"

    test "$TCL_PREFIX" != "$TK_PREFIX" &&
      gst_cv_tcltk_includes="$gst_cv_tcltk_includes -I$TK_PREFIX/include"

    save_cppflags="$CPPFLAGS"
    save_libs="$LIBS"
    CPPFLAGS="$CPPFLAGS $gst_cv_tcltk_includes"
    LIBS="$LIBS $gst_cv_tcltk_libs"

    # Check the headers & libraries
    AC_EGREP_CPP(everything_fine, [
#include <tcl.h>
#include <tk.h>
#ifdef TCL_MAJOR_VERSION
#ifdef TK_MAJOR_VERSION
#if ((TCL_MAJOR_VERSION == $TCL_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
#if ((TK_MAJOR_VERSION == $TK_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
    everything_fine
#endif
#endif
#endif
#endif], , gst_cv_tcltk_libs="not found")

    AC_CHECK_FUNC(Tcl_ObjSetVar2, , gst_cv_tcltk_libs="not found")
    AC_CHECK_FUNC(Tk_CreatePhotoImageFormat, , gst_cv_tcltk_libs="not found")
    CPPFLAGS="$save_cppflags"
    LIBS="$save_libs"
  fi
  test "$silent" != yes && exec AC_FD_MSG>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  AC_MSG_CHECKING(include path for Tcl/Tk)
  AC_MSG_RESULT($gst_cv_tcltk_includes)
  TCL_LIBS="$gst_cv_tcltk_libs"
  TCL_INCLUDES="$gst_cv_tcltk_includes"
  AC_DEFINE(HAVE_TCLTK)
fi

AC_SUBST(TCL_LIBS)
AC_SUBST(TCL_INCLUDES)
])dnl

dnl AC_INIT(tcltk.m4)
dnl AC_PROG_CC
dnl GST_HAVE_TCLTK
dnl AC_CACHE_SAVE
dnl exit 0
dnl 
dnl 
dnl From m4/va_arg.m4 -- 
dnl 
AC_DEFUN(GST_C_VARARGS, [

AC_CHECK_HEADERS(stdarg.h)
AC_CACHE_CHECK(whether va_arg(..., char) works, gst_cv_working_va_arg, [
  old_CFLAGS="$CFLAGS"
  if test "$GCC" = yes; then
    CFLAGS="$CFLAGS -O2"
  else
    CFLAGS="$CFLAGS -O"
  fi

  AC_TRY_LINK([
#   include <stdarg.h>

    int testfunc (int test, ...)
    {
      va_list args;
      char    test2;
  
      va_start(args, test);
      test = va_arg(args, char);
    }], [
      testfunc(5, '3');
      return 0;
    ],
    gst_cv_working_va_arg=yes,
    gst_cv_working_va_arg=no
  )
  CFLAGS="$old_CFLAGS"
])

if test $gst_cv_working_va_arg = no; then
  AC_DEFINE(PICKY_VA_ARG)
fi

])dnl
dnl 
dnl 
dnl From m4/waitpid.m4 -- 
dnl 
AC_DEFUN(GST_FUNC_WAITPID, [
AC_REQUIRE([AC_HEADER_SYS_WAIT])
AC_CHECK_FUNCS(wait wait3 waitpid)
# Check whether we have no waitpid, but we can emulate it
if test $ac_cv_func_waitpid = no; then
  if test $ac_cv_func_wait = yes || test $ac_cv_func_wait3 = yes; then
    LIBOBJS="$LIBOBJS waitpid.o" AC_DEFINE(HAVE_WAITPID)
  fi
fi


])dnl
dnl 
