"======================================================================
|
|   Smalltalk GUI wrapper for list boxes
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Primitive subclass:  #PList
	instanceVariableNames: 'selection hiliteItemInitMsg listMsg'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'
!

!PList methodsFor: 'initializing'!

stateChange: stateChangeKey
"Install message handler to redraw list in response to an update: message"
    self stateChange: stateChangeKey updateWith: [self display].
!

handleUserChange: changeSelector
    super handleUserChange: changeSelector.
    blox callback: self message: #selection:at:
!

changedSelection: stateChangeKey
"Install message handler for stateChangeKey to select the item based on the
initial selection"
    self stateChange: stateChangeKey updateWith: [self select: (data perform: hiliteItemInitMsg)]
!

initialize
    selection := 0.
    blox := BList new: (parentView blox).
    "self blox backgroundColor: 'LemonChiffon'."
!

hiliteItemInitMsg: hiliteItemInitSelector
"Save data object selector which will retrieve initial list selection in the 
variable, hiliteItemInitMsg"
    hiliteItemInitMsg := hiliteItemInitSelector.
!

listMsg: listSelector
"Return array of list items"
    listMsg := listSelector.
! !

!PList methodsFor: 'displaying'!

display
"Update list widget based on list"
    blox contents: (data perform: listMsg).
"Select item returned by intialialSelection message"
    hiliteItemInitMsg notNil ifTrue: 
	[self select: (data perform: hiliteItemInitMsg)]
! !

!PList methodsFor: 'message selectors'!

selection: aPList at: position
    | itemPosition |
    itemPosition := position + 1.
    "Change list selection based on new selection"
    ((stateChangeMsg notNil and: [selection ~= itemPosition])
	 "If this is a new selection, ask the data object whether the view can
	  update itself.  There may be text which has been modified in the text
	  view associated with the current list selection"
	 and: [self canChangeState])
	ifTrue: [
		 selection := itemPosition.
		 data perform: stateChangeMsg with: 
		     (Association key: selection value: ((itemPosition > 0) 
		 	     ifTrue: [(data perform: listMsg) at: itemPosition]
			     ifFalse: [nil]))
		     ]
	ifFalse: [ itemPosition > 0 ifTrue: [blox highlight: itemPosition ]].
    ^itemPosition.
! !

!PList methodsFor: 'modifying'!

unselect
    blox unhighlight.
!

select: item
"Select item named, aSymbol, in list"
    selection := 0.
    item notNil ifTrue: [
	item isInteger
	    ifTrue: [ selection := item]
	    ifFalse: [ selection := (data perform: listMsg) indexOf: item].
	selection > 0 ifTrue: [blox highlight: selection]]
! !
