"======================================================================
|
|   Generic visitor pattern for STParseNodes
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"
!

Object subclass: #STParseNodeVisitor
       instanceVariableNames: 'comments'
       classVariableNames: ''
       poolDictionaries: 'VMOtherConstants VMByteCodeNames'
       category: 'System-Compiler'
!

STParseNodeVisitor comment:
'I provide generic callbacks to visit a Smalltalk parse tree.'!

!STParseNodeVisitor methodsFor: 'visiting sets of nodes'!

arguments: argumentsCollection
    argumentsCollection do: [ :each | self argument: each ]
!

assignments: assignmentsCollection
    assignmentsCollection do: [ :each | self assignment: each ]
!

sequence: nodeCollection
    nodeCollection do: [ :each | self visit: each ]
!

temporaries: temporariesCollection
    temporariesCollection do: [ :each | self temporary: each ]
!

!STParseNodeVisitor methodsFor: 'scopes'!

scopeEnter
!

scopeLeave
!

!STParseNodeVisitor methodsFor: 'visiting particular nodes'!

argument: aSymbol
!

assignment: assignedNode
!

message: aMessageSendNode
!

messageReceiver: anExpressionNode
!

primitive: anIntegerOrNil
!

return: aNode
!

selector: aSymbol
!

temporary: aSymbol
!

visit: aNode
    aNode visitThrough: self
! !


!STParseNode methodsFor: 'visiting'!

visitThrough: aVisitor
    self subclassResponsibility
! !

!STBlockNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor scopeEnter.
    1 to: self numArgs do: [ :each |
    	aVisitor argument: (self parameters at: each)
    ].
    self numArgs + 1 to: self numArgs + self numTemps do: [ :each |
    	aVisitor temporary: (self parameters at: each)
    ].
    aVisitor sequence: self statements
    aVisitor scopeLeave.
! !

!STCascadeNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor visit: self receiver.
    self messages do: [ :each | aVisitor message: each ].
! !

!STConstNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor literal: self value.
! !

!STExpressionNode methodsFor: 'visiting'!

visitThrough: aVisitor
    self assigns isEmpty ifFalse: [ aVisitor assignments: self assigns ].
    aVisitor visit: self expression.
! !

!STIdentifierNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor variable: self.
! !

!STMessageNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor
	messageReceiver: self receiver;
	message: self message.
! !

!STMessageSendNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor message: self
! !

!STMethodDefinitionNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor
	scopeEnter;
	selector: self selector selector;
	arguments: self selector args;
	temporaries: self body temporaries;
	primitive: self body primitive;
	sequence: self body statements;
	scopeLeave.
! !

!STReturnNode methodsFor: 'visiting'!

visitThrough: aVisitor
    aVisitor return: self expression.
! !
