"======================================================================
|
|   Dynamic Loader Method Definitions
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #DLD
       instanceVariableNames: ''
       classVariableNames: 'LibraryList ExternalFunctions'
       poolDictionaries: ''
       category: 'Language-C interface'
!

DLD comment: '...and Gandalf said:
``Many folk like to know beforehand what is to be set on the
table; but those who have laboured to prepare the feast like
to keep their secret; for wonder makes the words of praise
louder.''''

I am just an ancillary class used to reference some C functions.
Most of my actual functionality is used by redefinitions of methods
in CFunctionDescriptor and Behavior.'!


DLD class defineCFunc: 'dldLink'
	  withSelectorArgs: 'linkFile: aFileName'
	  returning: #cObject
	  args: #(string)
!

DLD class defineCFunc: 'dldGetFunc'
	  withSelectorArgs: 'library: libHandle getFunc: aFuncString'
	  returning: #cObject
	  args: #(cObject string)
!

DLD class defineCFunc: 'defineCFunc'
	  withSelectorArgs: 'primDefineCFunc: aName as: aFuncAddr'
	  returning: #void
	  args: #(string cObject)
!


!CFunctionDescriptor class methodsFor: 'testing'!

isFunction: function
    "Answer whether a function is registered (on the C side) with the
     given name or is dynamically loadable."

    | descriptor |
    descriptor := self
	makeDescriptorFor: function
    	returning: #void		"dummy"
	withArgs: #().			"dummy"

    ^descriptor isValid or: [ DLD defineExternFunc: function ]
! !


!Behavior methodsFor: 'C callout'!

defineCFunc: cFuncName
    withSelectorArgs: selector
    returning: aReturnType
    args: argsArray

    "Too complex to describe it here - Look up the C interface in the manual."

    CFunctionDescriptor isFunction: cFuncName.

    ^Behavior
	defineCFunc: cFuncName
	withSelectorArgs: selector
	forClass: self
	returning: aReturnType
	args: argsArray
! !


!DLD class methodsFor: 'Dynamic Linking'!

defineCFunc: aFuncName as: addr
    "This method registers the function so that it is looked up
     again at image startup, then calls out to the C function
     defineCFunc (#primDefineCFunc:as:)."

    ExternalFunctions add: aFuncName asSymbol.
    ^self primDefineCFunc: aFuncName as: addr
!

defineExternFunc: aFuncName
    "This method calls #primDefineExternFunc: to try to link to a function with
     the given name, and answers whether the linkage was successful. You can
     redefine this method to restrict the ability to do dynamic linking."
    ^self primDefineExternFunc: aFuncName
!

primDefineExternFunc: aFuncName
    "This method tries to link to a function with the given name, and answers
     whether the linkage was successful. It should not be overridden."
    | funcAddr |
    
    self libraryList do: [ :lib |
	lib value notNil ifTrue: [
	    funcAddr := self library: lib value getFunc: aFuncName.
	    funcAddr notNil ifTrue: [ 
		self defineCFunc: aFuncName as: funcAddr.
		^true
	    ]
	]
    ].
    self libraryList
	detect: [ :lib |
	    lib value isNil and: [
		lib value: (self linkFile: lib key).
		funcAddr := self library: lib value getFunc: aFuncName.
		funcAddr notNil
	    ]
	]
	ifNone: [ ^false ].

    self defineCFunc: aFuncName as: funcAddr.
    ^true
!

defineExternFunc: aFuncName
    withSelectorArgs: selector
    forClass: aClass
    returning: aReturnType
    args: argsArray

    "Obsolete - Mantained for compatibility.  This method does NOT
    look for statically linked functions."

    (self defineExternFunc: aFuncName) ifFalse: [
	self error: 'function ', aFuncName, ' not found'
    ].

    ^Behavior
	defineCFunc: aFuncName
	withSelectorArgs: selector
	forClass: aClass
	returning: aReturnType
	args: argsArray
!

initialize
    "Private - Initialize the receiver's class variables"
    LibraryList := OrderedCollection new.
    ExternalFunctions := IdentitySet new.
!

reset
    "Called on startup - Make DLD re-link and reset the addresses of
     all the externally defined functions"
    | notLinked |
    LibraryList do: [ :each | each value: nil ].

    notLinked := WriteStream on: Array new.
    CFunctionDescs do: [ :func |
	(func isInteger not and: [ ExternalFunctions includes: func name asSymbol ])
	    ifTrue: [
		(DLD defineExternFunc: func name)
		    ifFalse: [ notLinked nextPut: func name ].

		func address: (CFunctionDescriptor addressOf: func name)
	    ]
    ].
    
    notLinked := notLinked contents.
    notLinked isEmpty ifFalse: [
	self error: 'functions ', notLinked printString,
		    ' could not be re-linked.'
    ]!

libraryList
    "Answer a copy of the search path of libraries to be used by DLD"
    ^LibraryList copy
!

addLibrary: library
    "Add library to the search path of libraries to be used by DLD"
    LibraryList add: library -> nil

! !

DLD initialize!
Smalltalk addInit: [ DLD reset ]!
