"======================================================================
|
|   MethodContext Method Definitions
|
|   $Revision: 1.8.3$
|   $Date: 2000/09/05 16:16:17$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


ContextPart variableSubclass: #MethodContext
       instanceVariableNames: 'flags '
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Implementation'
!

MethodContext comment: 
'My instances represent an actively executing method.  They record various
bits of information about the execution environment, and contain the
execution stack.' !


!MethodContext methodsFor: 'printing'!

printOn: aStream
    "Print a representation for the receiver on aStream"
    self receiver class printOn: aStream.

    self receiver class == self methodClass ifFalse: [
	aStream
	    nextPut: $(;
	    print: self methodClass;
	    nextPut: $)
    ].
    aStream
	nextPutAll: '>>';
	print: self selector
! !



!MethodContext methodsFor: 'accessing'!

isEnvironment
    "To create a valid execution environment for the interpreter even before
     it starts, GST creates a fake context whose selector is nil and which
     can be used as a marker for the current execution environment.  Answer
     whether the receiver is that kind of context."
    ^flags == 1
!

sender
    "Return the context from which the receiver was sent"
    ^self parentContext
!

home
    "Answer the MethodContext to which the receiver refers
     (i.e. the receiver itself)"
    ^self
!

isBlock
    "Answer whether the receiver is a block context"
    ^false
! !
