/******************************** -*- C -*- ****************************
 *
 *	BeOS Dynamic Linking support code
 *
 *	$Revision: 1.8.3$
 *	$Date: 2000/09/05 16:16:17$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

#include "dld_gst.h"

#include <stdio.h>
#include <kernel/image.h>


char	*gst_dld_exts[] = { ".so", NULL };

static char	*error;

voidPtr
gst_dld_open (path)
     char *path; 
{
  image_id image = 0;
	
  image = load_add_on(path);
  if (image <= 0) {
    error = "Cannot open shared library";
    return NULL;
  }

  error = NULL;
  return (voidPtr) image;
}

voidPtr
gst_dld_sym (handle, symbol)
     voidPtr handle;
     char *symbol;
{
  voidPtr address = 0;
  image_id image = (image_id)handle;
   
  if (get_image_symbol(image, symbol, B_SYMBOL_TYPE_ANY, &address) != B_OK) {
    error = "Cannot find function";
    return NULL;
  } else {
    error = NULL;
  }

  return (address);
}

char *
gst_dld_error ()
{
  return (error);
}

int
gst_dld_init (dldArgv0)
char *dldArgv0;
{
  return 0;
}
