/******************************** -*- C -*- ****************************
 *
 *	Win32 Dynamic Linking support code
 *
 *	$Revision: 1.8.3$
 *	$Date: 2000/09/05 16:16:17$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/



#include "dld_gst.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

static DWORD error;

char	*gst_dld_exts[] = { ".dll", ".exe", NULL };

voidPtr
gst_dld_open (path)
     char *path; 
{
  voidPtr result = LoadLibraryEx(path, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
  error = (result == NULL) ? GetLastError() : 0;
  return (result);
}

voidPtr
gst_dld_sym (handle, symbol)
     voidPtr handle;
     char *symbol;
{
  voidPtr result = GetProcAddress((HINSTANCE) handle, symbol);
  error = (result == NULL) ? GetLastError() : 0;
  return (result);
}

char *
gst_dld_error ()
{
  switch(error) {
    case 0:                             return NULL;
    case ERROR_FILE_NOT_FOUND:          return "File not found";
    case ERROR_NOT_ENOUGH_MEMORY:
    case ERROR_OUTOFMEMORY:             return "Not enough memory";
    case ERROR_BAD_EXE_FORMAT:          return "Bad executable file format";
    case ERROR_INVALID_EXE_SIGNATURE:   return "Bad executable magic number";
    default:                            return "Bad library file";
  }
}

int
gst_dld_init (dldArgv0)
char *dldArgv0;
{
  return 0;
}

